;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
;                 IBM Sample Audio Virtual Device Driver
;
;******************************************************************************
;
; DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
; sample code created by IBM Corporation.
; It is provided to you solely for the purpose of assisting you in the
; development of your applications.
; The code is provided "AS IS", without warranty of any kind.
; IBM shall not be liable for any damages arising out of your use of
; the sample code, even if they have been advised of the possibility
; of such damages.
;
; audioreq.asm - Request hardware access (also, release)
;
; This file contains routines to coordinate access to the shared hardware.
; Contention is managed with the Physical Device Driver (OS/2 sessions)
; and DOS sessions.
; When hardware is not available, a PopUp is displayed informing the
; user of the conflict.  Different actions are taken based on user direction.
;
; Note: The OS/2 Virtual Dev Help calls (VDHxxx) preserve
; EBX, EBP, ESI, EDI and the segment regs.  The others are
; fair game.  We need to protect ECX and EDX when it matters.
;******************************************************************************
        .386P                   ; Enable use of ring-0 80386 instructions

        OPTION  OLDMACROS       ; Needed for OS/2 Toolkit when using MASM 6.
       ;INCL_NONE  EQU     1
        INCL_VDH   EQU     1
        INCLUDE mvdm.inc        ; from OS/2 base toolkit
        INCLUDE basemid.inc     ; from OS/2 base toolkit
        INCLUDE devhelp.inc     ; externs for OS/2 Virtual Dev Helps
        INCLUDE vdddata.inc     ; EXTRNS for instance and global variables
        INCLUDE audiovdd.inc    ; EXTRNS for procedures in audiovdd.asm

; Define data segment
; This is the same segment defined in globdata.asm.
; Variables should not be declared here.  The segment
; is defined only for use as a tool in addressing the
; segment at IDC entry.

_DATA           SEGMENT  DWORD USE32 PUBLIC 'DATA'
_DATA           ENDS


; Primary code segment.  NON-swappable, NON-discardable
_TEXT   SEGMENT DWORD USE32 PUBLIC 'CODE'
        ASSUME  CS:_TEXT
        ASSUME  DS:FLAT, SS:FLAT, ES:FLAT

                                        ;------------------------------ PopUp -
; Display PopUp window
; This routine is called when a hardware access is denied
; Function asks user for desired action regarding session life.
;
; User has a few choices:
;    Abort  - Terminate this DOS session
;    Retry  - Suspend this DOS session until hardware becomes available
;    Ignore - Tell DOS session that the hardware doesn't exist
;
; PARMS:
;    ebx - Index into adapters table
;          Used to display name of device which had the use conflict.
;
; RETURNS (eax)
;    VDHP_TERMINATE_SESSION - Terminate session has been ordered
;    VDHP_RETRY             - Session should block till hardware is available
;    VDHP_IGNORE            - Flags were set to virtualize hardware as
;                             not present
PopUp   PROC NEAR
        push    ebp                             ; Establish stack frame
        mov     ebp, esp
        pusha                                   ; Save callers registers

        ; Should anything fail, establish default
        ; action to terminate the session.
        mov     dwTemp, VDHP_TERMINATE_SESSION

        ; Before displaying pop up, check DOS property.

        push    OFFSET FLAT:szEnumIfAvail       ; If DOS property is set to
        call    CheckProperty                   ; "use, if free", then ignore
        or      eax, eax                        ; hardware.  Otherwise ask user
        jnz     DoDisp                          ; for direction via popup.

        ; Set RC as if user selected IGNORE
        mov     dwTemp, VDHP_IGNORE
        jmp     Done

DoDisp:
        lea     esi, Adapters[ebx].pszPddName
        push    esi                             ; Address of string table
        push    1                               ; string count
        push    1174; MSG_MM_DEVICE_IN_USE      ; from OS/2 toolkit .inc files
        lea     eax, dwTemp                     ; Where to place user response
        push    eax
        push    VDHP_TERMINATE_SESSION + VDHP_RETRY + VDHP_IGNORE
        push    0                               ; reserved
        call    VDHPopup                        ; Display message error/warning

        mov     eax, dwTemp                     ; Result of pop-up
        cmp     eax, VDHP_TERMINATE_SESSION
        je      Term

        cmp     eax, VDHP_RETRY                 ; Block till hardware available
        je      Done

        ; User selected "Ignore"
        jmp     Done

Term:   push    HVDM_Current                    ; Session will be killed at
        call    VDHKillVDM                      ; earliest opportunity

Done:   popa                                    ; Restore callers registers
        mov     eax, dwTemp                     ; Pass return info to caller
        leave
        ret
PopUp   ENDP

                                        ;---------------- IsSemOwnedByAnother -
; Returns TRUE if another DOS session
; already owns the hardware.
;
; PARMS:
;    ebx - Index into adapters table
;
; RETURNS (eax)
;    TRUE - Another DOS session already owns the hardware
;   FALSE - Semaphore is not owned - No DOS sessions own the hardware

IsSemOwnedByAnother PROC NEAR
        push    ebp                             ; Establish stack frame
        mov     ebp, esp
        push    ecx
        push    edx

        push    Adapters[ebx].hsemAccessVDM     ; Check if any DOS sessions
        push    OFFSET FLAT:SemState            ; are using the hardware
        call    VDHQuerySem
        xor     eax, eax
        mov     al, SemState.vss_fOwned         ; 0==not owned
        pop     edx
        pop     ecx
        leave
        ret
IsSemOwnedByAnother ENDP

                                        ;---------------- GainOwnershipForVDD -
; Returns true if the VDD succeeds in gaining hardware ownership.
; On entry, it is assumed that the VDD does not own the hardware.
;
; PARMS:
;    ebx - Index into adapters table
;
; RETURNS (EAX):
;    TRUE - VDD gained ownership of the hardware
;   FALSE - Did not gain ownership

GainOwnershipForVDD PROC NEAR
        push    ebp                             ; Establish stack frame
        mov     ebp, esp
        push    ecx
        push    edx

        push    PDDFUNC_OPENDEVICE              ; Function (request hardware)
        push    0                               ; unused parameters
        push    0
        call    Adapters[ebx].PTR_PDD_IDC       ; RC 0==deny  1==honor
        pop     edx
        pop     ecx
        leave
        ret
GainOwnershipForVDD ENDP

                                        ;------------------------ GrantAccess -
; Routine called after DOS session has gained access to hardware.
; Remember state where access was attained and disable further traps.
;
; PARMS:
;    ebx - Index into adapters table
;
; REGISTER USE:
;    ebx - Index into adapter table
;    ecx - Loop index (count down)
;    edx - Index into I/O port range table
;
; RETURNS (nothing)
;
GrantAccess PROC NEAR
        push    ebp                             ; Establish stack frame
        mov     ebp, esp
        push    eax
        push    ebx
        push    ecx
        push    edx

        mov     eax, HVDM_Current               ; Remember handle to session
        mov     Adapters[ebx].hvdm_Owning, eax  ; that owns the hardware.
        mov     ax, PDB_Current                 ; Remember program executing
        mov     Adapters[ebx].pdb_Owning, ax    ; when hardware was accessed

        mov     ecx, Adapters[ebx].NumPortRanges
        mov     ebx, Adapters[ebx].PortArrayPtr ; Pointer to port array

  Next:
        push    ecx                             ; Gets destroyed on VDH call
        push    0                               ; Reserved
        push    [ebx].PORTARRAYENTRY.FirstPort
        push    [ebx].PORTARRAYENTRY.NumberPorts
        push    OFFSET FLAT:iohHookInfo         ; Points to hook function
        push    FALSE                           ; Disable IOport trapping
        call    VDHSetIOHookState
        pop     ecx                             ; Restore ecx
        add     ebx, sizeof PORTARRAYENTRY
        loop    Next                            ; Disable next set

        ; asdf

        pop     edx
        pop     ecx
        pop     ebx
        pop     eax
        leave
        ret
GrantAccess ENDP

                                        ;-------------------------- RequestHW -
; This routine is called the first time a DOS session touches
; the shared hardware.  This is taken as a request for ownership.
; This routine coordinates ownership with the PDD and other DOS sessions.
; When granted, subsequent traps are disabled giving the session
; direct access to the hardware.
; When denied, a pop-up is displayed giving the user notification of
; the conflict.  The session is then either terminated, suspended, or
; a flag is set to act like the hardware doesn't exist.
;
; PARMS:
;    ebx - Index into Adapters array (identifies which adapter the app hit)
;
; RETURNS (EAX):
;    0                       - Access granted
;    VDHP_TERMINATE_SESSION  - Session terminate has been ordered
;    VDHP_IGNORE             - Hardware should be virtualized as not-present
;
RequestHW PROC NEAR
        push    ebp                             ; Establish stack frame
        mov     ebp, esp
        push    ebx                             ; Save registers
        push    ecx
        push    edx
        push    esi
        push    edi

        call    IsSemOwnedByAnother             ; Boolean function
        or      eax, eax                        ; Returns true if a different
        jz      NotInUse                        ; DOS session owns the hardware

        call    PopUp                           ; Tell user about conflict
        cmp     eax, VDHP_RETRY                 ; If doesn't select retry,
        jne     Done                            ; then we're done.
        jmp     WaitOnMutex                     ; Otherwise, wait for hardware

   NotInUse:
        call    GainOwnershipForVDD             ; Ask PDD for ownership
        or      eax, eax                        ; Returns true if acquired
        jnz     WeGotHW                         ; ownership.
        call    PopUp                           ; Tell user hardware is busy
        cmp     eax, VDHP_RETRY                 ; If doesn't select retry,
        jne     Done                            ; then we're done
        jmp     WaitOnPDD                       ; Otherwise, wait for PDD

    WeGotHW:
        ; If get here, the VDD just attained hardware ownership and
        ; this DOS session will gain access with no delay.
        ; To "have ownership" the session must own the mutex semaphore.
        ; This session will acquire the sem with no delay.
        jmp     WaitOnMutex

WaitOnPDD:
        ; The PDD refused to release hardware and user has
        ; asked to wait until the hardware becomes available.
        ; Event semaphore will not be posted until VDD has acquired
        ; hardware ownership.
        ; Note, it is possible for multiple DOS sessions to block
        ; on this semaphore.  When the sem is posted, all of the
        ; blocked sessions will become runnable.  They will then
        ; compete to acquire the mutex sem - only one will acquire.

        push    Adapters[ebx].hsemPDDrelease    ; Block pending message from
        push    SEM_INDEFINITE_WAIT             ; PDD indicating hardware is
        call    VDHWaitEventSem                 ; available.
        or      eax, eax
        jz      SemErr

WaitOnMutex:
        ; VDD owns the hardware.
        ; Acquire ownership for this DOS session.

        push    Adapters[ebx].hsemAccessVDM     ; Wait for other DOS session
        push    SEM_INDEFINITE_WAIT             ; to release the hardware
        call    VDHRequestMutexSem              ; When own sem, we own the h/w.
        or      eax, eax
        jz      SemErr

        ; This DOS session owns the hardware

        call    GrantAccess                     ; Disable further traps
        xor     eax, eax                        ; Indicate access gained
        jmp     Done

SemErr: ; Semaphore problem, session is probably being killed.
        ; Need to flow control back to the VDM manager so it
        ; can complete killing this session.
        mov     eax, VDHP_IGNORE

Done:
        pop     edi                             ; Restore callers registers
        pop     esi
        pop     edx
        pop     ecx
        pop     ebx
        leave
        ret
RequestHW ENDP

                                        ;--------------------- ReleaseAdapter -
; Routine called when a DOS session/application that
; owns hardware terminates.  That is, the DOS session
; relinquishes the adapters.   In the case of a single
; session/application owning multiple adapters, this
; routine will be called mutiple times (once per owned adapter).
;
; PARMS:
;    ebx - Index into adapters table
;
; RETURNS (nothing)

ReleaseAdapter PROC NEAR
        push    ebp                             ; Establish stack frame
        mov     ebp, esp
        push    eax
        push    ebx
        push    ecx
        push    edx

        xor     eax, eax                        ; Temporarily, no DOS session
        mov     Adapters[ebx].hvdm_Owning, eax  ; owns the hardware
        mov     Adapters[ebx].pdb_Owning, ax

        ; Re-enable port trapping
        ; Should this DOS session again try to use the
        ; ports, it will be viewed as a first attempt

        push    ebx                             ; Save Adapters table index

        mov     ecx, Adapters[ebx].NumPortRanges
        mov     ebx, Adapters[ebx].PortArrayPtr ; Pointer to port array
  Next:
        push    ecx                             ; Save ecx
        push    0                               ; Reserved
        push    [ebx].PORTARRAYENTRY.FirstPort
        push    [ebx].PORTARRAYENTRY.NumberPorts
        push    OFFSET FLAT:iohHookInfo         ; Points to hook function
        push    TRUE                            ; Enable IOport trapping
        call    VDHSetIOHookState
        pop     ecx                             ; Save ecx
        add     ebx, sizeof PORTARRAYENTRY
        loop    Next                            ; Disable next set

        pop     ebx                             ; Restore Adapters table index

        push    Adapters[ebx].hsemAccessVDM     ; Release hardware access sem
        call    VDHReleaseMutexSem

        ; We have released the mutex semaphore.  The API documentation
        ; does not describe when the semaphore will next become owned.
        ; The code checks to see if any other DOS session has just gained
        ; ownership (usually this answer is no).  It then checks if any
        ; sessions are waiting to gain ownershp.
        ; If no other DOS sessions wants the adapter, release to PDD.

        push    Adapters[ebx].hsemAccessVDM     ; Check if any DOS sessions
        push    OFFSET FLAT:SemState            ; are using the hardware
        call    VDHQuerySem
        xor     eax, eax
        mov     ax, SemState.vss_fWaiter        ; If there are waiters or if
        or      al, SemState.vss_fOwned         ; some other session gained
        jnz     Done                            ; ownership, then we're done

        push    PDDFUNC_CLOSEDEVICE             ; otherwise, release the
        push    0                               ; adapter back to PDD control
        push    0
        call    Adapters[ebx].PTR_PDD_IDC

Done:
        pop     edx
        pop     ecx
        pop     ebx
        pop     eax
        leave
        ret
ReleaseAdapter ENDP


                                        ;----------------------- InstallHooks -
; Routine called during DOS session creation.
; For each Adapter, all I/O port hooks are installed.
;
; RETURNS: (eax)
;    TRUE  - Success
;    FALSE - Failed
;
InstallHooks PROC NEAR
        push    ebp                             ; Establish stack frame
        mov     ebp, esp
        push    ebx
        push    ecx
        push    edx

        xor     ebx, ebx                        ; Point to start of PDD table
        mov     ecx, MAX_NUM_ADAPTERS           ; Limit number of PDDs

NextAdapter:
        lea     eax, Adapters[ebx].pszPddName   ; If name is null, then
        cmp     byte ptr [eax], 0               ; remainder of table is empty.
        je      Success

        ; Install all the hooks for this adapter
        push    ebx                             ; Remember loop indexes
        push    ecx

        mov     ecx, Adapters[ebx].NumPortRanges
        mov     ebx, Adapters[ebx].PortArrayPtr ; Pointer to port array
Inner:
        push    ecx                             ; Gets destroyed on VDH call.
        push    0                               ; Reserved
        push    [ebx].PORTARRAYENTRY.FirstPort
        push    [ebx].PORTARRAYENTRY.NumberPorts
        push    OFFSET FLAT:iohHookInfo         ; Points to hook function
        push    VDHIIH_ASM_HOOK
        call    VDHInstallIOHook
        pop     ecx                             ; Restore inner loop index
        or      eax, eax
        jz      Failed

        add     ebx, sizeof PORTARRAYENTRY
        loop    Inner                           ; Hook next port range

        pop     ecx                             ; Restore outter loop indexes
        pop     ebx

        add     ebx, sizeof PER_CARD_DATA       ; Bump table index
        loop    NextAdapter                     ; Install hooks for next PDD

Success:mov     eax, TRUE                       ; Indicate success
        jmp     Done

Failed: pop     ecx                             ; Pop outter loop indexes
        pop     ebx                             ; from stack
        xor     eax, eax                        ; Indicate failure

Done:   pop     edx                             ; Restore callers registers
        pop     ecx
        pop     ebx
        leave
        ret
InstallHooks ENDP

                                        ;---------------------- AVDD_IDCEntry -
; Inter-Device Driver communication entry point.
; Routine is called from PDD to coordinate shared hardware
; access and for interrupt virtualization.
;
; Stack on entry
;            --------
;       +20 | ulFunc | Function code
;           |--------|
;       +16 |  ul1   | usually, PDD handle (index into Adapters table)
;           |--------|
;       +12 |  ul2   | Function specific parm (usually, not used)
;           |--------|
;       +8  |  sel   | Return selector
;           |--------|
;       +4  | offset | Return offset
;           |--------|
; SS:EBP -> |  ebp   | Callers frame pointer
;            --------
;
; VDDFUNC_INTERRUPT (0)
;    ul1 (PDD handle)
;    ul2 (not used)
;    return
;       (don't care)
;    PDD calls VDD at interrupt time
;    VDD virtualizes the interrupt for the owning DOS session.
;
; VDDFUNC_CLOSE (1)
;    ul1 (PDD handle)
;    ul2 (not used)
;    return
;       (don't care)
;    PDD indicates that OS/2 sessions no longer require
;    the hardware.

AVDD_IDCEntry   PROC FAR                        ; 16:32 entry point
ulFunc          EQU     <DWORD PTR [ebp+20]>    ; Equates for parameters
ulPddHandle     EQU     <DWORD PTR [ebp+16]>
ul2             EQU     <DWORD PTR [ebp+12]>

        push    ebp                             ; 2 clock version of enter 0,0
        mov     ebp, esp

        push    ds                              ; Preserve callers registers
        push    es
        push    ebx
        push    ecx
        push    edx

        mov     ax, SEG FLAT:_DATA              ; Loading selectors is
        mov     ds, ax                          ; expensive, but there are
        mov     es, ax                          ; few alternatives

        mov     ebx, ulPddHandle                ; Adapter table index
        cmp     ulFunc, VDDFUNC_INTERRUPT       ; If ulFunc != interrupt
        jne     NotInt                          ; then jump around

        ; PDD received genuine hardware interrupt.  Knowing that the VDD
        ; owns the hardware, the PDD is asking the VDD to virtualize the
        ; interrupt for the owning DOS session.
        ; To virtualize interrupts, the VDD must have an open VIRQ handle.
        ; This handle was acquired (one for each adapter) during initialization
        ; 
        ; The following Virtual Device Help (VDH) services are used during
        ; virtual interrupt processing:
        ;    VDHOpenVIRQ  - Get VIRQ handle, done during initialization
        ;    VDHSetVIRR   - Start virtualizing interrupts
        ;    VDHClearVIRR - Stop virtualizing interrupts.
        ; 
        ; When a VDD receives notification of a hardware interrupt, it starts
        ; virtual interrupt processing by setting VIRR state (VDHSetVIRR).
        ; With this set, the VDM manager will continually interrupt DOS session
        ; execution for interrupt processing.  This action occurs forever
        ; until the VDD clears the interrupt state using VDHClearVIRR.
        ; Given this action, it is normal for the VDD to clear the interrupt
        ; state immediately after the DOS session indicates it has completed
        ; interrupt processing.
        ; 
        ; DOS sessions do not control true IRQ state.  In an environment with
        ; a large number of interrupts, it is possible for the DOS session
        ; to lag behind the real hardware.  That is, the hardware may generate
        ; interrupts more quickly than the DOS session can process.
        ; The VDM manager properly queues successive interrupts which are
        ; virtualized using VDHSetVIRR.  However, this queue occupies space
        ; in the DOS session stack.  With a sufficient number of interrupts,
        ; the DOS session stack will collide with the heap - taking the
        ; DOS session down.  To prevent this undesireable action, the VDD
        ; can queue interrupts - generating a interrupt each time the DOS
        ; session completes processing until the queue is empty.

        mov     eax, Adapters[ebx].PendingIRQs  ; Is a interrupt being
        or      eax, eax                        ; simulated now?
        jz      DoSetVIRR                       ; If not, start IRQ processing

        inc     eax                             ; Add element to queue
        mov     Adapters[ebx].PendingIRQs, eax
        jmp     Done

DoSetVIRR:                                      ; No pending interrupts
        push    Adapters[ebx].hvdm_Owning       ; Start interrupt processing
        push    Adapters[ebx].VIRQHandle
        call    VDHSetVIRR
        jmp     Done

NotInt:
        ; The PDD no longer needs the hardware and is giving us a chance
        ; to restart DOS sessions that were blocked pending availability.

        push    Adapters[ebx].hsemPDDrelease    ; Is a session waiting for
        push    OFFSET FLAT:SemState            ; the PDD to release?
        call    VDHQuerySem
        cmp     SemState.vss_fWaiter, 0         ; 0==no one waiting
        je      Done                            ; No sessions to re-start

        ; At least one DOS session is waiting for
        ; the VDD to gain access to the hardware.

        call    GainOwnershipForVDD             ; Ask PDD for ownership
        or      eax, eax                        ; if eax==0, then Denied
        jz      Done                            ; Another OS/2 session got H/W

        ; VDD gained ownership.
        ; Post event semaphore.  All waiting DOS sessions
        ; will compete to gain ownership of the mutex sem.

        push    Adapters[ebx].hsemPDDrelease    ; Post semaphore
        call    VDHPostEventSem                 ; Make sessions runnable

 Done:  pop     edx                             ; Restore registers
        pop     ecx
        pop     ebx
        pop     es
        pop     ds

        pop     ebp                             ; Restore callers frame
        mov     eax, 1                          ; Indicate success
        db      67h                             ; Force 16:16 return
        ret     12                              ; Return to PDD
AVDD_IDCEntry   ENDP

_TEXT   ENDS                                    ; End of primary code segment
        END                                     ; End of source module
