;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;******************************************************************************
;                 IBM Sample Audio Virtual Device Driver
;
;******************************************************************************
;
; DISCLAIMER OF WARRANTIES.  The following [enclosed] code is
; sample code created by IBM Corporation.
; It is provided to you solely for the purpose of assisting you in the
; development of your applications.
; The code is provided "AS IS", without warranty of any kind.
; IBM shall not be liable for any damages arising out of your use of
; the sample code, even if they have been advised of the possibility
; of such damages.
;
; audioeoi.asm - End Of Interrupt processing
;
; This file contains routines to handle DOS session end of interrupt.
; The EOI notifications are sent to this file by the VDM manager when
; a DOS session indicates end of interrupt.  This activity is a response
; to a hardware interrupt which was virtualized to the DOS session
; using VDHSetVIRR (see audioreq.asm).
; When the DOS session/DOS device driver completes processing the
; interrupt, it sends a EOI signal to the 8259 interrupt controller.
; Of course, in a VDM, it doesn't talk to the real 8259, it talks to
; the virtual interrupt controller who sends us (the VDD) an EOI message.
; VDDs can also capture the DOS device drivers IRET instruction.
; This VDD catches only EOI notifications as this indicates the earliest
; time that the DOS device driver is ready to process a subsequent IRQ.
;
; Note: The OS/2 Virtual Dev Help calls (VDHxxx) preserve
; EBX, EBP, ESI, EDI and the segment regs.  The others are
; fair game.  We need to protect ECX and EDX when it matters.
;******************************************************************************
        .386P                   ; Enable use of ring-0 80386 instructions

        OPTION  OLDMACROS       ; Needed for OS/2 Toolkit when using MASM 6.
       ;INCL_NONE  EQU     1
        INCL_VDH   EQU     1
        INCLUDE mvdm.inc        ; from OS/2 base toolkit
        INCLUDE basemid.inc     ; from OS/2 base toolkit
        INCLUDE devhelp.inc     ; externs for OS/2 Virtual Dev Helps
        INCLUDE vdddata.inc     ; EXTRNS for instance and global variables

; Primary code segment.  NON-swappable, NON-discardable
_TEXT   SEGMENT DWORD USE32 PUBLIC 'CODE'
        ASSUME  CS:_TEXT
        ASSUME  DS:FLAT, SS:FLAT, ES:FLAT



; This VDD supports multiple adapters each having
; independent IRQ processing.
; The VDD work done on EOI is done in a common routine.
; Unfortunately, all supported EOI handlers must have
; their own entry point (otherwise, the VDD wouldn't
; know which IRQ has completed processing).
; The worker routines below receive control for the
; particular adapter.  They set EBX to index the
; Adapters array and call a common routine to do the
; main EOI processsing.
;
; The VDD is responsible for preserving the
; callers EBX, ESI and EDI registers.
;
; PARMS:
;    [ebp+8] - pcrf - Pointer to client register frame
;
; RETURNS: (nothing)

AVDD_EOIHandler0 PROC NEAR
        push    ebx             ; Save callers registers
        xor     ebx, ebx        ; Index into adapters array
        call    AVDD_EOIHandler ; Call primary EOI routine
        pop     ebx             ; Restore callers registers
        ret     4
AVDD_EOIHandler0 ENDP

AVDD_EOIHandler1 PROC NEAR
        push    ebx             ; Save callers registers
        mov     ebx, (sizeof PER_CARD_DATA) * 1
        call    AVDD_EOIHandler ; Call primary EOI routine
        pop     ebx             ; Restore callers registers
        ret     4
AVDD_EOIHandler1 ENDP

AVDD_EOIHandler2 PROC NEAR
        push    ebx             ; Save callers registers
        mov     ebx, (sizeof PER_CARD_DATA) * 2
        call    AVDD_EOIHandler ; Call primary EOI routine
        pop     ebx             ; Restore callers registers
        ret     4
AVDD_EOIHandler2 ENDP

AVDD_EOIHandler3 PROC NEAR
        push    ebx             ; Save callers registers
        mov     ebx, (sizeof PER_CARD_DATA) * 3
        call    AVDD_EOIHandler ; Call primary EOI routine
        pop     ebx             ; Restore callers registers
        ret     4
AVDD_EOIHandler3 ENDP

AVDD_EOIHandler4 PROC NEAR
        push    ebx             ; Save callers registers
        mov     ebx, (sizeof PER_CARD_DATA) * 4
        call    AVDD_EOIHandler ; Call primary EOI routine
        pop     ebx             ; Restore callers registers
        ret     4
AVDD_EOIHandler4 ENDP

AVDD_EOIHandler5 PROC NEAR
        push    ebx             ; Save callers registers
        mov     ebx, (sizeof PER_CARD_DATA) * 5
        call    AVDD_EOIHandler ; Call primary EOI routine
        pop     ebx             ; Restore callers registers
        ret     4
AVDD_EOIHandler5 ENDP

AVDD_EOIHandler6 PROC NEAR
        push    ebx             ; Save callers registers
        mov     ebx, (sizeof PER_CARD_DATA) * 6
        call    AVDD_EOIHandler ; Call primary EOI routine
        pop     ebx             ; Restore callers registers
        ret     4
AVDD_EOIHandler6 ENDP

AVDD_EOIHandler7 PROC NEAR
        push    ebx             ; Save callers registers
        mov     ebx, (sizeof PER_CARD_DATA) * 7
        call    AVDD_EOIHandler ; Call primary EOI routine
        pop     ebx             ; Restore callers registers
        ret     4
AVDD_EOIHandler7 ENDP


                                        ;-------------------- AVDD_EOIHandler -
; DOS session indicates end of interrupt.
; Clear the interrupt state.  If additional
; IRQs are pending, start another IRQ cycle.
;
; PARMS:
;    ebx - Index into Adapters table
;
; RETURNS: (nothing)

AVDD_EOIHandler PROC NEAR
        push    ebp                             ; Establish stack frame
        mov     ebp, esp
        push    ebx                             ; Save callers registers

        push    0                               ; VDM handle (current VDM)
        push    Adapters[ebx].VIRQHandle
        call    VDHClearVIRR                    ; Clear this interrupt

        mov     eax, Adapters[ebx].PendingIRQs  ; Are there any IRQs waiting
        or      eax, eax                        ; in queue?
        jz      Done                            ; If not, we're done

        dec     eax
        mov     Adapters[ebx].PendingIRQs, eax  ; Remove element from queue

        push    Adapters[ebx].hvdm_Owning       ; Generate next virtual IRQ
        push    Adapters[ebx].VIRQHandle
        call    VDHSetVIRR

Done:
        pop     ebx                             ; Restore callers registers
        pop     ebp                             ; Restore stack frame
        ret
AVDD_EOIHandler ENDP

_TEXT   ENDS                                    ; End of primary code segment
        END                                     ; End of source module
