/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/************************* START OF SPECIinCATIONS ***
*
* SOURCE FILE NAME:  VSDQUERY.C
*
* DESCRIPTIVE NAME: Device dependent porition of amp-mixer.
*
*
* STATUS:  OS/2 Release 2.x
*
* FUNCTION:
*
* NOTES: This source module is responsbile for dealing with VSD_QUERY request
*           including:    VSD_QUERYDATTYPE
*                         VSD_QUERYAUDIOATTRIBUTES
*                         VSD_QUERYCONNECTOR
*                         VSD_QUERYMIXCONNECTIONS
*                         VSD_QUERYMIXLINES
*                         VSD_QUERYMIXCONTROL
*
*           other sub-functions return unsupported function.
*
*
*/

#define INCL_NOPMAPI
#define INCL_DOS
#define INCL_ERRORS
#define INCL_AUDIO_VSD
#include <os2.h>
#include <os2me.h>
#include <mcd.h>
#include <audio.h>
#include <stdio.h>
#include <string.h>
#include <hhpheap.h>

#include <vsdcmds.h>
#include <vsdaud.h>
#include <os2mixer.h>
#include <vsdmix.h>


/************************ START OF SPECIFICATIONS **************************
*
* SUBROUTINE NAME: Status_Driver()
*
* FUNCTION: Sends audio status IOCTL request to PDD
*
* INPUT:  pInstance - pointer to AMP/Mixer instance structure
*         ulFlags   - flag indicating what info to return
*         pQueryParms - structure to return information in
*
* SUCESS:  VSDERR_SUCCESS
*
* FAILURE : VSD error code.
*
* OS/2 CALLS: DosDevIOCtl()
*
* C CALLS: None
*
* INTERNAL CALLS: MCI_Error()
*
*************************** END OF SPECIFICATIONS *************************/

LONG VsdQuery( PVSD_INSTANCE    pInstance,
               ULONG            ulFlags,
               PVOID            pQueryParms )

   {
   LONG lError = VSDERR_SUCCESS;

//   ULONG      ulLeftVolume;
//   ULONG      ulRightVolume;

   // 5622      for mute state;

//   BOOL       fLeftActive = TRUE;
//   BOOL       fRightActive = TRUE;



        /***************************************************************((*
        * NO error checking--if the caller passes a bogus param--they trap.
        *  If this sounds harsh, the purpose of the VSD is to be a simple
        *  interface to the audio device for responsible MCI drivers.
        ******************************************************************/

//        if ( !pQueryParms )
//          {
//          return ( VSDERR_MISSING_PARAMETER );
//          }


        switch( ulFlags )
            {
            case VSD_QUERYDATATYPE :
             {
             MCI_AMP_INSTANCE           TempAmp;
             PVSD_AUDIODATATYPE_PARMS   pAudioSettings;

             pAudioSettings = ( PVSD_AUDIODATATYPE_PARMS ) pQueryParms;

             memmove ( &TempAmp,  pInstance, sizeof( MCI_AMP_INSTANCE ) );

             TempAmp.lSRate        = ( LONG ) pAudioSettings->ulSamplingRate;
             TempAmp.sMode         = ( SHORT ) pAudioSettings->ulDataType;
             TempAmp.lBitsPerSRate = ( LONG ) pAudioSettings->ulBitsPerSample;
             TempAmp.sChannels     = ( LONG ) pAudioSettings->ulChannels;
             TempAmp.ulOperation   = pAudioSettings->ulOperation;

             /*-----------------------------------------------------------------*
             * Return the resource class and number of resource units for the
             * mode that the caller has specified.
             *-----------------------------------------------------------------*/

             lError = GetClassInformation( &TempAmp );
             }
             break;

        case VSD_QUERYVOLUME:
              {
              PVSD_VOLUME_PARMS   pVol;
              MIXERCONTROL        MixControl;

              pVol = ( PVSD_VOLUME_PARMS ) pQueryParms;

              pVol->ulVolume = pInstance->lLeftVolume;
              pVol->fMute = !(pInstance->fMute);

             if ( pInstance->fHardwareMix )
                {
                MixControl.ulLength = sizeof( MIXERCONTROL);      // length of the struct
                MixControl.ulLine = pInstance->ulLine;
                MixControl.ulControl = MIX_VOLUME;

                lError = mixGetControl ( pInstance->hMix,
                                         &MixControl );


                // return should be in                 MixControl.ulSetting;
                pVol->ulVolume = ( MixControl.ulSetting / ( 0xffff / 100 )) ;
                }

              }
              break;

        case VSD_QUERYAUDIOATTRIBUTES :
             {
             PVSD_AUDIOATTRIBUTES_PARMS pAudioAttributes;
             MIXERCONTROL               MixControl;

             pAudioAttributes = ( PVSD_AUDIOATTRIBUTES_PARMS ) pQueryParms;
             ulFlags = pAudioAttributes->ulFlags;

             if ( ulFlags == VSD_BALANCE )
                {
                pAudioAttributes->ulValue = pInstance->lBalance;
                MixControl.ulControl = MIX_BALANCE;
                }

             else if ( ulFlags == VSD_GAIN )
                {
                pAudioAttributes->ulValue = pInstance->ulGainLevel;
                // 10253 -- broken

                MixControl.ulControl = MIX_GAIN;
                }

             else if ( ulFlags ==  VSD_BASS )
                {
                pAudioAttributes->ulValue = pInstance->lBass;
                MixControl.ulControl = MIX_BASS;
                }

             else if ( ulFlags == VSD_TREBLE )
                {
                pAudioAttributes->ulValue = pInstance->lTreble;
                MixControl.ulControl = MIX_TREBLE;
                }

             else if ( ulFlags ==  VSD_PITCH )
                {
                pAudioAttributes->ulValue = pInstance->lPitch;
                // 10253 --- this doesn't work
                MixControl.ulControl = MIX_PITCH;
                }

             if ( pInstance->fHardwareMix )
                {
                MixControl.ulLength = sizeof( MIXERCONTROL);      // length of the struct
                MixControl.ulLine = pInstance->ulLine;

                lError = mixGetControl ( pInstance->hMix,
                                         &MixControl );

                pAudioAttributes->ulValue = MixControl.ulSetting / MIXER_MULTIPLIER ;
                }


             } /* switch audio attributes */
             break;
           case VSD_QUERYMONITOR:
                 {
                 PULONG pMon = ( PULONG ) pQueryParms;

                 *pMon = pInstance->lMonitor;
                 break;
                 }
        /*--------------------------------------------------------------------------------
        * The IBM Amp-mixer device has the notion of logical connections. See below:
        *
        *       Input                                            Output
        *                  -------------------------------------
        *                  |                                  |
        *    Microphone  - |                                  |-Speakers (Internal and External)
        *    Line In     - |       Mixer Device               |-Headphones
        * Internal Audio - |                                  |-
        *                  |                                  |
        * Amp Stream     - |                                  |
        *                  |                                  |
        *                  ------------------------------------
        *
        * However, the logical mixer device performs no checking on the type of connectors
        * so, vendors can easily add support for additional connectors.  The logical mixer
        * device takes the request to enable, disable or query the connector and forwards
        * it directly to the VSD.  The VSD should either perform the action or return
        * one of the following errors:
        *
        *     VSDERR_UNSUPPORTED_CONN_TYPE
        *     VSDERR_CANNOT_MODIFY_CONNECTOR
        *     VSDERR_INVALID_CONNECTOR_TYPE
        *-------------------------------------------------------------------------------*/

        case VSD_QUERYCONNECTOR             :
           {
           PVSD_CONNECTOR_PARMS   pVsdCon;

           pVsdCon = ( PVSD_CONNECTOR_PARMS ) pQueryParms;

           if ( pVsdCon->ulConn_Type  == MCI_HEADPHONES_CONNECTOR  ||
                pVsdCon->ulConn_Type  == MCI_VIDEO_IN_CONNECTOR    ||
                pVsdCon->ulConn_Type  == MCI_VIDEO_OUT_CONNECTOR   ||
                pVsdCon->ulConn_Type  == MCI_PHONE_SET_CONNECTOR   ||
                pVsdCon->ulConn_Type  == MCI_PHONE_LINE_CONNECTOR  ||
                pVsdCon->ulConn_Type  == MCI_UNIVERSAL_CONNECTOR   ||
                pVsdCon->ulConn_Type  == MCI_MIDI_STREAM_CONNECTOR ||
                pVsdCon->ulConn_Type  == MCI_CD_STREAM_CONNECTOR   ||
                pVsdCon->ulConn_Type  == MCI_WAVE_STREAM_CONNECTOR )
              {
              lError = VSDERR_UNSUPPORTED_CONN_TYPE;
              }

           if ( lError= ValidateIndex( pVsdCon->ulConn_Type, pVsdCon->ulIndex  ))
              {
              return (lError );
              }

           /*-----------------------------------------------------
           * For now, the amp-stream connector is always enabled.
           * since any MCI driver can always connect to us.
           *----------------------------------------------------*/

           if ( pVsdCon->ulConn_Type  == MCI_AMP_STREAM_CONNECTOR )
              {

               pVsdCon->fEnabled = MCI_TRUE;
               return (lError );
              }

              /*--------------------------------------------------
              * Does the device support the new mixer IOCTL set?
              * If it does, then enabling the connectors will
              * utilze the new IOCTL set.
              *-------------------------------------------------*/

              if ( pInstance->fHardwareMix )
                 {
                  LINECONNECTIONS     mixinfo;

                  /* The MCI connectors map directly to mixer connectors */

                  mixinfo.ulLine = pVsdCon->ulConn_Type;

                  /*----------------------------------------
                  * Actually, all map except for the spaker
                  * connector.  MCI used indexes and mixer
                  * interface always uses defines.
                  *----------------------------------------*/

                  if ( pVsdCon->ulConn_Type == MCI_SPEAKERS_CONNECTOR &&
                       pVsdCon->ulIndex == 2)
                     {
                     mixinfo.ulLine = SOURCE_PC_SPEAKER ;
                     }

                 /*----------------------------------------
                 * Ask the mixer device if it the connector
                 * is enabled.
                 *----------------------------------------*/

                 lError = mixGetConnections ( pInstance->hMix,
                                              &mixinfo );

                 /*--------------------------------------------
                 * Tell the caller if the connector is enabled.
                 *--------------------------------------------*/

                 if ( !lError )
                    {
                    pVsdCon->fEnabled = ( mixinfo.ulConnection) ? MCI_TRUE : MCI_FALSE;
                    }

                 }
              else
                 {
                 /*-------------------------------------------------------------*
                 * Enable connector
                 *-------------------------------------------------------------*/

                 switch( pVsdCon->ulConn_Type )
                         {
                         ULONG     ulMicType;

                         case MCI_LINE_IN_CONNECTOR:
                         case MCI_AUDIO_IN_CONNECTOR   :

                                 pVsdCon->fEnabled = StatusIOPort( STEREO_LINE_INPUT,
                                                                       pInstance,
                                                                       INPUT_PORT );

                                 break;

                         case MCI_MICROPHONE_CONNECTOR:

                                 if ( pInstance->ulGainLevel >= 70 )
                                    {
                                    ulMicType = BOOSTED_MIC_INPUT;
                                    }
                                 else
                                    {
                                    ulMicType = MIC_INPUT;
                                    }
                                 pVsdCon->fEnabled = StatusIOPort( ulMicType,
                                                                       pInstance,
                                                                       INPUT_PORT );
                                 break;

                         case MCI_LINE_OUT_CONNECTOR:
                         case MCI_AUDIO_OUT_CONNECTOR  :

                                 pVsdCon->fEnabled = StatusIOPort( STEREO_LINE_OUTPUT,
                                                                       pInstance,
                                                                       OUTPUT_PORT );

                                 break;

                         case MCI_SPEAKERS_CONNECTOR:

                                 if ( pVsdCon->ulIndex == 2 )
                                    {
                                    pVsdCon->fEnabled = StatusIOPort( SPEAKER_OUTPUT,
                                                                          pInstance,
                                                                          OUTPUT_PORT );
                                    }
                                 else
                                    {
                                    pVsdCon->fEnabled = StatusIOPort( HEADSET_OUTPUT,
                                                                          pInstance,
                                                                          OUTPUT_PORT );
                                    }

                                 break;
                         case MCI_INTERNAL_AUDIO_CONNECTOR :
                                 lError = VSDERR_UNSUPPORTED_CONN_TYPE;
                                 break;
                         default:
                                 lError = VSDERR_INVALID_CONNECTOR_TYPE;
                                 break;
                         }
                 } /* If no hardware mixing caps */

           }  /* Query a connector */

           break;
        case VSD_QUERYMIXCONNECTIONS:
           if ( pInstance->fHardwareMix )
              {
              lError = mixGetConnections ( pInstance->hMix,
                                           ( PLINECONNECTIONS ) pQueryParms );
              }
           else
              {
              lError = VSDERR_UNSUPPORTED_COMMAND;
              }

           break;
        case VSD_QUERYMIXCONTROL:
           if ( pInstance->fHardwareMix )
              {
              lError = mixGetControl ( pInstance->hMix,
                                     ( PMIXERCONTROL ) pQueryParms );
              }
           else
              {
              lError = VSDERR_UNSUPPORTED_COMMAND;
              }

           break;
        case VSD_QUERYMIXLINE:
           if ( pInstance->fHardwareMix )
              {
              lError = mixGetLineInfo ( pInstance->hMix,
                                        ( PMIXERLINEINFO ) pQueryParms );
              }
           else
              {
              lError = VSDERR_UNSUPPORTED_COMMAND;
              }

           break;
        case VSD_QUERYDISPLAY               :
        case VSD_QUERYVIDEOATTRIBUTES       :
        case VSD_QUERYIMAGEATTRIBUTES       :
        case VSD_QUERYTTSATTRIBUTES         :
        case VSD_QUERYCDCAPS                :
        case VSD_QUERYINPUTLEVELS           :
        case VSD_QUERYSTATUSLEVEL           :
        case VSD_QUERYPROCESSINTERNAL       :
        case VSD_QUERYDOOR                  :
        case VSD_QUERYTOC                   :
        case VSD_QUERYUPC                   :
        case VSD_QUERYCOMMSETTINGS          :
        case VSD_QUERYMEDIATYPE             :
        case VSD_QUERYKEYLOCK               :
        case VSD_QUERYRATELEVELS            :
        case VSD_QUERYCUE                   :
        case VSD_QUERYCOUNTER               :
        case VSD_QUERYLENGTH                :
        case VSD_QUERYCOMPATIBLECONNECTORS  :
        case VSD_QUERYSUPPORTEDEVENTS       :
        case VSD_QUERYEVENTLIST             :
        case VSD_QUERYVIEWPORTPOSITION      :
        case VSD_QUERYVIEWPORT              :
        case VSD_QUERYFREEZE                :
        case VSD_QUERYTRACKS                :
        case VSD_QUERYIMAGEFORMAT           :
        case VSD_QUERYDIRECTION             :
        case VSD_QUERYPOSITION              :
             return ( VSDERR_UNSUPPORTED_COMMAND );
        } /* switch ulFlags */
     return ( lError );

  } /* VSDQuery */

