/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/************************* START OF SPECIinCATIONS ***
*
* SOURCE FILE NAME:  VSDOPEN.C
*
* DESCRIPTIVE NAME: Open routines for the VSD.
*
*
*
* FUNCTION: This source module will open the vsd (and associated audio
*           device driver).  This VSD utilizes the AUDIODD interface and an
*           associated resource file to work around limitations in the AUDIODD
*           interface (which has been corrected with the capability IOCTL).
*
*
*    The following concepts are illustrated:
*       1. How to share the same instance with another DLL (MCI Amp-mixer).
*       2. Call to open the connected AUDIODD driver.
*       3. Bring in the VSD resource file (and why it is necessary) or
*          utilize new device capability IOCTL.
*       4. Setup for resource allocation.
*
* NOTES:
*
*/

//#define INCL_NOPMAPI
#define INCL_DOS
#define INCL_ERRORS
//#define INCL_WINSHELLDATA
//#define INCL_WINWINDOWMGR
//#define INCL_WINATOM
//#define INCL_WIN
#define INCL_AUDIO_VSD


#include <os2.h>
#include <os2me.h>
#include <mcd.h>
#include <audio.h>
#include <stdio.h>
#include <string.h>
#include <hhpheap.h>


#include <vsdcmds.h>
#include <vsdaud.h>
#include <os2mixer.h>
#include <vsdmix.h>



/************************ START OF SPECIFICATIONS **************************
*
* SUBROUTINE NAME: Open_Driver()
*
* FUNCTION: Verifies that the Audio DD has been loaded.  Note, the open
*           should not consume any resources.
*
* INPUT:  pInstance - pointer to VSD instance structure
*
* OUTPUT:
*
* SUCESS : VSDERR_SUCCESS
*
* FAILURE: VSDERR_NO_DEVICE_DRIVER
*
* OS/2 CALLS: DosOpen(), DosClose(),
*
* C CALLS: None
*
* INTERNAL CALLS:
*                                                                                                                                                  *
*************************** END OF SPECIFICATIONS *************************/

LONG VSDOpen( PVSD_OPEN_PARMS pVSDOpenParms )

{

    LONG          rc;
//    LONG          lError = VSDERR_SUCCESS;

    PVSD_INSTANCE pInstance;

//    ULONG         ulAction;
//    ULONG         ulOffset;
//    ULONG         ulIniSize;

//    extern HHUGEHEAP    hhpHeap;

//    HAB           hab;
//    HINI          hini;
//    BOOL          fFoundMix;

    PVSD_AUDIOOPEN_PARMS  pvsddata;

//    CHAR          szIniFile[261];
//    CHAR          *pIniName;

    /* If the caller passed in a primer, prime the instance with it */

    pvsddata = ( PVSD_AUDIOOPEN_PARMS ) pVSDOpenParms->pDevInfo;

    /*-------------------------------------------
    * Retrieve IBM instance from vsdData parms
    * note: other VSD writers should NOT use
    * this instance--rather allocate their
    * own instance--since it is liable to
    * change.
    *------------------------------------------*/

    pInstance = ( PVSD_INSTANCE )pvsddata->pDevInfo ;
    pInstance->lSRate          = pvsddata->ulSamplingRate;
    pInstance->lBitsPerSRate   = pvsddata->ulBitsPerSample;
    pInstance->sChannels       = pvsddata->ulChannels;
    pInstance->sMode           = pvsddata->ulDataType;
    pInstance->usDeviceID      = (USHORT) pvsddata->ulDeviceID;
    pInstance->ulOperation     = pvsddata->ulOperation;


    pVSDOpenParms->hvsd = ( HVSD ) pInstance;


    /* Store the name of the DD for future DosOpens */

    memmove( pInstance->szDeviceName,
             pVSDOpenParms->szPDDName,
             strlen( pVSDOpenParms->szPDDName ) );

    /*-----------------------------------------------------------------*
    * Pad the name with the necessary spaces
    *-----------------------------------------------------------------*/

    while( strlen( pInstance->szDeviceName ) < 8)
       {
       strcat( pInstance->szDeviceName, " ");
       }

      pInstance->ulActive     = FALSE;
      pInstance->fMute        = FALSE;
      pInstance->ulNumInputs  = 0;
      pInstance->ulNumOutputs = 0;
//      pInstance->ulGainLevel  = 70;

      /*-----------------------------------------------------
      * Some devices (w/o mixer support) can create some
      * horrible feedback effects.  So allow the manufacturer
      * to determine whether monitoring should be enabled.
      *-----------------------------------------------------*/
      pInstance->lMonitor     = MCI_FALSE;


      /*-----------------------*
      * Open the audio device
      *-----------------------*/

      rc = OpenDevice ( pInstance );
      if ( rc )
         {
         return ( rc );
         }


     /*-----------------------------------------------------------------*
     * New device drivers will support the AUDIO_CAPABILITIES IOCTL.  This
     * IOCTL lets the mixer determine what sampling rate/bit per sample
     * channels etc. the device supports.  If the driver doesn't support
     * the IOCTL, then we must load the information from a resource file.
     *-----------------------------------------------------------------*/
     rc = CapIOCTL( pInstance );
     if ( rc )
        {
        /*-----------------------------------------------------------------*
        * Each manufacturer is responsible for creating a resource file with
        * all the device specific information we require.  Retreive this
        * resource table.
        *-----------------------------------------------------------------*/
        rc = SetupResourceTable( pInstance );

        if ( rc )
           {
           DosClose( pInstance->hFile );
           return ( rc );
           }
        }
// LAD--check ulState variable--can
     if ( pInstance->fDriverCaps & SUPPORT_MIX )
        {
//        rc = mixOpen( ( PHMIXER ) &pInstance->hMix, 0 );
        pInstance->hMix = pInstance->hFile;


        // 10253--this means that we will have to close/reopen the VSD if data-types
        // change.

        switch ( pInstance->sMode )
          {
          case DATATYPE_MIDI :
             pInstance->ulLine = SOURCE_SYNTHESIZER;
             break;
          default :
             pInstance->ulLine = SOURCE_WAVE; // ???
             break;
          }


        /*-----------------------------------------
        * This flag will indicate whether or not
        * we will use the AUDIODD interface or
        * use the new mixer IOCTL's.
        *----------------------------------------*/

//        if ( pInstance->fDriverCaps & SUPPORT_MIX )
//           {
           pInstance->fHardwareMix = TRUE;
//           }

        } /* If we are to open a real mixer */

     /*---------------------------------------------------------
     * We will ignore errors right now, since all DD's may not
     * support the mixer functions.
     *--------------------------------------------------------*/

     /*-----------------------------------------------------------------*
     * Return the resource class and number of resource units for the
     * mode that the caller has specified.
     *-----------------------------------------------------------------*/

     rc = GetClassInformation( pInstance );

     /*-------------------------------------------------
     * Work around ACPA problems.  Since we cannot ask
     * the device driver if it can best fit until after
     * the MCIDRV_RESTORE, perform the best fit on
     * the open.
     *-------------------------------------------------*/

     if ( pInstance->ulDeviceID == MACPA &&
          rc == VSDERR_UNSUPP_SAMPLESPERSEC )
        {
        ACPABestFit( pInstance );
        rc = VSDERR_SUCCESS;
        }
     else if ( rc )
        {
        /*-------------------------------------------------
        * If an error occurs because the VSD can't support the
        * requested mode (i.e. some type of ADPCM the VSD doesn't
        * support, then it should update the following fields
        * in the vsddata parms to the NEAREST mode that is
        * supported.
        *-------------------------------------------------*/

        pvsddata->ulSamplingRate  = pInstance->ulBestFitRate;
        pvsddata->ulBitsPerSample = pInstance->ulBestFitBPS ;
        pvsddata->ulChannels      = pInstance->ulBestFitChan;
        pvsddata->ulDataType      = pInstance->sBestFitMode ;

        DosClose( pInstance->hFile );
        }

      pvsddata->ulDataSubType = pInstance->ulSubType;

     /*-------------------------------------------------
     * The information is only utilized by the IBM VSD.
     * Other VSDs do not have fill in this field.
     *-------------------------------------------------*/

     pvsddata->ulReserved1   = pInstance->ulGlobalFile;

     return(rc);

} /* Open Driver */

