/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/***********************START OF SPECIFICATIONS ****************

*
* SOURCE FILE NAME:  VSDMAP.C
*
* DESCRIPTIVE NAME: Ring 3 Amp/Mixer AUDIO Interface Driver
*
*
* STATUS:  OS/2 Release 2.0
*
* FUNCTION: This file contains a mapping from the old VSD layer to the
*           new VSD layer.  It will be called by older MCDs.  We maintain
*           this for compatibility purposes.
*
* NOTES:
*
* DATE          DEVELOPER                 CHANGE DESCRIPTION
* 07/28/93      Linden deCarmo            File created
*
************************** END OF SPECIFICATIONS **************************/

#define INCL_NOPMAPI
#define INCL_DOS
#define INCL_ERRORS
#define INCL_RESOURCES
#define INCL_AUDIO_VSD



#include <os2.h>
#include <os2me.h>
#include <mcd.h>
#include <audio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <hhpheap.h>

#include <vsdcmds.h>
#include <vsdaud.h>



/************************ START OF SPECIFICATIONS **************************
*
* SUBROUTINE NAME: AUDIOIFIDriverEntry
*
* FUNCTION: Ring 3 entry point for AUDIOIF calls from Amp/Mixer
*
* INPUT:  sMessage      - request id
*         lParam1       - function specific value
*         lParam2       - function specific value
*         lParam3       - identifies caller (1 = Amp/Mixer, 0 = Audio MCI)
*
* OUTPUT: returns VSDERR_SUCCESS if successful, otherwise it returns an
*                 MCI error code.

*
* OS/2 CALLS: None
*
* C CALLS: None
*
* Notes: This entry only maps known callers (i.e. MIDIMCD, Audio MCD etc.)
*        interfaces.  If anyone calls another unsupported interface, they
*        are in deep trouble.
*
*************************** END OF SPECIFICATIONS *************************/

ULONG APIENTRY AUDIOIFDriverEntry(PMCI_AMP_INSTANCE pInstance,
                                  ULONG sMessage,
                                  ULONG lParam1,
                                  ULONG lParam2,
                                  ULONG lParam3)

        {
        LONG lError = VSDERR_SUCCESS;

        if ( sMessage == MCI_SET )
           {
           lError = WaveMap( pInstance, lParam1, lParam2 );
           }

//        switch(sMessage)
//                {
//                /*---------------------------------------------------------*
//                * STATUS message received
//                *---------------------------------------------------------*/
//
////              case MCI_STATUS:
////                      lError = StatusMap(pInstance, lParam2, lParam3);
////
////                        break;
//                /*---------------------------------------------------------*
//                * SET message received
//                *---------------------------------------------------------*/
//
//                case MCI_SET:
//                        /*-------------------------------------------------*
//                        * Map request to manipulate audio data types
//                        *-------------------------------------------------*/
//
//                        lError = WaveMap( pInstance,
//                                          lParam1,
//                                          lParam2 );
//                        break;
//                /*---------------------------------------------------------*
//                * GETDEVCAPS message received
//                *---------------------------------------------------------*/
//
////                case MCI_GETDEVCAPS:
////                        lError = CapsMap( pInstance,
////                                          lParam1,
////                                          (ULONG *) lParam2,
////                                          lParam3 );
//
//                        break;
//                /*---------------------------------------------------------*
//                * MCI_SEQ_STATUS_TEMPO message received
//                *---------------------------------------------------------*/
//
////                case MCI_SEQ_STATUS_TEMPO:
////                        lError = VSDERR_UNSUPPORTED_FUNCTION;
////
////                        break;
//
//                }

        return(lError);
        }




/************************ START OF SPECIFICATIONS **************************
*
* SUBROUTINE NAME: Wave_Driver
*
* FUNCTION: Sets waveform attributes (Sample rate, bits per sample, etc)
*
* INPUT:  pInstance   - pointer to Amp Instance structure
*         lParam1      - pointer to MCI_WAVE_SET_PARMS structure
*
* OUTPUT: returns VSDERR_SUCCESS if successful, otherwise it returns an
*         MCI error code.
*
* OS/2 CALLS: DosDevIOCtl(), DosOpen(), DosClose(), DosQueryFileInfo()
*             DosAllocSharedMem(), DosFreeMem()
*
* C CALLS: None.
*
*
*************************** END OF SPECIFICATIONS *************************/

LONG WaveMap( PMCI_AMP_INSTANCE pInstance,
              ULONG lParam1,
              ULONG lParam2)

{
    LONG                           lError = VSDERR_SUCCESS;

//    ULONG                          ulResourceDecrease;
//    ULONG                          ulResourceChange = FALSE;
//    ULONG                          ulOldResources = pInstance->ulResourcesUsed;
//    ULONG                          ulOldClass = pInstance->ulClass;
//    ULONG ulMatch;


//    MCI_AMP_INSTANCE               TempAmp;

//    MCIDRV_CHANGERESOURCE_PARMS    mciChangeResource;

    LPMCI_WAVE_SET_PARMS           prWaveSet;

    VSD_AUDIODATATYPE_PARMS AudioDatatype;


    prWaveSet = (LPMCI_WAVE_SET_PARMS) lParam2;


    AudioDatatype.ulDataType      = prWaveSet->wFormatTag;
    AudioDatatype.ulBitsPerSample = prWaveSet->wBitsPerSample;
    AudioDatatype.ulSamplingRate  = prWaveSet->nSamplesPerSec;
    AudioDatatype.ulChannels      = prWaveSet->nChannels;
    AudioDatatype.ulFlags = lParam1;

    lError = VSDSetCommand( pInstance, VSD_SETDATATYPE, &AudioDatatype );

    pInstance->sBestFitMode  = DATATYPE_WAVEFORM;
    pInstance->ulBestFitBPS  = AudioDatatype.ulBitsPerSample;
    pInstance->ulBestFitChan = AudioDatatype.ulChannels;
    pInstance->ulBestFitRate = AudioDatatype.ulSamplingRate;


    return(lError);

} /* VSDWave */




///************************ START OF SPECIFICATIONS **************************
//*
//* SUBROUTINE NAME: Status_Driver()
//*
//* FUNCTION: Sends audio status IOCTL request to PDD
//*
//* INPUT:  pInstance - pointer to AMP/Mixer instance structure
//*         lParam1 - flag indicating what info to return
//*         lParam2 - pointer to MCI_STATUS_PARMS structure
//*         lParam3 - indicates who made the request (0 - Audio MCD, 1 = AMP)
//*
//* OUTPUT: returns VSDERR_SUCCESS if successful, otherwise it returns an
//*         MCI error code.
//*
//* OS/2 CALLS: DosDevIOCtl()
//*
//* C CALLS: None
//*
//* INTERNAL CALLS: MCI_Error()
//*
//*************************** END OF SPECIFICATIONS *************************/
//
//LONG StatusMap( PMCI_AMP_INSTANCE pInstance,
//                ULONG lParam2,
//                ULONG lParam3)
//{
//
//   LONG lError = VSDERR_SUCCESS;
//   LPMCI_STATUS_PARMS prStatusParms;
//
//
//   prStatusParms = (LPMCI_STATUS_PARMS) lParam2;
//
//   /*-----------------------------------------------------------------*
//   * Transfer requested status info to Status Parms structure
//   *-----------------------------------------------------------------*/
//
// switch(prStatusParms->dwItem)
//   {
//
//   case MCI_STATUS_READY:
//           if ( pInstance->ulActive )
//             {
//             prStatusParms->dwReturn = MCI_TRUE;
//             }
//           else
//             {
//             prStatusParms->dwReturn = MCI_FALSE;
//             }
//           lError = MAKEULONG(lError, MCI_TRUE_FALSE_RETURN);
//           break;
//   case MCI_STATUS_CURRENT_TRACK:
//            // return some bogus number to remain compatible
//            // with the redmondians
//            prStatusParms->dwReturn = 1;
//            lError = MAKEULONG(lError, MCI_INTEGER_RETURNED);
//            break;
//
//     default:
//             lError = VSDERR_INVALID_ITEM_FLAG;
//             prStatusParms->dwReturn = 0L;
//             lError = MAKEULONG(lError, MCI_INTEGER_RETURNED);
//             break;
//     }
//
//
// return(lError);
//
///* StatusMap */

// removed because all MCI drivers were updated.

/************************ START OF SPECIFICATIONS **************************
*
* SUBROUTINE NAME: DevCaps_Driver
*
* FUNCTION: Returns device capabilities
*
* INPUT:  lParam1       - type of capability
*         lParam2       - pointer to LONG variable to receive capability
*
* OUTPUT: returns VSDERR_SUCCESS if successful, otherwise it returns an
*                 MCI error code.
*
* OS/2 CALLS: None.
*
* C CALLS: None.
*
* INTERNAL CALLS: None.
*
*************************** END OF SPECIFICATIONS *************************/

//LONG CapsMap( PMCI_AMP_INSTANCE pInstance,
//              ULONG             lParam1,
//             ULONG             *lParam2,
//              ULONG             ulCaller )
//{
//  LONG lError = VSDERR_SUCCESS;
//  MCI_AMP_INSTANCE    TempAmp;
//  ULONG               ulrc;
//  PMCI_WAVE_GETDEVCAPS_PARMS  pAudioCaps;
//
//
//
//
//  if ( lParam1 == MCI_GETDEVCAPS_CAN_RECORD )
//     {
//     *lParam2 = pInstance->ulCanRecord;
//     ulrc = VSDERR_SUCCESS;
//     }
//  else if (lParam1 == MCI_GETDEVCAPS_WAVE_FORMAT )
//     {
//     pAudioCaps = ( PMCI_WAVE_GETDEVCAPS_PARMS ) *lParam2;
//
//     memmove ( &TempAmp,  pInstance, sizeof( MCI_AMP_INSTANCE ) );
//
//     TempAmp.lSRate        = ( LONG ) pAudioCaps->ulSamplesPerSec;
//     TempAmp.sMode         = ( SHORT ) pAudioCaps->ulFormatTag;
//     TempAmp.lBitsPerSRate = ( LONG ) pAudioCaps->ulBitsPerSample;
//     TempAmp.sChannels     = ( LONG ) pAudioCaps->ulChannels;
//
//     if ( pAudioCaps->ulFormatMode == MCI_PLAY )
//        TempAmp.ulOperation = OPERATION_PLAY;
//     else
//        TempAmp.ulOperation = OPERATION_RECORD;
//
//     /*-----------------------------------------------------------------*
//     * Return the resource class and number of resource units for the
//     * mode that the caller has specified.
//     *-----------------------------------------------------------------*/
//
//     ulrc = GetClassInformation( &TempAmp );
//
//     pAudioCaps->ulReturn = !ulrc;
//
//
//     } /* wave format request */
//
//  return ( MAKEULONG(ulrc, MCI_TRUE_FALSE_RETURN) );
//
//} /* DevCapsMap */
