/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/************************* START OF SPECIinCATIONS ***
*
* SOURCE FILE NAME:  VSDMAN.C
*
* DESCRIPTIVE NAME: Contains resource management functions.
*
*
* STATUS:  OS/2 Release 2.x
*
* FUNCTION: This source module contains routines to process vsd resource
*           management issues (such as save/restore etc.)
*
* NOTES:
*    The following conecpts are illustrated in these source files:
*       1. VSD_CLOSE (close the device).  This also shows how to save
*            the state of the device in an .ini file.
*       2. VSD_RESTORE (active the VSD).
*       3. VSD_SAVE (deactivate the VSD).  Shows how to use the AUDIO_INIT
*            IOCTL to save device state.
*       4. VSD_RESOURCE (VsdResource).  Returns the number of resource units
*            that a particular mode consumes (i.e. PCM takes x % of the card
*            etc.)
*       5. VsdDevUnits
*
*/

#define INCL_DOS
#define INCL_WINSHELLDATA
//#define INCL_WINWINDOWMGR
#define INCL_WINATOM
#define INCL_WIN
#define INCL_AUDIO_VSD



#include <os2.h>
#include <os2me.h>
#include <mcd.h>
#include <audio.h>
#include <stdio.h>
#include <string.h>
#include <hhpheap.h>

#include <vsdcmds.h>
#include <vsdaud.h>
#include <os2mixer.h>
#include <vsdmix.h>


/************************ START OF SPECIFICATIONS **************************
*
* SUBROUTINE NAME: VSDClose()
*
* FUNCTION: Closes the audio vsd and associated device driver.
*           VSDs should perform all cleanup activity here, since the
*           instance is now TERMINATED!!!!!!
*
* INPUT:  pInstance - pointer to VSD instance
*
* OUTPUT: returns VSDERR_SUCCESS if successful, otherwise it returns an
*         MCI error code.
*
* OS/2 CALLS: DosClose()
*
* C CALLS: None
*
* INTERNAL CALLS: RemoveDevice(), MCI_Error()
*                                                                                                                                                  *
*************************** END OF SPECIFICATIONS *************************/

LONG VSDClose( PVSD_INSTANCE  pInstance )
{

   LONG rc;
   LONG lError = VSDERR_SUCCESS;

  /*-------------------------------------------------
  * If we successfully opened a device, ensure that
  * the file handle is closed.
  *------------------------------------------------*/

  if ( pInstance->ulDosOpened )
     {
     rc = DosClose( pInstance->hFile );
     lError = MCI_Error(rc);
     }


  return(lError);

}  /* CloseDriver */





/************************ START OF SPECIFICATIONS **************************
*
* SUBROUTINE NAME: VSDSave
*
* FUNCTION: Saves state of device in VSD structure
*
* INPUT: prInstance - pointer to AMP/Mixer instance structure
*
* OUTPUT: returns VSDERR_SUCCESS if successful, otherwise it returns an
*         MCI error code.
*
* OS/2 CALLS: DosDevIOCtl()
*
* C CALLS: None.
*
* INTERNAL CALLS: MCI_Error()
*
*************************** END OF SPECIFICATIONS *************************/

LONG VSDSave( PVSD_INSTANCE   pInstance )
   {

//   LONG             rc;
   LONG             lError = VSDERR_SUCCESS;

   /*---------------------------------------------------------*
   * If the instance has already been saved, just succeed
   *---------------------------------------------------------*/

   if ( !pInstance->ulActive  )
     {
     return ( VSDERR_HARDWARE );
     }


   /*-----------------------------------------------------------------*
   * Send AUDIO_INIT IOCTL request to instance to inactive
   *
   * But, if we opened a real mixer (i.e no AUDIODD), then the
   * IOCTLs will not be necessary.
   *----------------------------------------------------*/
   if ( !( !pInstance->ulDefaultsSet && pInstance->fHardwareMix ) )
//      {
//      }
//   else
//
//      {
      lError = DoIOCTLLoad( pInstance, IDLE );
//      }

   if ( !lError )
     {
     pInstance->ulActive = FALSE;
     }

   return(lError);


    } /* VSDSave */


/************************ START OF SPECIFICATIONS **************************
*
* SUBROUTINE NAME: VSDRestore
*
* FUNCTION: Restores state of device saved in VSD structure
*
* INPUT: pInstance - pointer to VSD instance
*
* SUCCESS : VSDERR_SUCCESS
*
* FAILURE : VSD error code.
*
* OS/2 CALLS: DosDevIOCtl()
*
* C CALLS: None.
*
* INTERNAL CALLS: VSDError()
*
*************************** END OF SPECIFICATIONS *************************/

LONG VSDRestore( PVSD_INSTANCE  pInstance )
{

   LONG                     lError = VSDERR_SUCCESS;
//   LONG                     rc;

//   ULONG                    ulOpenIt = TRUE;
//   ULONG                    ulFileSize;
//   ULONG                    ulAction;
//   ULONG                    ulKeepTrying = 0;

//   MCI_AUDIO_INIT           *pAudioInit;
   MCI_MASTERAUDIO_PARMS    mciMasterAudio;

   /*---------------------------------------------------------*
   * If the instance has already been restored, just succeed
   *---------------------------------------------------------*/

   if ( pInstance->ulActive  )
   {
   return ( VSDERR_SUCCESS );
   }

   /*---------------------------------------------------------*
   * Do Audio Init IOCtl call
   *
   * if we opened a real mixer (i.e no AUDIODD), then the
   * IOCTLs will not be necessary.
   *----------------------------------------------------*/

   if ( !( !pInstance->ulDefaultsSet && pInstance->fHardwareMix ) )
//      {
//      }
//   else
      lError = DoIOCTLLoad( pInstance, pInstance->ulHardwareMode );

   if ( !lError )
     {
     /*------------------------------------------------
     * Once the VSD is active, set up the
     * appropriate volume settings.
     * To accomplish this, ask MDM the current volume
     * state.
     *-----------------------------------------------*/

     lError = mciSendCommand( pInstance->usDeviceID,
                              MCI_MASTERAUDIO,
                              MCI_QUERYCURRENTSETTING | MCI_MASTERVOL | MCI_WAIT,
                              ( DWORD ) &mciMasterAudio,
                              0 );

     if ( ( DWORD_LOWD( lError ) == VSDERR_SUCCESS ) )
       {

       // set our instance's master vol. to the system master volume

       pInstance->ulMasterVolume = mciMasterAudio.dwReturn;

       pInstance->ulDosOpened = TRUE;
       pInstance->ulActive    = TRUE;

       /*-----------------------------------------------------
       * if we opened a real mixer (i.e no AUDIODD), then the
       * IOCTLs will not be necessary.
       *----------------------------------------------------*/
       if ( !pInstance->fHardwareMix )
          {
          lError = ModifyAudioAttributes(pInstance, VSD_SET_ALL );
          }
       else
          {
          lError = VSDERR_SUCCESS;
          }

       }  /* if send command was a success */

     } /* if no error on load */


   return(lError);

} /* VSDRestore */



/************************ START OF SPECIFICATIONS **************************
*
* SUBROUTINE NAME: VSDDevUnits
*
* FUNCTION: Returns the number of devices supported by the VSD.
*
* INPUT: pInstance - pointer to VSD instance
*
* SUCCESS : VSDERR_SUCCESS
*
* FAILURE : VSD error code.
*
* OS/2 CALLS: DosDevIOCtl()
*
* C CALLS: None.
*
* INTERNAL CALLS: VSDError()
*
*************************** END OF SPECIFICATIONS *************************/

LONG VSDDevUnits( PVSD_INSTANCE        pInstance,
                  PVSD_DEVUNITS_PARMS  pRequest )

{
   pRequest->VSD_Unit[0].ulDevType = MCI_DEVTYPE_AUDIO_AMPMIX;
   return ( VSDERR_SUCCESS );

} /* VSDDevUnits */


/************************ START OF SPECIFICATIONS **************************
*
* SUBROUTINE NAME: VSDDevUnits
*
* FUNCTION: Returns the number of devices supported by the VSD.
*
* INPUT: pInstance - pointer to VSD instance
*
* SUCCESS : VSDERR_SUCCESS
*
* FAILURE : VSD error code.
*
* OS/2 CALLS: DosDevIOCtl()
*
* C CALLS: None.
*
* INTERNAL CALLS: VSDError()
*
*************************** END OF SPECIFICATIONS *************************/

LONG VSDResource( PVSD_INSTANCE        pInstance,
                  PVSD_RESOURCE_PARMS  pRequest )

{
   VSD_INSTANCE  TempInst;
   ULONG         rc;



  if ( pInstance->fHardwareMix && !pInstance->ulDefaultsSet )
     {
     /* True hardware mixer--right now, not really taking resource */
     // LAD--must add new mixer class, only one active at a time.

     pRequest->ulResUnits = 0;
     pRequest->ulClass = PCM_CLASS;
     rc = VSDERR_SUCCESS;
     }
  else
     {

     memmove ( &TempInst, pInstance, sizeof ( VSD_INSTANCE ) );
     /*-----------------------------------------------------------------*
     * Return the resource class and number of resource units for the
     * mode that the caller has specified.
     *-----------------------------------------------------------------*/

     rc = GetClassInformation( &TempInst );

     /*-------------------------------------------------
     * Work around ACPA problems.  Since we cannot ask
     * the device driver if it can best fit until after
     * the MCIDRV_RESTORE, perform the best fit on
     * the open.
     *-------------------------------------------------*/

     if ( TempInst.ulDeviceID == MACPA &&
          rc == VSDERR_UNSUPP_SAMPLESPERSEC )
        {
        ACPABestFit( &TempInst );
        rc = VSDERR_SUCCESS;
        }

      /* Return the resource management info to the caller */

      pRequest->ulResUnits = TempInst.ulResourcesUsed;
      pRequest->ulClass = TempInst.ulClass;
     } /* if we are not using a true hardware mixer */

    return ( rc );

} /* VSDDevUnits */
