/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/************************* START OF SPECIinCATIONS ***
*
* SOURCE FILE NAME:  VSDCONN.C
*
* DESCRIPTIVE NAME: VSD connector manipulator
*
*
* STATUS:  OS/2 Release 2.0
*
* FUNCTION: The file contains routines to enable/disable and query the
*           the status of connectors.
*
*/

#define INCL_NOPMAPI
#define INCL_DOS
#define INCL_ERRORS
#define INCL_AUDIO_VSD
#include <os2.h>
#include <os2me.h>
#include <mcd.h>
#include <audio.h>
#include <stdio.h>
#include <string.h>
#include <hhpheap.h>


#include <vsdcmds.h>
#include <vsdaud.h>


LONG Set_IO_Ports( LPMCI_AUDIO_CHANGE prAudioChange,
                   PMCI_AMP_INSTANCE  prInstance,
                   LONG               ulFlags )
{

   ULONG         i;
   ULONG         ulNumPorts;


   prAudioChange->lInput = INPUTS_LISTED;
   prAudioChange->lOutput = OUTPUTS_LISTED;


   for ( ulNumPorts = 0; ulNumPorts <= prInstance->ulNumInputs; ulNumPorts++ )
      {
      // if we are in record mode--DO NOT enable an input
      // not sure why this code is here.

//      if ( prInstance->ulOperation == OPERATION_PLAY )
//         {
//         prAudioChange->rInputList[ ulNumPorts ].ulDevType = NULL_INPUT;
//         prAudioChange->rInputList[ ulNumPorts ].ulDevNum  = NULL_INPUT;
//
//         }
//      else
//         {

//         if ( ulFlags & VSD_SET_CONN )
//            {
            prAudioChange->rInputList[ ulNumPorts ].ulDevType =
                         prInstance->rInputList[ ulNumPorts ].ulDevType;
//            }

//         else
//            {
//            prAudioChange->rInputList[ ulNumPorts ].ulDevType = AUDIO_IGNORE;
//            }
//         }

      prAudioChange->rInputList[ ulNumPorts ].ulDevNum = DEVICE_1;
      }

   for ( ulNumPorts = 0; ulNumPorts <= prInstance->ulNumOutputs; ulNumPorts++ )
      {
//      if ( ulFlags & VSD_SET_CONN )
//         {
         prAudioChange->rOutputList[ ulNumPorts ].ulDevType =
                      prInstance->rOutputList[ ulNumPorts ].ulDevType;
//         }
//      else
//         {
//         prAudioChange->rOutputList[ ulNumPorts ].ulDevType = AUDIO_IGNORE;
//         }

      prAudioChange->rOutputList[ ulNumPorts ].ulDevNum = DEVICE_1;
      }

   if ( prInstance->ulNumInputs < LIST_LEN )
      {
      for ( i = prInstance->ulNumInputs + 1; i < LIST_LEN; i++)
         {
         prAudioChange->rInputList[ i ].ulDevType = NULL_INPUT;
         prAudioChange->rInputList[ i ].ulDevNum  = NULL_INPUT;
         }
      }

   if ( prInstance->ulNumOutputs + 1  < LIST_LEN )
      {
      for ( i = prInstance->ulNumOutputs + 1; i < LIST_LEN; i++)
         {
         prAudioChange->rOutputList[ i ].ulDevType = NULL_OUTPUT;
         prAudioChange->rOutputList[ i ].ulDevNum  = NULL_OUTPUT;
         }
       }
   return(0L);

} /* Set IO Ports */






/************************** START OF SPECIFICATIONS ************************
*                                                                          *
* SUBROUTINE NAME: AddPort                                                 *
*                                                                          *
* DESCRIPTIVE NAME: Add a port                                             *
*                                                                          *
* FUNCTION: Adds a port to the list of active ports and ensures that       *
*           exists for the application and if it has the right access.     *
*                                                                          *
* NOTES:    This routine contains OS/2 system specific functions.          *
*           DosQueryMem                                                    *
*                                                                          *
* INPUT:    PortArray - Array which contains the list of ports             *
*           ulPort    -                                                    *
*           removed because ACPA does not support lists                    *
*                                                                          *
* OUTPUT:   VSDERR_SUCCESS                                                 *
*           VSDERR_CANNOT_MODIFY_CONNECTOR -- if too many ports            *
*                                                                          *
* SIDE EFFECTS:                                                            *
*                                                                          *
*************************** END OF SPECIFICATIONS *************************/

ULONG AddIOPort( ULONG              ulPort,
                 PVSD_INSTANCE      pInstance,
                 ULONG              ulDirection )

{
 if ( ulDirection == OUTPUT_PORT )
     {
     if ( pInstance->ulNumOutputs > LIST_LEN )
        {
        return VSDERR_HARDWARE;
        }

     // if this port is not already on the list of active ports,
     // activate it

     if ( !StatusIOPort( ulPort, pInstance, ulDirection ) )
        {
        pInstance->rOutputList[ pInstance->ulNumOutputs ].ulDevType = ulPort;
        pInstance->rOutputList[ pInstance->ulNumOutputs++ ].ulDevNum = DEVICE_1;
        }
     }
  else if ( ulDirection == INPUT_PORT )
     {
     if ( pInstance->ulNumInputs > LIST_LEN )
        {
        return VSDERR_HARDWARE;
        }
     pInstance->rInputList[ pInstance->ulNumInputs ].ulDevType = ulPort;
     pInstance->rInputList[ pInstance->ulNumInputs ].ulDevNum = DEVICE_1;
     }

  return VSDERR_SUCCESS;



} /* AddPort */

/************************* START OF SPECIFICATIONS *************************
*                                                                          *
* SUBROUTINE NAME: RemovePort                                              *
*                                                                          *
* DESCRIPTIVE NAME: Remove a Port                                          *
*                                                                          *
* FUNCTION: Removes a port from the list of active ports and ensures that  *
*           the if all ports are turned off, the ACPA will still have the  *
*           mike on                                                        *
*                                                                          *
* NOTES:    This routine contains OS/2 system specific functions.          *
*           DosQueryMem                                                    *
*                                                                          *
* INPUT:    PortArray - Array which contains the list of ports             *
*           ulPort    -                                                    *
*                                                                          *
* OUTPUT:   VSDERR_SUCCESS                                                 *
*           VSDERR_CANNOT_MODIFY_CONNECTOR -- if too many ports            *
*                                                                          *
* SIDE EFFECTS:                                                            *
*                                                                          *
*************************** END OF SPECIFICATIONS *************************/

ULONG RemoveIOPort( ULONG           ulPort,
                    PVSD_INSTANCE   pInstance,
                    ULONG           ulDirection )

{
ULONG           ulSearchCounter = 0;
ULONG           ulFoundPort;

  if ( ulDirection == OUTPUT_PORT )
     {
     if ( pInstance->ulNumOutputs > LIST_LEN )
        {
        return VSDERR_HARDWARE;
        }
     // acpa specific code-- no way to turn off the mike if it is the
     // last connector

     while ( ulSearchCounter <= pInstance->ulNumOutputs )
       {
       if ( pInstance->rOutputList[ ulSearchCounter ].ulDevType == ulPort )
          {
          ulFoundPort = MCI_TRUE;
          break;
          }
       ulSearchCounter++;
       }

     if ( ulFoundPort )
        {
        // move the remainder of the list forward


        memmove( &pInstance->rOutputList[ ulSearchCounter ],
                 &pInstance->rOutputList[ ulSearchCounter + 1 ],
                 ( ( LIST_LEN - 1) - ulSearchCounter + 1 ) * sizeof ( MCI_PORT_LIST ) );
        pInstance->ulNumOutputs--;
        }

     }
  else if ( ulDirection == INPUT_PORT )
     {
     if ( pInstance->ulNumInputs > LIST_LEN )
        {
        return VSDERR_HARDWARE;
        }
     pInstance->rInputList[ pInstance->ulNumInputs ].ulDevType = 0;
     pInstance->rInputList[ pInstance->ulNumInputs ].ulDevNum = 0;
     }
  return VSDERR_SUCCESS;



} /* RemoveIOPort */


/************************* START OF SPECIFICATIONS *************************
*                                                                          *
* SUBROUTINE NAME: StatusPort                                              *
*                                                                          *
* DESCRIPTIVE NAME: Status for a port                                      *
*                                                                          *
* FUNCTION: Returns if a particular port is currently active.              *
*                                                                          *
* NOTES:    This routine contains OS/2 system specific functions.          *
*           DosQueryMem                                                    *
*                                                                          *
* INPUT:    ulPort                                                         *
*                                                                          *
* OUTPUT:   MCI_TRUE                                                       *
*           MCI_FALSE                                                      *
*                                                                          *
* SIDE EFFECTS:                                                            *
*                                                                          *
*************************** END OF SPECIFICATIONS **************************/

ULONG StatusIOPort( ULONG              ulPort,
                    PVSD_INSTANCE      pInstance,
                    ULONG              ulDirection )

{
  ULONG     ulSearchCounter = 0;
  ULONG     ulFoundPort     = MCI_FALSE;

  if ( ulDirection == OUTPUT_PORT )
     {

     if ( pInstance->ulNumOutputs > LIST_LEN )
        {
        return VSDERR_HARDWARE;
        }

    // loop through the list of inputs till we hit the end or we
    // find the port

     while ( ulSearchCounter <= pInstance->ulNumOutputs )
       {
       if ( pInstance->rOutputList[ ulSearchCounter ].ulDevType == ulPort )
          {
          ulFoundPort = MCI_TRUE;
          break;
          }
       ulSearchCounter++;
       }

     }
  else if ( ulDirection == INPUT_PORT )
     {

     if ( pInstance->ulNumInputs > LIST_LEN )
        {
        return VSDERR_HARDWARE;
        }
    // loop through the list of inputs till we hit the end or we
    // find the port

     while ( ulSearchCounter <= pInstance->ulNumInputs )
       {
       if ( pInstance->rInputList[ ulSearchCounter ].ulDevType == ulPort )
          {
          ulFoundPort = MCI_TRUE;
          break;
          }
       ulSearchCounter++;
       }
     }
   return ulFoundPort;

} /* AddPort */


/************************* START OF SPECIFICATIONS *************************
*                                                                          *
* SUBROUTINE NAME: ValidateIndex                                           *
*                                                                          *
* DESCRIPTIVE NAME: Reports if a connector index is valid.                 *
*                                                                          *
* FUNCTION: Returns if a particular port is currently active.              *
*                                                                          *
* NOTES:    This routine reports if the mixer device supports a particular *
*           connector index.  More than one Connectors (i.e. the speakers) *
*           can be attached to the VSD.  Individual connectors are         *
*           distinguished by the index.                                    *
*                                                                          *
* INPUT:    ulPort                                                         *
*                                                                          *
* OUTPUT:   MCI_TRUE                                                       *
*           MCI_FALSE                                                      *
*                                                                          *
* SIDE EFFECTS:                                                            *
*                                                                          *
*************************** END OF SPECIFICATIONS **************************/



ULONG ValidateIndex( ULONG ulType, ULONG ulIndex )

{
    /*---------------------------------------------------------------------*
    * Ensure only that valid index's are used
    *---------------------------------------------------------------------*/

    if ( ulType == MCI_SPEAKERS_CONNECTOR )
       {
       if ( ulIndex > 2 )
          {
          return VSDERR_INVALID_CONNECTOR_INDEX;
          }
       }
    else if ( ulIndex != 1 )
       {
       return VSDERR_INVALID_CONNECTOR_INDEX;
       }  /* If the index is not one */

    return ( VSDERR_SUCCESS );
} /* ValidateIndex */
