/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/************************* START OF SPECIinCATIONS ***
*
* SOURCE FILE NAME:  VSDCAP.C
*
* DESCRIPTIVE NAME: Ring 3 Amp/Mixer AUDIO Interface Driver
*
*
* STATUS:  OS/2 Release 2.0
*
* FUNCTION: This source module contains the ring 3 (DLL) entry point for
*           MCD Amp/Mixer calls from the Amp/Mixer or Waveform handler
*
* NOTES:
*        DEPENDENCIES: ACPA PDD
*        RESTRICTIONS: Runs in 32 bit protect mode (OS/2 2.0)
*
* ENTRY POINT:
*        AUDIOIFDriverEntry
*
* EXTERNAL REFERENCES: Sends IOCTL request to ACPA audio board
*
*/

#define INCL_NOPMAPI
#define INCL_DOS
#define INCL_ERRORS
#define INCL_AUDIO_VSD
#include <os2.h>
#include <os2me.h>
#include <mcd.h>
#include <audio.h>
#include <stdio.h>
#include <string.h>
#include <hhpheap.h>


#include <vsdcmds.h>        // generic vsd include file
#include <vsdaud.h>         // local vsd include file
#include <os2mixer.h>
#include <vsdmix.h>


/************************ START OF SPECIFICATIONS **************************
*
* SUBROUTINE NAME: Device_Caps
*
* FUNCTION: Returns device capabilities
*
* INPUT:  lParam1       - type of capability
*         lParam2       - pointer to LONG variable to receive capability
*
* OUTPUT: returns VSDERR_SUCCESS if successful, otherwise it returns an
*                 MCI error code.
*
* OS/2 CALLS: None.
*
* C CALLS: None.
*
* INTERNAL CALLS: None.
*
*************************** END OF SPECIFICATIONS *************************/

LONG VSDCaps( PVSD_INSTANCE         pInstance,
              ULONG                 ulFlags,
              PVSD_GETDEVCAPS_PARMS pCapsParms )


{

   LONG lError = VSDERR_SUCCESS;


//   if ( !pCapsParms || pCapsParms->ulLength < VSD_GETDEVCAPS_Len )
//      {
//      return ( VSDERR_REQUEST_BUF_TOO_SMALL );
//      }

// MIXER info
//   if ( ulFlags == VSD_MIXCAPS )
//      {

// *********************************
// LAD--need define for mixer device
// rather than 0.
// *********************************

//      lError = mixGetDevCaps( ( PMIXERCAPS ) pCapsParms );
//      }
//   else
//   if ( ulFlags == VSD_MIXLINECAPS )
//      {
//
//      lError = mixGetLineInfo( pInstance->hMix, ( PMIXERLINEINFO ) pCapsParms );
//
//      }
// MIXER info
//   else
//      {
      pCapsParms->ulMax_Caps = 7;
      pCapsParms->ulNum_Caps = 7;

      pCapsParms->bSupports[ DC_HASAUDIO ]             = DC_TRUE;
      pCapsParms->bSupports[ DC_HASAUDIOATTRIBUTES ]   = DC_TRUE;
      pCapsParms->bSupports[ DC_HASAUDIOCAPABILITIES ] = DC_TRUE;
      pCapsParms->bSupports[ DC_HASVOLUME ]            = pInstance->ulVolControl;
      pCapsParms->bSupports[ DC_HASINPUTLEVEL ]        = DC_TRUE;
      pCapsParms->bSupports[ DC_HASMONITOR ]           = DC_TRUE;
      pCapsParms->bSupports[ DC_CANPLAY ]              = DC_TRUE;
      pCapsParms->bSupports[ DC_CANRECORD ]            = pInstance->ulCanRecord;
//      } /* if no error */

   return(lError);

} /* VSDCaps */

