/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************START OF SPECIFICATIONS *************************
*                                                                          *
* Module NAME:  VSDAUD.H                                                   *
*                                                                          *
*                                                                          *
* OS/2 2.0 Multimedia VSD structures and definitions for audio devices     *
*                                                                          *
************************** END OF SPECIFICATIONS ***************************/

#define INCL_SEMAPHORES

#define  INPUT_PORT              1
#define  OUTPUT_PORT             2


// values for RC file -- should be in SHIP_H!!!!!!
#define  STATIC_RATE             0L
#define  BEGIN_CONTINUOUS        1L
#define  END_CONTINUOUS          2L

#define  AMP_MIX                 1
#define  NON_AMP_MIX             0
#define  CT_ADPCM                DATATYPE_CT_ADPCM



#define NUMMODES                8
#define KNOWN_AUDIODD_MAPS      8


#define  NUM_DATATYPES           54
#define  RIFF_PCM                 1
#define  RIFF_ADPCM               103

// Classes used for resource management
#define  PCM_CLASS               1
#define  MIDI_CLASS              2
#define  AVC_MUSIC_CLASS         3
#define  AVC_HQ_CLASS            4
#define  AVC_VOICE_CLASS         5
#define  AVC_STEREO_CLASS        6
#define  RECORD_CLASS            7
#define  PCM_STEREO_CLASS        8
#define  MIX_CLASS               3
#define  NO_CLASS_DETERMINED     100

// known cards, others can be added via an .rc file

#define MAUDIO                  1
#define SB                      2
#define SB_PRO                  3
#define SB_16                   4
#define PAS_16                  5
#define FOXGLOVE                6
#define SPEAKER                 7
#define THINKPAD                8


// ini file defines
#define OS2_MIX_KEY             1

// capability IOCTL defines

/******************************************************/
        // Waveform Table DataStructure
/******************************************************/
typedef struct _mode_data_typ
  {
   ULONG      ulDataType;        /* PCM, ADPCM, etc..       */
   ULONG      ulDataSubType;     /* Freq, bits/sam,..       */
   short      mode_num;          /* Mode Constant           */
   int        flags;             /* Fixed or 2s Comp        */
   LONG       srate;             /* 11,22,44 Khz            */
   LONG       bits_per_sample;   /* 8 or 16 bits/sam        */
   SHORT      channels;          /* Mono or Stereo          */
   ULONG      ulBytes;           /* Scaled for Time Calcs    */
   ULONG      ulMMTime;          /* Scaled for Time Calcs    */

   }MODE_DATA;



#ifdef AUDIO_VSD
typedef MCI_WAVE_GETDEVCAPS_PARMS  VSD_WAVE_GETDEVCAPS_PARMS;
typedef PMCI_WAVE_GETDEVCAPS_PARMS  PVSD_WAVE_GETDEVCAPS_PARMS;
#endif


#pragma pack(1)
typedef struct _class_data
  {
   ULONG      ulDataType;           /* PCM, ADPCM, etc..       */
   ULONG      ulSubType;            /* Freq, bits/sam,..       */
   USHORT     sSRate;               /* 11,22,44 Khz            */
   USHORT     sBitsPerSRate;        /* 8 or 16 bits/sam        */
   USHORT     usChannels;           /* Mono or Stereo          */
   ULONG      ulSamplingDescription;
   USHORT     usPlayClass;
   USHORT     usPlayUnits;
   USHORT     usRecordClass;
   USHORT     usRecordUnits;
   }CLASS_DATA;
#pragma pack()

typedef struct _VSD_BEST_FIT
  {
  LONG       lBPSGuess;
  LONG       lChanGuess;
  LONG       lSampGuess;
  } VSD_BEST_FIT;

#define FIX2C   FIXED + TWOS_COMPLEMENT



/*-------------------------------------------------------------------------*
* Table to convert gain % to number
*-------------------------------------------------------------------------*/
typedef struct
        {
        ULONG   ulGainValue;
        } GAINTABLE;

#define NUMGAINENTRIES  18



#define AUDIOIF_MULTIPLIER           0x147AE14        // 0x7FFFFFFF / 100
#define AUDIOIF_DIVISOR              0x147            // 0x7fff / 100 -- get one word
#define NOT_INITIALIZED             -1




/* Prototypes for audio vsd */

/* Public API's */

LONG VSDOpen( PVSD_OPEN_PARMS pVSDOpenParms );
LONG VsdQuery( PVSD_INSTANCE pInstance, ULONG uFlags, PVOID pQueryParms );
LONG VSDClose( PVSD_INSTANCE  pInstance );
LONG VSDSave( PVSD_INSTANCE   pInstance );
LONG VSDRestore( PVSD_INSTANCE   pInstance );
LONG VSDDevUnits( PVSD_INSTANCE pInstance, PVSD_DEVUNITS_PARMS  pRequest );
LONG VSDResource( PVSD_INSTANCE pInstance, PVSD_RESOURCE_PARMS  pRequest );
LONG VSDSetCommand( PVSD_INSTANCE pInstance, ULONG ulFlags, PVOID pRequest );
LONG VSDGetProdInfo( PVSD_INSTANCE pInstance, PVSD_GETPRODINFO_PARMS  pInfoParms );
LONG VSDCaps( PVSD_INSTANCE pInstance, ULONG ulFlags, PVSD_GETDEVCAPS_PARMS pQueryParms );


/* Private functions */
LONG MCI_Error(ULONG lError);
LONG ModifyAudioAttributes( PVSD_INSTANCE  pInstance, ULONG ulFlags );
LONG  DoIOCTLLoad( PVSD_INSTANCE  pInstance, SHORT sMode );
LONG LoadDSP( PVSD_INSTANCE pInstance, LPMCI_AUDIO_INIT   pAudioInit);
ULONG SetupResourceTable( PVSD_INSTANCE    pInstance );
ULONG GetClassInformation( PVSD_INSTANCE   pInstance );
void BestGuess ( LONG, LONG, LONG, LONG, LONG, LONG, LONG, VSD_BEST_FIT *);
void MapModes( PVSD_INSTANCE    pInstance );
void  ACPABestFit( PVSD_INSTANCE   pInstance );
LONG Set_IO_Ports( LPMCI_AUDIO_CHANGE pAudioChange, PVSD_INSTANCE pInstance, LONG ulFlags );
ULONG AddIOPort( ULONG ulPort, PVSD_INSTANCE  pInstance, ULONG ulDirection );
ULONG RemoveIOPort( ULONG ulPort, PVSD_INSTANCE pInstance, ULONG ulDirection );
ULONG StatusIOPort( ULONG ulPort, PVSD_INSTANCE pInstance, ULONG ulDirection );

LONG WaveMap( PMCI_AMP_INSTANCE pInstance, ULONG lParam1, ULONG lParam2);
LONG StatusMap( PMCI_AMP_INSTANCE pInstance, ULONG lParam2, ULONG lParam3);
LONG CapsMap( PMCI_AMP_INSTANCE pInstance, ULONG lParam1, ULONG *lParam2, ULONG ulCaller);
ULONG CapIOCTL( PVSD_INSTANCE    pInstance );
ULONG OpenDevice ( PVSD_INSTANCE      pInstance );
ULONG ValidateIndex( ULONG ulType, ULONG ulIndex  );
ULONG vsdDDCMDEntryPoint (PVOID pEntry);


/* Mixer stuff */

