/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/********************* START OF SPECIFICATIONS *****************************
*                                                                          *
* SOURCE FILE NAME: OS2MIXER.C                                             *
*                                                                          *
* DESCRIPTIVE NAME: Multi-Media Mixer Library                              *
*                                                                          *
* COPYRIGHT:                                                               *
*              Copyright (c) Media Vision  1991,1992, 1993                 *
*                                                                          *
* 05/24/94      Linden deCarmo            Eliminated mixOpen               *
* 06/08/94      Linden deCarmo            Update structs per FRB           *
* 06/11/94      Linden deCarmo            VSD documentation improvements   *
* 06/11/94      Linden deCarmo            Removed unused mixer functions   *
* 06/15/94      Linden deCarmo            Updated error mapping.           *
* 06/16/94      Linden deCarmo            Created consistend comments.     *
*                                                                          *
*********************** END OF SPECIFICATIONS ******************************/

#define INCL_NOPMAPI                   // no PM include files required
#define INCL_DOSFILEMGR                // need for Dos File I/O API's
#define INCL_DOSDEVICES                // Device values
#define INCL_DOS
#define INCL_ERRORS

#define INCL_AUDIO_VSD

#include <os2.h>
#include <os2def.h>

#include <os2me.h>
#include <mcd.h>

#include <audio.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <os2mixer.h>                  // header defs for this I/O proc
#include <vsdcmds.h>
#include <vsdaud.h>

void MapMixErrors (PULONG       pulError );
ULONG  MixMessage( HMIXER   hMix, ULONG    msg, PVOID    pData, ULONG    ulDataSize );

/************************** START OF SPECIFICATIONS ************************
*                                                                          *
* SUBROUTINE NAME: mixGetConnections                                       *
*                                                                          *
* DESCRIPTIVE NAME: Determine if a mixer line is enabled.                  *
*                                                                          *
* FUNCTION: Call audio device driver to determine if source (in ulLine)    *
*           is connected to anything.  Valid sinks are returned in         *
*           ulConnection.                                                  *
*                                                                          *
* OUTPUT:   VSDERR_SUCESS if there was a match                             *
*           An MCI error otherwise                                         *
*                                                                          *
* SIDE EFFECTS:                                                            *
*                                                                          *
*************************** END OF SPECIFICATIONS **************************/

ULONG mixGetConnections ( HMIXER             hMixer,
                          PLINECONNECTIONS   pConnections)
{
  USHORT usLastError;


   usLastError=MixMessage( hMixer,
                          MIX_GETCONNECTIONS,
                          (PVOID ) pConnections,
                          sizeof (LINECONNECTIONS ) );

   return(usLastError);

} /* mixGetConnections */

/************************** START OF SPECIFICATIONS ************************
*                                                                          *
* SUBROUTINE NAME: mixSetConnections                                       *
*                                                                          *
* DESCRIPTIVE NAME: Connects a mixer source to a sink.                     *
*                                                                          *
* FUNCTION: Call audio device driver to connect a source (in ulLine)       *
*           to a sink (in ulConnection).                                   *
*                                                                          *
* OUTPUT:   VSDERR_SUCESS if there was a match                             *
*           An MCI error otherwise                                         *
*                                                                          *
* SIDE EFFECTS:                                                            *
*                                                                          *
*************************** END OF SPECIFICATIONS **************************/

ULONG mixSetConnections ( HMIXER               hMixer,
                          PLINECONNECTIONS     pConnections)
{
  USHORT usLastError;



  usLastError=MixMessage( hMixer,
                          MIX_SETCONNECTIONS,
                          (PVOID ) pConnections,
                          sizeof ( LINECONNECTIONS ) );
  return(usLastError);

} /* mixSetConnections */



/************************** START OF SPECIFICATIONS ************************
*                                                                          *
* SUBROUTINE NAME: mixGetLineInfo                                          *
*                                                                          *
* DESCRIPTIVE NAME: Returns capabilities (i.e. volume etc.) for a given    *
*                   line.                                                  *
*                                                                          *
* FUNCTION: Call audio device driver to determine the source's (in ulLine) *
*           capabilities (returned in ulSupport).                          *
*                                                                          *
* OUTPUT:   VSDERR_SUCESS if there was a match                             *
*           An MCI error otherwise                                         *
*                                                                          *
* SIDE EFFECTS:                                                            *
*                                                                          *
*************************** END OF SPECIFICATIONS **************************/


ULONG mixGetLineInfo( HMIXER          hMixer,
                      PMIXERLINEINFO  pInfo )
{
  USHORT usLastError;

   usLastError=MixMessage( hMixer,
                          MIX_GETLINEINFO,
                          (PVOID) pInfo,
                          sizeof( MIXERLINEINFO ));

return(usLastError);
}

/************************** START OF SPECIFICATIONS ************************
*                                                                          *
* SUBROUTINE NAME: mixGetControl                                           *
*                                                                          *
* DESCRIPTIVE NAME: Determine the state of a line's controls.              *
*                                                                          *
* FUNCTION: Call audio device driver to determine the source's (in ulLine) *
*           control (in ulControl) setting (i.e. range 0-0xffff).          *
*                                                                          *
* OUTPUT:   VSDERR_SUCESS if there was a match                             *
*           An MCI error otherwise                                         *
*                                                                          *
* SIDE EFFECTS:                                                            *
*                                                                          *
*************************** END OF SPECIFICATIONS **************************/


ULONG mixGetControl( HMIXER          hMixer,

                     PMIXERCONTROL   pMixControl )
{
  USHORT usLastError;
  usLastError=MixMessage(  hMixer,
                          MIX_GETCONTROL,
                          (PVOID) pMixControl,
                          sizeof( MIXERCONTROL) );

return(usLastError);
}
/************************** START OF SPECIFICATIONS ************************
*                                                                          *
* SUBROUTINE NAME: mixSetControl                                           *
*                                                                          *
* DESCRIPTIVE NAME: Set the state of a line's controls.                    *
*                                                                          *
* FUNCTION: Call audio device driver to set the source's (in ulLine)       *
*           control (in ulControl) setting (i.e. range 0-0xffff).          *
*                                                                          *
* OUTPUT:   VSDERR_SUCESS if there was a match                             *
*           An MCI error otherwise                                         *
*                                                                          *
* SIDE EFFECTS:                                                            *
*                                                                          *
*************************** END OF SPECIFICATIONS **************************/

ULONG mixSetControl( HMIXER          hMixer,
                     PMIXERCONTROL   pMixControl )

{
  USHORT usLastError;
   usLastError=MixMessage( hMixer,
                          MIX_SETCONTROL,
                          (PVOID) pMixControl,
                          sizeof( MIXERCONTROL) );

   return(usLastError);

} /* mixSetControl */

/************************** START OF SPECIFICATIONS ************************
*                                                                          *
* SUBROUTINE NAME: MixMessage                                              *
*                                                                          *
* DESCRIPTIVE NAME: Call Device driver with mixer message.                 *
*                                                                          *
* FUNCTION: Send a mixer IOCTL to AUDIODD driver.                          *
*                                                                          *
* OUTPUT:   VSDERR_SUCESS if there was a match                             *
*           An MCI error otherwise                                         *
*                                                                          *
* SIDE EFFECTS:                                                            *
*                                                                          *
*************************** END OF SPECIFICATIONS **************************/

ULONG  MixMessage( HMIXER   hMix,
                   ULONG    msg,
                   PVOID    pData,
                   ULONG    ulDataSize )
{
APIRET  rc;              /* Return code */

ULONG   ulParmOut;
ULONG   ulParmLengthInOut = 0L;


   rc = DosDevIOCtl( hMix,
                     AUDIO_IOCTL_CAT,
                     msg,
                     NULL,
                     0,
                     &ulParmLengthInOut,
                     pData,
                     ulDataSize,
                     (PVOID) &ulParmOut);


   MapMixErrors( &rc );
   return ( rc );

} /* mixmessage */


/************************ START OF SPECIFICATIONS **************************
*
* SUBROUTINE NAME: MapMixErrrors
*
* FUNCTION: Converts mixer errors to MCI errors
*
* INPUT:  PULONG -- error to map
*
* OUTPUT: void
*
* OS/2 CALLS:
*
* C CALLS: None.
*
*
*************************** END OF SPECIFICATIONS *************************/

void MapMixErrors (PULONG       pulError )
{
  switch ( *pulError )
    {
    case MIXERR_INVALIDOUTPUT  :
    case MIXERR_INVALIDINPUT   :
      *pulError = VSDERR_INVALID_CONNECTOR_TYPE;
      break;
    default                  :
      *pulError = VSDERR_SUCCESS;
    }
} // MapMixErrors

