/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/************************ START OF SPECIFICATIONS ***************************/
/*                                                                          */
/* SOURCE FILE NAME:            DDCENTRY.C                                  */
/*                                                                          */
/* DESCRIPTIVE NAME: DDCMDEntryPoint and procedures                         */
/*                                                                          */
/*                                                                          */
/* STATUS:  WPOS Release 1.0                                                */
/*                                                                          */
/* NOTES:                                                                   */
/*                                                                          */
/* ENTRY POINTS:                                                            */
/*                                                                          */
/* EXTERNAL REFERENCES:                                                     */
/*                                                                          */
/* MODIFICATION HISTORY:                                                    */
/* DATE      DEVELOPER         CHANGE DESCRIPTION                           */
/* --------  -----------       --------------------                         */
/* 11/11/93  Brian Czako       Initial code added to module.                */
/*************************** END OF SPECIFICATIONS **************************/

/**********************************************************/
/*  Include files                                         */
/**********************************************************/

#define INCL_BASE           /* include BASE OS/2 defines */
#define INCL_PM
#define INCL_WINWINDOWMGR
#include <os2.h>            /* all-inclusive OS/2 include file */

#include <ptrace.h>         /* PTRACE macros */
#include <os2me.h>          /* include external definitions */

#include <shdd.h>

#include "ddcmd.h"

extern STREAM     aStreamVSD[MAX_STREAM_NUM];                             //WPOS                //WPOS


#define Convert32to1616(value) (                                                         \
                (value)                                                                  \
                   ? ((PVOID) MAKEULONG (LOUSHORT (value), (HIUSHORT (value) << 3) + 7)) \
                   : NULL)


/************************** START OF SPECIFICATIONS *************************/
/*                                                                          */
/* SUBROUTINE NAME:             DDCMDEntryPoint                             */
/*                                                                          */
/* FUNCTION: Entry point to "generic" DDCMD DLL.  Used for ring 3           */
/*      stream handler DLL, passing down requests to ring 0 via IOCtl       */
/*      calls.                                                              */
/*                                                                          */
/* NOTES:  none                                                             */
/*                                                                          */
/* INPUT:  none                                                             */
/*                                                                          */
/* OUTPUT:                                                                  */
/*                                                                          */
/*************************** END OF SPECIFICATIONS **************************/
ULONG   vsdDDCMDEntryPoint (PVOID pEntry)
{

        PDDCMDCOMMON    pCommon = (PDDCMDCOMMON) pEntry;

        if (pCommon == NULL)
        {
                return (ERROR_INVALID_BLOCK) ;
        }

        switch (pCommon->ulFunction)
        {
                case DDCMD_SETUP:
                        return DDCmdSetup ((PDDCMDSETUP)pCommon);

                case DDCMD_READ:
                        return DDCmdRead ((PDDCMDREADWRITE)pCommon);

                case DDCMD_WRITE:
                        return DDCmdWrite ((PDDCMDREADWRITE)pCommon);

                case DDCMD_STATUS:
                        return DDCmdStatus ((PDDCMDSTATUS)pCommon);

                case DDCMD_CONTROL:
                        return DDCmdControl ((PDDCMDCONTROL)pCommon);

                case DDCMD_REG_STREAM:
                        return DDCmdRegister ((PDDCMDREGISTER)pCommon);

                case DDCMD_DEREG_STREAM:
                        return DDCmdDeRegister ((PDDCMDDEREGISTER)pCommon);

                default:
                        return (ERROR_INVALID_FUNCTION);
        }
}



ULONG   DDCmdSetup (PDDCMDSETUP pSetup)
{
        ULONG   rc, ParmSize;
        PVOID   pBackupSetupParm;
        DDSHPARMS ParmIn;

        //******************************************************
        // Convert pSetup, pSetup->pSetupParm to 16:16 pointers
        //******************************************************
        pBackupSetupParm   = pSetup->pSetupParm;

        pSetup->pSetupParm = Convert32to1616 (pSetup->pSetupParm);
        ParmIn.pBuffer     = Convert32to1616 (pSetup);
        ParmIn.rc          = 0;
        ParmSize           = sizeof (DDCMDSETUP);

        rc = DosDevIOCtl (aStreamVSD[pSetup->hStream].hfileDDSHPDD,       //WPOS
                          (ULONG) DDSH_CATEGORY_INTERNAL,
                          (ULONG) DDCMD_SETUP,
                          (PVOID)  &ParmIn,
                          (ULONG)  ParmSize,
                          (PULONG) &ParmSize,
                          (PVOID)  &ParmIn,
                          (ULONG)  ParmSize,
                          (PULONG) &ParmSize );

        if (!rc)
        {
                rc = ParmIn.rc;
        }

        //********************
        // Restore pSetupParm
        //********************
        pSetup->pSetupParm = pBackupSetupParm;

        return (rc);
}



ULONG   DDCmdRead (PDDCMDREADWRITE pRead)
{
        ULONG   rc, ParmSize;
        DDSHPARMS ParmIn;


        ParmIn.pBuffer = Convert32to1616 (pRead);
        ParmIn.rc      = 0;
        ParmSize       = sizeof (DDCMDREADWRITE);

        rc = DosDevIOCtl (aStreamVSD[pRead->hStream].hfileDDSHPDD,        //WPOS
                          (ULONG) DDSH_CATEGORY_INTERNAL,
                          (ULONG) DDCMD_READ,
                          (PVOID)  &ParmIn,
                          (ULONG)  ParmSize,
                          (PULONG) &ParmSize,
                          (PVOID)  &ParmIn,
                          (ULONG)  ParmSize,
                          (PULONG) &ParmSize );

        if (!rc)
        {
                rc = ParmIn.rc;
        }

        return (rc);
}

ULONG   DDCmdWrite (PDDCMDREADWRITE pWrite)
{
        ULONG   rc, ParmSize;
        DDSHPARMS ParmIn;


        ParmIn.pBuffer  = Convert32to1616 (pWrite);
        ParmIn.rc       = 0;
        ParmSize        = sizeof (DDCMDREADWRITE);

        rc = DosDevIOCtl (aStreamVSD[pWrite->hStream].hfileDDSHPDD,       //WPOS
                          (ULONG) DDSH_CATEGORY_INTERNAL,
                          (ULONG) DDCMD_WRITE,
                          (PVOID)  &ParmIn,
                          (ULONG)  ParmSize,
                          (PULONG) &ParmSize,
                          (PVOID)  &ParmIn,
                          (ULONG)  ParmSize,
                          (PULONG) &ParmSize );

        if (!rc)
        {
                rc = ParmIn.rc;
        }

        return (rc);
}

ULONG   DDCmdStatus (PDDCMDSTATUS pDDCMDStatus)
{
        ULONG   rc, ParmSize;
        PVOID   pBackupBuffer;
        DDSHPARMS ParmIn;

        pBackupBuffer = pDDCMDStatus->pStatus;
        pDDCMDStatus->pStatus = Convert32to1616 (pDDCMDStatus->pStatus);
        ParmIn.pBuffer        = Convert32to1616 (pDDCMDStatus);
        ParmIn.rc             = 0;
        ParmSize              = sizeof (DDCMDSTATUS);

        rc = DosDevIOCtl (aStreamVSD[pDDCMDStatus->hStream].hfileDDSHPDD, //WPOS
                          (ULONG) DDSH_CATEGORY_INTERNAL,
                          (ULONG) DDCMD_STATUS,
                          (PVOID)  &ParmIn,
                          (ULONG)  ParmSize,
                          (PULONG) &ParmSize,
                          (PVOID)  &ParmIn,
                          (ULONG)  ParmSize,
                          (PULONG) &ParmSize );

        if (!rc)
        {
                rc = ParmIn.rc;
        }

        pDDCMDStatus->pStatus = pBackupBuffer;  // Restore original pointer

        return (rc);
}

ULONG   DDCmdControl (PDDCMDCONTROL pControl)
{
        ULONG   rc, ParmSize;
        DDSHPARMS ParmIn;
        PVOID   pBackupBuffer;

        pBackupBuffer   = pControl->pParm;
        pControl->pParm = Convert32to1616 (pControl->pParm);
        ParmIn.pBuffer  = Convert32to1616 (pControl);
        ParmIn.rc       = 0;
        ParmSize        = sizeof (DDCMDCONTROL);

        rc = DosDevIOCtl (aStreamVSD[pControl->hStream].hfileDDSHPDD,     //WPOS
                          (ULONG) DDSH_CATEGORY_INTERNAL,
                          (ULONG) DDCMD_CONTROL,
                          (PVOID)  &ParmIn,
                          (ULONG)  ParmSize,
                          (PULONG) &ParmSize,
                          (PVOID)  &ParmIn,
                          (ULONG)  ParmSize,
                          (PULONG) &ParmSize );

        if (!rc)
        {
                rc = ParmIn.rc;
        }

        pControl->pParm = pBackupBuffer;

        return (rc);
}

ULONG   DDCmdRegister (PDDCMDREGISTER pRegister)
{
        ULONG   rc, ParmSize;
        DDSHPARMS ParmIn;
        ULONG     ActionTaken;                                         //WPOS

        ParmIn.pBuffer = Convert32to1616 (pRegister);
        ParmIn.rc      = 0;
        ParmSize       = sizeof (DDCMDREGISTER);

        //*****************
        // Open Ring 0 stub
        //*****************
////////if (!(rc = DosOpen (pRegister->szR0StubName,                   //WPOS

        if (!(rc = DosOpen ("R0STUB$",          // Hardcoding of stub  //WPOS
                            &aStreamVSD[pRegister->hStream].hfileDDSHPDD, //WPOS
                            &ActionTaken,                              //WPOS
                            0,                                         //WPOS
                            FILE_NORMAL,                               //WPOS
                            OPEN_ACTION_OPEN_IF_EXISTS |               //WPOS
                            OPEN_ACTION_FAIL_IF_NEW,                   //WPOS
                            OPEN_ACCESS_READWRITE |                    //WPOS
                            OPEN_FLAGS_NOINHERIT |                     //WPOS
                            OPEN_FLAGS_FAIL_ON_ERROR |                 //WPOS
                            OPEN_SHARE_DENYNONE,                       //WPOS
                            NULL)))                                    //WPOS
        {                                                              //WPOS

           rc = DosDevIOCtl (aStreamVSD[pRegister->hStream].hfileDDSHPDD, //WPOS
                             (ULONG) DDSH_CATEGORY_INTERNAL,
                             (ULONG) DDCMD_REG_STREAM,
                             (PVOID)  &ParmIn,
                             (ULONG)  ParmSize,
                             (PULONG) &ParmSize,
                             (PVOID)  &ParmIn,
                             (ULONG)  ParmSize,
                             (PULONG) &ParmSize );
        }

        if (!rc)
        {
                rc = ParmIn.rc;
        }

        return (rc);
}




ULONG   DDCmdDeRegister (PDDCMDDEREGISTER pDeregister)
{
        ULONG   rc, ParmSize;
        DDSHPARMS ParmIn;


        ParmIn.pBuffer = Convert32to1616 (pDeregister);
        ParmIn.rc      = 0;
        ParmSize       = sizeof (DDCMDDEREGISTER);

        rc = DosDevIOCtl (aStreamVSD[pDeregister->hStream].hfileDDSHPDD,  //WPOS
                          (ULONG) DDSH_CATEGORY_INTERNAL,              //WPOS
                          (ULONG) DDCMD_DEREG_STREAM,
                          (PVOID)  &ParmIn,
                          (ULONG)  ParmSize,
                          (PULONG) &ParmSize,
                          (PVOID)  &ParmIn,
                          (ULONG)  ParmSize,
                          (PULONG) &ParmSize );

        if (!rc)
        {
                rc = ParmIn.rc;
                DosClose(aStreamVSD[pDeregister->hStream].hfileDDSHPDD);                                       //WPOS
                aStreamVSD[pDeregister->hStream].hfileDDSHPDD = 0;        //WPOS
        }

        return (rc);
}
