/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)audioif.h  13.13 92/04/13";*/
/**************************START OF SPECIFICATIONS *************************
*
* SOURCE FILE NAME:  AUDIOIF.H
*
* DESCRIPTIVE NAME: Header file for Audio Interface Driver
*
*
* STATUS: OS/2 Release 2.0
*
* FUNCTION: Declares audio structures and definitions for ACPA Audio device
*
* NOTE:                                                                                                                                    *
*       DEPENDENCIES:
*       RESTRICTIONS:
*
* 1/19/94 Pam Lee    Made changes for merge with AMMC
*
************************** END OF SPECIFICATIONS **************************/
#include <checkmem.h>

#define  INPUT_PORT              1
#define  OUTPUT_PORT             2


// values for RC file -- should be in SHIP_H!!!!!!
#define  STATIC_RATE             0L
#define  BEGIN_CONTINUOUS        1L
#define  END_CONTINUOUS          2L

#define  AMP_MIX                 1
#define  NON_AMP_MIX             0
#define  CT_ADPCM                DATATYPE_CT_ADPCM



#define NUMMODES                8
#define KNOWN_AUDIODD_MAPS      8


RIFFTABLE RiffTable[NUMMODES] =
        {
        {DATATYPE_WAVEFORM,    PCM},
        {DATATYPE_ADPCM_AVC,   ADPCM},
        {DATATYPE_MULAW,       MU_LAW},
        {DATATYPE_ALAW,        A_LAW},
        {DATATYPE_MIDI,        MIDI},
        {DATATYPE_SPV2,        SPV2},
        {DATATYPE_CDXA_AUDIO,  ADPCMXA},
        {DATATYPE_CT_ADPCM,    CT_ADPCM}
        };

#define  NUM_DATATYPES           54
#define  RIFF_PCM                 1
#define  RIFF_ADPCM               103

// Classes used for resource management
#define  PCM_CLASS               1
#define  MIDI_CLASS              2
#define  AVC_MUSIC_CLASS         3
#define  AVC_HQ_CLASS            4
#define  AVC_VOICE_CLASS         5
#define  AVC_STEREO_CLASS        6
#define  RECORD_CLASS            7
#define  PCM_STEREO_CLASS        8
#define  NO_CLASS_DETERMINED     100

// known cards, others can be added via an .rc file

#define MAUDIO                  1
#define SB                      2
#define SB_PRO                  3
#define SB_16                   4
#define PAS_16                  5
#define FOXGLOVE                6
#define SPEAKER                 7


/******************************************************/
        // Waveform Table DataStructure
/******************************************************/
typedef struct _mode_data_typ
  {
   ULONG      ulDataType;        /* PCM, ADPCM, etc..       */
   ULONG      ulDataSubType;     /* Freq, bits/sam,..       */
   short      mode_num;          /* Mode Constant           */
   int        flags;             /* Fixed or 2s Comp        */
   LONG       srate;             /* 11,22,44 Khz            */
   LONG       bits_per_sample;   /* 8 or 16 bits/sam        */
   SHORT      channels;          /* Mono or Stereo          */
   ULONG      ulBytes;           /* Scaled for Time Calcs    */
   ULONG      ulMMTime;          /* Scaled for Time Calcs    */

   }MODE_DATA;


#pragma pack(1)
typedef struct _class_data
  {
   ULONG      ulDataType;           /* PCM, ADPCM, etc..       */
   ULONG      ulSubType;            /* Freq, bits/sam,..       */
   USHORT     sSRate;               /* 11,22,44 Khz            */
   USHORT     sBitsPerSRate;        /* 8 or 16 bits/sam        */
   USHORT     usChannels;           /* Mono or Stereo          */
   ULONG      ulSamplingDescription;
   USHORT     usPlayClass;
   USHORT     usPlayUnits;
   USHORT     usRecordClass;
   USHORT     usRecordUnits;
   }CLASS_DATA;
#pragma pack()



#define FIX2C   FIXED + TWOS_COMPLEMENT



/*-------------------------------------------------------------------------*
* Table to convert gain % to number
*-------------------------------------------------------------------------*/
typedef struct
        {
        ULONG   ulGainValue;
        } GAINTABLE;

#define NUMGAINENTRIES  18

GAINTABLE GainTable[ NUMGAINENTRIES ] =

      { { 0 },
        { 6 },
        { 12 },
        { 18 },
        { 24 },
        { 30 },
        { 36 },
        { 42 },
        { 48 },
        { 54 },
        { 60 },
        { 66 },
        { 72 },
        { 78 },
        { 84 },
        { 90 },
        { 96 },
        { 100 },
      };


typedef struct
        {
        ULONG   ulGainValue;
        } BOOSTGAINTABLE;

GAINTABLE BoostGainTable[ 7 ] =

      {  { 102 },
         { 104 },
         { 106 },
         { 108 },
         { 112 },
         { 114 },
         { 116 }
      };


#define AUDIOIF_MULTIPLIER           0x147AE14        // 0x7FFFFFFF / 100
#define AUDIOIF_DIVISOR              0x147            // 0x7fff / 100 -- get one word
#define NOT_INITIALIZED             -1




/*-------------------------------------------------------------------------*
* Function Prototypes
*-------------------------------------------------------------------------*/

LONG   Open_Driver(PMCI_AMP_INSTANCE, ULONG);
LONG   Close_Driver(PMCI_AMP_INSTANCE );
LONG   MasterVol_Driver2(PMCI_AMP_INSTANCE, ULONG, ULONG);
LONG   Status_Driver2(PMCI_AMP_INSTANCE,ULONG, ULONG);
LONG   Set_Driver2(PMCI_AMP_INSTANCE, LONG);
LONG   DevCaps_Driver2(PMCI_AMP_INSTANCE, ULONG, ULONG *, ULONG );
LONG   Save_Driver(PMCI_AMP_INSTANCE);
LONG   Restore_Driver(PMCI_AMP_INSTANCE);
LONG   Info_Driver2(PMCI_AMP_INSTANCE, ULONG, ULONG);
LONG   Ports_Driver2(PMCI_AMP_INSTANCE, ULONG, ULONG);
LONG   Command_Driver(PMCI_AMP_INSTANCE, ULONG);
LONG   Wave_Driver(PMCI_AMP_INSTANCE, ULONG, ULONG );

LONG   LoadDSP(PMCI_AMP_INSTANCE, LPMCI_AUDIO_INIT);
LONG   MCI_Error(ULONG);
LONG   FindDevice(CHAR *, HFILE);
PMCI_AMP_INSTANCE DevAlreadyOpen(CHAR *);
LONG   AddDevice(PMCI_AMP_INSTANCE);
LONG   AddTableDevice( CHAR * );
struct ACPATrackTableList *FindTableDevice( CHAR * );
LONG   RemoveDevice(PMCI_AMP_INSTANCE );
LONG   Set_IO_Ports( LPMCI_AUDIO_CHANGE, PMCI_AMP_INSTANCE, LONG );
LONG   ChannelsUsedInDevice(CHAR *pDeviceName);
ULONG  CheckAUDIOIF (PMCI_AMP_INSTANCE  lpAmpInstance);
void   CheckBounds( PLONG );
ULONG  StatusIOPort( ULONG, PMCI_AMP_INSTANCE, ULONG );
ULONG  RemoveIOPort( ULONG, PMCI_AMP_INSTANCE, ULONG );
ULONG  AddIOPort( ULONG, PMCI_AMP_INSTANCE, ULONG );
LONG   DoIOCTLLoad( PMCI_AMP_INSTANCE, SHORT sMode );
void   MapModes( PMCI_AMP_INSTANCE    pInstance );
ULONG  GetClassInformation(PMCI_AMP_INSTANCE    pInstance );
ULONG  SetupResourceTable ( PMCI_AMP_INSTANCE    pInstance );
ULONG  ACPABestFit( PMCI_AMP_INSTANCE    pInstance );

//#pragma linkage(AUDIOIFDriverEntry, system )
ULONG APIENTRY AUDIOIFDriverEntry(PMCI_AMP_INSTANCE prInstance,
                                  ULONG sMessage,
                                  ULONG lParam1,
                                  ULONG lParam2,
                                  ULONG lParam3);

//4meg #pragma linkage( CheckMem, system )

//4meg DWORD CheckMem( PVOID, ULONG, ULONG );

