/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/************************* START OF SPECIinCATIONS ***
*
* SOURCE FILE NAME:  AUDIOIF.C
*
* DESCRIPTIVE NAME: Ring 3 Amp/Mixer AUDIO Interface Driver
*
*
* STATUS:  OS/2 Release 2.0
*
* FUNCTION: This source module contains the ring 3 (DLL) entry point for
*           MCD Amp/Mixer calls from the Amp/Mixer or Audio Stream Handler.
*           The Mixer MCI driver will call the VSD to setup for the correct
*           mode and manipulate audio attributes.  The Audio Stream Handler
*           will pass data buffers to/from the audio device.
*
*           Currently, there is only one entry point for a new VSD.  This
*           VSD contains two for backwards compatibility with older
*           apps that talked to a private VSD interface.
*
*
* Architecture :
*             Logical Mixer Device
*    ------------------------------------------------
*    | AMPMXMCD.DLL      |    VSD                    |
*    | (Device           |      (Device Dependent)   |
*    |   Independent)  <--->                         |
*    |                   |                           |
*    |-------------------|---------------------------|
*                                        /\
*                                        |
*                                        |  Buffers
*                                        |
*                                        \/
*      -----------  Buffers   -----------------------
*      |   SSM  | <---------> | Audio Stream Handler |
*      ----------             -----------------------
*
*
*

*
* NOTES:
*        DEPENDENCIES: This implementation of the VSD requires
*                      an AUDIODD device driver.  OEM implementations
*                      do not.
*        RESTRICTIONS: Runs at user level.
*
* ENTRY POINT:
*        AUDIOIFDriverEntry
*
* EXTERNAL REFERENCES: Sends IOCTL request to ACPA audio board
*
*/

#define INCL_NOPMAPI
#define INCL_DOS
#define INCL_ERRORS
#define INCL_AUDIO_VSD
#include <os2.h>
#include <os2me.h>
#include <mcd.h>
#include <audio.h>
#include <stdio.h>
#include <string.h>
#include <hhpheap.h>
#include <checkmem.h>

#include <vsdcmds.h>
#include <vsdaud.h>
#include <os2mixer.h>
#include <mmdsload.h>                   // MM_DosLoadModule @LP01


#define AUDIOIF_MULTIPLIER           0x147AE14        // 0x7FFFFFFF / 100
#define AUDIOIF_DIVISOR              0x147            // 0x7fff / 100 -- get one word
#define NOT_INITIALIZED             -1

#define FAILURE                 0L
#define SUCCESS                 1L
#define VSD_SEM_NAME "\\SEM32\\AUDIOIF"



/************************ START OF SPECIFICATIONS **************************
*
* SUBROUTINE NAME: VSDEntry
*
* FUNCTION: Ring 3 entry point for AUDIOIF calls from Amp/Mixer
*
* INPUT:   HVSD     hvsd     Handle to the VSD
*          ULONG    ulFunc   Function to operate (i.e. VSD_OPEN, VSD_SET etc.)
*          ULONG    ulFlags  Flags to manipulate function
*          PVOID    pRequest Pointer to function specific parameter.
*
* OUTPUT: returns VSDERR_SUCCESS if successful, otherwise it returns an
*                 MCI error code.
*
* OS/2 CALLS: None
*
* C CALLS: None
*
* INTERNAL CALLS:
*
*************************** END OF SPECIFICATIONS *************************/

ULONG APIENTRY MM_VSDEntry(  HVSD     hvsd,
                             ULONG    ulFunc,
                             ULONG    ulFlags,
                             PVOID    pRequest )

        {
        LONG lError = VSDERR_SUCCESS;

        switch( ulFunc )
                {

    /**************************************
    * Required functions for all VSD's.
    **************************************/
    /********************************************
    * The first call a VSD will receive is an OPEN
    *********************************************/

    case VSD_OPEN    :

     lError = VSDOpen( ( PVSD_OPEN_PARMS ) pRequest );
     break;

    case VSD_DEVUNITS  :
     lError = VSDDevUnits( ( PVSD_INSTANCE ) hvsd, ( PVSD_DEVUNITS_PARMS )pRequest );
     break;

    case VSD_RESOURCE       :
     lError = VSDResource( ( PVSD_INSTANCE ) hvsd, ( PVSD_RESOURCE_PARMS ) pRequest );
     break;


    case VSD_RESTORE:
     lError = VSDRestore( ( PVSD_INSTANCE ) hvsd );
     break;

    case VSD_SAVE:
     lError = VSDSave( ( PVSD_INSTANCE ) hvsd );
     break;

    case VSD_CLOSE:
      lError = VSDClose( ( PVSD_INSTANCE ) hvsd );
      break;

    case VSD_GETDEVCAPS:
      lError = VSDCaps( ( PVSD_INSTANCE ) hvsd, ulFlags, ( PVSD_GETDEVCAPS_PARMS )pRequest );
      break;

    case VSD_QUERY   :
     lError = VsdQuery( ( PVSD_INSTANCE ) hvsd, ulFlags, pRequest);
     break;

     /**************************************
     * Basic commands
     **************************************/

     case VSD_SET:

           lError = VSDSetCommand( ( PVSD_INSTANCE ) hvsd, ulFlags, pRequest );
           break;


   /**************************************
   * Other commands
   **************************************/

   //  Merge of DDCMD.DLL with VSD.
   case VSD_DDCMD:
          lError = vsdDDCMDEntryPoint (pRequest);
          break;


   case VSD_ESCAPE:
      break;

// case VSD_CREATE_MIX :
   case VSD_EVENTS     :

   /* Unsupported commands */


   case VSD_CAPTUREIMAGE :
   case VSD_EJECT        :
   case VSD_FREEZE       :
   case VSD_INSERTSETTINGSPAGE :
   case VSD_LOAD               :
   case VSD_PARK               :
   case VSD_RESET              :
   case VSD_RESTOREIMAGE       :
   case VSD_SEEK               :
   case VSD_STEP               :

   /*----------------------------------------------------
   * Audio VSDs DO NOT have to support getProdInfo (unless
   * they want to).  No portion of MMPM2 will call the VSD
   * requesting this info (remember, this is true only for
   * audio).  This information is obtained by the mixer
   * via an MCI_SYSINFO call since each driver must place
   * the information in the ini file when it is installed.
   *---------------------------------------------------*/
   case VSD_GETPRODINFO :

      lError = VSDERR_UNSUPPORTED_FUNCTION;
      break;

    /*---------------------------------------------------------*
    * Unknown message received
    *---------------------------------------------------------*/

    default:
            lError = VSDERR_UNRECOGNIZED_COMMAND;

            break;
    }

  return(lError);


} /* VSDEntry */

















/************************ START OF SPECIFICATIONS **************************
*
* SUBROUTINE NAME: MCI_Error()
*
* FUNCTION: Returns MCI equivalent of an OS/2 error code.
*
* INPUT:  lError - OS/2 error code
*
* OUTPUT: Returns MCI equivalent of an OS/2 error code.
*
* OS/2 CALLS: None
*
* C CALLS: None
*
*************************** END OF SPECIFICATIONS *************************/

LONG MCI_Error(ULONG lError)
        {
        ULONG lMCIError;

        switch(lError)
                {
                case NO_ERROR:
                        lMCIError = VSDERR_SUCCESS;
                        break;

                case ERROR_FILE_NOT_FOUND:
                        lMCIError = VSDERR_FILE_NOT_FOUND;
                        break;

                case ERROR_PROC_NOT_FOUND:
                        lMCIError = VSDERR_DRIVER_PROC_NOT_FOUND;
                        break;

                case ERROR_INTERRUPT:
                case ERROR_INVALID_HANDLE:
                case ERROR_INVALID_ADDRESS:
                case ERROR_ACCESS_DENIED:
                          lMCIError = VSDERR_INTERNAL;
                          break;

                case ERROR_NOT_ENOUGH_MEMORY:
                        lMCIError = VSDERR_OUT_OF_MEMORY;
                        break;
                case ERROR_OPEN_FAILED:
                case 65280            :
                case 65536            :
                        lMCIError = VSDERR_HARDWARE;
                        break;

                default:
                        lMCIError = VSDERR_HARDWARE;
                        break;
                }

        return(lMCIError);
        }


/************************ START OF SPECIFICATIONS **************************
*
* SUBROUTINE NAME: AUDIOIFInit()
*
* FUNCTION: Initializes global semaphore.  If VSD needs to initialize global
*           variables, allocate heaps, or perform functions
*           which need to be done once per process, it should be done here.
*
* INPUT:  None
*
* OUTPUT: Returns 1 if successful, 0 otherwise.
*
* OS/2 CALLS: DosCreateMutexSem()
*
*************************** END OF SPECIFICATIONS *************************/
//#pragma linkage (_DLL_InitTerm, system)

ULONG APIENTRY _VSD_InitTerm (ULONG hModhandle, ULONG Flag);
ULONG APIENTRY _VSD_InitTerm (ULONG hModhandle, ULONG Flag)


   {
   extern ULONG        ulNumUsersVSD;
   extern HMTX         hmtxProcessSemVSD;
   ULONG               rc;

   /*********************************************************
   * Termination
   *********************************************************/
   if ( Flag )
   {

     /*****************************************
     * Cleanup semaphore and user count
     ******************************************/
     rc = DosRequestMutexSem ( hmtxProcessSemVSD, SEM_INDEFINITE_WAIT);
     ulNumUsersVSD--;
     DosReleaseMutexSem (hmtxProcessSemVSD);
     DosCloseMutexSem (hmtxProcessSemVSD);

     return (SUCCESS);
   }

   /*********************************************************
   * Initialization
   *********************************************************/
   /*********************************************************
   * Create the Global Mutex Sem if this is the first process
   *********************************************************/
   rc = DosCreateMutexSem ( VSD_SEM_NAME, &hmtxProcessSemVSD, 0L, FALSE);
   if (rc == ERROR_DUPLICATE_NAME)
   {
       rc = MCIERR_SUCCESS;
       /***************************************************
       * Open The Mutex Semaphore for subsequent processes
       ****************************************************/
       rc = DosOpenMutexSem (VSD_SEM_NAME, (PHMTX) &hmtxProcessSemVSD);
   }
   if ( rc )
      return (FAILURE);

   /****************************************
   * Acquire The Mutex Semaphore
   *****************************************/
   rc = DosRequestMutexSem ( hmtxProcessSemVSD, SEM_INDEFINITE_WAIT);
   if (rc)
   {
     DosCloseMutexSem (hmtxProcessSemVSD);
     return (FAILURE);
   }

   ulNumUsersVSD++;

   /******************************************
   * Release The Mutex Semaphore
   *******************************************/
   rc = DosReleaseMutexSem (hmtxProcessSemVSD);
   if (rc)
   {
      if (ulNumUsersVSD)
        DosCloseMutexSem (hmtxProcessSemVSD);
      return (FAILURE);
   }

   return (SUCCESS);


   } /* _DLL_InitTerm */
