/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**************************START OF SPECIFICATIONS **************************/
/*                                                                          */
/* SOURCE FILE NAME:  CDEVHLP.H                                             */
/*                                                                          */
/* DISCRIPTIVE NAME: C functional prototype interface for OS/2 DevHlp       */
/*                   services.                                              */
/*                                                                          */
/* NOTE: Uses 'C' calling conventions                                       */
/*   DEPENDENCIES:                                                          */
/*   RESTRICTIONS:                                                          */
/*                                                                          */
/************************** END OF SPECIFICATIONS ***************************/

USHORT  DevHlp_AllocGDTSelector(ULONG ulNumGDTSelectors, PVOID paGDTSel);

USHORT  DevHlp_AllocPhys(ULONG BlockSize,
                         USHORT Location,
                         PVOID  pRetAddr);

USHORT  DevHlp_AttachDD(PUCHAR TargetDDname,
                        PATTACHAREA AttachDDArea);

USHORT  DevHlp_PhysToGDTSelector(PVOID  PhysAddress,
                                 ULONG  ByteLength,
                                 USHORT Selector);


USHORT  DevHlp_PhysToVirt(PVOID  PhysAddress,
                          ULONG  Size,
                          PVOID  pRetAddress);

USHORT  DevHlp_RegisterPDD(NPSZ  pszPDDName,
                           PVOID pfnPDDFunction);

USHORT  DevHlp_VirtToLin(USHORT Selector,
                         ULONG OffsetAddress,
                         PVOID pRetLinAddress);

USHORT  DevHlp_VirtToPhys(PVOID VirtAddress,
                          PVOID pRetPhysAddress);

//**************************************************
// ABIOS services
//**************************************************
USHORT  DevHlp_GetLIDEntry(USHORT DevID,
                           USHORT RelID,
                           USHORT DevState,
                           PUSHORT LID);

USHORT  DevHlp_FreeLIDEntry(USHORT LID);

USHORT  DevHlp_ABIOSCall(USHORT LID,
                         NPVOID RBOffset,
                         USHORT Entry);
