;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/

        PAGE    80,132
        .386p

        TITLE   CDEVHLP - 'C' INTERFACE FOR DEVHELP CALLS
        SUBTTL  'C' DEVHLP
        NAME    DEVHLPs

;********************** START OF SPECIFICATIONS *********************
;*
;* SOURCE FILE NAME:  CDEVHLP.ASM
;*
;* DESCRIPTIVE NAME:  'C' interface for OS/2 devhelp calls
;*
;* FUNCTION: This module provides the interface mechanism to translate a 'C'
;*           stacked based devhelp call to a MASM register based OS/2 devhelp
;*           call.
;*
;* NOTES:
;*    DEPENDENCIES: NONE
;*    RESTRICTIONS: Use assmebly language only.
;*
;* ENTRY POINTS:    _DevHlp_AllocGDTSelector
;*                  _DevHlp_AllocPhys
;*                  _DevHlp_PhysToGDTSelector
;*                  _DevHlp_PhysToVirt
;*                  _DevHlp_VirtToLin                   
;*                  _DevHlp_VirtToPhys
;*                  _DevHlp_ABIOSCall
;*                  _DevHlp_GetLIDEntry
;*                  _DevHlp_FreeLIDEntry
;*
;* EXTERNAL REFERENCES (system):  Far calls to OS/2 kernal DevHlp routines.
;*
;*********************** END OF SPECIFICATIONS **********************
;******************************************************************************
;                       I N C L U D E S
;******************************************************************************

.xlist
include devhlp.inc
.list

;******************************************************************************
;                       E X T E R N S
;******************************************************************************
_DATA   SEGMENT WORD PUBLIC USE16 'DATA'
        EXTRN   _DevHlp:DWORD
_DATA   ENDS

;******************************************************************************
;                   D A T A   D E C L A R A T I O N S
;******************************************************************************

;******************************************************************************
;                           C O D E
;******************************************************************************

_TEXT   SEGMENT WORD PUBLIC USE16 'CODE'
        ASSUME cs:_TEXT

;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_AllocGDTSelector
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_AllocGDTSelector
;*     LINKAGE:   CALL NEAR
;*
;* INPUT: ULONG block size in bytes
;*
;* EXIT-NORMAL:  Refer to OS/2 devhelp api document ES:DI contains locaton of array
;*               of words of GDT's.
;*
;* EXIT_ERROR: 'Carry flag set' and AX=error code
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES: none
;*
;* EXTERNAL REFERENCES: DevHlp_AllocGDTSelector
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_AllocGDTSelector proc near
        PUBLIC  _DevHlp_AllocGDTSelector
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
NumGDTSelectors EQU     <[bp+4]>
paGDTSel        EQU     <[bp+8]>        ; seg:off of GDT array
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    cx
        push    dx
        push    di
        push    es

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     es,WORD PTR paGDTSel+2          ; get seg.
        mov     di,WORD PTR paGDTSel            ; get off.
        mov     cx,NumGDTSelectors
        mov     dl,DevHlp_AllocGDTSelector
        call    [_DevHlp]
        jc      allocgdt
        xor     ax,ax                           ; clear for no error
allocgdt:
        pop     es
        pop     di
        pop     dx
        pop     cx
        pop     bp
        ret
_DevHlp_AllocGDTSelector endp

;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_AllocPhys
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_AllocPhys
;*     LINKAGE:   CALL NEAR
;*
;* INPUT: ULONG block size in bytes
;*
;* EXIT-NORMAL:  Refer to OS/2 devhelp api document ax:bx = 32 bit physical addr
;*               AX = 0
;*
;* EXIT_ERROR: AX=error code
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES: none
;*
;* EXTERNAL REFERENCES: DevHlp_AllocPhys
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_AllocPhys proc near
        PUBLIC  _DevHlp_AllocPhys
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
BytesLo         EQU     <[bp+4]>        ; memory block size
BytesHi         EQU     <[bp+6]>
Location        EQU     <[bp+8]>        ; above or below 1MB
pRetAddress     EQU     <[bp+10]>       ; 32bit address to allocated memory blk

        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    bx
        push    dx
        push    es

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     bx,BytesLo
        mov     ax,BytesHi
        mov     dh,BYTE PTR Location            ; 0=above 1MB
        mov     dl,DevHlp_AllocPhys             ; 1=below 1MB
        call    [_DevHlp]
        jc      allocphys

        mov     dx,bx                           ; Need bx for addressing
        les     bx,pRetAddress                  ; Dereference address of
                                                ; callers variable
        mov     es:[bx+2],ax                    ; Return high 16 bits and
        mov     es:[bx],dx                      ; Low 16 bits (flat pointer)

        xor     ax,ax                           ; clear ax => no error
allocphys:
        pop     es
        pop     dx
        pop     bx
        pop     bp                              ; restore callers frame
        ret
_DevHlp_AllocPhys endp

;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_AttachDD
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_AttachDD
;*     LINKAGE:   CALL NEAR
;*
;* INPUT: seg:offset of target dd name, offset of attach area
;*
;* EXIT-NORMAL:  Refer to OS/2 devhelp api document
;*
;* EXIT_ERROR:
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES: none
;*
;* EXTERNAL REFERENCES: DevHlp
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_AttachDD        PROC    NEAR
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
TargetDDName    EQU     <[bp+4]>        ; get offset only
AttachDDArea    EQU     <[bp+8]>
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    bx
        push    di
        push    dx

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        xor     ax,ax                           ; clear ax for return code
        mov     bx,WORD PTR TargetDDName
        mov     di,WORD PTR AttachDDArea
        mov     dl,DevHlp_AttachDD
        call    [_DevHlp]
        jc      attachdd_err
        jmp     attachdd_ok

attachdd_err:
        mov     ax,-1                           ; set error for 'C' code
        jmp     attachdd_exit

attachdd_ok:
        xor     ax,ax                           ; clear for no error
attachdd_exit:
        pop     dx
        pop     di
        pop     bx
        pop     bp
        ret
_DevHlp_AttachDD        ENDP
;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_PhysToGDTSelector
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_PhysToGDTSelector
;*     LINKAGE:   CALL NEAR
;*
;* INPUT: 32bit physical address, length of segment, selector to setup
;*
;* EXIT-NORMAL: Refer to OS/2 devhelp api document
;*              ptr that contained 32bit physaddrr is now a sel:off.
;*              AX = 0
;*
;* EXIT_ERROR: ax=error code
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES:
;*
;* EXTERNAL REFERENCES: DevHlp_PhysToGDTSelector
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_PhysToGDTSelector proc near
        PUBLIC  _DevHlp_PhysToGDTSelector
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
PhysAddress     EQU     <[bp+4]>
ByteLength      EQU     <[bp+8]>
Selector        EQU     <[bp+12]>
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    bx
        push    cx
        push    dx
        push    si

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     ax,WORD PTR PhysAddress+2
        mov     bx,WORD PTR PhysAddress
        mov     cx,ByteLength
        mov     si,Selector
        mov     dl,DevHlp_PhysToGDTSelector
        call    DWORD PTR [_DevHlp]      ; return error in ax if CF
        jc      physToGDT
        xor     ax,ax
physToGDT:
        pop     si
        pop     dx
        pop     cx
        pop     bx
        pop     bp
        ret
_DevHlp_PhysToGDTSelector endp



;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_PhysToVirt
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_PhysVirt
;*     LINKAGE:   CALL NEAR
;*
;* INPUT: ULONG block size in bytes
;*
;* EXIT-NORMAL: Refer to OS/2 devhelp api document ax:bx = 32 bit physical addr
;*              AX = 0
;*
;* EXIT_ERROR: ax=error code
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES: none
;*
;* EXTERNAL REFERENCES: DevHlp_PhysToVirt
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_PhysToVirt proc near
        PUBLIC  _DevHlp_PhysToVirt
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
PhysAddress     EQU     <[bp+4]>        ; physical address
BlockSize       EQU     <[bp+8]>        ; block size
pRetAddress     EQU     <[bp+12]>       ; address of returned virtual pointer
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    dx
        push    es
        push    di
        push    ds
        push    si

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     ax,WORD PTR PhysAddress+2
        mov     bx,WORD PTR PhysAddress
        mov     cx,BlockSize
        xor     dh,dh
        mov     dl,DevHlp_PhysToVirt
        call    [_DevHlp]
        jc      physvirterr

        les     di,pRetAddress                  ; de-reference pointer
        mov     es:[di+2],ds                    ; hi word (return ds:si)
        mov     es:[di],si                      ; lo word
        xor     ax,ax                           ; clear for no error

physvirterr:
        pop     si
        pop     ds
        pop     di
        pop     es
        pop     dx
        pop     bp
        ret
_DevHlp_PhysToVirt endp

;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_RegisterPDD
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_RegisterPDD
;*     LINKAGE:   CALL NEAR
;*
;* INPUT:
;*
;* EXIT-NORMAL: Refer to OS/2 devhelp api document
;*              AX = 0
;*
;* EXIT_ERROR: ax = -1
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES:
;*
;* EXTERNAL REFERENCES: DevHlp_RegisterPDD
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_RegisterPDD proc near
        PUBLIC  _DevHlp_RegisterPDD
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
pszPDDName      EQU     <[bp+4]>        ; word
pfnPDDFunction  EQU     <[bp+6]>        ; dword
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    si
        push    dx
        push    ds
        push    es

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     si,pszPDDName           ; DS:SI = ptr to ASCIIZ PDD name
        mov     es,pfnPDDFunction+2     ; ES:DI = ptr to PDD entry point
        mov     di,pfnPDDFunction
        mov     dl,DevHlp_RegisterPDD
        call    DWORD PTR [_DevHlp]     ; return error in ax if CF
        jc      RegisterPDDErr

        xor     ax, ax                  ; Success, RC = zero
        jmp     RegisterPDDDone

RegisterPDDErr:
        mov     ax,-1

RegisterPDDDone:
        pop     es
        pop     ds
        pop     dx
        pop     si
        pop     bp
        ret
_DevHlp_RegisterPDD endp

;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_VirtToLin
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_VirtToLin
;*     LINKAGE:   CALL NEAR
;*
;* INPUT:
;*
;* EXIT-NORMAL:  Refer to OS/2 devhelp api document
;*
;* EXIT_ERROR:
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES:
;*
;* EXTERNAL REFERENCES: DevHlp_VirtToLin
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_VirtToLin       PROC    NEAR
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
Selector        EQU     <[bp+4]>                ; word
OffsetAddress   EQU     <[bp+6]>                ; dword
pRetLinAddress  EQU     <[bp+10]>               ; pvoid
        push    bp
        mov     bp,sp                           ; allocate NULL stack frame
        push    ebx
        push    esi
        push    edx

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     ax,WORD PTR Selector
        or      ax,ax
        jnz     VirtLinSel
        mov     ax,_DATA
VirtLinSel:
        mov     esi,OffsetAddress
        mov     dl,DevHlp_VirtToLin
        call    DWORD PTR [_DevHlp]             ; return error in ax if CF
        jc      VirtLinErr

        xor     ebx,ebx
        push    ds
        lds     bx,pRetLinAddress               ; load full ptr
        mov     [ebx],eax
        pop     ds
        xor     eax,eax                         ; clear any 'c' error

VirtLinErr:
        pop     edx
        pop     esi
        pop     ebx
        pop     bp
        ret
_DevHlp_VirtToLin       ENDP

;********************** START OF SPECIFICATIONS *********************
;*
;* SUBROUTINE NAME: _DevHlp_VirtToPhys
;*
;* DESCRIPTIVE NAME:
;*
;* FUNCTION: Call the devhelper routine with the 'C' parameters passed in the
;*           registers.
;*
;* NOTES:
;*
;* ENTRY POINTS:  _DevHlp_VirtToPhys
;*     LINKAGE:   CALL NEAR
;*
;* INPUT:
;*
;* EXIT-NORMAL: Refer to OS/2 devhelp api document
;*              AX = 0
;*
;* EXIT_ERROR: ax = -1
;*
;* EFFECTS:  Registers:
;*
;* INTERNAL REFERENCES:
;*
;* EXTERNAL REFERENCES: DevHlp_VirtToPhys
;*
;*********************** END OF SPECIFICATIONS **********************

_DevHlp_VirtToPhys proc near
        PUBLIC  _DevHlp_VirtToPhys
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
VirtAddress     EQU     <[bp+4]>        ; dword
pRetPhysAddress EQU     <[bp+8]>        ; dword
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    si
        push    dx
        push    ds

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        lds     si,VirtAddress
        mov     dl,DevHlp_VirtToPhys
        call    DWORD PTR [_DevHlp]     ; return error in ax if CF
        jc      VirtPhysErr

        les     si,pRetPhysAddress      ; de-reference pointer
        mov     es:[si+2],ax            ; Return high word
        mov     es:[si],bx              ; Return low word
        xor     ax, ax                  ; Success, RC = zero
        jmp     VirtPhysDone

VirtPhysErr:
        mov     ax,-1

VirtPhysDone:
        pop     ds
        pop     dx
        pop     si
        pop     bp
        ret
_DevHlp_VirtToPhys endp

;***************************************************************************
;* SUBROUTINE NAME: _DevHlp_GetLIDEntry
;*
;* DESCRIPTION:  Get a Logical ID
;*
;* This routine is used to obtain a Logical ID (LID) for devices that exist
;* (that is, devices that are awake).
;
;* C PROTOCOL
;*
;*   USHORT GetLIDEntry(USHORT DeviceID,USHORT RelativeLID,USHORT DeviceState,
;*                      PUSHORT pLID);
;***************************************************************************
;*
_DevHlp_GetLIDEntry    PROC    NEAR
        PUBLIC  _DevHlp_GetLIDEntry 
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
GL_DeviceID    equ        byte ptr [bp+4]
GL_RelID       equ        byte ptr [bp+6]
GL_DevState    equ        byte ptr [bp+8]
GL_pLID        equ        dword ptr [bp+10]
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    dx                               ; Save registers
        push    es
        push    bx

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     al,GL_DeviceID                   ; DeviceID
        mov     bl,GL_RelID                      ; Relative LID
        mov     dh,GL_DevState                   ; Device State
        mov     dl,DevHlp_GetLIDEntry            ; Select function
        call    [_DevHlp]                   ; Call devhelp
        jc      gle10
        les     bx,GL_pLID                       ; Address of Var Addr
        mov     word ptr es:[bx],ax
        xor     ax,ax
gle10:
        pop     bx
        pop     es
        pop     dx
        pop     bp
        ret
_DevHlp_GetLIDEntry    ENDP

;***************************************************************************
;* SUBROUTINE NAME: _DevHlp_FreeLIDEntry
;*
;* DESCRIPTION: Release a Logical ID
;*
;* This routine is used to release a Logical ID.  This must be done at
;* DEINSTALL or termination time.
;*
;* C PROTOCOL
;*
;* USHORT FreeLIDEntry(USHORT LID);
;***************************************************************************
;*
_DevHlp_FreeLIDEntry   PROC    NEAR
        PUBLIC  _DevHlp_FreeLIDEntry  
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
FL_LID  equ     word ptr [bp+4]
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    dx                               ; Save registers

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     ax,FL_LID                        ; LogicalID
        mov     dl,DevHlp_FreeLIDEntry           ; Select function
        call    [_DevHlp]                   ; Call devhelp
        jc      fle10
        xor     ax,ax
fle10:
        pop     dx
        pop     bp
        ret
_DevHlp_FreeLIDEntry   ENDP

;***************************************************************************
;* SUBROUTINE NAME: _DevHlp_ABIOSCall
;*
;* DESCRIPTION: Invoke ABIOS Function
;*
;* This routine is used to invoke an ABIOS service for the Operating
;* System Transfer Convention.
;*
;* C PROTOCOL
;*
;* USHORT ABIOSCall(USHORT LID, POINTER RBOffset, USHORT Entry);
;***************************************************************************
;*
_DevHlp_ABIOSCall      PROC    NEAR
        PUBLIC  _DevHlp_ABIOSCall
        ASSUME cs:_TEXT,ds:_DATA,es:NOTHING,ss:NOTHING
AB_LID        equ   word ptr [bp+4]
AB_RBOffset   equ   word ptr [bp+6]
AB_Entry      equ   byte ptr [bp+8]
        push    bp
        mov     bp,sp                   ; allocate NULL stack frame
        push    dx                               ; Save registers
        push    si

IFDEF   DEVHLP_DEBUG
        int     3
ENDIF
        mov     ax,AB_LID                        ; LogicalID
        mov     si,AB_RBOffset                   ; RB Offset
        mov     dh,AB_Entry                      ; Entry
        mov     dl,DevHlp_ABIOSCall              ; Select function
        call    [_DevHlp]                        ; Call devhelp
        jc      abc10
        xor     ax,ax
abc10:
        pop     si
        pop     dx
        pop     bp
        ret
_DevHlp_ABIOSCall      ENDP

_TEXT   ENDS
        END
