/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

;/********************* START OF SPECIFICATIONS *********************
;*
;* FILE NAME:   AUDIOVDM.C
;*
;* DESCRIPTIVE NAME:  VDM support for Audio PDD communication to VDD
;*
;*
;* FUNCTION:
;*
;*
;* NOTES:
;*
;* ENTRY POINTS:     VDMEntryPoint()
;*     LINKAGE:      call NEAR
;*
;* INPUT:
;*
;* EFFECTS:
;*
;* INTERNAL REFERENCES: PDDEntryPoint()
;*                      VDMInterruptTime()
;*                      VDMClose()
;* EXTERNAL REFERENCES:
;*
;*********************** END OF SPECIFICATIONS **********************/

#include <os2.h>
#include <os2medef.h>
#include <ssm.h>
#include <audio.h>
#include "audiodd.h"
#include "cdevhlp.h"


extern usInUse;
extern GLOBAL      GlobalTable;
extern ADAPTERDATA AdapterInfo;

ULONG PDDInternalEntryPoint(ULONG ulFunc, ULONG ul1, ULONG ul2)
{

        PVOID   pRetLinAddress;
        USHORT  usTemp;

   // _asm int 3
   switch (ulFunc) {
      /*******************************************************/
      /* VDD registering its entry point with PDD            */
      /*******************************************************/
      case 0:
         // get and save VDD entry point
         GlobalTable.VDDIDCSel =(USHORT) ul1;
         GlobalTable.VDDIDCOffset = ul2;
         break;

      /*******************************************************/
      /* Query protocol level                                */
      /*******************************************************/
      case 1:
         return (PDD_VERISON);

      /*******************************************************/
      /* VDD sends PDD a handle to use for IDC communication */
      /*******************************************************/
      case 2:
         GlobalTable.ulPDDHandle = ul1;
         break;

      /*******************************************************/
      /* VDD request open to PDD                             */
      /*******************************************************/
      case 3:
         if (!usInUse) {
            usInUse = NOT_AVAILABLE | VDM;
            return(1);                      // honor open request
            }
         else
            return (0);                     // fail open

      /*******************************************************/
      /* VDD request close to PDD                                    */
      /*******************************************************/
      case 4:
         usInUse = AVAILABLE;
         break;

      /*******************************************************/
      /* Return linear address of I/O port info structure    */
      /*******************************************************/
      case 5:
         // Need to call DevHelp "VirtToLin" to convert
         // 16:16 address to linear address - return linear address to VDD
         // The IOport information should be stored in non-swappable
         // data area with following structure.

         usTemp = (USHORT)(NPVOID)&AdapterInfo;
         if (!DevHlp_VirtToLin(NULL,             // pass null to indicate use DS
                               usTemp,           // 16-bit offset
                               &pRetLinAddress)) // seg:offset
                 return((ULONG)pRetLinAddress);
         else
                return(0);

   }

   /*
   ** Note, the return must be a 16:32 return as we were called
   ** far from 32 bit kernel code.
   ** This code is 16:16 and the compiler would wrongly generate
   ** a 16:16 far return if we used the C return() instruction.
   */
   return (1);
}


/********************* START OF SPECIFICATIONS *********************
* NAME:      VDMInterruptTime()
*
* FUNCTION:  Check if running in a VDM and report interrupt to VDM
*
* NOTES:     If this interrupt is from a VDM session, then we do NOT
*            want the PDD to perform I/O to the adapter - let the DOS
*            application write to the adapter.
*
* LINKAGE:   Call from InterruptHandler (near)
*
* INPUT:
*
* EFFECTS:
*
* INTERNAL REFERENCES:
*
* EXTERNAL REFERENCES:
*
*********************** END OF SPECIFICATIONS **********************/
VOID VDMInterruptTime()
{
        /****************************************************************/
        /* if PDD in use by VDM, then call VDD during interrupt time    */
        /****************************************************************/

        if (usInUse & VDM)
           {
           CallVDD (GlobalTable.VDDIDCOffset,
                    GlobalTable.VDDIDCSel,
                    VDM_INTR,
                    GlobalTable.ulPDDHandle,
                    (ULONG)AdapterInfo.usIRQLevel);
           }
}


/********************* START OF SPECIFICATIONS *********************
* NAME:      VDMClose()
*
* FUNCTION:  To close let the VDD know that the PDD is being closed
*            and available for use by the VDD.
*
* NOTES:     This allows a VDM waiting for access to the adapter to
*            call us back on an OPEN.
*
* LINKAGE:   Call from DosClose code (near)
*
* INPUT:
*
* EFFECTS:
*
* INTERNAL REFERENCES:
*
* EXTERNAL REFERENCES:
*
*********************** END OF SPECIFICATIONS **********************/
VOID VDMClose()
{
        /****************************************************************/
        /* Always call VDD at DosClose time                             */
        /* This will allow a VDM waiting for access to call us back     */
        /****************************************************************/

        if (GlobalTable.VDDIDCSel)
               CallVDD (GlobalTable.VDDIDCOffset,
                        GlobalTable.VDDIDCSel,
                        VDM_CLOSE,
                        GlobalTable.ulPDDHandle,
                        0);
}
