;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
; util.asm
;    This file contains miscellaneous utility functions for io port data
; transfer, memory data transfer, and address manipulation.


.386

_DATA SEGMENT WORD PUBLIC USE16 'DATA'
_DATA ENDS

_BSS SEGMENT WORD PUBLIC USE16 'BSS'
_BSS ENDS

CONST SEGMENT WORD PUBLIC USE16 'CONST'
CONST ENDS

_TEXT SEGMENT WORD PUBLIC USE16 'CODE'
_TEXT ENDS

DGROUP  GROUP   _DATA, CONST, _BSS
CGRP    GROUP   _TEXT


_DATA   SEGMENT
_DATA   ENDS


_TEXT   SEGMENT WORD PUBLIC USE16 'CODE'
        ASSUME cs:CGRP, ds:DGROUP, es:NOTHING, ss:NOTHING


; VOID outportb(USHORT io_address, UCHAR data)
;    This function writes a byte to a particular io port address.
;    The function receives the io address and the data as parameters on the
; stack.
;    The function does not return a value.

public _outportb
_outportb proc near
            push bp
            mov bp,sp
            mov dx,WORD PTR [bp+4]             ;io_address
            mov al,BYTE PTR [bp+6]                ;data
            out dx,al
            mov sp,bp
            pop bp
            ret
_outportb endp


; UCHAR inportb(USHORT io_address)
;    This function reads a bytes from a particular io port address.
;    The receives the io address as a parameter on the stack.
;    The function returns the data read in ax.

public _inportb
_inportb proc near
            push bp
            mov bp,sp
            mov dx,WORD PTR [bp+4]                ;io_address
            in al,dx
            mov ah,0
            mov sp,bp
            pop bp
            ret
_inportb endp


; VOID outportw(USHORT io_address, USHORT data)
;    This function writes a word to a particular io port address.
;    The function receives the io address and the data as parameters on the
; stack.
;    The function does not return a value.

public _outportw
_outportw proc near
            push bp
            mov bp,sp
            mov dx,WORD PTR [bp+4]             ;io_address
            mov ax,WORD PTR [bp+6]             ;data
            out dx,ax
            mov sp,bp
            pop bp
            ret
_outportw endp


; USHORT inportw(USHORT io_address)
;    This function reads a bytes from a particular io port address.
;    The receives the io address as a parameter on the stack.
;    The function returns the data read in ax.

public _inportw
_inportw proc near
            push bp
            mov bp,sp
            mov dx,WORD PTR [bp+4]                ;io_address
            in ax,dx
            mov sp,bp
            pop bp
            ret
_inportw endp
  

; VOID memcopy(UCHAR *srcP, UCHAR *destP, USHORT length)
;    This function copies a block of data from one memory location to another.
;    The function receives the source address, destination address, and length
; of the data as parameters on the stack.
;    The function does not return a value.

public _memcopy
_memcopy proc near

SRC1_LOW equ <[bp+4]>
SRC1_HIGH equ <[bp+6]>
DEST1_LOW equ <[bp+8]>
DEST1_HIGH equ <[bp+0ah]>
BUF1_LEN equ <[bp+0ch]>

    ; point to parameters and local variables
        push   bp
        mov    bp,sp

    ; save registers
        push   cx
        push   bx
        push   ds
        push   es
        push   si
        push   di

    ; store number of bytes to transfer and calculate number of double words
    ; and set of transfer value
        mov    bx,BUF1_LEN
        mov    cx,bx
        shr    cx,2

    ; set size in bytes of object to be allocated
        mov    es,DEST1_HIGH
        mov    di,DEST1_LOW

    ; set up pointers to source buffer
        mov    ds,SRC1_HIGH
        mov    si,SRC1_LOW

    ; set up transfer direction
        cld

    ; do the transfer
        rep    movsd

    ; transfer number of odd bytes
        mov    cx,bx
        and    cx,03h
        rep    movsb



    ;set up return value and restore registers
        pop    di
        pop    si
        pop    es
        pop    ds
        pop    bx
        pop    cx
        pop    bp

   ;done
        ret
_memcopy endp


;VOID memfill(UCHAR *destP, ULONG length, UCHAR value)
;    This function fills a block of memory with a particular value.
;    The function receives address of the memory, the length of the memory, and
; the fill value as parameters on the stack.
;    The function does not return a value.

public _memfill
_memfill proc near

DEST2_LOW equ <[bp+4]>
DEST2_HIGH equ <[bp+6]>
BUF2_LEN equ <[bp+8]>
VALUE2 equ <[bp+0ch]>

    ; point to parameters and local variables
        push   bp
        mov    bp,sp

    ; save registers
        push   ecx
        push   es
        push   di

    ; store number of bytes to transfer and calculate number of double words
    ; and set of transfer value
        mov    ebx,BUF2_LEN
        mov    ecx,ebx
        shr    ecx,2

    ; set size in bytes of object to be allocated
        mov    es,DEST2_HIGH
        mov    di,DEST2_LOW

    ; set up value
        mov    al,VALUE2
        mov    ah,VALUE2
        shl    eax,010h
        mov    al,VALUE2
        mov    ah,VALUE2

    ; set up transfer direction
        cld

    ; do the transfer
        rep    stosd

    ; transfer number of odd bytes
        mov    cx,bx
        and    cx,03h
        rep    stosb

    ;set up return value and restore registers
        pop    di
        pop    es
        pop    ecx
        pop    bp

   ;done
        ret
_memfill endp


; VOID *make_far_ptr(USHORT segment, USHORT offset)
;    This function converts a segment and offset pair to a far pointer.
;    The function receives the segment and offset as paramaters on the stack.
;    The function does not return a value.

public _make_far_ptr
_make_far_ptr proc near
            push bp
            mov bp,sp
            mov dx,word ptr [bp+4]
            mov ax,word ptr [bp+6]
            pop bp
            ret
_make_far_ptr endp


_TEXT ENDS

END
