/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// trace.c
//    This file contains routines that support the data logging facility
// used for device driver debugging and performance analysis.


    // include files
#include "types.h"
#include "trace.h"


    // debug info 
#ifdef DEBUG_FLAG
#define static /**/
#endif


    // private global variables
static ULONG Trace_data[NUM_TRACES][NUM_TRACE_ELEMENTS];
static USHORT Current_trace_element_pos[NUM_TRACES];
static BOOL Trace_overflow[NUM_TRACES];


VOID init_trace(USHORT trace_num)
//    This function initializes a trace.
//    The parameter 'trace_num' is the number of the trace
// from 1 to NUM_TRACES.
//    The function does not return a value.
{
    USHORT i;

        // done if trace number is out of range
    if ((trace_num < 1) || (trace_num > NUM_TRACES))
        return;

        // init the trace position - clear trace overflow indicator - init
        // buffer by filling with unlikely value
    Current_trace_element_pos[trace_num - 1] = 0;
    Trace_overflow[trace_num - 1] = FALSE;
    for (i = 0; i <= NUM_TRACE_ELEMENTS - 1; i++)
        Trace_data[trace_num - 1][i] = 0xffffffff;

        // finished
    return;
}



VOID trace(USHORT trace_num, ULONG data)
//    This function enters a trace value into a particular trace buffer.
//    The parameter 'trace_num' is the number of the trace buffer and the
// parameter 'data' is the value to enter into the buffer.
//    The function does not return a value.
{
        // done if trace number is out of range
    if ((trace_num < 1) || (trace_num > NUM_TRACES))
        return;

        // check for overflow condition
    if (Current_trace_element_pos[trace_num - 1] >= NUM_TRACE_ELEMENTS) {
        Trace_overflow[trace_num - 1] = TRUE;
        return;
    }

        // log the data into the buffer
    Trace_data[trace_num - 1]
                    [Current_trace_element_pos[trace_num - 1]++] = data;

        // finished
    return;
}
