/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// timer.c
//    This file contains miscellaneous time related functions.


    // include files
#include "types.h"
#include "timer.h"


    // debug info
#ifdef DEBUG_FLAG
#define static /**/
#endif


    // constant definitions
#define MAX_NUM_TIMERS 10


    // type definitions
typedef struct {
    ULONG count;
    BOOL used;
} TIMER;

    // private global variables
static USHORT Bump_counter = 1;
static TIMER Timer[MAX_NUM_TIMERS];


VOID init_timer_services(VOID)
//    Initialize the timer services;
//    The function does not have parameters.
//    The fuction does not return a value.
{
    USHORT i;

        // init the timers to unused
    for (i = 0; i <= MAX_NUM_TIMERS - 1; i++)
        Timer[i].used = FALSE;

        // finished
    return;
}

 
VOID update_timer(VOID)
//    This function updates the timer counters.
//    The function does not have parameters.
//    The function does not return a value.
{
    USHORT i;

        // update the used timers
    if (Bump_counter < 4) {
        for (i = 0; i <= MAX_NUM_TIMERS - 1; i++)
            if (Timer[i].used == TRUE)
                Timer[i].count += 31L;
        Bump_counter++;
    }
    else {
        for (i = 0; i <= MAX_NUM_TIMERS - 1; i++)
            if (Timer[i].used == TRUE)
                Timer[i].count += 32L;
        Bump_counter = 1;
    }

        // finished
    return;
}


SHORT acquire_timer(VOID)
//    This function acquires a timer
//    The function does not have parameters.
//    The function does not returns the number of the timer if successful.
// Otherwise, the function returns the value -1.
{
    USHORT i;

        // search the list and return a free timer
    for (i = 0; i <= MAX_NUM_TIMERS - 1; i++) {
        if (Timer[i].used == FALSE) {
            Timer[i].used = TRUE;
            return (i);
        }
    }
 
        // return unsuccessful - no free timer
    return (-1);
}


VOID release_timer(SHORT num)
//    This function frees a timer.
//    The parameter 'num' is the number of the timer.
//    The function does not return a value.
{
        // mark the timer free
    Timer[num].used = FALSE;

        // finished
    return;
}


VOID reset_timer(SHORT num)
//    This function resets a timer to 0.
//    The parameter 'num' is the number of the timer.
//    The function does not return a value.
{
        // reset the timer
    Timer[num].count = 0L;

        // finished
    return;
}


ULONG get_time(SHORT num)
//    This function gets the value of a timer.
//    The parameter 'num' is the number of the timer.
//    The function returns the value of the timer.
{
        // return the timer count
    return (Timer[num].count);
}


VOID delay_ms(ULONG num_of_millisecs)
//    This function delays a specified time period.
//    The parameter 'num_of_millisecs' is the time period in millisecs to delay.
//    The function does not return a value.
{
    SHORT num;

        // get a timer
    if ((num = acquire_timer()) == -1)
        return;

        // init the delay timer
    reset_timer(num);

        // return when period expires
    while (1) {
        if (get_time(num) >= num_of_millisecs)
            break;
    }

        // release the timer
    release_timer(num);

        // finished
    return;
}
