/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// strmhelp.h
//    This file contains definitions for shared constants, definitions for
// shared types, and prototypes for public functions originating in strmhelp.c.


    // constant definitions
#define STREAM_STATE_STOP 0                // stream states
#define STREAM_STATE_START 1
#define STREAM_STATE_PAUSE 2

#define STREAM_OPERATION_PLAY 0            // stream operations
#define STREAM_OPERATION_RECORD 1

#define STREAM_DATA_FORMAT_PCM 0           // data formats
#define STREAM_DATA_FORMAT_MU_LAW 1
#define STREAM_DATA_FORMAT_A_LAW 2

#define STREAM_INPUT_NULL 0                // stream inputs
#define STREAM_INPUT_STEREO_LINE 1
#define STREAM_INPUT_MIC 2
#define STREAM_INPUT_BOOSTED_MIC 3

#define STREAM_OUTPUT_NULL 0               // stream outputs
#define STREAM_OUTPUT_STEREO_LINE 1


    /* type definitions */
typedef struct _event {                    // event element type
    ULONG handle;
    ULONG alarm_time;
    struct _event *nextP;
} EVENT;

typedef struct _buf_element {              // buffer element type
    VOID *bufferP;
    USHORT next_data_trans_pos;
    ULONG cur_dev_consumed_pos;
    USHORT buffer_size;
    struct _buf_element *nextP;
    struct _buf_element *prevP;
} BUF_ELEMENT;

typedef struct {                           // channel status type
    ULONG volume;
    ULONG input_level;
} CHANNEL_STATUS;

typedef struct _stream {                   // stream type
    struct _stream *nextP;
    struct _stream *prevP;
    BUF_ELEMENT *first_free_buf_elementP;
    BUF_ELEMENT *head_buf_elementP;
    BUF_ELEMENT *cur_buf_elementP;
    BUF_ELEMENT *tail_buf_elementP;
    CHANNEL_STATUS channel[2];
    USHORT sys_file_num;
    SHORT state;
    ULONG handle;
    SHORT operation;
    ULONG current_time;
    USHORT sample_rate;
    SHORT data_format;
    UCHAR bits_per_sample;
    UCHAR num_of_channels;
    USHORT buffer_size;
    SHORT output_device;
    SHORT input_device;
    ULONG start_time;
} STREAM;


    // prototypes for public functions
VOID init_strmhelp(VOID);
SHORT create_stream(USHORT);
VOID destroy_stream(STREAM *);
VOID do_reg_stream(STREAM *, ULONG);
VOID do_dereg_stream(STREAM *);
BOOL stream_registered(STREAM *);
VOID set_stream_active(ULONG);
STREAM *get_stream_from_sys_file_num(USHORT);
VOID set_active_stream(STREAM *);
STREAM *get_stream_from_handle(ULONG);
STREAM *get_active_stream(VOID);
VOID set_stream_clock_and_format(STREAM *, USHORT, SHORT, UCHAR, UCHAR);
VOID set_stream_volume(STREAM *, ULONG);
VOID set_stream_state(STREAM *, SHORT);
VOID set_stream_operation(STREAM *, SHORT);
VOID set_stream_time(STREAM *, ULONG);
VOID set_stream_input_level(STREAM *, LONG);
ULONG get_stream_time(STREAM *);
SHORT get_stream_operation(STREAM *);
SHORT get_stream_state(STREAM *);
VOID set_stream_monitor(STREAM *, BOOL);
VOID set_stream_input_device(STREAM *, SHORT);
VOID set_stream_output_device(STREAM *, SHORT);
VOID get_current_stream_status(USHORT *, SHORT *, UCHAR *, UCHAR *, SHORT *);
VOID start_stream_operation(VOID);
VOID do_stream_operation(VOID);
VOID update_volume_and_balance(VOID);
EVENT *insert_stream_event(STREAM *, ULONG);
VOID del_stream_event(STREAM *, EVENT *);
VOID del_all_stream_events(STREAM *);
EVENT *get_stream_event_from_handle(STREAM *, ULONG);
VOID set_event_time(EVENT *, ULONG);
ULONG get_stream_handle(STREAM *);
SHORT add_buf_element_to_que_tail(STREAM *, VOID *, ULONG);
VOID set_stream_buf(STREAM *, USHORT);
VOID set_stream_size(STREAM *, USHORT);
VOID del_all_stream_buf_elements(STREAM *);
BOOL was_it_my_interrupt(VOID);
