/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// string.c
//    This file contains miscellaneous string utility functions.


    // include files
#include "types.h"
#include "string.h"


    // private global variables
static CHAR Digits[] = {"0123456789ABCDEF"};


    // prototypes for private functions
CHAR toupper(CHAR);
CHAR *memchr(CHAR *, CHAR, USHORT);


SHORT strcmp(CHAR *str1P, CHAR *str2P)
//    This function compares two strings.
//    The parameters 'str1P' and 'str2P' are pointers to null terminated ascii
// strings.
//    The function returns the value 0 if the strings are identical. Otherwise,
// the value -1 is returned.
{
        // compare the strings - done if differing characters or
        // null encountered
    while (*str1P == *str2P) {
        if ((*str1P == '\0') || (*str2P == '\0'))
            break;
        str1P++;
        str2P++;
    }

        // return successful if at the end of both strings
    if ((*str1P == '\0') && (*str2P == '\0'))
        return(0);

        // return failure
    return(-1);
}


SHORT hex_ascii_to_ushort(CHAR *srcP, USHORT *numP)
//    This function converts a null terminated ascii string representing a
// hex integer to an unsigned short integer.
//    The parameter 'srcP' is a pointer to the null terminated ascii string.
//    The function returns the converted value in the parameter 'numP'. As
// a return value, the function returns the value -1 if an unexpected
// character was encountered. Otherwise, the value '-1' is returned.
{
    USHORT x;
    CHAR *chrP;

        // skip leading spaces
    while (isspace(*srcP))
        srcP++;

        // skip leading zeros
    while (*srcP == '0')
        srcP++;

        // accumulate digits - return error if unexpected character encountered
    x = 0;
    while (*srcP != NULL) {
        if ((chrP = memchr(Digits, toupper(*srcP), 16)) == (CHAR *) 0)
            return(-1);
        x = (x * 16) + (chrP - Digits);
        srcP++;
    }
    *numP = x;

        // return successful
    return (0);
}


SHORT dec_ascii_to_ushort(CHAR *srcP, USHORT *numP)
//    This function converts a null terminated ascii string representing a
// decimal integer to an unsigned short integer.
//    The parameter 'srcP' is a pointer to the null terminated ascii string.
//    The function returns the converted value in the parameter 'numP'. As
// a return value, the function returns the value -1 if an unexpected
// character was encountered. Otherwise, the value '-1' is returned.

{
    USHORT x;
    CHAR *chrP;

        // skip leading spaces
    while (isspace(*srcP))
        srcP++;

        // skip leading zeros
    while (*srcP == '0')
        srcP++;

        // accumulate digits - return error if unexpected character encountered
    x = 0;
    while (*srcP != NULL) {
        if ((chrP = memchr(Digits, *srcP, 16)) == (CHAR *) 0)
            return(-1);
        x = (x * 10) + (chrP - Digits);
        srcP++;
    }
    *numP = x;

        // return successful
    return (0);
}


static CHAR toupper(CHAR c)
//    This function converts a lower case character to an upper case character.
//    The parameter 'c' is the character to convert.
//    The function returns the upper case value.
{
        // convert to upper case and store character
    if ((c >= 'a') && (c <= 'z'))
        c -= 0x20;

        // return the upper case character
    return (c);
}


BOOL isspace(CHAR c)
//    This function determines if a character is a space.
//    The parameter 'c' is the character to evaluate.
//    The function returns the value TRUE if the character is a space.
// Otherwise, the value FALSE is returned.
{
        // return true or false
    return (c == ' ');
}


static CHAR *memchr(CHAR *strP, CHAR c, USHORT size)
//    This function searches a string for a particular character and returns
// a pointer to the character in the string.
//    The parameter 'strP' is a pointer to a string of characters. The
// parameter 'c' is the character to evaluate. The parameter 'size' is the
// size of the string.
//    The function returns a pointer to the character in the string if found.
// Otherwise, the value null is returned.
{
    USHORT i;

        // search for the character - return position if found
    i = 0;
    while (i <= size - 1) {
        if (*strP == c)
            return (strP);
        strP++;
        i++;
    }

        // character not found - return null
    return ((CHAR *) 0);
}
