/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// entry.h

//    This file contains definitions for shared types and prototypes for

// public functions originating in strategy.c.





    // type definitions

typedef struct {                            // template for request header 

   UCHAR length;                            // request packet length 

   UCHAR unit;                              // unit code for block DD only 

   UCHAR command;                           // command code 

   USHORT status;                           // return status 

   UCHAR reserved[4];                       // reserved bytes 

   ULONG qlink;                             // queue linkage 

   union {                                  // command-specific data 

      struct {

         UCHAR dummy1;

         FFP_V_V devhlp_entry;              // dev help address 

         CHAR *argP;                        // argument pointer 

         UCHAR dummy3;

      } init_in;

      struct {

         UCHAR dummy1;

         USHORT code_end;                   // final code offset 

         USHORT data_end;                   // final data offset 

         ULONG dummy2;

         UCHAR dummy3;

      } init_out;

      struct {

         UCHAR category;                    // category code 

         UCHAR function;                    // function code 

         VOID *param_bufP;                  // address of parameter buffer 

         VOID *data_bufP;                   // address of data buffer 

         USHORT sys_file_num;               // system file number 

      } ioctl;

      struct {

         USHORT sys_file_num;

      } open;

      struct {

         USHORT sys_file_num;

      } close;

   } s;

} REQPACKET;





    // prototypes for public functions

VOID do_strat(REQPACKET *);

SHORT vdd_acquire_device(VOID);

VOID vdd_release_device(VOID);

VOID vdd_get_info(VDD_INFO *);

