/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// strategy.c
//     This file contain the routine the services the device driver strategy
// entry point and routines that support the vdd interface.


    // include files
#include "types.h"
#include "entry.h"
#include "devhlp.h"
#include "header.h"
#include "param.h"
#include "audcont.h"
#include "end.h"
#include "strmhelp.h"
#include "strmcont.h"
#include "device.h"
#include "mem.h"
#include "strategy.h"
#include "timer.h"
#include "trace.h"
#include "rmhelp.h"
#include "ddprintf.h"


    // debug info
#ifdef DEBUG_FLAG
#define static /**/
#endif


    // constant definitions
#define CMD_INIT 0                          /* comand for device initialization */
#define CMD_INIT_COMP 0x1f
#define CMD_OPEN 13
#define CMD_CLOSE 14
#define CMD_IOCTL 16                        /* command for general io control */

#define RPDONE 0x0100                       /* return successful */
#define RPERR 0x8000                        /* return error */
#define RPGENFAIL 0x000c                    /* return error: General failure */


    // external global variable declarations
extern DEVHDR Dev_hdr;                             /* DEVICE HEADER */
extern USHORT End_of_data;                  /* end of data marker */


    // public global variables
SHORT Trace_timer;


    // private global variables
static BOOL Installed;                      /* flag for driver installed status */
static USHORT Num_of_opens;
static BOOL Vdd_device_in_use;


VOID do_strat(REQPACKET far *rpP)
//    This function services requests to the device driver strategy entry
// point.
//    The parameter 'rpP' is a pointer to a block of information from the
// operating system specific to the request.

{
    USHORT i;
    ULONG data_end_offset, func_offset;
    SHORT device_type;
    USHORT base_io_address, irq_num, dma_channel;
    CHAR driver_name[MAX_PARAM_LEN];
    USHORT num_io_ranges, base_port, num_ports;

        // initialization event
    switch(rpP->command) {
        case CMD_INIT:

//#define DEBUGA1
#ifdef DEBUGA1
_asm push ax
_asm int 3
_asm mov ax,0a1h
_asm pop ax
#endif

                // initialize number of opens counter, device in use by os/2
                // flag, and device driver installed flag.
            Num_of_opens = 0;
            Vdd_device_in_use = FALSE;
            Installed = FALSE;

#ifdef TRACE_ALL_EVENTS
            init_trace(TRACE_ALL_EVENTS);
            Trace_timer = acquire_timer();
            reset_timer(Trace_timer);
#endif

                // error if device driver already installed
            if (Installed) {
                rpP->status = RPDONE | RPERR | RPGENFAIL;
                rpP->s.init_out.code_end = 0;
                rpP->s.init_out.data_end = 0;
                return;
            }

                // initialize device driver helper services
            devhlp_init(rpP->s.init_in.devhlp_entry);

            init_mem();


                // initialize stream and audio control services
            init_strmcont();
            init_strmhelp();

                // get the driver name parameter
            if (get_param_driver_name(rpP->s.init_in.argP, driver_name) != 0) {
                rpP->status = RPDONE | RPERR | RPGENFAIL;
                rpP->s.init_out.code_end = 0;
                rpP->s.init_out.data_end = 0;
                return;
            }

            set_driver_name(driver_name);


#ifdef RESMGR
            if (RMHELP_CreateDriver("BUSAUDIO.SYS") != RMRC_SUCCESS) {
                rpP->status = RPDONE | RPERR | RPGENFAIL;
                rpP->s.init_out.code_end = 0;
                rpP->s.init_out.data_end = 0;
                ddprintf ("\n** RM:CreateDriver **\n");
                return;
            }
#endif

                // get the device type parameter
            if (get_param_dev_type(rpP->s.init_in.argP, &device_type) != 0) {
                if (dev_auto_detect_dev_type(&device_type) != 0) {
                    rpP->status = RPDONE | RPERR | RPGENFAIL;
                    rpP->s.init_out.code_end = 0;
                    rpP->s.init_out.data_end = 0;
#ifdef RESMGR
                    RMHELP_DestroyDriver();
#endif
                    return;
                }
            }

                // set the device type
            set_dev_type(device_type);

                // gt the base io address parameter
            if (get_param_base_io_addr(rpP->s.init_in.argP,
                                                  &base_io_address) != 0)  {
                rpP->status = RPDONE | RPERR | RPGENFAIL;
                rpP->s.init_out.code_end = 0;
                rpP->s.init_out.data_end = 0;
#ifdef RESMGR
                RMHELP_DestroyDriver();
#endif
                return;
            }

                // set the base io address
            if (set_dev_base_io_addr(base_io_address) != 0)  {
                rpP->status = RPDONE | RPERR | RPGENFAIL;
                rpP->s.init_out.code_end = 0;
                rpP->s.init_out.data_end = 0;
#ifdef RESMGR
                RMHELP_DestroyDriver();
#endif
                return;
            }

                // get number of i/o address ranges accessed by ad1848
            num_io_ranges = get_dev_ad1848_num_io_ranges();

            for (i = 1; i <= num_io_ranges; i++) {
                get_dev_ad1848_io_range(i, &base_port, &num_ports);

#ifdef RESMGR
                if (RMHELP_AllocPorts(base_port, num_ports,
                                           RS_IO_EXCLUSIVE) != RMRC_SUCCESS) {
                    rpP->status = RPDONE | RPERR | RPGENFAIL;
                    rpP->s.init_out.code_end = 0;
                    rpP->s.init_out.data_end = 0;
                    RMHELP_DestroyDriver();
                    ddprintf ("\n** RM:PORT %x **\n", base_port);
                    return;
                }
#endif
            }

                // get number of i/o address ranges accessed by echo
            num_io_ranges = get_dev_echo_num_io_ranges();

            for (i = 1; i <= num_io_ranges; i++) {
                get_dev_echo_io_range(i, &base_port, &num_ports);

#ifdef RESMGR
                if (RMHELP_AllocPorts(base_port, num_ports,
                                           RS_IO_EXCLUSIVE) != RMRC_SUCCESS) {
                    rpP->status = RPDONE | RPERR | RPGENFAIL;
                    rpP->s.init_out.code_end = 0;
                    rpP->s.init_out.data_end = 0;
                    RMHELP_DestroyDriver();
                    ddprintf ("\n** RM:PORT %x **\n", base_port);
                    return;
                }
#endif
            }

                // get the irq number parameter
            if (get_param_irq_number(rpP->s.init_in.argP, &irq_num) != 0) {
                rpP->status = RPDONE | RPERR | RPGENFAIL;
                rpP->s.init_out.code_end = 0;
                rpP->s.init_out.data_end = 0;
#ifdef RESMGR
                RMHELP_DestroyDriver();
#endif
                return;
            }

#ifdef RESMGR
            if (RMHELP_AllocIRQ(irq_num) != RMRC_SUCCESS) {
                rpP->status = RPDONE | RPERR | RPGENFAIL;
                rpP->s.init_out.code_end = 0;
                rpP->s.init_out.data_end = 0;
                RMHELP_DestroyDriver();
                ddprintf ("\n** RM:IRQ %d **\n", irq_num);
                return;
            }
#endif

                // set the irq number
            if (set_dev_irq_number(irq_num) != 0) {
                rpP->status = RPDONE | RPERR | RPGENFAIL;
                rpP->s.init_out.code_end = 0;
                rpP->s.init_out.data_end = 0;
#ifdef RESMGR
                RMHELP_DestroyDriver();
#endif
                return;
            }

                // install on the system timer
            func_offset = (ULONG) service_timer_interrupt;
            if (set_sys_timer((USHORT) func_offset) != 0) {
                rpP->status = RPDONE | RPERR | RPGENFAIL;
                rpP->s.init_out.code_end = 0;
                rpP->s.init_out.data_end = 0;
#ifdef RESMGR
                RMHELP_DestroyDriver();
#endif
                return;
            }

                // install device driver service routine
                // for hardware interrupt
            func_offset = (ULONG) service_hardware_interrupt;
            if (set_irq((USHORT) func_offset, get_dev_irq_number()) != 0) {
                rpP->status = RPDONE | RPERR | RPGENFAIL;
                rpP->s.init_out.code_end = 0;
                rpP->s.init_out.data_end = 0;
#ifdef RESMGR
                RMHELP_DestroyDriver();
#endif
                return;
            }

                // if it applies to the current device - get the dma channel
                // parameter - set the dma channel
            if ((device_type == DEV_MS_SOUND) ||
                            (device_type == DEV_TOSHIBA_T4700CS) ||
                                   (device_type == DEV_COMPAQ) ||
                                          (device_type == DEV_THINKPAD)) {
                if (get_param_dma_channels(rpP->s.init_in.argP,
                                                        &dma_channel) != 0) {
                    rpP->status = RPDONE | RPERR | RPGENFAIL;
                    rpP->s.init_out.code_end = 0;
                    rpP->s.init_out.data_end = 0;
#ifdef RESMGR
                    RMHELP_DestroyDriver();
#endif
                    return;
                }

#ifdef RESMGR
                if (RMHELP_AllocDMA(dma_channel) != RMRC_SUCCESS) {
                    rpP->status = RPDONE | RPERR | RPGENFAIL;
                    rpP->s.init_out.code_end = 0;
                    rpP->s.init_out.data_end = 0;
                    RMHELP_DestroyDriver();
                    ddprintf ("\n** RM:DMA %d **\n", dma_channel);
                    return;
                }
#endif
                if (set_dev_dma_channels(dma_channel) != 0) {
                    rpP->status = RPDONE | RPERR | RPGENFAIL;
                    rpP->s.init_out.code_end = 0;
                    rpP->s.init_out.data_end = 0;
#ifdef RESMGR
                    RMHELP_DestroyDriver();
#endif
                    return;
                }

            }
                          // if it applies to the current device - initialize dsp related
                // functions
            if (device_type == DEV_REEL_MAGIC) {
                if (init_dev_dsp(rpP->s.init_in.argP) != 0) {
                    rpP->status = RPDONE | RPERR | RPGENFAIL;
                    rpP->s.init_out.code_end = 0;
                    rpP->s.init_out.data_end = 0;
#ifdef RESMGR
                    RMHELP_DestroyDriver();
#endif
                    return;
                }
            }

                // register device driver service routine for pdd / vdd
                // communications
            if (register_pdd(driver_name,
                                   (FFP_V_V) service_vdd_idc_request) != 0) {
                rpP->status = RPDONE | RPERR | RPGENFAIL;
                rpP->s.init_out.code_end = 0;
                rpP->s.init_out.data_end = 0;
#ifdef RESMGR
                RMHELP_DestroyDriver();
#endif

                return;
            }

                // set the DMA channel and irq number, and base io address
            if (init_device() != 0) {
                rpP->status = RPDONE | RPERR | RPGENFAIL;
                rpP->s.init_out.code_end = 0;
                rpP->s.init_out.data_end = 0;
#ifdef RESMGR
                RMHELP_DestroyDriver();
#endif
                return;
            }

#ifdef RESMGR
            if (RMHELP_CreateAdapter() != RMRC_SUCCESS ) {
                rpP->status = RPDONE | RPERR | RPGENFAIL;
                rpP->s.init_out.code_end = 0;
                rpP->s.init_out.data_end = 0;
                RMHELP_DestroyDriver();
                ddprintf ("\n** RM:CreateAdapter **\n");
                return;
            }
#endif

                // driver has successfully installed - set end of code and data
                // markers - set driver installed flag
            rpP->status = RPDONE;
            rpP->s.init_out.code_end = (USHORT) end_of_text;
            data_end_offset = (ULONG) &End_of_data;
            rpP->s.init_out.data_end = (USHORT) data_end_offset;
            Installed = TRUE;

                // done
            return ;

        case CMD_OPEN:

                // return error if driver in use by dos or         sesssion
            if (Vdd_device_in_use) {
                rpP->status = RPDONE | RPERR | RPGENFAIL;
                return;
            }

                // if this is the first open of the device driver
            if (Num_of_opens == 0) {


            }

#ifdef TRACE_ALL_EVENTS
            trace(TRACE_ALL_EVENTS, 0xffffffff);
            trace(TRACE_ALL_EVENTS, 0xffffffff);
            trace(TRACE_ALL_EVENTS, 0xa0000000);
            reset_timer(Trace_timer);
            trace(TRACE_ALL_EVENTS, get_time(Trace_timer));
            trace(TRACE_ALL_EVENTS, (ULONG) rpP->s.open.sys_file_num);
#endif

                // create an enviroment for this open
            if (audio_open(rpP->s.open.sys_file_num) != 0) {
#ifdef TRACE_ALL_EVENTS
                trace(TRACE_ALL_EVENTS, 0xe0000000);
#endif
                rpP->status = RPDONE | RPERR | RPGENFAIL;
                return;
            }


                // increment the number of opens
            Num_of_opens++;

                // finished
            rpP->status = RPDONE;
            return;

        case CMD_CLOSE:

#ifdef TRACE_ALL_EVENTS
            trace(TRACE_ALL_EVENTS, 0xffffffff);
            trace(TRACE_ALL_EVENTS, 0xaf000000);
            trace(TRACE_ALL_EVENTS, get_time(Trace_timer));
            reset_timer(Trace_timer);
            trace(TRACE_ALL_EVENTS, rpP->s.close.sys_file_num);
#endif

                // decrement the number of opens
            Num_of_opens--;

                // if there are no opens after this close
            if (Num_of_opens == 0) {

                    // report to the vdd that the device is free
                vdd_report_device_free();
            }

                // close the audio enviroment
            if (audio_close(rpP->s.close.sys_file_num) == -1) {
#ifdef TRACE_ALL_EVENTS
                trace(TRACE_ALL_EVENTS, 0xef000000);
#endif
                rpP->status = RPDONE | RPERR | RPGENFAIL;
                return;
            }

                // finished
            rpP->status = RPDONE;
            return;


        case CMD_IOCTL:

                // do the audio control command
            if (rpP->s.ioctl.category == 0x80) {
                if (do_audio_control_command(rpP->s.ioctl.function,
                     rpP->s.ioctl.data_bufP, rpP->s.ioctl.sys_file_num) != 0) {
                    rpP->status = RPDONE | RPERR | RPGENFAIL;
                    return;
                }
            }

                // finished
            rpP->status = RPDONE;
            return;

        default:
            rpP->status = RPDONE;
            return;
    }
}


SHORT vdd_acquire_device(VOID)
//    This function acquires the device for the vdd if there are no active
// opens of the device driver.
//    The function does not have parameters.
//    The function returns the value 0 if successful. Otherwise the value -1
// is returned.

{
        // set the device in use flag if there are no opens - return successful
    if (Num_of_opens == 0) {
        Vdd_device_in_use = TRUE;
        return(0);
    }

        // return error if there are active opens
    return(-1);
}


VOID vdd_release_device(VOID)
//    This function releases the device from the vdd.
//    The fuction does not have parameters.
//    The function does not return a value.

{
        // set the flag to indicate the device is not in use by the vdd
    Vdd_device_in_use = FALSE;

        // finished
    return ;
}


VOID vdd_get_info(VDD_INFO *infoP)
//    This function gets information for the vdd
//    The function returns information in the buffer pointed to by the
// parameter 'infoP'.
//    The function does not return a value.

{
        // set up the return information
    infoP->adapter_info.irq_level = get_dev_irq_number();
    infoP->adapter_info.dma_channel = get_dev_dma_play_channel();
    infoP->adapter_info.num_ranges = 1;
    infoP->port_entry.first_port = get_dev_base_io_address();
    infoP->port_entry.number_ports = 10;

        // finished
    return;
}
