/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// param.c 
//    This file contains routines that parse parameters 


    // include files
#include "types.h"
#include "param.h"
#include "string.h"
#include "header.h"
#include "device.h"


    // debug info 
#ifdef DEBUG_FLAG
#define static /**/
#endif



SHORT get_param_dev_type(CHAR *strP, SHORT *device_type)
//    This function gets the device type parameter.
//    The parameter 'strP' is a pointer to a null terminated string of ascii
// characters containing all the parameters to the driver. The number of the
// device is returned in the parameter 'device_type'.
//    The function returns the value -1 if an expected value was not found.
// Otherwise, the value 0 is returned.
{
    USHORT i;
    CHAR s[MAX_PARAM_LEN];

        // skip past the file path and name
    while (1) {
        if ((*strP == ' ') || (*strP == '\0')) 
            break;

        strP++;
    } 

        // search for parameter type indicator
    while (1) {
        if (*strP == '\0')
            return (-1);

        if ((*strP == 'T') && (*(strP + 1) == ':'))
            break;

        strP++;
    }

        // get parameter and null terminate
    strP += 2;
    i = 0;

    for (i = 0; i <= MAX_PARAM_LEN - 2; i++) {
        if ((*strP == ' ') || (*strP == '\0')) {
            s[i] = '\0';
            break;
        }
        s[i] = *strP++;
    }

        // set up return info
    if (strcmp("MS_SOUND", s) == 0) {
        *device_type = DEV_MS_SOUND;
        return (0);
    }
    if (strcmp("THINKPAD", s) == 0) {
        *device_type = DEV_THINKPAD;
        return (0);
    }

    if (strcmp("COMPAQ", s) == 0) {
        *device_type = DEV_COMPAQ;
        return (0);
    }

    if (strcmp("TOSHIBA_T4700CS", s) == 0) {
        *device_type = DEV_TOSHIBA_T4700CS;
        return (0);
    }

    if (strcmp("TOSHIBA_T6600C", s) == 0) {
        *device_type = DEV_TOSHIBA_T6600C;
        return (0);
    }


    if (strcmp("REEL_MAGIC", s) == 0) {
        *device_type = DEV_REEL_MAGIC;
        return (0);
    }

        // return error - no acceptable parameter found
    return(-1);
}
 

SHORT get_param_base_io_addr(CHAR *strP, USHORT *base_io_address)
//    This function gets the base io address parameter.
//    The parameter 'strP' is a pointer to a null terminated string of ascii
// characters containing all the parameters to the driver. The base io address
// is returned in the parameter 'base_io_address'.
//    The function returns the value -1 if an expected value was not found.
// Otherwise, the value 0 is returned.

{
    USHORT i;
    CHAR s[MAX_PARAM_LEN];

        // skip past the file path and name
    while (1) {
        if ((*strP == ' ') || (*strP == '\0'))
            break;

        strP++;
    }

        // search for parameter type indicator
    while (1) {
        if (*strP == '\0')
            return (-1);

        if ((*strP == 'P') && (*(strP + 1) == ':'))
            break;

        strP++;
    }

        // get parameter and null terminate
    strP += 2;
    i = 0;

    for (i = 0; i <= MAX_PARAM_LEN - 2; i++) {
        if ((*strP == ' ') || (*strP == '\0')) {
            s[i] = '\0';
            break;
        }
        s[i] = *strP++;
    }

        // set up return info
    if (hex_ascii_to_ushort(s, base_io_address) != 0)
        return (-1);

        // finished
    return (0);
}
 

SHORT get_param_irq_number(CHAR *strP, USHORT *irq_num)
//    This function gets the irq number parameter.
//    The parameter 'strP' is a pointer to a null terminated string of ascii
// characters containing all the parameters to the driver. The irq number
// is returned in the parameter 'irq_number'.
//    The function returns the value -1 if an expected value was not found.
// Otherwise, the value 0 is returned.

{
    USHORT i;
    CHAR s[MAX_PARAM_LEN];

        // skip past the file path and name
    while (1) {
        if ((*strP == ' ') || (*strP == '\0'))
            break;

        strP++;
    }

        // search for parameter type indicator
    while (1) {
        if (*strP == '\0')
            return (-1);

        if ((*strP == 'I') && (*(strP + 1) == ':'))
            break;

        strP++;
    }

        // get parameter and null terminate
    strP += 2;
    i = 0;

    for (i = 0; i <= MAX_PARAM_LEN - 2; i++) {
        if ((*strP == ' ') || (*strP == '\0')) {
            s[i] = '\0';
            break;
        }
        s[i] = *strP++;
    }

        // set up return info
    if (dec_ascii_to_ushort(s, irq_num) != 0)
        return (-1);

        // finished
    return (0);
}


SHORT get_param_dma_channels(CHAR *strP, USHORT *dma_channel)
//    This function gets the device type parameter.
//    The parameter 'strP' is a pointer to a null terminated string of ascii
// characters containing all the parameters to the driver. The dma channel
// is returned in the parameter 'dma_channel'.
//    The function returns the value -1 if an expected value was not found.
// Otherwise, the value 0 is returned.
{
    USHORT i;
    CHAR s[MAX_PARAM_LEN];

        // skip past the file path and name
    while (1) {
        if ((*strP == ' ') || (*strP == '\0'))
            break;

        strP++;
    }

        // search for parameter type indicator
    while (1) {
        if (*strP == '\0')
            return (-1);

        if ((*strP == 'D') && (*(strP + 1) == ':'))
            break;

        strP++;
    }

        // get parameter and null terminate
    strP += 2;
    i = 0;

    for (i = 0; i <= MAX_PARAM_LEN - 2; i++) {
        if ((*strP == ' ') || (*strP == '\0')) {
            s[i] = '\0';
            break;
        }
        s[i] = *strP++;
    }

        // set up return info
    if (dec_ascii_to_ushort(s, dma_channel) != 0)
        return (-1);

        // finished
    return (0);
}


SHORT get_param_driver_name(CHAR *strP, CHAR *driver_name)
//    This function gets the device driver name parameter.
//    The parameter 'strP' is a pointer to a null terminated string of ascii
// characters containing all the parameters to the driver. The driver name
// is returned in the parameter 'driver_name'.
//    The function returns the value -1 if an expected value was not found.
// Otherwise, the value 0 is returned.
{
    USHORT i;

        // skip past the file path and name
    while (1) {
        if ((*strP == ' ') || (*strP == '\0'))
            break;

        strP++;
    }

        // search for parameter type indicator
    while (1) {
        if (*strP == '\0')
            return (-1);

        if ((*strP == 'N') && (*(strP + 1) == ':'))
            break;

        strP++;
    }

        // get parameter and null terminate
    strP += 2;
    i = 0;

    for (i = 0; i <= MAX_PARAM_LEN - 2; i++) {
        if ((*strP == ' ') || (*strP == '\0')) {
            *driver_name = '\0';
            break;
        }
        *driver_name++ = *strP++;
    }

        // finished
    return (0);
}
