/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// header.c
//     This file contains device driver header information and routines.


    // include files
#include "types.h"
#include "header.h"


    // debug info
#ifdef DEBUG_FLAG
#define static /**/
#endif


    // constant definitions
#define DEV_ATTRIB 0xc880   // 1100 1000 1000 0000
                            // 15 = 1    character device
                            // 14 = 1    offset to idc entry point is set
                            // 13 = 0    for block device driver use only
                            // 12 = 0    not shared device
                            // 11 = 1    open / close is required
                            // 10 = 0    reserved
                            //  9 = 0    OS/2 device driver
                            //  8 = 0    no dosdevioctl2 support
                            //  7 = 1    no capabilities bit strip
                            //  6 = 0    reserved
                            //  5 = 0    reserved
                            //  4 = 0    reserved
                            //  3 = 0    not clock device
                            //  2 = 0    not null device
                            //  1 = 0    not stdout device
                            //  0 = 0    not stdin device

#define DEV_CAPS 0x00000000


   // external  variable declarations
extern strategy();                          /* end of data marker */
extern service_pdd_idc_request();


DEVHDR Dev_hdr = {(ULONG) 0xffff,                       /* link */
                  DEV_ATTRIB,                       /* attribute */
                  (USHORT) strategy,                /* offset to strategy routine */
                  (USHORT) service_pdd_idc_request, /* offset to idc routine */
                  "        ",                       /* device driver name */
                  "        ",                       /* reserved */
                  DEV_CAPS
};

    // private global variables
static CHAR oco_notice[8][40] = {
                              "Licensed Material - Property of IBM",
                              "                                   ",
                              "(C) Copyright IBM Corp. 1994,",
                              "All Rights Reserved.",
                              "U.S. Government Users Restricted Rights",
                              "- Use, duplication or disclosure",
                              "restricted by GSA ADP Schedule Contract",
                              "with IBM Corp."};


VOID set_driver_name(CHAR *nameP)
//    This function sets the device driver name in the header.
//    The parameter 'nameP' is a pointer to a null terminated string of ascii
// characters representing the name of the device driver.
//    The function does not return a value.

{
    USHORT i;

        // copy the name into the header
    for (i = 0; i <= DDNAME_BUFSIZE - 1; i++) {
        if (*nameP == '\0')
            Dev_hdr.name[i] = ' ';
        else
            Dev_hdr.name[i] = *nameP++;
    }

        // finished
    return;
}
