;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
; entry.asm
;    This file contains functions that support all the entry points into the
; driver.


.386p


    ; constant definitions
OPEN_PDD equ 0
QUERY_PROTOCOL equ 1
ASSIGN_HANDLE equ 2
ACQUIRE_DEVICE equ 3
RELEASE_DEVICE equ 4
GET_VDD_INFO equ 5
DEVICE_FREE equ 1


    ; external references
extrn _do_strat:near
extrn _do_stream_operation:near
extrn _clear_dev_interrupt:near
extrn _get_dev_irq_number:near
extrn _update_stream_times:near
extrn _update_timer:near
extrn _do_stream_command:near
extrn _vdd_acquire_device:near
extrn _vdd_release_device:near
extrn _vdd_get_info:near
extrn _virt_to_lin:near
extrn _eoi:near


_DATA SEGMENT WORD PUBLIC USE16 'DATA'
_DATA ENDS

_BSS SEGMENT WORD PUBLIC USE16 'BSS'
_BSS ENDS

CONST SEGMENT WORD PUBLIC USE16 'CONST'
CONST ENDS

_TEXT SEGMENT WORD PUBLIC USE16 'CODE'
_TEXT ENDS

DGROUP  GROUP   _DATA, CONST, _BSS
CGRP    GROUP   _TEXT


    ; private global variables
_DATA   SEGMENT
comm Vdd_entry: byte: 8
comm Vdd_handle: byte: 4
comm Vdd_info: byte: 16
Vdd_installed dw 00H
_DATA   ENDS


_TEXT   SEGMENT WORD PUBLIC USE16 'CODE'
        ASSUME cs:CGRP, ds:DGROUP, es:NOTHING, ss:NOTHING


; VOID far strategy(VOID)
;    This function is the device driver strategy routine and entry point into
; the device driver  for open, close, and ioctl requests.
;    The register pair es:bx contains the address of request information from
; the operating system.
;    The function does not return a value.

_strategy proc far
public _strategy

                ;save registers
            push    es
            push    bx

                ;do it
            call    _do_strat

                ;restore registers
            pop     bx
            pop     es

               ;done
            ret
_strategy endp


; VOID far service_hardware_interrupt(VOID)
;    This function serves as the entry point into the driver for hardware
; interrupts from the supported device.
;    The function does not have parameters.
;    The function does not return a value.

_service_hardware_interrupt proc far
public _service_hardware_interrupt

    ; save registers
        push   ds
        push   es
        push   eax
        push   edx
        push   ecx
        push   ebx
        push   esp
        push   ebp
        push   esi
        push   edi
        pushfd

    ; set up data segment
        mov    ax,DGROUP
        mov    ds,ax

    ; service stream activities
        call   _do_stream_operation; 

    ; clear the interrupt flag on the device
        call   _clear_dev_interrupt; 

    ; clear the interrupt flag on the pic
        call   _get_dev_irq_number
        cli
        push   ax
        call   _eoi
        add    sp,2
        sti

    ; restore registers
        popfd
        pop    edi
        pop    esi
        pop    ebp
        pop    esp
        pop    ebx
        pop    ecx
        pop    edx
        pop    eax
        pop    es
        pop    ds

    ; finished
        ret
_service_hardware_interrupt endp


; VOID far service_timer_interrupt(VOID)
;    This function serves as the entry point into the driver for hardware
; interrupts from the system timer.
;    The function does not have parameters.
;    The function does not return a value.

_service_timer_interrupt proc far
public _service_timer_interrupt

    ; save registers
        push   ds
        push   es
        push   eax
        push   edx
        push   ecx
        push   ebx
        push   esp
        push   ebp
        push   esi
        push   edi
        pushfd

    ; set up data segment
        mov    ax,DGROUP
        mov    ds,ax

    ; update streams related to the stream
        call _update_stream_times

    ; update other timer functions
        call _update_timer

    ; restore registers
        popfd
        pop    edi
        pop    esi
        pop    ebp
        pop    esp
        pop    ebx
        pop    ecx
        pop    edx
        pop    eax
        pop    es
        pop    ds

    ; finished
        ret
_service_timer_interrupt endp


; ULONG far service_pdd_idc_request(VOID *bufP)
;    This function serves as the entry point into the driver for idc calls
; from other pdd's.
;    The parameter 'bufP' is a pointer to information specific to each request.
;    The function return a value specific to the request in dx:ax.

_service_pdd_idc_request proc far
public _service_pdd_idc_request

BUFP_LOW equ <[bp+6]>
BUFP_HIGH equ <[bp+8]>

    ; point to parameters
        push   bp
        mov    bp,sp

    ; save registers
        push   ds
        push   es
        push   ecx
        push   ebx
        push   esp
        push   ebp
        push   esi
        push   edi
        pushfd

    ; set up data segment
        mov    ax,DGROUP
        mov    ds,ax

    ; ensure interrupts are enabled
        sti

    ; service the request
        push   word ptr BUFP_HIGH
        push   word ptr BUFP_LOW
        call   _do_stream_command
        add    sp,4

    ; restore registers
        popfd
        pop    edi
        pop    esi
        pop    ebp
        pop    esp
        pop    ebx
        pop    ecx
        pop    es
        pop    ds
        pop    bp

    ; return
        ret
_service_pdd_idc_request endp


; VOID far service_vdd_idc_request(VOID *bufP)
;    This function serves as the entry point into the driver for idc calls
; from vdd's.
;    The parameter 'bufP' is a pointer to information specific to each request.
;    The function returns a value specific to the request in dx:ax.

_service_vdd_idc_request proc far
public _service_vdd_idc_request
PARM2 equ <[bp+10]>
PARM1 equ <[bp+14]>
FUNC_CODE equ <[bp+18]>

    ; point to parameters 
        push   bp
        mov    bp,sp

    ; save registers
        push   ds
        push   es
        push   ecx
        push   edx
        push   ebx
        push   esp
        push   ebp
        push   esi
        push   edi
        pushfd

    ; set up data segment
        mov    ax,DGROUP
        mov    ds,ax

    ; set up flag to indicate that the vdd was installed and made this call
        mov    Vdd_installed,1

    ; get function code for this request
        mov    eax,FUNC_CODE

    ; vdd open - store entry point into virtual device driver
        cmp    eax,OPEN_PDD
        jne    next1

        mov    eax,dword ptr PARM1
        mov    edx,dword ptr PARM2
        mov    dword ptr Vdd_entry,edx
        mov    dword ptr Vdd_entry+4,eax
        mov    eax,1
        jmp    done1

    ; vdd query protocol
next1:  cmp    eax,QUERY_PROTOCOL
        jne    next2

        mov    eax,0501h
        jmp    done1

    ; vdd assign handle
next2:  cmp    eax,ASSIGN_HANDLE
        jne    next3

        mov    eax,dword ptr PARM1
        mov    dword ptr Vdd_handle,eax
        mov    eax,1
        jmp    done1

    ; vdd open device
next3:  cmp    eax,ACQUIRE_DEVICE
        jne    next4

        call   _vdd_acquire_device
        cmp    ax,0ffffh
        je     error1
        mov    eax,1
        jmp    done1
error1: mov    eax,0
        jmp    done1

    ; vdd close device
next4:  cmp    eax,RELEASE_DEVICE
        jne    next5

        call   _vdd_release_device
        mov    eax,1
        jmp    done1

    ; vdd get io port information
next5:  cmp    eax,GET_VDD_INFO
        jne    done1

        push   seg Vdd_info
        push   offset Vdd_info
        call   _vdd_get_info
        add    sp,4

        push   seg Vdd_info
        mov    ebx,offset Vdd_info
        push   ebx
        call   _virt_to_lin
        add    sp,6

        push   ax
        push   dx
        pop    eax

    ; restore registers
done1:  popfd
        pop    edi
        pop    esi
        pop    ebp
        pop    esp
        pop    ebx
        pop    edx
        pop    ecx
        pop    es
        pop    ds
        pop    bp

    ; do a 16:32 return while discarding parameters
        db     66h
        ret    12
_service_vdd_idc_request endp


; VOID vdd_report_device_free(VOID)
;    This function reports to the vdd that the device is no longer in use by
; the pdd.
;    The function does not have parameters.
;    The function does not return a value.

_vdd_report_device_free proc
public _vdd_report_device_free

    ; done if vdd is not installed
        cmp Vdd_installed,0
        je done

    ; set up parameters to vdd - function code - handle - dummy parameter
        mov    eax,DEVICE_FREE
        push   eax
        push   dword ptr Vdd_handle
        mov    eax,0
        push   eax

    ; call device help function
        db 66h
        call fword ptr [Vdd_entry]

    ; finished
done:   ret
_vdd_report_device_free endp


_TEXT   ENDS


END
