/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// echo.c
//    This file contains functions that interface with the ECHO personal
// sound system asic.


    // include files
#include "types.h"
#include "util.h"


    // constant definitions
#define MAX_NUM_IO_RANGES 5
#define PSS_ID_VERS   4
#define WSS_CONFIG_PORT 0x12
#define DSP_SIGNATURE 0x4500

    // type definitions
typedef struct {
    USHORT base_port;
    USHORT num_ports;
} IO_RANGE;


    // private global variables
static USHORT Echo_base_io_addr[] = {0x220, 0x240};
static USHORT Cur_base_io_addr_num;
static IO_RANGE Echo_io_range[MAX_NUM_IO_RANGES];
static USHORT Echo_num_io_ranges = 0;


USHORT get_dev_echo_num_io_ranges(VOID)
//    This function determines the number of i/o address ranges accessed by
// the ad1848 portion of the driver.
//    The function does not have parameters.
//    The function returns the number of ranges.
{
    return (Echo_num_io_ranges);
}


VOID get_dev_echo_io_range(USHORT range_num,
                                    USHORT *base_port, USHORT *num_ports)
//    This function gets a particular io range nad the number of ports in that
// range.
//    The parameter 'range_num' is the number of the range.
//    The function returns the first port address and the number of ports in
// range in the parameters 'base_port' and 'num_ports'.
{
    *base_port = Echo_io_range[range_num - 1].base_port;
    *num_ports = Echo_io_range[range_num - 1].num_ports;

    return;
}


BOOL dev_is_soundwave_32(VOID)
//    This function determines if a device is the Orchid Soundwave 32.
//    The function does not have parameters.
//    The fuction returns the value 'TRUE' if the device is found. Otherwise,
// the value 'FALSE' is found.
{
    USHORT i, reg_value;

        // look for dsp signature - return TRUE if match
    for (i = 0; i <= 1; i++) {
        reg_value = inportw(Echo_base_io_addr[i] + PSS_ID_VERS) & 0xff00;
        if (reg_value == DSP_SIGNATURE) {
            Cur_base_io_addr_num = i;
            Echo_io_range[Echo_num_io_ranges].base_port =
                                           Echo_base_io_addr[i];
            Echo_io_range[Echo_num_io_ranges].num_ports = 1;
            Echo_num_io_ranges++;
            return (TRUE);
        }
    }

        // device not found
    return (FALSE);
}


VOID enable_echo_asic(USHORT port)
//    This function enables the echo chip to WSS emulation mode.
//    The parameter is the base i/o address of the emulated device.
//    The function does not return a value.
{
        // configure the device
    outportw(Echo_base_io_addr[Cur_base_io_addr_num]
                                        + WSS_CONFIG_PORT, port << 4);

        // finished
    return;
}
