/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
// device.h
//    This file contains definitions  for shared constatnts and prototypes for
// public functions that originate in device.c.


    // constant definitions
#define DEV_LINE 0
#define DEV_AUX1 1
#define DEV_MICROPHONE 2
#define DEV_BOOSTED_MICROPHONE 3
#define DEV_POST_MIXED_DAC_OUTPUT 4

#define DEV_OPERATION_OFF 0
#define DEV_OPERATION_PLAY 1
#define DEV_OPERATION_RECORD 2

#define DEV_MS_SOUND 0
#define DEV_THINKPAD 1
#define DEV_COMPAQ 2
#define DEV_TOSHIBA_T4700CS 3
#define DEV_TOSHIBA_T6600C 4
#define DEV_REEL_MAGIC 5
#define DEV_SOUNDWAVE_32 6


    // prototypes for public functions
VOID clear_dev_data(USHORT);
SHORT dev_auto_detect_dev_type(SHORT *);
VOID set_dev_type(SHORT);
SHORT get_dev_type(VOID);
SHORT set_dev_irq_number(USHORT);
SHORT set_dev_base_io_addr(USHORT);
SHORT set_dev_dma_channels(USHORT);
SHORT init_dev_dsp(CHAR *);
SHORT init_device(VOID);
USHORT get_dev_buffer_size(VOID);
VOID set_dev_config_info(USHORT, SHORT, UCHAR, USHORT, UCHAR);
VOID set_dev_dma_info(USHORT, USHORT);
VOID stop_dev_operation(VOID);
VOID start_dev_record(SHORT);
VOID start_dev_play(VOID);
VOID set_dev_left_volume(ULONG);
VOID set_dev_right_volume(ULONG);
VOID set_dev_left_input_level(ULONG);
VOID set_dev_right_input_level(ULONG);
VOID send_dev_data(UCHAR *, USHORT);
VOID get_dev_data(UCHAR *, USHORT);
USHORT get_dev_num_bytes_produced(VOID);
USHORT get_dev_num_bytes_consumed(VOID);
VOID clear_dev_interrupt(VOID);
VOID set_dev_monitor(BOOL);
VOID set_dev_master_volume(USHORT);
ULONG get_dev_time(VOID);
USHORT get_dev_base_io_address(VOID);
USHORT get_dev_irq_number(VOID);
USHORT get_dev_dma_play_channel(VOID);
USHORT fifo_empty(VOID);
USHORT get_dev_ad1848_num_io_ranges(VOID);
VOID get_dev_ad1848_io_range(USHORT, USHORT *, USHORT *);
USHORT get_dev_echo_num_io_ranges(VOID);
VOID get_dev_echo_io_range(USHORT, USHORT *, USHORT *);
