;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
; devhlp.asm
;    This file contains routines that support device driver helper services
; from the operating system.


.386p


   ;constant definitions
REGISTERPDD equ 050h
SETTIMER equ 01dh
SETIRQ equ 01bh
UNSETIRQ equ 1ch
EOI equ 031h
RESETTIMER equ 1eh
ALLOCPHYS equ 018h
FREEPHYS equ 019h
ALLOCGDTSELECTOR equ 02dh
PHYSTOGDTSEL equ 054h
VMALLOC equ 57h
VIRTTOLIN equ 05bh
VMFREE equ 058h
LINTOGDTSELECTOR equ 05ch


_DATA SEGMENT WORD PUBLIC USE16 'DATA'
_DATA ENDS

_BSS SEGMENT WORD PUBLIC USE16 'BSS'
_BSS ENDS

CONST SEGMENT WORD PUBLIC USE16 'CONST'
CONST ENDS

_TEXT SEGMENT WORD PUBLIC USE16 'CODE'
_TEXT ENDS

DGROUP  GROUP   _DATA, CONST, _BSS
CGRP    GROUP   _TEXT


    PUBLIC _Device_help
_DATA   SEGMENT
_Device_help DW 2 DUP (0)
_DATA   ENDS


_TEXT   SEGMENT WORD PUBLIC USE16 'CODE'
        ASSUME cs:CGRP, ds:DGROUP, es:NOTHING, ss:NOTHING


; VOID devhlp_init(FFP_V_V funcP)
public _devhlp_init
_devhlp_init proc near
;    This function stores device helper services entry point.
;    The function receives the entry point address on the stack.
;    The function does not return a value.

DEVICE_HELP_LOW equ <[bp+4]>
DEVICE_HELP_HIGH equ <[bp+6]>

   ;point to parameters - save registers
        push    bp
        mov     bp,sp

   ;store the entry point
        mov     ax,word ptr DEVICE_HELP_LOW
        mov     dx,word ptr DEVICE_HELP_HIGH
        mov     word ptr _Device_help,ax
        mov     word ptr _Device_help+2,dx

   ;restore registers
        pop     bp

   ;done
        ret
_devhlp_init endp


; SHORT register_pdd(CHAR *pdd_nameP, FFP_V_V service_routineP)
public _register_pdd
_register_pdd proc near
;    This function registers a 16:16 physical device driver for pdd/vdd
; communications.
;    The function receives a pointer to the name of the device driver
; represented as a string of null terminated ascii characters and the
; address of the service routine on the stack.
;    The function returns the value 0 if successful. Otherwise, the function
; returns the value -1.

PDD_NAME_OFF equ <[bp+4]>
PDD_NAME_SEG equ <[bp+6]>
SERV_ROUTINE_OFF equ <[bp+8]>
SERV_ROUTINE_SEG equ <[bp+0ah]>
DEVICE_HELP_ADDR equ <[bp-4]>


    ; point to parameters and local variables
        push   bp
        mov    bp,sp

    ; set up local variables
        push _Device_help+2
        push _Device_help

    ; save registers
        push   di
        push   cx
        push   ds
        push   dx
        push   es

    ; set up pointer to ascii name for pdd in ds:si
        mov    ds,PDD_NAME_SEG
        mov    si,PDD_NAME_OFF

    ; set up pdd's communications function address in es:di
        mov    es,SERV_ROUTINE_SEG
        mov    di,SERV_ROUTINE_OFF

    ; set up code for device help function
        mov    dl,REGISTERPDD

    ; call device help function
        call   dword ptr DEVICE_HELP_ADDR
        mov    ax,0
        jnc    done1
        mov    ax,-1

   ;restore registers
done1:  pop    es
        pop    dx
        pop    ds
        pop    cx
        pop    di

        add    sp,4
        pop    bp

   ;done
        ret
_register_pdd endp


; SHORT set_sys_timer(USHORT service_routine_offset)
public _set_sys_timer
_set_sys_timer proc near
;    This function adds a timer handler to the list of timer handlers to be
; called on every timer tick.
;    The function receives the address of the service routine on the stack.
;    The function returns the value 0 if successful. Otherwise, the function
; returns the value -1.

SERV_ROUTINE_OFFSET equ <[bp+4]>

    ; point to parameters and local variables
        push   bp
        mov    bp,sp

    ; save registers
        push   dx

    ; set up pdd's function address offset in ax
        mov    ax,SERV_ROUTINE_OFFSET

    ; set up code for device help function
        mov    dl,SETTIMER

    ; call device help function
        call   dword ptr [_Device_help]
        mov    ax,0
        jnc    done2
        mov    ax,-1

   ;restore registers
done2:  pop    dx
        pop    bp

   ;done
        ret
_set_sys_timer endp


; SHORT reset_sys_timer(USHORT service_routine_offset)
public _reset_sys_timer
_reset_sys_timer proc near
;    This function removes a timer handler to the list of timer handlers to be
; called on every timer tick.
;    The function receives the address of the service routine on the stack.
;    The function returns the value 0 if successful. Otherwise, the function
; returns the value -1.

SERV_ROUTINE_OFFSET equ <[bp+4]>

    ; point to parameters and local variables
        push   bp
        mov    bp,sp

    ; save registers
        push   dx

    ; set up pdd's function address offset in ax
        mov    ax,SERV_ROUTINE_OFFSET

    ; set up code for device help function
        mov    dl,RESETTIMER

    ; call device help function
        call   dword ptr [_Device_help]
        mov    ax,0
        jnc    done3
        mov    ax,-1

   ;restore registers
done3:  pop    dx
        pop    bp

   ;done
        ret
_reset_sys_timer endp


; SHORT set_irq(USHORT service_routine_offset, USHORT irq_num)
public _set_irq
_set_irq proc near
;    This function installs an interrupt handler for a specific IRQ number.
;    The function receives the address of the service routine and the irq
; number on the stack.
;    The function returns the value 0 if successful. Otherwise, the function
; returns the value -1.

SERV_ROUTINE_OFFSET equ <[bp+4]>
IRQ_NUM equ <[bp+6]>

    ; point to parameters and local variables
        push   bp
        mov    bp,sp

    ; save registers
        push   dx
        push   bx

    ; set up pdd's function address offset in ax
        mov    ax,SERV_ROUTINE_OFFSET

    ; set up interrupt level number'
        mov    bx,IRQ_NUM

    ; indicate interrupt not shared
        mov    dh,0

    ; set up code for device help function
        mov    dl,SETIRQ

    ; call device help function
        call   dword ptr [_Device_help]
        mov    ax,0
        jnc    done4
        mov    ax,-1

   ;restore registers
done4:  pop    bx
        pop    dx
        pop    bp

   ;done
        ret
_set_irq endp


; SHORT unset_irq(USHORT irq_num)
public _unset_irq
_unset_irq proc near
;    This function removes an interrupt handler for a specific IRQ number.
;    The function receives the irq number on the stack.
;    The function returns the value 0 if successful. Otherwise, the function
; returns the value -1.

IRQ_NUM equ <[bp+4]>

    ; point to parameters and local variables
        push   bp
        mov    bp,sp

    ; save registers
        push   dx
        push   bx

    ; set up interrupt level number'
        mov    bx,IRQ_NUM

    ; set up code for device help function
        mov    dl,UNSETIRQ

    ; call device help function
        call   dword ptr [_Device_help]
        mov    ax,0
        jnc    done5
        mov    ax,-1

   ;restore registers
done5:  pop    bx
        pop    dx
        pop    bp

   ;done
        ret
_unset_irq endp


; VOID eoi(USHORT irq_num)
public _eoi
_eoi proc near
;    This function is used to issue an end-of-interrupt to the master / slave
; interrupt controller as appropriate to the interrupt level.
;    The function recieves the irq number on the stack.
;    The function does not return a value.

IRQ_NUM equ <[bp+4]>


    ; point to parameters and local variables
        push   bp
        mov    bp,sp

    ; save registers
        push   dx

    ; set up interrupt level
        mov    al,IRQ_NUM

    ; set up code for device help function
        mov    dl,EOI

    ; call device help function
        call   dword ptr [_Device_help]
        mov    ax,0
        jnc    done6
        mov    ax,-1

   ;restore registers
done6 : pop    dx
        pop    bp

   ;done
        ret
_eoi endp


;ULONG alloc_phys(ULONG size)
public _alloc_phys
_alloc_phys proc near
;    This function allocates a block of physical memory.
;    The function recieves the size of the memory to allocate in bytes.
;    The function returns the address of the memory if successful. Otherwise,
; the value 0 is returned.

SIZE_LOW equ <[bp+4]>
SIZE_HIGH equ <[bp+6]>

    ; point to parameters and local variables
        push   bp
        mov    bp,sp

    ; save registers
        push   bx

    ; set size in bytes of object to be allocated
        mov    bx,SIZE_LOW
        mov    ax,SIZE_HIGH

    ; set position above 1MB
        mov    dh,0

    ; set up code for device help function
        mov    dl,ALLOCPHYS

    ; call device help function
        call   dword ptr [_Device_help]
        jc     err8
        mov    dx,ax
        mov    ax,bx
        jmp    done9

    ; unsuccessful - try again
    ; set size in bytes of object to be allocated
err8:   mov    bx,SIZE_LOW
        mov    ax,SIZE_HIGH

    ; set position below 1MB
        mov    dh,1

    ; set up code for device help function
        mov    dl,ALLOCPHYS

    ; call device help function
        call   dword ptr [_Device_help]
        jc     err9
        mov    dx,ax
        mov    ax,bx
        jmp    done9

err9:   mov    ax,0
        mov    dx,0

   ;set up return value and restore registers
done9:  pop    bx
        pop    bp

   ;done
        ret
_alloc_phys endp


;VOID free_phys(ULONG phys_addr)
public _free_phys
_free_phys proc near
;    This function frees a block of physical memory.
;    The function receives the address of the memory on the stack.
;    The function does not return a value.

ADDR_LOW equ <[bp+4]>
ADDR_HIGH equ <[bp+6]>


    ; point to parameters and local variables
        push   bp
        mov    bp,sp

    ; save registers
        push   bx

    ; set up address of memory to free
        mov    bx,ADDR_LOW
        mov    ax,ADDR_HIGH

    ; set up code for device help function
        mov    dl,FREEPHYS

    ; call device help function
        call   dword ptr [_Device_help]

    ; restore registers
        pop    bx
        pop    bp

   ;done
        ret
_free_phys endp


; SHORT alloc_gdt_selector(ULONG selector[], USHORT num)
public _alloc_gdt_selector
_alloc_gdt_selector proc near
;    This function allocates an array of global data table selectors.
;    The function receives the address of the array and the number of
; selectors to allocate on the stack.
;    The function returns the value 0 if successful. Otherwise, the value -1
; is returned.

SEL_LOW equ <[bp+4]>
SEL_HIGH equ <[bp+6]>
NUM equ <[bp+8]>

    ; point to parameters and local variables
        push   bp
        mov    bp,sp

    ; save registers
        push   bx
        push   cx
        push   es
        push   di

    ; set size in bytes of object to be allocated
        mov    es,SEL_HIGH
        mov    di,SEL_LOW

    ; set up number of selectors requested
        mov    cx,NUM

    ; set up code for device help function
        mov    dl,ALLOCGDTSELECTOR

    ; call device help function
        call   dword ptr [_Device_help]
        jc     err11

    ; set up return value
        mov    ax,0

        jmp    done11

err11:  mov    ax,-1

   ;set up return value and restore registers
done11: pop    di
        pop    es
        pop    cx
        pop    bx
        pop    bp

   ;done
        ret
_alloc_gdt_selector endp


;SHORT phys_to_gdt_sel(ULONG phys_addr, USHORT selector, ULONG length)
public _phys_to_gdt_sel
_phys_to_gdt_sel proc near
;    This function maps a global data table selector to the address of a block
; of physical memory.
;    The function receives the address of the physical memory, the selector,
; and the size of the block of memory in bytes on the stack.

ADDR1 equ <[bp+4]>
SELECTOR1 equ <[bp+8]>
LEN1 equ <[bp+0ah]>

    ; point to parameters and local variables
        push   bp
        mov    bp,sp

    ; save registers
        push   ecx
        push   si

    ; set address
        mov    eax,ADDR1

    ; set up length
        mov    ecx,LEN1

    ; set up selector number
        mov    si,SELECTOR1

    ; set up access
        mov    dh,06h

    ; set up code for device help function
        mov    dl,PHYSTOGDTSEL

    ; call device help function
        call   dword ptr [_Device_help]
        jc     err16

    ; set up return value
        mov    ax,0

        jmp    done16

err16:  mov    ax,-1

   ;set up return value and restore registers
done16: pop    si
        pop    ecx
        pop    bp

   ;done
        ret
_phys_to_gdt_sel endp


;ULONG vm_alloc(ULONG size)
public _vm_alloc
_vm_alloc proc near
;    This function allocates a block of physical memory.
;    The function receives the size of the memory to allocate in bytes on the
; stack.
;    The function returns the address of the memory if successful. Otherwise,
; the value 0 is returned.

OBJSIZE equ <[bp+4]>

    ; point to parameters and local variables
        push   bp
        mov    bp,sp

    ; save registers
        push   edi
        push   ecx

    ; set size in bytes of object to be allocated
        mov    ecx,OBJSIZE

    ; indicate that no physical address is provided
        mov    edi,0ffffffffh

    ; set flags for allocation request
    ;     bit 0 - 1 - allocate memory below 16mb line
    ;     bit 1 - 1 - fix in memory at all times
    ;     bit 2 - 0 - memory can not be swapped
    ;     bit 3 - 1 - allocate object in contiguous memory
    ;     bit 4 - 0 - no physical address is passed
    ;     bit 5 - 0 - allocate in the global address range
    ;     bit 6 - 0 - memory can not be registered under screen group control
    ;     bit 7 - 0 - reserved
    ;     bit 8 - 0 - commit memory - no page alignment
    ;     bit 9 - 15 - 0000000
    ;     0000 0000 0000 1011 = 000bh
        mov    eax,000bh

    ; set up code for device help function
        mov    dl,VMALLOC

    ; call device help function
        call   dword ptr [_Device_help]
        jc     err17

    ; set up return value
        push   eax
        pop    ax
        pop    dx
        jmp    done17

err17:  mov    ax,0
        mov    dx,0

   ;restore registers
done17: pop    ecx
        pop    edi
        pop    bp

   ;done
        ret
_vm_alloc endp


;ULONG virt_to_lin(USHORT selector, ULONG offset)
public _virt_to_lin
_virt_to_lin proc near
;    This function converts a virtual address to a linear address.
;    The function receives the selector and the offset of the address on the
; stack.
;    The function returns the linear address.

OFF equ <[bp+4]>
SEL equ <[bp+8]>

    ; point to parameters and local variables
        push   bp
        mov    bp,sp

    ; save registers
        push   esi

    ; set up address
        mov    esi,OFF
        mov    ax,SEL

    ; set up code for device help function
        mov    dl,VIRTTOLIN

    ; call device help function
        call   dword ptr [_Device_help]
        jnc    next18

    ; error
        mov    ax,0
        mov    dx,0
        jmp    done18

    ; set up return value
next18: push   eax
        pop    dx
        pop    ax

    ; restore registers
done18: pop    esi
        pop    bp

   ;done
        ret
_virt_to_lin endp


;VOID vm_free(ULONG linear_addr)
public _vm_free
_vm_free proc near
;    This function frees a block of virtual memory.
;    The function receives the address of the memory on the stack.
;    The function does not return a value.

ADDR20 equ <[bp+4]>


    ; point to parameters and local variables
        push   bp
        mov    bp,sp

    ; set up address of memory to free
        mov    eax,ADDR20

    ; set up code for device help function
        mov    dl,VMFREE

    ; call device help function
        call   dword ptr [_Device_help]

    ; restore registers
        pop    bp

   ;done
        ret
_vm_free endp


;SHORT lin_to_gdt_selector(ULONG lin_addr, USHORT selector, ULONG size)
public _lin_to_gdt_selector
_lin_to_gdt_selector proc near
;    This function maps a linear address to a global data table selector.
;    The function receives the linear address, the number of the selector, and
; the size of the memory block in bytes on the stack.
;    The function returns the value 0 if successful. Otherwise, the value -1 is
; returned.

ADDR21 equ <[bp+4]>
SELECTOR21 equ <[bp+8]>
SIZE21 equ <[bp+0ah]>

    ; point to parameters and local variables
        push   bp
        mov    bp,sp

    ; save registers
        push   ebx
        push   ecx

    ; set up selector
        mov    ax,SELECTOR21

    ; set up linear address
        mov    ebx,ADDR21

    ; set up size to be mapped
        mov    ecx,SIZE21

    ; set up code for device help function
        mov    dl,LINTOGDTSELECTOR

    ; call device help function
        call   dword ptr [_Device_help]
        jc     err21

    ; set up return value
        mov    ax,0

        jmp    done21

err21:  mov    ax,-1

   ; restore registers
done21: pop    ecx
        pop    ebx
        pop    bp

   ;done
        ret


_lin_to_gdt_selector endp



_TEXT ENDS

END
