;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
STREAM_INSTANCE       STRUC
SI_pNext_SI           DD   ?  ; Pointer to next Stream Instance Structure
SI_hStream            DD   ?  ; Stream Handle from SH'
SI_ulImgSize          DD   ?  ; Size of one Image with it's header
SI_ulFPS              DD   ?  ; Frames Per Second

SI_ulFPSFlags         DD   ?  ; Flags for FPS (Frames or MicroSeconds)
SI_ulTime             DD   ?  ; 
SI_Unused6            DD   ?  ; 
SI_Unused7            DW   ?  ; 
SI_Unused1            DB   ?  ; 
SI_Stopping           DB   ?  ; Stop Stream is Pending

SI_ulSTime            DD   ?  ; Time in millisecond when the start was issued from the SH
SI_ulCTime            DD   ?  ; Time in millisecond when the last image was captured for the SH
SI_ulFrames           DD   ?  ; Number of Frames captured for the SH
SI_ulSkipped          DD   ?  ; Total number of Frames skipped

SI_ulMissing          DD   ?  ; Frames skipped/missing since last read
SI_ulOverrun          DD   ?  ; Total Number of Overruns
SI_ulUnderRun         DD   ?  ; Total Number of Underruns
SI_ulUnused2          DD   ?  ; unused

SI_pCur_Img_Buff      DD   ?  ; Current SH buffer in use
SI_pCur_Img_Free      DD   ?  ; Address of current free area in Current Buffer
SI_ulCur_Img_Len      DD   ?  ; Bytes Still available in this buffer
SI_ulCur_Img_Size     DD   ?  ; Size of SH Buffer

SI_ulCur_Remain       DW   ?  ; Sum Remainder on each Interrupt (prevents rounding error)
SI_ulOrg_Remain       DW   ?  ; Orgininal Remiander from 1000/Frame Rate
SI_ulDivisor          DW   ?  ; Original Divisor (Frame Rate)
SI_unused8            DW   ?  ; unused
SI_unused4            DD   ?  ; unused
SI_ScaleFactor        DD   ?  ; 

SI_X_Left             DD   ?  ; Image Size and Position info
SI_Y_Top              DD   ?  ; 
SI_Y_Height           DD   ?  ; 
SI_X_Width            DD   ?  ; 

SI_DX_Left            DD   ?  ; Image Destination Size and Position info
SI_DY_Top             DD   ?  ; 
SI_DY_Height          DD   ?  ; 
SI_DX_Width           DD   ?  ; 

SI_pFree_img_buffs    DD   ?  ; Free Image Buffer List (First Buffer)
SI_pFree_img_Tail     DD   ?  ; Free Image Buffer List (Last  Buffer)
SI_pEventQ            DD   ?  ; List of Queued Events
SI_pEventQ_Free       DD   ?  ; List of Free Event Queue Elements

SI_ulSysFileNum       DD   ?  ; Device Handle so pdd can map device instance to hstream
SI_pSHDEntryPoint     DD   ?  ; Stream handler entry point
SI_ulStreamOperation  DD   ?  ; SH input Record or play
SI_ulSHTime           DD   ?  ; SH input Stream Time from Setup

SI_ulSTime_Base       DD   ?  ; Input base Stream time from hardware
SI_ulTime_Delta       DD   ?  ; Difference between System Time - SH time
SI_ulTic_Delta        DD   ?  ; Time Between Image Captures
SI_ulPause_Time       DD   ?  ; Time Stream was Paused

SI_ulResume_Time      DD   ?  ; Time the Stream was Resumed
SI_ulResume_Tic_Delta DD   ?  ; Time to next capture on next resume
SI_T_Paused           DB   ?  ; State 1=Pause Time active, 0=Pause Time !active
                      DB   ?
                      DW   ?
                      DD   ?
STREAM_INSTANCE       ENDS

STREAM_IMAGE_FREE_BUFF_HDR    STRUC
SIFBH_Next             DD  ?  ; Next Free Buffer Pointer
SIFBH_Len              DD  ?  ; Length of this buffer
SIFBH_reserved2        DD  ?  ; unused
STREAM_IMAGE_FREE_BUFF_HDR    ENDS

STREAM_INSTANCE_EVENT  STRUC
SIE_Next               DD  ?  ; Next Stream Event
SIE_NTime              DD  ?  ; Time for next notify to occur
SIE_Time               DD  ?  ; Time between Events
SIE_hEvent             DD  ?  ; Handle for the Event
SIE_reserved1          DD  ?  ; unused
STREAM_INSTANCE_EVENT  ENDS

SIE_Num_Events         EQU 30 ; Allow a maximum of N different Events per Stream Instance
