/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/* ͻ */
/*                                                                          */
/* ======================================================================== */
/*                                                                          */
/*                                                                          */
/*        Date : 06/04/91                                                   */
/*                                                                          */
/*       System: IBM OS/2 Ver. 2.0                                          */
/*     Language:                                                            */
/*                                                                          */
/*      Purpose: Performance Trace Hook Definition File                     */
/*                                                                          */
/*                                                                          */
/*  Description: PTrace is a tool developed by the MME Performance Group    */
/*               to aid in the analysis and evaluation of MME performance.  */
/*               These hook assignments are maintained by the MME perfor-   */
/*               mance group.  If additional hook assignments are desired,  */
/*               contact Denise Morien at extension 2-8130 or VM ID         */
/*               DENNIE on BCRVMPC1.                                        */
/*                                                                          */
/*                                                                          */
/*  Change Activity:                                                        */
/*                                                                          */
/*   DATE        Programmer                  Reason / Comments              */
/*  --------  -------------------  ---------------------------------------  */
/*                                                                          */
/*  06/04/91  KCK                  Creation                                 */
/*  06/07/91  DRM                  Added MMIO hooks for Marcello (6D/36-48) */
/*                                 Added FSSH hooks for Marcello (6E/01-10) */
/*  06/23/91  DRM                  Added SSM  hooks for Keith    (6D/01-15) */
/*                                 Added ADSH hooks for Keith    (6E/20-24) */
/*  07/22/91  KCK                  Added MDM  hooks for Brad     (6F/01-02) */
/*  08/05/91  DRM                  Added MMIO hooks for Marcello (6D/49-56) */
/*                                                                          */
/*  08/07/91  MRL                  Added CDSH hooks (6E/40-42)              */
/*                                 Updated FSSH hooks ( now only 6E/10-11 ) */
/*                                 Added SHCOMMON hook section for routed   */
/*                                 Stream Handler functions, and support    */
/*                                 funcs.  SHCOMMON_xxxx ( 6E/01-0C )       */
/*                                 Modified hook numbering scheme for most  */
/*                                 components so assignment is more readily */
/*                                 reconfigurable.                          */
/*                                                                          */
/*  08/07/91  MRL                  THE MAJOR RE-ORG !!!                     */
/*                                 Now All components are enabled for       */
/*                                 remapping minor codes as required.       */
/*                                 Addition of hook codes to support the    */
/*                                 common routed SH function table in       */
/*                                 SSM.H.  Reorganized the major code       */
/*                                 layout.  The numbers have changed, but   */
/*                                 the names have stayed the same to        */
/*                                 convict the guilty.  Anyone who stuck    */
/*                                 to using the macros names should have    */
/*                                 NO problems, anyone who didn't will      */
/*                                 have to stay after school.  Several      */
/*                                 SHCOMMON hooks remain to service those   */
/*                                 functions that exist in ALL SH's.        */
/*                                                                          */
/*                                                                          */
/*  01/13/91  MRL                  Added an additional hook to MMIO         */
/*                                 to support the file identification API,  */
/*                                 and added hooks to support the 5 basic   */
/*                                 IOProc commands for the MIDIIO handler.  */
/*                                                                          */
/*  02/10/92  Bill Lawton          Added for hooks for SSM.                 */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/* ͼ */
/*                                                                            */
/*                                                                            */
/* The hook concept implies that a specific point in the software may be      */
/* assigned a 16 bit code that uniquely identifies that point for performance */
/* and/or path analysis.  The 16 bit code assigned is further subdivided into */
/* two 8 bit codes, referred to as the MAJOR and MINOR code.  The MAJOR code  */
/* allows identification of that code segment usually by function, and the    */
/* minor code allows identification of a point within that code segment       */
/* usually by code purpose, subroutine, or procedure.                         */
/*                                                                            */
/* The major codes currently assigned to MME are 0x6D through 0x6F and are to */
/* be allocated as follows -                                                  */
/*              0x6D -> Sync/Stream Manager and MMIO                          */
/*              0x6E -> Stream Handlers                                       */
/*              0x6F -> MDM and MCDs                                          */
/*                                                                            */
/* UPDATE: 08/07/91  The NEW ordering for major codes is as follows:          */
/*              0x6D -> Sync/Stream Manager, CSSH, FSSH, ADSH, MISH           */
/*              0x6E -> MDM, SHCOMMON functions, and MCD's                    */
/*              0x6F -> MMIO and MSH                                          */
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* Minor codes are defined below.                                             */
/*                                                                            */
/* NOTE: 8/7/91  ( Marcelo R. Lopez, Jr. ) CREATION of SHCOMMON,              */
/*                                         and it's subsequent removal        */
/*                                                                            */
/* !!!!  Much of the Stream Handler code is being written to remain generic   */
/* READ  and therefore simply linkable into any given xxSH DLL.  Since calls  */
/*       to the Stream handler internal functions are routed by the SSM to the*/
/*  ==>  appropriate SH before the SH routes the request to the appropriate   */
/*  ==>  function within the DLL, and since the SSM can extract the identity  */
/*       of the internally requested function from it's parameter block, this */
/*       little fact, hereafter after referred to as a "NEAT TRICK", will be  */
/* THIS  employed to take advantage of the fact that hooks will only be       */
/* !!!!  required ( for tracking routing of requests ) within SSM in it's     */
/*       routine ( in SSMSRV.C ).  Thus hooks for Stream Handlers will only   */
/*       required for timing INTERNAL functions, if necessary.  Thus having   */
/*       less hook macros scattered about the code to have to maintain.       */
/*       Anyone who takes over responsibility of this module MUST ENSURE      */
/*       that the first 16 hooks within the SSM COMPONENT.  Some SHCOMMON     */
/*       codes will remain given that they are truly specific to SH's and     */
/*       and do not pertain to the SSM at all.                                */
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*                                                                            */
/******************************************************************************/


/*                                                                            */
/* ͻ */
/*                                                                          */
/*  SSM  - Sync/Stream Manager                         Major Code - 0x6D    */
/*                                                                          */
/* ͼ */
/* -------------------------------------------------------------------------- */
/*  These defines are for use with the PTRACE facilities for performance      */
/*  evaluation of the SSM (PDD and DLL).                                      */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */

#define SSM_MAJOR               0x6D

/* -------------------------------------------------------------------------- */
/*  Minor code definitions                                                    */
/*  The range of minor codes reserved for the SSM are                         */
/*              0x01 -> 0x4F    == Start Hooks                                */
/*              0x81 -> 0xAF    == Stop Hooks                                 */
/* -------------------------------------------------------------------------- */



#define SSM_MINORBASE           0x01

/* ͻ */
/*                                                                          */
/*  NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE !   */
/*                                                                          */
/*                                                                          */
/*  Marcelo R. Lopez, Jr.                                                   */
/*                                                                          */
/*  As of 8/7/91, the first 16 hooks for SSM will be the Stream Handler     */
/*  routed SHC functions.  These entries will reflect the table that        */
/*  exists in SSM.H.  IN THE EVENT, that ANYONE modifies SSM.H these first  */
/*  entries MUST be updated to reflect any modification to the table as it  */
/*  will DIRECTLY affect the hooks which are generated with respect to      */
/*  what function is being dispatched in the Stream Handler being called !  */
/*                                                                          */
/*  You MUST maintain certainty that if you modify this table you do so at  */
/*  GREAT PERIL, not just to yourself, but to all components within OS/2    */
/*  MME.  This warning is placed here in the hopes that the naive few of    */
/*  you who see this ( in the future ) and have the silly notion of messing */
/*  with it, WILL THINK not twice, BUT THRICE before making a big mistake.  */
/*                                                                          */
/*  Don't be fooled by imitations, this IS the ordering, anyone who hasn't  */
/*  contacted Jose Martinez, Jr.(HOSE at BCRVMPC1), and believes themselves */
/*  endowed with the unalienable right to modify the table, think again,    */
/*  as Mr. Martinez will certainly explain your folly to you.               */
/*                                                                          */
/*  Now, Be Excellent to one another.                                       */
/*                                                                          */
/*                                                                          */
/*  NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE !   */
/*                                                                          */
/* ͼ */


#define SSM_MINORBASE           0x01


/* SSMSRV.C */
#define SSM_EntryShcAssociate   ( 0x01 )
#define SSM_ExitShcAssociate    ( SSM_EntryShcAssociate | (BYTE)0x80 )

#define SSM_EntryShcClose       ( 0x02 )
#define SSM_ExitShcClose        ( SSM_EntryShcClose | (BYTE)0x80 )

#define SSM_EntryShcCreate      ( 0x03 )
#define SSM_ExitShcCreate       ( SSM_EntryShcCreate | (BYTE)0x80 )

#define SSM_EntryShcDestroy     ( 0x04 )
#define SSM_ExitShcDestroy      ( SSM_EntryShcDestroy | (BYTE)0x80 )

#define SSM_EntryShcStart       ( 0x05 )
#define SSM_ExitShcStart        ( SSM_EntryShcStart | (BYTE)0x80 )

#define SSM_EntryShcStop        ( 0x06 )
#define SSM_ExitShcStop         ( SSM_EntryShcStop | (BYTE)0x80 )

#define SSM_EntryShcSeek        ( 0x07 )
#define SSM_ExitShcSeek         ( SSM_EntryShcSeek | (BYTE)0x80 )

#define SSM_EntryShcEnableEvt   ( 0x08 )
#define SSM_ExitShcEnableEvt    ( SSM_EntryShcEnableEvt | (BYTE)0x80 )

#define SSM_EntryShcDisableEvt  ( 0x09 )
#define SSM_ExitShcDisableEvt   ( SSM_EntryShcDisableEvt | (BYTE)0x80 )

#define SSM_EntryShcEnableSync  ( 0x0A )
#define SSM_ExitShcEnableSync   ( SSM_EntryShcEnableSync | (BYTE)0x80 )

#define SSM_EntryShcDisableSync ( 0x0B )
#define SSM_ExitShcDisableSync  ( SSM_EntryShcDisableSync | (BYTE)0x80 )

#define SSM_EntryShcGetTime     ( 0x0C )
#define SSM_ExitShcGetTime      ( SSM_EntryShcGetTime | (BYTE)0x80 )

#define SSM_EntryShcGetPrtcl    ( 0x0D )
#define SSM_ExitShcGetPrtcl     ( SSM_EntryShcGetPrtcl | (BYTE)0x80 )

#define SSM_EntryShcInstPrtcl   ( 0x0E )
#define SSM_ExitShcInstPrtcl    ( SSM_EntryShcInstPrtcl | (BYTE)0x80 )

#define SSM_EntryShcEnumPrtcl   ( 0x0F )
#define SSM_ExitShcEnumPrtcl    ( SSM_EntryShcEnumPrtcl | (BYTE)0x80 )

#define SSM_EntryShcNegotReslt  ( 0x10 )
#define SSM_ExitShcNegotReslt   ( SSM_EntryShcNegotReslt | (BYTE)0x80 )

#define SSM_EntryShcSendMsg     ( 0x11 )
#define SSM_ExitShcSendMsg      ( SSM_EntryShcSendMsg | (BYTE)0x80 )


/******************************************************************************/
/* ͻ */
/*                                                                          */
/*  NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE !   */
/*                                                                          */
/*  NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE !   */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*  DID YOU READ THE NOTE ABOVE ??????????                                  */
/*                                                                          */
/*  IF YOU HAVEN'T, PLEASE DO SO !!!!!!!!!                                  */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*  NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE !   */
/*                                                                          */
/*  NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE ! NOTE !   */
/*                                                                          */
/* ͼ */
/******************************************************************************/

//
//
//
/* Ring 0 hooks */
//
//
//

//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//
// There is ONLY an allowance for 15 Ring 0 hook, please note this when
// assigning these hooks.
//
// NOTE ALSO !!  Changing SSM_R0MINORBASE modifies where the Ring 0 hooks
//               are mapped.
//
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!



// 20
//
#define SSM_R0MINORBASE         ( SSM_MINORBASE + 19 )

//
// Hook Definitions
//

/* SSMDD.ASM */
#define SSM_ProcRun_Entry       ( 0x14 )
#define SSM_ProcRun_Exit        ( SSM_ProcRun_Entry  | (BYTE)0x80 )

#define SSM_ProcBlock_Entry     ( 0x15 )
#define SSM_ProcBlock_Exit      ( SSM_ProcBlock_Entry | (BYTE)0x80 )

#define SSM_IoctlEntry          ( 0x16 )
#define SSM_IoctlExit           ( SSM_IoctlEntry | (BYTE)0x80 )

#define SSM_IDCCallToSHC        ( 0x17 )
#define SSM_IDCRetFromSHC       ( SSM_IDCCallToSHC | (BYTE)0x80 )

#define SSM_IDCNotifyEntry      ( 0x18 )
#define SSM_IDCNotifyExit       ( SSM_IDCNotifyEntry | (BYTE)0x80 )

#define SSM_IDCDeRegEntry       ( 0x19 )
#define SSM_IDCDeRegExit        ( SSM_IDCDeRegEntry | (BYTE)0x80 )

#define SSM_IDCRptEvtEntry      ( 0x1A )
#define SSM_IDCRptEvtExit       ( SSM_IDCRptEvtEntry | (BYTE)0x80 )


/* SSMNOTIC.C */
#define GET_EMPTY_Entry         ( 0x1B )
#define GET_EMPTY_Exit          ( GET_EMPTY_Entry | (BYTE)0x80 )

#define GET_FULL_Entry          ( 0x1C )
#define GET_FULL_Exit           ( GET_FULL_Entry | (BYTE)0x80 )

#define RET_EMPTY_Entry         ( 0x1D )
#define RET_EMPTY_Exit          ( RET_EMPTY_Entry | (BYTE)0x80 )

#define RET_FULL_Entry          ( 0x1E )
#define RET_FULL_Exit           ( RET_FULL_Entry | (BYTE)0x80 )

#define BUF_Record_Entry        ( 0x1F )
#define BUF_Record_Exit         ( BUF_Record_Entry | (BYTE)0x80 )



/* SSMEVDDC.C */
#define SMH_ReportEvent0        ( 0x20 )
#define SSM_Negotiate_error     ( SMH_ReportEvent0 | (BYTE)0x80 )

//
//
//
/* Ring 3 hooks */
//
//
// 35

#define SSM_R3MINORBASE         ( 0x23 )

//
// Hook definitions
//


/* SSMAPI.C */
#define SSM_SMH3Entry           ( 0x23 )
#define SSM_SMH3Exit            ( SSM_SMH3Entry | (BYTE)0x80 )

#define SSM_SMHRegisterEntry    ( 0x24 )
#define SSM_SMHRegisterExit     ( SSM_SMHRegisterEntry | (BYTE)0x80 )

#define SSM_SMHReportEvntEntry  ( 0x25 )
#define SSM_SMHReportEvntExit   ( SSM_SMHReportEvntEntry | (BYTE)0x80 )

#define SSM_SMHNotifyEntry      ( 0x26 )
#define SSM_SMHNotifyExit       ( SSM_SMHNotifyEntry | (BYTE)0x80 )

#define SSM_SMHDeRegisterEntry  ( 0x27 )
#define SSM_SMHDeRegisterExit   ( SSM_SMHDeRegisterEntry | (BYTE)0x80 )

#define SSM_SMHLockMemEntry     ( 0x28 )
#define SSM_SMHLockMemExit      ( SSM_SMHLockMemEntry | (BYTE)0x80 )

#define SSM_SpiAssociateEntry   ( 0x29 )
#define SSM_SpiAssociateExit    ( SSM_SpiAssociateEntry | (BYTE)0x80 )

#define SSM_SpiCreateEntry      ( 0x2A )
#define SSM_SpiCreateExit       ( SSM_SpiCreateEntry | (BYTE)0x80 )

#define SSM_SpiDestroyEntry     ( 0x2B )
#define SSM_SpiDestroyExit      ( SSM_SpiDestroyEntry | (BYTE)0x80 )

#define SSM_SpiEnumProtoEntry   ( 0x2C )
#define SSM_SpiEnumProtoExit    ( SSM_SpiEnumProtoEntry | (BYTE)0x80 )

#define SSM_SpiEnumHndlrEntry   ( 0x2D )
#define SSM_SpiEnumHndlrExit    ( SSM_SpiEnumHndlrEntry | (BYTE)0x80 )

#define SSM_SpiGetHndlrEntry    ( 0x2E )
#define SSM_SpiGetHndlrExit     ( SSM_SpiGetHndlrEntry | (BYTE)0x80 )

#define SSM_SpiGetProtoEntry    ( 0x2F )
#define SSM_SpiGetProtoExit     ( SSM_SpiGetProtoEntry | (BYTE)0x80 )

#define SSM_SpiGetTimeEntry     ( 0x30 )
#define SSM_SpiGetTimeExit      ( SSM_SpiGetTimeEntry | (BYTE)0x80 )

#define SSM_SpiInstProtoEntry   ( 0x31 )
#define SSM_SpiInstProtoExit    ( SSM_SpiInstProtoEntry | (BYTE)0x80 )

#define SSM_SpiSeekStrmEntry    ( 0x32 )
#define SSM_SpiSeekStrmExit     ( SSM_SpiSeekStrmEntry | (BYTE)0x80 )

#define SSM_SpiStartStrmEntry   ( 0x33 )
#define SSM_SpiStartStrmExit    ( SSM_SpiStartStrmEntry | (BYTE)0x80 )

#define SSM_SpiStopStrmEntry    ( 0x34 )
#define SSM_SpiStopStrmExit     ( SSM_SpiStopStrmEntry | (BYTE)0x80 )

#define SSM_SpiEnEventEntry     ( 0x35 )
#define SSM_SpiEnEventExit      ( SSM_SpiEnEventEntry | (BYTE)0x80 )

#define SSM_SpiDisEventEntry    ( 0x36 )
#define SSM_SpiDisEventExit     ( SSM_SpiDisEventEntry | (BYTE)0x80 )

#define SSM_SpiEnSyncEntry      ( 0x37 )
#define SSM_SpiEnSyncExit       ( SSM_SpiEnSyncEntry | (BYTE)0x80 )

#define SSM_SpiDisSyncEntry     ( 0x38 )
#define SSM_SpiDisSyncExit      ( SSM_SpiDisSyncEntry | (BYTE)0x80 )


/* SSMSRV.C */
#define SSM_SHCRouterEntry      ( 0x39 )
#define SSM_SHCRouterExit       ( SSM_SHCRouterEntry | (BYTE)0x80 )

#define SSM_3SHCRouterEntry     ( 0x3A )
#define SSM_3SHCRouterExit      ( SSM_3SHCRouterEntry | (BYTE)0x80 )


/* SSMEVDLL.C */
#define SSM_3SMHRptEventSync    ( 0x3B )
#define SSM_xxxUnused1          ( SSM_3SMHRptEventSync | (BYTE)0x80 )

#define SSM_3CallAppEventRout   ( 0x3C )
#define SSM_3RetAppEventRout    ( SSM_3CallAppEventRout | (BYTE)0x80 )

#define SSM_CallAppEventRout    ( 0x3D )
#define SSM_RetAppEventRout     ( SSM_CallAppEventRout | (BYTE)0x80 )


/* SSMSRV.C */
#define SSM_SMHNotifyIOCtlEntry ( 0x3E )
#define SSM_SMHNotifyIOCtlExit  ( SSM_SMHNotifyIOCtlEntry | (BYTE)0x80 )

#define SSM_QueueEventIOCtlEntry ( 0x3F )
#define SSM_QueueEventIOCtlExit  ( SSM_QueueEventIOCtlEntry | (BYTE)0x80 )

#define SSM_CreateBDS            ( 0x40 )
#define SSM_CreateBDSNotMax      ( SSM_CreateBDS | (BYTE)0x80 )


/* SSMAPI.C */
#define SSM_SpiDetSyncEntry     ( 0x41 )
#define SSM_SpiDetSyncExit      ( SSM_SpiDetSyncEntry | (BYTE)0x80 )

#define SSM_SpiSendMsgEntry     ( 0x42 )
#define SSM_SpiSendMsgExit      ( SSM_SpiSendMsgEntry | (BYTE)0x80 )




//****************************************************************************
//
// Stream Handlers
//
//****************************************************************************

/*                                                                            */
/* ͻ */
/*                                                                          */
/*  SHCOMMON - COMMON System Stream Handler            Major Code - 0x6E    */
/*                                                                          */
/* ͼ */
/*                                                                            */
/* ---------------------------------------------------------------------      */
/*  Minor code definitions                                                    */
/*  The range of minor codes reserved for the COMMON SH codes                 */
/*              0x40 -> 0x4F    == Start Hooks                                */
/*              0xC0 -> 0xCF    == Stop Hooks                                 */
/* -------------------------------------------------------------------------- */

#define SHCOMMON_MAJOR              0x6D

//
//    Definition for Base Minor code for File System Stream Handler
//

#define SHCOMMON_MINOR_BASE            0x40

/* MSH */
//#define SHCOMMON_STARTSHCASSOCIATE     ( 0x40 )
//#define SHCOMMON_STOPSHCASSOCIATE      (SHCOMMON_STARTSHCASSOCIATE | (BYTE)0x80 )
//
//#define SHCOMMON_STARTSHCCREATE        ( 0x41 )
//#define SHCOMMON_STOPSHCCREATE         (SHCOMMON_STARTSHCCREATE | (BYTE)0x80 )
//
//#define SHCOMMON_STARTSHCDESTROY       ( 0x42 )
//#define SHCOMMON_STOPSHCDESTROY        (SHCOMMON_STARTSHCDESTROY | (BYTE)0x80 )

#define SHCOMMON_STARTREPORTEVENT      ( 0x43 )
#define SHCOMMON_STOPREPORTEVENT       (SHCOMMON_STARTREPORTEVENT | (BYTE)0x80 )

//#define SHCOMMON_STARTSHCSTART         ( 0x44 )
//#define SHCOMMON_STOPFSHCSTART         (SHCOMMON_STARTSHCSTART | (BYTE)0x80 )
//
//#define SHCOMMON_STARTSHCSTOP          ( 0x45 )
//#define SHCOMMON_STOPSHCSTOP           (SHCOMMON_STARTSHCSTOP | (BYTE)0x80 )

#define SHCOMMON_STARTSLEEPCHECK       ( 0x46 )
#define SHCOMMON_STOPSLEEPCHECK        (SHCOMMON_STARTSLEEPCHECK | (BYTE)0x80 )

#define SHCOMMON_STARTCHECKSLEEP       ( 0x47 )
#define SHCOMMON_STOPCHECKSLEEP        (SHCOMMON_STARTCHECKSLEEP | (BYTE)0x80 )

//#define SHCOMMON_STARTSHSEEK           ( 0x48 )
//#define SHCOMMON_STOPSHSEEK            (SHCOMMON_STARTSHSEEK | (BYTE)0x80 )

#define SHCOMMON_STARTSHIOERROR        ( 0x49 )
#define SHCOMMON_STOPSHIOERROR         (SHCOMMON_STARTSHIOERROR | (BYTE)0x80 )

#define SHCOMMON_STARTSHFINDSIB        ( 0x4A )
#define SHCOMMON_STOPSHFINDSIB         (SHCOMMON_STARTSHFINDSIB | (BYTE)0x80 )

//#define SHCOMMON_STARTSHCNEGOTRES      ( 0x4B )
//#define SHCOMMON_STOPSHCNEGOTRES       (SHCOMMON_STARTSHCNEGOTRES | (BYTE)0x80 )



/*                                                                            */
/* ͻ */
/*                                                                          */
/*  ADSH - ACPA Stream Handler                         Major Code - 0x6D    */
/*                                                                          */
/* ͼ */
/*                                                                            */
/* ---------------------------------------------------------------------      */
/*  Minor code definitions                                                    */
/*  The range of minor codes reserved for the ADSH are                        */
/*              0x50 -> 0x65    == Start Hooks                                */
/*              0xD0 -> 0xE5    == Stop Hooks                                 */
/* -------------------------------------------------------------------------- */

#define ADSH_MAJOR              0x6D
#define ADSH_MINORBASE          0x50


/* ADSH and AUDIO PDDs */
#define ADSH_ACPADevIntEntry            ( 0x50 )
#define ADSH_ACPADevIntExit             ( ADSH_ACPADevIntEntry | (BYTE)0x80 )

#define ADSH_IntHandlerEntry            ( 0x51 )
#define ADSH_IntHandlerExit             ( ADSH_IntHandlerEntry | (BYTE)0x80 )

#define ADSH_SHCCreateEntry             ( 0x52 )
#define ADSH_SHCCreateExit              ( ADSH_SHCCreateEntry | (BYTE)0x80 )

#define ADSH_SHCStartEntry              ( 0x53 )
#define ADSH_SHCStartExit               ( ADSH_SHCStartEntry | (BYTE)0x80 )

#define ADSH_SHCStopEntry               ( 0x54 )
#define ADSH_SHCStopExit                ( ADSH_SHCStopEntry | (BYTE)0x80 )

#define ADSH_GetEmptyEntry              ( 0x55 )
#define ADSH_GetEmptyExit               ( ADSH_GetEmptyEntry | (BYTE)0x80 )

#define ADSH_ReturnFullEntry            ( 0x56 )
#define ADSH_ReturnFullExit             ( ADSH_ReturnFullEntry | (BYTE)0x80 )

#define ADSH_GetFullEntry               ( 0x57 )
#define ADSH_GetFullExit                ( ADSH_GetFullEntry | (BYTE)0x80 )

#define ADSH_ReturnEmptyEntry           ( 0x58 )
#define ADSH_ReturnEmptyExit            ( ADSH_ReturnEmptyEntry | (BYTE)0x80 )

#define ADSH_ReportEOSEntry             ( 0x59 )
#define ADSH_ReportEOSExit              ( ADSH_ReportEOSEntry | (BYTE)0x80 )

#define ADSH_ReportErrorEntry           ( 0x5A )
#define ADSH_ReportErrorExit            ( ADSH_ReportErrorEntry | (BYTE)0x80 )

#define ADSH_ReportPLCueEntry           ( 0x5B )
#define ADSH_ReportPLCueExit            ( ADSH_ReportPLCueEntry | (BYTE)0x80 )

#define ADSH_ReportCueTimeEntry         ( 0x5C )
#define ADSH_ReportCueTimeExit          ( ADSH_ReportCueTimeEntry | (BYTE)0x80 )

#define ADSH_ReportCueDataEntry         ( 0x5D )
#define ADSH_ReportCueDataExit          ( ADSH_ReportCueDataEntry | (BYTE)0x80 )

#define ADSH_RepDataUnderEntry          ( 0x5E )
#define ADSH_RepDataUnderExit           ( ADSH_RepDataUnderEntry | (BYTE)0x80 )

#define ADSH_RepSyncOverEntry           ( 0x5F )
#define ADSH_RepSyncOverExit            ( ADSH_RepSyncOverEntry | (BYTE)0x80 )

#define ADSH_EventHandlerEntry          ( 0x60 )
#define ADSH_EventHandlerExit           ( ADSH_EventHandlerEntry | (BYTE)0x80)

#define ADSH_ACPADevErrorEntry          ( 0x61 )
#define ADSH_ACPADevErrorExit           ( ADSH_ACPADevErrorEntry | (BYTE)0x80)

#define ADSH_AddBufEntry                ( 0x65 )
#define ADSH_AddBufExit                 ( ADSH_AddBufEntry | (BYTE)0x80)

#define ADSH_RemoveBufEntry             ( 0x66 )
#define ADSH_RemoveBufExit              ( ADSH_RemoveBufEntry | (BYTE)0x80)

#define ADSH_IDCWriteEntry              ( 0x67 )
#define ADSH_IDCWriteExit               ( ADSH_IDCWriteEntry | (BYTE)0x80)

#define ADSH_GetBufferEntry             ( 0x68 )
#define ADSH_GetBufferExit              ( ADSH_GetBufferEntry | (BYTE)0x80)

#define ADSH_RetBufferEntry             ( 0x69 )
#define ADSH_RetBufferExit              ( ADSH_RetBufferEntry | (BYTE)0x80)

#define ADSH_DLLIntEntry                ( 0x6a )
#define ADSH_DLLIntExit                 ( ADSH_DLLIntEntry | (BYTE)0x80)

#define ADSH_IDCControlEntry            ( 0x6b )
#define ADSH_IDCControlExit             ( ADSH_IDCControlEntry | (BYTE)0x80)

#define ADSH_IDCSetupEntry              ( 0x6c )
#define ADSH_IDCSetupExit               ( ADSH_IDCSetupEntry | (BYTE)0x80)

#define ADSH_SendBufferEntry            ( 0x6d )
#define ADSH_SendBufferExit             ( ADSH_SendBufferEntry | (BYTE)0x80)

/*                                                                            */
/* ͻ */
/*                                                                          */
/*  CDSH - Compact Disk Stream Handler                 Major Code - 0x6D    */
/*                                                                          */
/* ͼ */
/*                                                                            */
/* ---------------------------------------------------------------------      */
/*  Minor code definitions                                                    */
/*  The range of minor codes reserved are                                     */
/*              0x70 -> 0x7F    == Start Hooks                                */
/*              0xF0 -> 0xFF    == Stop Hooks                                 */
/* -------------------------------------------------------------------------- */

#define CDSH_MAJOR              0x6D

#define CDSH_MINORBASE          0x70


/* CD Stream */
#define CDSH_STARTCDREADIOCTL   ( 0x70 )
#define CDSH_STOPCDREADIOCTL    (CDSH_STARTCDREADIOCTL | (BYTE)0x80 )

#define CDSH_STARTCDDAREAD      ( 0x71 )
#define CDSH_STOPCDDAREAD       (CDSH_STARTCDDAREAD    | (BYTE)0x80 )

#define CDSH_STARTCDDAWRITE     ( 0x72 )
#define CDSH_STOPCDDAWRITE      (CDSH_STARTCDDAWRITE   | (BYTE)0x80 )





//*********************************************************************************


/*                                                                            */
/* ͻ */
/*                                                                          */
/*  MDM  -                                             Major Code - 0x6E    */
/*                                                                          */
/* ͼ */
/*                                                                            */
/* --------------------------------------------------------------------------      */
/*  Minor code definitions                                                    */
/*  The range of minor codes reserved are                                     */
/*              0x01 -> 0x1F    == Start Hooks                                */
/*              0x81 -> 0x9F    == Stop Hooks                                 */
/* -------------------------------------------------------------------------- */
/*                                                                            */


#define MDM_MAJOR               0x6E

#define MDM_MINORBASE           0x01


/* MMSNDSTR.C */
#define MDM_mciSendStringEntry  ( 0x01 )
#define MDM_mciSendStringExit   ( MDM_mciSendStringEntry | (BYTE)0x80 )

/* MMSNDCMD.C */
#define MDM_mciSendCommandEntry ( 0x02 )
#define MDM_mciSendCommandExit  ( MDM_mciSendCommandEntry | (BYTE)0x80 )

/* MCIOPEN.C */
#define MDM_mciOpen_Entry       ( 0x03 )
#define MDM_mciOpen_Exit        ( MDM_mciOpen_Entry | (BYTE)0x80 )

#define MDM_MCDOpen_Entry       ( 0x04 )
#define MDM_MCDOpen_Exit        ( MDM_MCDOpen_Entry | (BYTE)0x80 )

#define MDM_mciMakeActive_Entry ( 0x05 )
#define MDM_mciMakeActive_Exit  ( MDM_mciMakeActive_Entry | (BYTE)0x80 )

/* MCICLOSE.C */
#define MDM_mciClose_Entry      ( 0x06 )
#define MDM_mciClose_Exit       ( MDM_mciClose_Entry | (BYTE)0x80 )

/* MMRESMAN.C */
#define MDM_RESTORE_Entry       ( 0x07 )
#define MDM_RESTORE_Exit        ( MDM_RESTORE_Entry | (BYTE)0x80 )

#define MDM_SAVE_Entry          ( 0x08 )
#define MDM_SAVE_Exit           ( MDM_SAVE_Entry | (BYTE)0x80 )

#define MDM_Thread_call_Entry   ( 0x09 )
#define MDM_Thread_call_Exit    ( MDM_Thread_call_Entry | (BYTE)0x80 )



/*                                                                            */
/* ͻ */
/*                                                                          */
/*  MCD -                                              Major Code - 0x6E    */
/*                                                                          */
/* ͼ */
/*                                                                            */
/* ---------------------------------------------------------------------      */
/*  Minor code definitions                                                    */
/*  The range of minor codes reserved are                                     */
/*              0x20 -> 0x3F    == Start Hooks                                */
/*              0xA0 -> 0xBF    == Stop Hooks                                 */
/* -------------------------------------------------------------------------- */
/*                                                                            */

#define MCD_MAJOR              0x6E

#define MCD_MINORBASE          0x20

/******************************************************************************/
/*                                                                            */
/* NOTE ! NOTE ! NOTE ! NOTE !                                                */
/*                                                                            */
/* Marcelo R. Lopez, Jr.                                                      */
/*                                                                            */
/* As of 8/7/91, (afternoon) this section is now, unnecessary as the SH       */
/* calls will be hooked from within the SSM itself, and the minor codes for   */
/* each SHC call will be encoded into the hook at RUN time, as the function   */
/* offset #, and therefore the SHC function call itself, will be pulled from  */
/* parameter structure within SSM from he who called SSM to route the request.*/
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* ͻ */
/*                                                                          */
/*  AUFP -                                             Major Code - 0x6E    */
/*                                                                          */
/* ͼ */
/*                                                                            */
/* ---------------------------------------------------------------------      */
/*  Minor code definitions                                                    */
/*  The range of minor codes reserved are                                     */
/*              0x50 -> 0x5F    == Start Hooks                                */
/*              0xD0 -> 0xDF    == Stop Hooks                                 */
/* -------------------------------------------------------------------------- */
/*                                                                            */

#define AUFP_MAJOR             0x6E

#define AUFP_MINORBASE         0x50

#define AUFP_DEVINTENTRY               ( 0x50 )
#define AUFP_DEVINTEXIT                ( AUFP_DEVINTENTRY | ((BYTE)0x80))



/*                                                                            */
/* ͻ */
/*                                                                          */
/*  DSPM -                                             Major Code - 0x6E    */
/*                                                                          */
/* ͼ */
/*                                                                            */
/* ---------------------------------------------------------------------      */
/*  Minor code definitions                                                    */
/*  The range of minor codes reserved RING 0 are                              */
/*              0x60 -> 0x67    == Start Hooks                                */
/*              0xE0 -> 0xE7    == Stop Hooks                                 */
/*  The range of minor codes reserved RING 3 are                              */
/*              0x68 -> 0x6F    == Start Hooks                                */
/*              0xE8 -> 0xEF    == Stop Hooks                                 */
/* -------------------------------------------------------------------------- */
/*                                                                            */

#define DSPM_MAJOR             0x6E

#define DSPM_MINORBASE         0x60

/* Ring 0 */
#define DSPM_DEVINTENTRY               ( 0x60 )
#define DSPM_DEVINTEXIT                ( DSPM_DEVINTENTRY | ((BYTE)0x80))


/* Ring 3 */


//*********************************************************************************



/*                                                                            */
/* ͻ */
/*                                                                          */
/*  MMIO -                                             Major Code - 0x6F    */
/*                                                                          */
/* ͼ */
/*                                                                            */
/* ---------------------------------------------------------------------      */
/*  These defines are for use with the PTRACE facilities for performance      */
/*  evaluation of the MMIO DLL.                                               */
/*  5/28/91 - John O'Neil   OS/2 MME Development                              */
/*  8/6/91  - Rick L.       OS/2 MME Development                              */
/* ---------------------------------------------------------------------      */
/*  Minor code definitions                                                    */
/*  The range of minor codes reserved for the MMIO are                        */
/*              0x01 -> 0x3F    == Start Hooks                                */
/*              0x80 -> 0xBF    == Stop Hooks                                 */
/* -------------------------------------------------------------------------- */


#define MMIO_MAJOR              0x6F

#define MMIO_MINORBASE          0x01

//  These are the minor codes for the IOProc's to use.

//  For DosOpen call:
#define MMIO_STARTDOSOPEN             ( 0x01 )
#define MMIO_STOPDOSOPEN              (MMIO_STARTDOSOPEN | ((BYTE)0x80))

// For DosRead call:
#define MMIO_STARTDOSREAD             ( 0x02 )
#define MMIO_STOPDOSREAD              (MMIO_STARTDOSREAD | ((BYTE)0x80))

// For DosWrite call:
#define MMIO_STARTDOSWRITE            ( 0x03 )
#define MMIO_STOPDOSWRITE             (MMIO_STARTDOSWRITE | ((BYTE)0x80))

//  For DosSetFilePtr call:
#define MMIO_STARTDOSSEEK             ( 0x04 )
#define MMIO_STOPDOSSEEK              (MMIO_STARTDOSSEEK | ((BYTE)0x80))

//  For DosClose call:
#define MMIO_STARTDOSCLOSE            ( 0x05 )
#define MMIO_STOPDOSCLOSE             (MMIO_STARTDOSCLOSE | ((BYTE)0x80))

//  For DosDelete call:
#define MMIO_STARTDOSDELETE           ( 0x06 )
#define MMIO_STOPDOSDELETE            (MMIO_STARTDOSDELETE | ((BYTE)0x80))



//
//      Memory IO Proc Hooks
//

// For MemOpen call:
#define MMIO_STARTMEMOPEN             ( 0x07 )
#define MMIO_STOPMEMOPEN              (MMIO_STARTMEMOPEN | ((BYTE)0x80))

// For MemRead call:
#define MMIO_STARTMEMREAD             ( 0x08 )
#define MMIO_STOPMEMREAD              (MMIO_STARTMEMREAD | ((BYTE)0x80))

// For MemWrite call:
#define MMIO_STARTMEMWRITE            ( 0x09 )
#define MMIO_STOPMEMWRITE             (MMIO_STARTMEMWRITE | ((BYTE)0x80))

// For MemSetFilePtr call:
#define MMIO_STARTMEMSEEK             ( 0x0A )
#define MMIO_STOPMEMSEEK              (MMIO_STARTMEMSEEK | ((BYTE)0x80))

// For MemClose call:
#define MMIO_STARTMEMCLOSE            ( 0x0B )
#define MMIO_STOPMEMCLOSE             (MMIO_STARTMEMCLOSE | ((BYTE)0x80))


//
//
//      MMIO.DLL API hook definitions
//
//

#define MMIO_STARTMMIOOPEN            ( 0x0C )
#define MMIO_STOPMMIOOPEN             (MMIO_STARTMMIOOPEN | (BYTE)0x80 )

#define MMIO_STARTMMIOCLOSE           ( 0x0D )
#define MMIO_STOPMMIOCLOSE            (MMIO_STARTMMIOCLOSE | (BYTE)0x80 )

#define MMIO_STARTMMIOREAD            ( 0x0E )
#define MMIO_STOPMMIOREAD             (MMIO_STARTMMIOREAD | (BYTE)0x80 )

#define MMIO_STARTMMIOWRITE           ( 0x0F )
#define MMIO_STOPMMIOWRITE            (MMIO_STARTMMIOWRITE | (BYTE)0x80 )

#define MMIO_STARTMMIOSEEK            ( 0x10 )
#define MMIO_STOPMMIOSEEK             (MMIO_STARTMMIOSEEK | (BYTE)0x80 )

#define MMIO_STARTMMIOFLUSH           ( 0x11 )
#define MMIO_STOPMMIOFLUSH            (MMIO_STARTMMIOFLUSH | (BYTE)0x80 )

#define MMIO_STARTMMIOASCEND          ( 0x12 )
#define MMIO_STOPMMIOASCEND           (MMIO_STARTMMIOASCEND | (BYTE)0x80 )

#define MMIO_STARTMMIODESCEND         ( 0x13 )
#define MMIO_STOPMMIODESCEND          (MMIO_STARTMMIODESCEND | (BYTE)0x80 )

#define MMIO_STARTMMIOADVANCE         ( 0x14 )
#define MMIO_STOPMMIOADVANCE          (MMIO_STARTMMIOADVANCE | (BYTE)0x80 )

#define MMIO_STARTMMIOINSTALLIO       ( 0x15 )
#define MMIO_STOPMMIOINSTALLIO        (MMIO_STARTMMIOINSTALLIO | (BYTE)0x80 )

#define MMIO_STARTMMIOSENDMSG         ( 0x16 )
#define MMIO_STOPMMIOSENDMSG          (MMIO_STARTMMIOSENDMSG | (BYTE)0x80 )

#define MMIO_STARTMMIOACQUIRESEM      ( 0x17 )
#define MMIO_STOPMMIOACQUIRESEM       (MMIO_STARTMMIOACQUIRESEM | (BYTE)0x80 )

#define MMIO_STARTMMIODISCARDSEM      ( 0x18 )
#define MMIO_STOPMMIODISCARDSEM       (MMIO_STARTMMIODISCARDSEM | (BYTE)0x80 )

#define MMIO_STARTMMIOCREATECHUNK     ( 0x19 )
#define MMIO_STOPMMIOCREATECHUNK      (MMIO_STARTMMIOCREATECHUNK | (BYTE)0x80 )



//
//
//      BND ( Bundle File, or COMPOUND FILE,  IO Proc Hooks )
//
//

#define MMIO_STARTMMIOCFOPEN          ( 0x1A )
#define MMIO_STOPMMIOCFOPEN           (MMIO_STARTMMIOCFOPEN | ((BYTE)0x80))

#define MMIO_STARTMMIOCFCLOSE         ( 0x1B )
#define MMIO_STOPMMIOCFCLOSE          (MMIO_STARTMMIOCFCLOSE | ((BYTE)0x80))

#define MMIO_STARTMMIOCFRMVSHRENTRY   ( 0x1C )
#define MMIO_STOPMMIOCFRMVSHRENTRY    (MMIO_STARTMMIOCFRMVSHRENTRY | ((BYTE)0x80))

#define MMIO_STARTMMIOCFADDSHRENTRY   ( 0x1D )
#define MMIO_STOPMMIOCFADDSHRENTRY    (MMIO_STARTMMIOCFADDSHRENTRY | ((BYTE)0x80))

#define MMIO_STARTMMIOCFSETINFO       ( 0x1E )
#define MMIO_STOPMMIOCFSETINFO        (MMIO_STARTMMIOCFSETINFO | ((BYTE)0x80))

#define MMIO_STARTMMIOCFGETINFO       ( 0x1F )
#define MMIO_STOPMMIOCFGETINFO        (MMIO_STARTMMIOCFGETINFO | ((BYTE)0x80))

#define MMIO_STARTMMIOCFOPNTMPELEMENT ( 0x20 )
#define MMIO_STOPMMIOCFOPNTMPELEMENT  (MMIO_STARTMMIOCFOPNTMPELEMENT | ((BYTE)0x80))

#define MMIO_STARTMMIOCFCLSTMPELEMENT ( 0x21 )
#define MMIO_STOPMMIOCFCLSTMPELEMENT  (MMIO_STARTMMIOCFCLSTMPELEMENT | ((BYTE)0x80))

#define MMIO_STARTMMIOCFADDENTRY      ( 0x22 )
#define MMIO_STOPMMIOCFADDENTRY       (MMIO_STARTMMIOCFADDENTRY | ((BYTE)0x80))


//
// NOTE !!!! CHANGEENTRY has two E's
//

#define MMIO_STARTMMIOCFCHANGEENTRY   ( 0x23 )
#define MMIO_STOPMMIOCFCHANGEENTRY    (MMIO_STARTMMIOCFCHANGEENTRY | ((BYTE)0x80))

#define MMIO_STARTMMIOCFCOPY          ( 0x24 )
#define MMIO_STOPMMIOCFCOPY           (MMIO_STARTMMIOCFCOPY | ((BYTE)0x80))

#define MMIO_STARTMMIOCFDELETEENTRY   ( 0x25 )
#define MMIO_STOPMMIOCFDELETEENTRY    (MMIO_STARTMMIOCFDELETEENTRY | ((BYTE)0x80))

#define MMIO_STARTMMIOCFADDELEMENT    ( 0x26 )
#define MMIO_STOPMMIOCFADDELEMENT     (MMIO_STARTMMIOCFADDELEMENT | ((BYTE)0x80))

#define MMIO_STARTMMIOCFFINDENTRY     ( 0x27 )
#define MMIO_STOPMMIOCFFINDENTRY      (MMIO_STARTMMIOCFFINDENTRY | ((BYTE)0x80))



//
//
// File Format Support HOOKS
//
//
//
//


#define MMIO_STARTMMIOIDENTFILE       ( 0x28 )
#define MMIO_STOPMMIOIDENTFILE        (MMIO_STARTMMIOIDENTFILE | ((BYTE)0x80))



//
// COMING ATTRACTIONS!!!!!  Coming to a Theatre near you.....
//
//                     THE MIDI IOProc
//
//
//

#define MMIO_STARTMIDIOPEN            ( 0x29 )
#define MMIO_STOPMIDIOPEN             (MMIO_STARTMIDIOPEN | ((BYTE)0x80))

#define MMIO_STARTMIDIREAD            ( 0x2A )
#define MMIO_STOPMIDIREAD             (MMIO_STARTMIDIREAD | ((BYTE)0x80))

#define MMIO_STARTMIDIWRITE           ( 0x2B )
#define MMIO_STOPMIDIWRITE            (MMIO_STARTMIDIWRITE | ((BYTE)0x80))

#define MMIO_STARTMIDISEEK            ( 0x2C )
#define MMIO_STOPMIDISEEK             (MMIO_STARTMIDISEEK | ((BYTE)0x80))

#define MMIO_STARTMIDICLOSE           ( 0x2D )
#define MMIO_STOPMIDICLOSE            (MMIO_STARTMIDICLOSE | ((BYTE)0x80))




/*                                                                            */
/* ͻ */
/*                                                                          */
/*  MSH  - Memory Stream Handler                       Major Code - 0x6F    */
/*                                                                          */
/* ͼ */
/*                                                                            */
/* ---------------------------------------------------------------------      */
/*  Minor code definitions                                                    */
/*  The range of minor codes reserved are                                     */
/*              0x40 -> 0x4F    == Start Hooks                                */
/*              0xC0 -> 0xCF    == Stop Hooks                                 */
/* -------------------------------------------------------------------------- */

#define MSH_MAJOR              0x6F

#define MSH_MINORBASE          0x40

#define MSH_STARTPLAYLISTRD           ( 0x40 )
#define MSH_STOPPLAYLISTRD            (MSH_STARTPLAYLISTRD | ((BYTE)0x80))

#define MSH_STARTPLAYLISTWR           ( 0x41 )
#define MSH_STOPPLAYLISTWR            (MSH_STARTPLAYLISTWR | ((BYTE)0x80))

/*                                                                          */
/* ͻ */
/*                                                                        */
/*  SMV  - Software Motion Video                      Major Code - 0x6F   */
/*                                                                        */
/* ͼ */
/*                                                                          */
/* --------------------------------------------------------------------     */
/*  Minor code definitions                                                  */
/*  The range of minor codes reserved are                                   */
/*              0x50 -> 0x7F    == Start Hooks                              */
/*              0xD0 -> 0xFF    == Stop Hooks                               */
/* ------------------------------------------------------------------------ */

#define SMV_MAJOR              0x6F

#define SMV_MINORBASE          0x50

/* Software Motion Video Recorder */
#define SWVR_GetImageEntry            ( 0x50 )
#define SWVR_GetImageExit             (SWVR_GetImageEntry   | ((BYTE)0x80))

#define SWVR_CompIndxFrameEntry       ( 0x51 )
#define SWVR_CompIndxFrameExit        (SWVR_CompIndxFrameEntry | ((BYTE)0x80))

#define SWVR_CompRefrFrameEntry       ( 0x52 )
#define SWVR_CompRefrFrameExit        (SWVR_CompRefrFrameEntry | ((BYTE)0x80))

#define SWVR_PostBufferFullEntry      ( 0x53 )
#define SWVR_PostBufferFullExit       (SWVR_PostBufferFullEntry|((BYTE)0x80))

#define SWVR_PostBufferEmptyEntry     ( 0x54 )
#define SWVR_PostBufferEmptyExit      (SWVR_PostBufferEmptyEntry|((BYTE)0x80))

#define SWVR_WaitMsgBufferFullEntry   ( 0x55 )
#define SWVR_WaitMsgBufferFullExit    (SWVR_WaitMsgBufferFullEntry|((BYTE)0x80))

#define SWVR_WaitMsgBufferEmptyEntry  ( 0x56 )
#define SWVR_WaitMsgBufferEmptyExit   (SWVR_WaitMsgBufferEmptyEntry|((BYTE)0x80))

#define SWVR_PostCountErrorEntry      ( 0x57 )
#define SWVR_PostCountErrorExit       (SWVR_PostCountErrorEntry|((BYTE)0x80))

#define SWVR_BufferWriteStartEntry    ( 0x58 )
#define SWVR_BufferWriteDoneExit      (SWVR_BufferWriteStartEntry|((BYTE)0x80))

#define SWVR_VCADosDevIOCTLEntry      ( 0x59 )
#define SWVR_VCADosDevIOCTLExit       (SWVR_VCADosDevIOCTLEntry|((BYTE)0x80))

#define SWVR_VCABufferCopyEntry       ( 0x5A )
#define SWVR_VCABufferCopyExit        (SWVR_VCABufferCopyEntry|((BYTE)0x80))

#define SWVR_VCAtoX2CopyEntry         ( 0x5B )
#define SWVR_VCAtoX2CopyExit          (SWVR_VCAtoX2CopyEntry  |((BYTE)0x80))

#define SWVR_VCAtoX4CopyEntry         ( 0x5C )
#define SWVR_VCAtoX4CopyExit          (SWVR_VCAtoX4CopyEntry  |((BYTE)0x80))

#define SWVR_VCA640CopyEntry          ( 0x5D )
#define SWVR_VCA640CopyExit           (SWVR_VCA640CopyEntry   |((BYTE)0x80))


/* Software Video Stream Handler */
#define SVSH_DLLDecompBufferEntry     ( 0x64 )
#define SVSH_DLLDecompBufferExit      (SVSH_DLLDecompBufferEntry  | ((BYTE)0x80))

#define ULDC_DLLDroppedEntry          ( 0x65 )
#define ULDC_DLLDroppedExit           (ULDC_DLLDroppedEntry | ((BYTE)0x80))


/* Software Video MCD */
#define SVMC_SetBitmapEntry           ( 0x69 )
#define SVMC_SetBitmapExit            (SVMC_SetBitmapEntry   | ((BYTE)0x80))

#define SVMC_BitBltEntry              ( 0x6A )
#define SVMC_BitBltExit               (SVMC_BitBltEntry      | ((BYTE)0x80))

#define SVMC_BlitUpEntry              ( 0x6B )
#define SVMC_BlitUpExit               (SVMC_BlitUpEntry      | ((BYTE)0x80))

#define SVMC_SpiMoveCoorEntry         ( 0x6C )
#define SVMC_SpiMoveCoorExit          (SVMC_SpiMoveCoorEntry | ((BYTE)0x80))

#define SVMC_SpiSizeCoorEntry         ( 0x6D )
#define SVMC_SpiSizeCoorExit          (SVMC_SpiSizeCoorEntry | ((BYTE)0x80))

