/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*                                                                           */
/* ͻ */
/*                                                                          */
/* ======================================================================== */
/*                                                                          */
/*                                                                          */
/*        Date : 06/04/91                                                   */
/*                                                                          */
/*       System: IBM OS/2 Ver. 2.0                                          */
/*     Language:                                                            */
/*                                                                          */
/*      Purpose: Performance Trace Hook Definition File                     */
/*                                                                          */
/*                                                                          */
/*  Description: PTrace is a tool developed by the MME Performance Group    */
/*               to aid in the analysis and evaluation of MME performance.  */
/*               These hook assignments are maintained by the MME perfor-   */
/*               mance group.  If additional hook assignments are desired,  */
/*               contact Denise Morien at extension 2-8130 or VM ID         */
/*               DENNIE on BCRVMPC1.                                        */
/*                                                                          */
/*                                                                          */
/*  Change Activity:                                                        */
/*                                                                          */
/*   DATE        Programmer                  Reason / Comments              */
/*  --------  -------------------  ---------------------------------------  */
/*                                                                          */
/*  12/07/90, Marcelo R. Lopez, Jr.  Made modifications to support the      */
/*                                   GetDekkoAddress() macro, which         */
/*                                   employs a sub-function of the R0       */
/*                                   Stream Handler which acquires          */
/*                                   the information from the global        */
/*                                   infoseg via the 16-bit                 */
/*                                   DosGetInfoSeg(), and then processes    */
/*                                   the information                        */
/*                                   and places it in a global 32bit        */
/*                                   linear addressable data buffer,        */
/*                                   and returns Linear pointers to the     */
/*                                   RasTable, and the MMIO Base Address.   */
/*                                   We then map these pointers to the      */
/*                                   structures which have been stolen      */
/*                                   from the sample MMPH.h of the kernel   */
/*                                   Task Switcher, and VOILA (!) we have   */
/*                                   access to the Dekko card.              */
/*                                                                          */
/*  12/11/90  Marcelo R. Lopez, Jr.  Changed the GetDekkoAddress() macros   */
/*                                   a slight, by adding the correct        */
/*                                   function number, and category, to the  */
/*                                   DosDevIOCtl call. The SH0$ device      */
/*                                   only utilizes the second PARM passed   */
/*                                   to it, and passes the two pointers     */
/*                                   back in the array provided by the      */
/*                                   caller, it is then our responsibility  */
/*                                   to map these two pointers              */
/*                                   to the correct structures, etc.        */
/*                                                                          */
/*                                                                          */
/*  4/05/91   Marcelo R. Lopez, Jr.  Change all references to DEK$ to       */
/*                                   PTRACE$, and all references of         */
/*                                   DEKDD.SYS to PTRACE$.  Add copyright   */
/*                                   statement.                             */
/*                                                                          */
/*  5/20/91   Marcelo R. Lopez, Jr.  Modified hooks to be independent of    */
/*                                   device driver or Dekko hardware        */
/*                                   presence.                              */
/*                                                                          */
/*                                                                          */
/*  6/06/91   Marcelo R. Lopez, Jr.  Addition of support for 16-bit hooks   */
/*  &6/10/91                         within Device Drivers which mix MASM   */
/*                                   and 'C' code.  Also, merging PTRACE.H  */
/*                                   with PERFHOOK.H into one header file.  */
/*                                   Inclusion of PTRACE_D.H via PTRACE.H   */
/*                                   Added more robust documentation to     */
/*                                   make the procedures employed more      */
/*                                   understandable.  The header            */
/*                                                                          */
/*  6/11/91   Marcelo R. Lopez, Jr.  Made modifications throughout to       */
/*                                   modify the method of access to the     */
/*                                   Dekko Card.  Now every piece of        */
/*                                   code goes through the same variable    */
/*                                   to access the address(es) of the Dekko */
/*                                   card, via DekkoStruct, which is        */
/*                                   assigned to a global var named:        */
/*                                             PTraceAddress                */
/*                                   PTraceAddress essentially acts as      */
/*                                   a layer of indirection, and since it   */
/*                                   points to a data area which should     */
/*                                   contain BOTH 32 & 16 bit versions of   */
/*                                   the address of the Dekko Card, then    */
/*                                   16 or 32 bit code can employ the       */
/*                                   one that best suits the piece of code  */
/*                                   being compiled/assembled.  I.E., a     */
/*                                   16-bit piece of 'C' code will always   */
/*                                   access the Dekko card through the 16-  */
/*                                   bit version of the address, and 32-bit */
/*                                   will employ it's 32-bit equivalent.    */
/*                                   This method allows a freer inter-      */
/*                                   marriage of code from the two lan-     */
/*                                   quages, basically it means that        */
/*                                   everybody access the card through a    */
/*                                   global data structure defined and      */
/*                                   initialized by some other code, and    */
/*                                   access that piece which pertains in    */
/*                                   specific to the type of code being     */
/*                                   compiled.                              */
/*                                                                          */
/*                                                                          */
/*  6/14/91   Marcelo R. Lopez, Jr.  Modified 16-bit InitPTrace() to        */
/*                                   eliminate long/short conversion        */
/*                                   warnings during compile.  Modified     */
/*                                   VALIDATEACCESS macro to perform        */
/*                                   verification of the DEKKOSTRUCT        */
/*                                   structures' integrity differently.     */
/*                                                                          */
/*  02/10/92  Bill Lawton            Added RAS support & StopTimer5word     */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/*                                                                          */
/* ͼ */
/***************************************************************************/
/*                                                                         */
/*                                                                         */
/*                                                                         */
/***************************************************************************/
//
//
// Note:   This set of extension serves as an examples and may be
//         modified by OS/2 MME Development or Performance Groups.
//         Anyone wishing to add or detract should contact either
//         Jose Martinez ( HOSE at BCRVMPC1 ) or Dennis Morien ( DENNIE at
//         BCRVMPC1 ).
//         prior to such modification.
//
// Creation Date:   11/30/90
//
// Author:  Marcelo R. Lopez, Jr.
//          Keith C. Kelly
//
//
//
//
//*****************************************************************************


//****************************************************************************
//*
//*  Public variables used by the kernel's performance hook macros. This
//*  declaration must reside here as DLL define their own variables.
//*
//*  NOTE: that these name are defined only for performance builds !!!
//*
//****************************************************************************

#ifdef MMRAS
   // Put RAS in RETAIL and DEBUG
   #define MMEITHER      1                             // RASHOOK
   #ifdef INCL_16                                      // RASHOOK
      ULONG  Call_RAS16SysTrace(ULONG ulMajor, ULONG ulMinor, ULONG ulP1, ULONG ulP2, ULONG ulP3, ULONG ulP4, ULONG ulP5);
   #else                                               // RASHOOK
      ULONG  Call_Dos16SysTrace(ULONG ulMajor, ULONG ulMinor, ULONG ulP1, ULONG ulP2, ULONG ulP3, ULONG ulP4, ULONG ulP5);
   #endif                                              // RASHOOK
#else                                                  // RASHOOK
   #define Call_Dos16SysTrace(major,minor,parm1, parm2, parm3, parm4, parm5)
   #define Call_RAS16SysTrace(ulMajor, ulMinor,ulP1,ulP2,ulP3, ulP4, ulP5);
#endif                                                 // RASHOOK
#ifdef PTRACE                                          // RASHOOK
  // Put in PTRACE only
  #define MMEITHER       1                             // RASHOOK
#endif

//****************************************************************************

#ifdef PTRACE
  #ifdef INCL_16
    #define PTRACE_INCL_16
    #ifdef PTRACE_PDD
       #define PTRACE_INCL_SUPER16
    #else
       #define PTRACE_INCL_USER16
    #endif
  #else
    #define PTRACE_INCL_32
  #endif

  #ifdef PTRACE_INCL_32

     //
     // Define that the HIGH LEVEL hooks are to be included into the scheme
     // of things, otherwise NULL hooks will be included.
     //
     // There are separate definitions for LOW and HIGH level hooks, for
     // both 16 & 32bit.  They are handled in-line in their respective
     // contexts.  In other words, all LOW level hooks are together, and
     // all high-level hooks are also together.
     //
     //



     #define LOWLEVEL32     1
     #define HIGHLEVEL32    1
     #define HIGHLEVELHOOKS 1
     #define mmptr


      //
      // Information for DD Dekko Access workaround
      //

      struct data_table {
               ULONG mmiobase32;
               ULONG mmiobase16;
               CHAR  rastable[32];
      } DekkoStruct;


      struct data_table *PTraceAddress;


  #endif
  #ifdef PTRACE_INCL_16


     #define LOWLEVEL16     1
     #define HIGHLEVEL16    1
     #define HIGHLEVELHOOKS 1
     #define mmptr


      //
      // Information for DD Dekko Access workaround
      //

      struct data_table {
               ULONG mmiobase32;
               ULONG mmiobase16;
               CHAR  rastable[32];
      } DekkoStruct;


      struct data_table  *PTraceAddress;



  #endif
#endif


//****************************************************************************
//
//
//      The declarations and definitions below correspond to the data and macros
//      for performing the low-level atomic operations of interfacing to the
//      Dekko hardware.  In the event that the timing hardware changes, this
//      portion will require modification to support this new hardware.
//
//
//****************************************************************************


#if ( LOWLEVEL16 || LOWLEVEL32 )



  #define BASE16 4
  #define BASE32 0


  //
  // Define the OFFSETS within the PTraceStruct where the 16-bit & 32-bit
  //


      //
      //  Dekko card memory mapped I/O address data area
      //

     typedef struct PTraceStruct
     {
       unsigned long   reserved;           /* +0 - not used                   */
       unsigned short  majmin_code;        /* +4 - Major (hi) minor (lo) code */
       unsigned short  start_stop_sync;    /* +6 - not used                   */
       unsigned long   perf_data_4byte;    /* +8 - 4 byte performance data    */
       unsigned short  perf_data;          /* +C - 2 byte performance data    */

     }_PTraceStruct;



  //
  //
  // Local variables used by the performance hook internal macros
  //
  //


   static _PTraceStruct   *dekko_addr;
   unsigned char          *dekko_ptr;
           short          dekko_idx;
   unsigned long          dekko_quad;
   unsigned char          *RMT;

   USHORT MMEMajorMinor;


  #define GETMMIO         0x40   // IoCtl function to acquire Dekko
  #define PTRACE_CATEGORY 0x81   // IoCtl Category for PTRACE$ device

  /***************************************************************************/
  /*                                                                         */
  /*  TEST_TRACING........... Determines if tracing is active for the given  */
  /*                          major code and if the "master" tracing switch  */
  /*                          is currently active.                           */
  /*                                                                         */
  /***************************************************************************/

  #define TEST_TRACING(RMT,Maj)            \
          (*RMT & 0x40) && (*(RMT+(Maj>>3)) & (0x80>>(Maj&7)))





  //
  //    The following are the low-level hooks as existed in PERFHOOK.h before
  //    being integrated into PTRACE.h .   All subsequent changes will be made
  //    here, and PERFHOOK.H will be discarded.  It must NOT be included else-
  //    where, as that will create a definition conflict in the compilers'
  //    preprocessor
  //


  //**************************************************************************
  //
  // This is a DEBUG statement that will ONLY be built when debugging is turned
  // on.  As this will cause a BREAK of system execution, make certain that
  // DLL, apps, etc. built with this turned on, that they execute under a KERNAL
  // DEBUG version OS/2.
  //
  //**************************************************************************


   #define DEBUGBREAK { _asm {     \
                             int 3 \
                             }     \
                      }


  /***************************************************************************/
  /*                                                                         */
  /*  ValidateAccess......... Macro used to validate that access to the      */
  /*                          PTrace Tools is possible.  If for some reason  */
  /*                          NO InitPTrace call is made within the HIGH     */
  /*                          level hooks then there may be NO setup         */
  /*                          performed on the PTrace Structure.  Therefore, */
  /*                          can access the card, so the hooks MUST fall    */
  /*                          through.                                       */
  /*                                                                         */
  /* if 32-bit                                                               */
  /*                                                                         */
  /*     if NOT DEBUG                                                        */
  /*                                                                         */
  /*          ValidateAccess( via 32-bit pointer )                           */
  /*                                                                         */
  /*     else                                                                */
  /*          BREAK ( int 3 )                                                */
  /*          ValidateAccess( via 32-bit pointer )                           */
  /*                                                                         */
  /*     endif                                                               */
  /*                                                                         */
  /* else                                                                    */
  /*                                                                         */
  /*    if NOT DEBUG                                                         */
  /*                                                                         */
  /*          ValidateAccess( via 16-bit pointer )                           */
  /*                                                                         */
  /*    else                                                                 */
  /*                                                                         */
  /*          BREAK ( int 3 )                                                */
  /*          ValidateAccess( via 16-bit pointer )                           */
  /*                                                                         */
  /*    endif                                                                */
  /*                                                                         */
  /* endif                                                                        */
  /*                                                                         */
  /*                                                                         */
  /***************************************************************************/

  #if LOWLEVEL32


      #define VALIDATEACCESS   \
             ( ((_PTraceStruct *)(PTraceAddress->mmiobase32)) != NULL )


  #elif LOWLEVEL16


      #define VALIDATEACCESS   \
             ( ((_PTraceStruct far *)(PTraceAddress->mmiobase16)) != NULL )


  #endif




  /***************************************************************************/
  /*                                                                         */
  /*  FORCE_WRITE............ Macro used to break the optimization of the    */
  /*                          C complier. This macro will force it to        */
  /*                          generate code for consecutive statements which */
  /*                          write to the same memory location. This may    */
  /*                          stop working without notice. It should be      */
  /*                          checked each time the "C" compiler is changed. */
  /*                                                                         */
  /***************************************************************************/

  #if LOWLEVEL32

    #define FORCE_WRITE if( ((_PTraceStruct *)(PTraceAddress->mmiobase32)) != 0 );

  #elif LOWLEVEL16

    #define FORCE_WRITE if( ((_PTraceStruct far *)(PTraceAddress->mmiobase16)) != 0 );

  #endif


  /***************************************************************************/
  /*                                                                         */
  /*  WRITE_DATA_LENGTH...... Writes the given word value at the +C offset   */
  /*                          data area of the dekko card.                   */
  /*                                                                         */
  /*                                                                         */
  /*                                                                         */
  /***************************************************************************/


  #if LOWLEVEL32

     #define WRITE_DATA_LENGTH(val)  ((_PTraceStruct *)PTraceAddress->mmiobase32)->perf_data = (USHORT)val;

  #elif LOWLEVEL16

     #define WRITE_DATA_LENGTH(val)  ((_PTraceStruct far *)PTraceAddress->mmiobase16)->perf_data = (USHORT)val;

  #endif

  /***************************************************************************/
  /*                                                                         */
  /*  WRITE_MAJ_MNR_CODES.... Writes the given major and minor codes into    */
  /*                          the "majmin_code" element of the dekko addr.   */
  /*                                                                         */
  /***************************************************************************/


  #if LOWLEVEL32

    #define WRITE_MAJMNR_CODES(MajMnr) ((_PTraceStruct *)PTraceAddress->mmiobase32)->majmin_code = MajMnr;

  #elif LOWLEVEL16

    #define WRITE_MAJMNR_CODES(MajMnr) ((_PTraceStruct far *)PTraceAddress->mmiobase16)->majmin_code = MajMnr;

  #endif



  /***************************************************************************/
  /*                                                                         */
  /*  WRITE_BYTE_VALUE....... Writes the given byte value at the +C offset   */
  /*                          data area of the dekko card. The byte is       */
  /*                          written into the high byte of the data area    */
  /*                          and the low byte is padded with a zero.        */
  /*                                                                         */
  /***************************************************************************/
  // We only have 1 byte to write

  #if LOWLEVEL32

    #define WRITE_BYTE_VALUE(val)                      \
        ((_PTraceStruct  *)PTraceAddress->mmiobase32)->perf_data = 2;                     \
        ((_PTraceStruct  *)PTraceAddress->mmiobase32)->perf_data = ( 0x0000 | val );      \
        FORCE_WRITE

  #elif LOWLEVEL16

    #define WRITE_BYTE_VALUE(val)                      \
        ((_PTraceStruct far *)PTraceAddress->mmiobase16)->perf_data = 2;                     \
        ((_PTraceStruct far *)PTraceAddress->mmiobase16)->perf_data = ( 0x0000 | val );      \
        FORCE_WRITE


  #endif



  /***************************************************************************/
  /*                                                                         */
  /*  WRITE_WORD_VALUE....... Writes the given word value at the +C offset   */
  /*                          data area of the dekko card.                   */
  /*                                                                         */
  /***************************************************************************/

  #if LOWLEVEL32

    #define WRITE_WORD_VALUE(val)                      \
             ((_PTraceStruct *)PTraceAddress->mmiobase32)->perf_data = (USHORT)val;      \
             FORCE_WRITE


  #elif LOWLEVEL16

    #define WRITE_WORD_VALUE(val)                      \
             ((_PTraceStruct far *)PTraceAddress->mmiobase16)->perf_data = (USHORT)val;      \
             FORCE_WRITE


  #endif



  /***************************************************************************/
  /*                                                                         */
  /*  WRITE_DWORD_VALUE...... Writes the double word value at the +8 offset  */
  /*                          data area of the dekko card.                   */
  /*                                                                         */
  /***************************************************************************/

  #if LOWLEVEL32

    #define WRITE_DWORD_VALUE(val)                     \
             ((_PTraceStruct *)PTraceAddress->mmiobase32)->perf_data_4byte = (ULONG)val; \
             FORCE_WRITE


  #elif LOWLEVEL16

    #define WRITE_DWORD_VALUE(val)                     \
             ((_PTraceStruct far *)PTraceAddress->mmiobase16)->perf_data_4byte = (ULONG)val; \
             FORCE_WRITE

  #endif


  /***************************************************************************/
  /*                                                                         */
  /*  WRITE_DWORDFROM2WORD... Writes the double word value at the +8 offset  */
  /*                          data area of the dekko card, first             */
  /*                          combining 2 singular words for information.    */
  /*                                                                         */
  /***************************************************************************/

  #if LOWLEVEL32

    #define WRITE_DWORDFROM2WORD( UniqueId, Datum )                      \
             ((_PTraceStruct *)PTraceAddress->mmiobase32)->perf_data_4byte = (ULONG)( (((ULONG)Datum)<<16) | ((ULONG)UniqueId) );  \
             FORCE_WRITE


  #elif LOWLEVEL16

    #define WRITE_DWORDFROM2WORD( UniqueId, Datum )                     \
             ((_PTraceStruct far *)PTraceAddress->mmiobase16)->perf_data_4byte = (ULONG)( (((ULONG)Datum)<<16) | ((ULONG)UniqueId) );  \
             FORCE_WRITE

  #endif

  /*
  //  DO NOT TOUCH !!!!!!!!!
  //
  //  ((_PTraceStruct far *)PTraceAddress->mmiobaseXX)->perf_data_4byte=(unsigned long)val;
  //
  */

  /***************************************************************************/
  /*                                                                         */
  /*  WRITE_BYTE_STREAM...... Write the stream of bytes indicated by         */
  /*                          dekko_ptr and dekko_idx to the +C offset of    */
  /*                          the dekko card as a series of double words.    */
  /*                                                                         */
  /*  07/09/90 - Fixed extra quad written when last byte of string was on    */
  /*             the quad boundry.                                           */
  /*                                                                         */
  /*  12/14/90 - Modified the macros to support the DEKKO2 convention of     */
  /*             only writing 16-bit values to the +0C offset of the card.   */
  /*                                                                         */
  /*                                                                         */
  /*                                                                         */
  /*                                                                         */
  /***************************************************************************/


    #define WRITE_BYTE_STREAM                                 \
            while (dekko_idx > 0) {                           \
                dekko_quad = *(short mmptr *)dekko_ptr;       \
                if ( dekko_idx == 1 ) {                       \
                   WRITE_WORD_VALUE( (0x0000|dekko_quad)<<8 ) \
                } else {                                      \
                   WRITE_WORD_VALUE(dekko_quad)               \
                }                                             \
                dekko_ptr += 2; dekko_idx -= 2;               \
            }

  /***************************************************************************/
  /*                                                                         */
  /*  WRITE_WORD_STREAM...... Write the stream of WORDS indicated by         */
  /*                          dekko_ptr and dekko_idx to the +C offset of    */
  /*                          the dekko card as a series of double words.    */
  /*                                                                         */
  /*  07/09/90 - Fixed extra quad written when last byte of string was on    */
  /*             the quad boundry.                                           */
  /*                                                                         */
  /*  12/14/90 - Modified the macros to support the DEKKO2 convention of     */
  /*             only writing 16-bit values to the +0C offset of the card.   */
  /*                                                                         */
  /*                                                                         */
  /*                                                                         */
  /*                                                                         */
  /***************************************************************************/


    #define WRITE_WORD_STREAM                                 \
            while (dekko_idx > 0) {                           \
                dekko_quad = *(long mmptr *)dekko_ptr;        \
                if ( dekko_idx == 1 ) {                       \
                   WRITE_WORD_VALUE( (0x0000|dekko_quad)<<8 ) \
                } else {                                      \
                   WRITE_WORD_VALUE(dekko_quad)               \
                }                                             \
                dekko_ptr += 2; dekko_idx -= 2;               \
            }

  /***************************************************************************/
  /*                                                                         */
  /*  WRITE_ASCIIZ_STRING.... Writes the asciiz string to the dekko card as  */
  /*                          a series of double words to the +8 offset. The */
  /*                          final "dword" is padded with as many blanks as */
  /*                          needed. The null terminator is always written. */
  /*                                                                         */
  /*  06/21/90 - Modified to check for null string. Write zeros if NULL.     */
  /*                                                                         */
  /***************************************************************************/


  // Write out the length to '+0C'
  // Write the stream of bytes


  #define WRITE_ASCIIZ_STRING(str)                    \
          if (str != NULL) {                          \
              dekko_ptr = (unsigned char mmptr *)str; \
              dekko_idx = 1;                          \
              while (*dekko_ptr++) dekko_idx++;       \
              dekko_ptr = (unsigned char mmptr *)str; \
              WRITE_DATA_LENGTH(dekko_idx)            \
              WRITE_BYTE_STREAM  }                    \
          else  {                                     \
              WRITE_DATA_LENGTH(2)                    \
              WRITE_WORD_VALUE(0)                     \
          }

  /***************************************************************************/
  /*                                                                         */
  /*  WRITE_NUMB_STRING...... Writes the length byte of the string to the +C */
  /*                          offset of the dekko card. The data part of the */
  /*                          string is then written to the +8 offset as a   */
  /*                          series of double words.                        */
  /*                                                                         */
  /*  06/21/90 - Fixed pointer incrememt problem. Also allowed for fact that */
  /*             length byte value includes the length byte.                 */
  /*                                                                         */
  /***************************************************************************/

  #define WRITE_NUMB_STRING(str)                      \
          if (str != NULL) {                          \
              dekko_ptr = (unsigned char mmptr *)str; \
              dekko_idx = *dekko_ptr - 1;             \
              dekko_ptr++;                            \
              WRITE_DATA_LENGTH(dekko_idx)            \
              WRITE_BYTE_STREAM }                     \
          else {                                      \
              WRITE_DATA_LENGTH(2)                    \
              WRITE_WORD_VALUE(0)                     \
          }



  //
  //    End of LOWLEVELHOOKS
  //

#endif


//*************************************************************************
//
//
// The header files included below is the master definition file for the
// hooks for the MultiMedia extensions.  This master file cannot be
// without knowledge of the performance group which keeps that master table
// that it is based on. No NEW hooks can be added without first notifying
// the performance group, which will perform the update of it's contents.
//
//
//*************************************************************************

//*************************************************************************
//
//      Include the HOOK name definitions regardless, because although
//      the HOOKS which are generated are NULL operations, the definitions for
//      the hook names must be included for the preprocessor    to be able to
//      resolve the names defined in the code which includes PTRACE.H.
//
//      IN OTHER WORDS, DON'T TOUCH !!!!!
//
//*************************************************************************

#include <ptrace_d.h>

//*************************************************************************
//
//      Below the HIGH level macros are defined, as well as the initialization
//      for the two programming models currently supported within PTRACE.
//
//*************************************************************************


#ifdef HIGHLEVELHOOKS

  #ifdef PTRACE_INCL_32

    /***************************************************************************/
    /*                                                                         */
    /*  InitPTrace ......      Calls the subcomponents which initialize the    */
    /*                           PTraceAddress". Address value is obtained from*/
    /*                          the info segment data.                         */
    /*                                                                         */
    /*          InitPTrace ()                                                  */
    /*                   |                                                     */
    /*                   |                                                     */
    /*                   \--->  GetDekkoAddress()                              */
    /*                   |                                                     */
    /*                   |                                                     */
    /*                   \--->  SetDekkoAddress()                              */
    /*                                                                         */
    /*   This interface allows for plug-n-play functionality on the part of    */
    /* internals which relate to the physical hardware being employed as the   */
    /* Time Stamp Generator/Data Collector.                                    */
    /*                                                                         */
    /*                                                                         */
    /*                                                                         */
    /***************************************************************************/



    #define InitPTrace()          \
               GetDekkoAddress()  \
               SetDekkoAddress()


    //
    //  Date: 12/20/90, Marcelo R. Lopez, Jr. BPC.
    //
    //
    //  The IFDEF above relates to the fact that PTrace  is a 32-bit only
    //  solution, and does not address the operation of mixed-mode applications or
    //  dll's.  Access to DEKKO from mixed mode DLL's or applications will
    //  require code to handle access to DEKKO from 16-bit code.
    //
    //
    //  The device driver PTRACE$ will "fill in the blanks" so-to-speak.
    //
    /***************************************************************************/
    /*                                                                         */
    /*  GET_DEKKO_ADDRESS...... Loads the dekko card address into the variable */
    /*                          "PTraceAddress". Address value is obtained from*/
    /*                          the info segment data.                         */
    /*                                                                         */
    /***************************************************************************/


      #define GetDekkoAddress() {                                   \
                                                                    \
        HFILE  hPrf;                                                \
        ULONG  ulAction;                                            \
        APIRET apircMacRC;                                          \
                                                                    \
        ULONG  len1, len2;                                          \
                                                                    \
        struct data_table   *dek_pntr, *q;                          \
        dek_pntr = &DekkoStruct;                                    \
        len1     = (ULONG)sizeof(DekkoStruct);                      \
        q        = NULL;                                            \
        len2     = 0L;                                              \
                                                                    \
        dek_pntr->mmiobase32 = (ULONG)NULL;                         \
        dek_pntr->mmiobase16 = (ULONG)NULL;                         \
                                                                    \
        apircMacRC = DosOpen( (PSZ)"PTRACE$",                       \
                              &hPrf,                                \
                              &ulAction,                            \
                              0L,                                   \
                              0L,                                   \
                              1L,                                   \
                              (ULONG)0xC2,                          \
                              NULL );                               \
                                                                    \
        if ( apircMacRC == ((APIRET)NO_ERROR) ) {                   \
           apircMacRC = DosDevIOCtl( hPrf,                          \
                                     0x81L,                         \
                                     0x40L,                         \
                                     dek_pntr,                      \
                                     len1,                          \
                                     &len1,                         \
                                     q,                             \
                                     len2,                          \
                                     &len2 );                       \
           DosClose( hPrf );                                        \
        }                                                           \
      }


    //************************************************************************
    //
    //
    //  SetDekkoAddressD is simply a DEBUG version of the macro, not really
    //  intended for use outside of BPC Lab.
    //
    //
    //************************************************************************

      #define SetDekkoAddressD()                              \
           PTraceAddress = &DekkoStruct;                       \
           {                                            \
              _asm { int 3 }                             \
           }                                              \
           DEBUGBREAK                                      \
           RMT = (unsigned char *)DekkoStruct.rastable;         \
           printf( "Dekko Address set to: %x\n", (PTraceAddress->mmiobase32) );


      #define SetDekkoAddress()         \
           PTraceAddress = &DekkoStruct; \
           RMT = (unsigned char *)DekkoStruct.rastable;



    //************************************************************************
    //
    // End of 32-bit Initialization definitions.        The actual HIGH LEVEL
    // operation MACROS are defined later.  The separation of initializations
    // is logical since the HIGH level macros will talk to the card via the
    // same mechanism, although the declarations of the variables themselves
    // vary in accordance with the programming model of the system.      In other
    // word, if 16-bit a FAR variable to the SELECTOR:OFFSET of the DEKKO
    // card is employed, otherwise, a 32-bit flat pointer is used.
    //
    //************************************************************************



  #endif
  #ifdef PTRACE_INCL_16

         #ifdef PTRACE_INCL_SUPER16

            //
            //      Now handle 16-bit stuff, or process the stuff as simple dummy
            //      invocations of the macros
            //
            //
            //
            //
            //      These Macros    support 'C' code within a Device driver that will
            //      receive the SEL:OFF variable which was intialized by the device
            //      driver elsewhere, and declared as a _FAR16 variable, PERFHOOK
            //      will have 2 sets of atomic operations.  One set for FLAT memory
            //      model, and another which supports 16-bit code by employing

            //      SELECTOR:OFFSET model.   The device driver which whatever 'C' code
            //      is built with the macros below, will previously have to have
            //      initialized a variable which should contain the SEL:OFF format of
            //      the base address to the DEKKO DUT card.  The macros will verify that
            //      the address is NOT NULL, then proceed to write to the card as in
            //      OS/2 v1.X
            //
            //
            //
            //
            //
            //      Additions:  6/4/91, Lopez, Kelly.
            //
            //      rev 0.1  Defined dummy macros, created 16 bit InitPTrace()
            //                                       which MUST have a pointer to the Data VARIABLE which contains
            //                                       the SEL:OFF form of the Base address to the Dekko card.
            //
            //      rev 0.2  Modify the InitPTrace() macro to employ the the 16:16 address
            //
            //      /========\     /------------------------------------\
            //      |        |---->| FAR16 segment with PTraceAddress = |
            //      | Device |    /| INFOSEG.MMIOADDR                   |
            //      | Driver |   / \------------------------------------/
            //      | Init   |  /          ||
            //      |        | |           ||                          (MASM)
            //      \========/ |           ||
            //     ------------|-----------||--------------------------------------------
            //                 |           ||                           ('C')
            //                 |           ||
            //                 |          \||/
            //                 |           \/
            //                 |         /------------\
            //                 |         | InitPTrace |------>/--------------------------\
            //                 |         |            |       | Set PTraceAddress = to   |
            //                 |         \------------/       | where PTraceAddress is * |
            //                 |                              | to.                      |
            //                 |                              \--------------------------/
            //                 |                                            ||
            //                 |                                            ||
            //                 |                                           \||/
            //                 |                                            \/
            //                 |                      /--MySubroutine()------------\
            //                 |                      |                            |
            //                 |                      |       Start_Timer_DWord()  |
            //                 |                      |                            |
            //                 \----------------------|                            |
            //                                        |       Stop_Timer_DWord()   |
            //                                        |                            |
            //                                        \----------------------------/
            //
            //
            //
            //      Since the we have a valid set of options defined for the preprocessor,
            //      we will define another CONSTANT which will cause the
            //

            //
            //
            // This is currently a NULL operation since the PTraceAddress is defined
            // as a PUBLIC within Device Driver Init, and declared as PTraceAddress, so
            // 16-bit Supervisor code can directly access the PTrace( Dekko ) structure
            //
            //
            //
            //
            //


            //    ***************************************************************
            //
            //      This 'C' macro may be used to retrieve the physical address
            //      of the dekko card at device INIT time from ring 3 with IOPL.
            //
            //    ***************************************************************

                #include <conio.h>

                #define InitPTrace()         \
                           GetDekkoAddress() \
                           SetDekkoAddress()

                #define max_slots     0x0020
                #define port_select   0x0096
                #define card_id       0x0100
                #define dekko_id      0xEED7
                #define pos_base      0x0102
                #define start_slot    0x0008
                #define dekko_mask    0x001E
                #define dekko_addrs   0x000C
                #define dekko_start   0xC8000
                #define dekko_limit   0x2047


                #define GetDekkoAddress() {                                   \
                                                                              \
                  unsigned short rc;                                          \
                  unsigned short slot;                                        \
                  unsigned short choices;                                     \
                  unsigned short dekko_index;                                 \
                  unsigned long  dekko_base;                                  \
                  unsigned long  dekko_phys;                                  \
                  unsigned long  dekko_virt;                                  \
                  unsigned short padekko_GDTs[1];                             \
                  struct data_table   *dek_pntr;                              \
                                                                              \
                  dek_pntr = &DekkoStruct;                                    \
                  dek_pntr->mmiobase32 = NULL;                                \
                  dek_pntr->mmiobase16 = NULL;                                \
                  dekko_phys = NULL;                                          \
                  dekko_virt = NULL;                                          \
                  slot = start_slot;                                          \
                                                                              \
                  for (slot=start_slot;slot<(start_slot+max_slots);slot++) {  \
                    outp(port_select, slot);                                  \
                    if(inpw(card_id)==dekko_id) break;                        \
                  }                                                           \
                  if(slot!=(start_slot+max_slots)) {                          \
                    dekko_base  = dekko_start;                                \
                    dekko_index = 0x08;                                       \
                    for (choices=1;choices<=dekko_addrs;choices++) {          \
                      if((inp(pos_base)&dekko_mask)==(int)dekko_index) {      \
                        dekko_phys = dekko_base;                              \
                        break;                                                \
                      }                                                       \
                      dekko_index = dekko_index+2;                            \
                      dekko_base  = dekko_base+0x200;                         \
                    }                                                         \
                  }                                                           \
                  if (dekko_phys != NULL) {                                   \
                     if (!(rc = DevHlp_AllocGDTSelector(01L, padekko_GDTs))) {\
                        rc = DevHlp_PhysToGDTSelector( (PVOID) dekko_phys,    \
                                                       14,                    \
                                                       padekko_GDTs[0]);      \
                     }                                                        \
                     if (!rc) {                                               \
                        dekko_virt = (ULONG) padekko_GDTs[0];                 \
                        dek_pntr->mmiobase16 = (dekko_virt << 16);            \
                     }                                                        \
                  }                                                           \
                }



                #define SetDekkoAddress()          \
                     PTraceAddress = &DekkoStruct; \
                     RMT = (unsigned char *)DekkoStruct.rastable;


         #endif
         #ifdef PTRACE_INCL_USER16

             //
             //    Otherwise, INCL_USER16 which is for application or DLL support
             //    within PTrace
             //

             #ifdef PTRACE_DEBUG

                #define InitPTrace()         \
                           GetDekkoAddress() \
                           SetDekkoAddressD()

              #else

                #define InitPTrace()         \
                           GetDekkoAddress() \
                           SetDekkoAddress()

              #endif


             #define GetDekkoAddress() {                                   \
                                                                           \
               HFILE  hPrf;                                                \
               USHORT usAction;                                            \
               USHORT apircMacRC;                                          \
                                                                           \
               struct data_table   *dek_pntr, *q;                          \
               ULONG  len1, len2;                                          \
                                                                           \
               dek_pntr = &DekkoStruct;                                    \
               len1     = (ULONG)sizeof(DekkoStruct);                      \
               q        = NULL;                                            \
               len2     = 0L;                                              \
                                                                           \
               dek_pntr->mmiobase16 = (ULONG)NULL;                         \
               dek_pntr->mmiobase32 = (ULONG)NULL;                         \
                                                                           \
               apircMacRC = DosOpen( (PSZ)"PTRACE$",                       \
                                     &hPrf,                                \
                                     (PUSHORT)&usAction,                   \
                                     0L,                                   \
                                     0,                                    \
                                     1,                                    \
                                     0xC2,                                 \
                                     0L);                                  \
                                                                           \
               if ( apircMacRC == ((USHORT)NO_ERROR) ) {                   \
                     apircMacRC = DosDevIOCtl( q,                          \
                                               dek_pntr,                   \
                                               0x40,                       \
                                               0x81,                       \
                                               hPrf);                      \
                                                                           \
                 DosClose( hPrf );                                         \
               }                                                           \
             }


            //************************************************************************
            //
            //
            //  SetDekkoAddressD is simply a DEBUG version of the macro, not really
            //  intended for use outside of BPC Lab.
            //
            //
            //************************************************************************

              #define SetDekkoAddressD()            \
                   PTraceAddress = &DekkoStruct;    \
                   RMT = (unsigned char *)DekkoStruct.rastable;  \
                   {                                \
                      _asm { int 3 }                \
                   }                                \
                   DEBUGBREAK                       \
                   printf( "Dekko Address set to: %lx\n", (PTraceAddress->mmiobase16) ); \


              #define SetDekkoAddress()          \
                   PTraceAddress = &DekkoStruct; \
                   RMT = (unsigned char *)DekkoStruct.rastable;


         #endif

  #endif


  //************************************************************************
  //
  // All the HIGH level hooks work employing the same mechanism of indexing
  // into a structure, which is global to the module.
  //
  //************************************************************************




  //***************************************************************************
  //
  // The Write_Dek_xxxx macros were the initial step, before creating
  // a differently named set of Start/Stop Timer macros.  They essentially
  // perform the same function, and can be used interchangeably.  The Start/Stop
  // macros are those which are documented, and will remain externally compatible
  // with the functionality defined in the documentation for PTrace.
  //
  //***************************************************************************
  #define Write_Dek_Word( major, minor, val )        \
       if ( (VALIDATEACCESS))  {                 \
          if (TEST_TRACING(RMT,major)) {             \
             MMEMajorMinor = ((major << 8) | minor); \
             WRITE_MAJMNR_CODES (MMEMajorMinor)      \
             WRITE_WORD_VALUE(val)                   \
          }                                          \
       }


  #define Write_Dek_DWord( major, minor, val )       \
       if ( (VALIDATEACCESS))  {                 \
          if (TEST_TRACING(RMT,major)) {             \
             MMEMajorMinor = ((major << 8) | minor); \
             WRITE_MAJMNR_CODES (MMEMajorMinor)      \
             WRITE_DWORD_VALUE(val)                  \
          }                                          \
       }


  #define Write_Dek_Byte( major, minor, val )        \
       if ( (VALIDATEACCESS))  {                 \
          if (TEST_TRACING(RMT,major)) {             \
             MMEMajorMinor = ((major << 8) | minor); \
             WRITE_MAJMNR_CODES (MMEMajorMinor)      \
             WRITE_BYTE_VALUE(val)                   \
          }                                          \
       }


  #define Write_Dek_String( major, minor, str )      \
       if ( (VALIDATEACCESS))  {                 \
          if (TEST_TRACING(RMT,major)) {             \
             MMEMajorMinor = ((major << 8) | minor); \
             WRITE_MAJMNR_CODES (MMEMajorMinor)      \
             WRITE_ASCIIZ_STRING(str)                \
          }                                          \
       }


  //
  //
  // Plug and Play macro.
  //
  //


  #define SET_TIMER_HOOK_NAME( major , minor )        \
           MMEMajorMinor = (USHORT) ( ((USHORT)minor) | (((USHORT)major)<<8) );
   //      MMEMajorMinor = MAKEUSHORT( minor, major );


   //
   //
   //  Concat Two Words worth of data into required data format
   //
   //

   #define Set_Hook_Data

  //***********************************************************
  //
  //
  //  START_TIMER Sync Macros
  //
  //
  //
  #ifdef INCL_16
      #define Start_Timer_StreamData( major, minor, IdToStream , val )   \
           if ( (VALIDATEACCESS))  {                     \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( sizeof( ULONG ) )    \
                 WRITE_DWORDFROM2WORD(IdToStream, val)   \
           }                                             \
              Call_RAS16SysTrace(major,minor,(ULONG)IdToStream,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);

      #define Start_Timer_2Word( major, minor, word1 , word2 )   \
           if ( (VALIDATEACCESS))  {                     \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( sizeof( ULONG ) )    \
                 WRITE_DWORDFROM2WORD( word1 , word2 )   \
           }                                             \
              Call_RAS16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);

      #define Start_Timer_3Word( major, minor, word1 , word2, word3 )   \
           if ( (VALIDATEACCESS))  {                     \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( (2 * sizeof(ULONG)) )\
                 WRITE_DWORDFROM2WORD( word1 , word2 )   \
                 WRITE_DWORDFROM2WORD( word3, 0 )        \
           }                                             \
              Call_RAS16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)NULL,(ULONG)NULL);

      #define Start_Timer_4Word( major, minor, word1 , word2, word3, word4 )   \
           if ( (VALIDATEACCESS))  {                     \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( (2 * sizeof(ULONG)) )\
                 WRITE_DWORDFROM2WORD( word1 , word2 )   \
                 WRITE_DWORDFROM2WORD( word3, word4 )    \
           }                                             \
              Call_RAS16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)word4,(ULONG)NULL);

      #define Start_Timer_5Word( major, minor, word1, word2, word3, word4, word5 )   \
           if ( (VALIDATEACCESS))  {                     \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( (2 * sizeof(ULONG)) )\
                 WRITE_DWORDFROM2WORD( word1 , word2 )   \
                 WRITE_DWORDFROM2WORD( word3, 0 )        \
           }                                             \
              Call_RAS16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)word4,(ULONG)word5);

      #define Start_Timer_DWord( major, minor, val )     \
           if ( (VALIDATEACCESS))  {                 \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( sizeof( ULONG ) )    \
                 WRITE_DWORD_VALUE(val)                  \
           }                                             \
              Call_RAS16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);


      #define Start_Timer_Word( major, minor, val )      \
           if ( (VALIDATEACCESS))  {                 \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES ( MMEMajorMinor)     \
                 WRITE_DATA_LENGTH( sizeof( USHORT ) )   \
                 WRITE_WORD_VALUE(val)                   \
           }                                             \
              Call_RAS16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);


      #define Start_Timer_Byte( major, minor, val )      \
           if ( (VALIDATEACCESS))  {                 \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_BYTE_VALUE(val)                   \
           }                                             \
              Call_RAS16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);


      #define Start_Timer_String( major, minor, val )    \
           if ( (VALIDATEACCESS))  {                 \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_ASSCIZ_STRING(val)                \
           }                                             \
              Call_RAS16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
  #else
      // #ifdef INCL_32
      #define Start_Timer_StreamData( major, minor, IdToStream , val )   \
           if ( (VALIDATEACCESS))  {                     \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( sizeof( ULONG ) )    \
                 WRITE_DWORDFROM2WORD(IdToStream, val)   \
           }                                             \
              Call_Dos16SysTrace(major,minor,(ULONG)IdToStream,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);

      #define Start_Timer_2Word( major, minor, word1 , word2 )   \
           if ( (VALIDATEACCESS))  {                     \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( sizeof( ULONG ) )    \
                 WRITE_DWORDFROM2WORD( word1 , word2 )   \
           }                                             \
              Call_Dos16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);

      #define Start_Timer_3Word( major, minor, word1 , word2, word3 )   \
           if ( (VALIDATEACCESS))  {                     \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( (2 * sizeof(ULONG)) )\
                 WRITE_DWORDFROM2WORD( word1 , word2 )   \
                 WRITE_DWORDFROM2WORD( word3, 0 )        \
           }                                             \
              Call_Dos16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)NULL,(ULONG)NULL);

      #define Start_Timer_4Word( major, minor, word1 , word2, word3, word4 )   \
           if ( (VALIDATEACCESS))  {                     \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( (2 * sizeof(ULONG)) )\
                 WRITE_DWORDFROM2WORD( word1 , word2 )   \
                 WRITE_DWORDFROM2WORD( word3, word4 )    \
           }                                             \
              Call_Dos16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)word4,(ULONG)NULL);

      #define Start_Timer_5Word( major, minor, word1, word2, word3, word4, word5 )   \
           if ( (VALIDATEACCESS))  {                     \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( (2 * sizeof(ULONG)) )\
                 WRITE_DWORDFROM2WORD( word1 , word2 )   \
                 WRITE_DWORDFROM2WORD( word3, 0 )        \
           }                                             \
              Call_Dos16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)word4,(ULONG)word5);

      #define Start_Timer_DWord( major, minor, val )     \
           if ( (VALIDATEACCESS))  {                 \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( sizeof( ULONG ) )    \
                 WRITE_DWORD_VALUE(val)                  \
           }                                             \
              Call_Dos16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);


      #define Start_Timer_Word( major, minor, val )      \
           if ( (VALIDATEACCESS))  {                 \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES ( MMEMajorMinor)     \
                 WRITE_DATA_LENGTH( sizeof( USHORT ) )   \
                 WRITE_WORD_VALUE(val)                   \
           }                                             \
              Call_Dos16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);


      #define Start_Timer_Byte( major, minor, val )      \
           if ( (VALIDATEACCESS))  {                 \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_BYTE_VALUE(val)                   \
           }                                             \
              Call_Dos16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);


      #define Start_Timer_String( major, minor, val )    \
           if ( (VALIDATEACCESS))  {                 \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_ASSCIZ_STRING(val)                \
           }                                             \
              Call_Dos16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
  #endif

  //***********************************************************
  //
  //
  //  STOP_TIMER Sync Macros
  //
  //
  //
  #ifdef INCL_16
      #define Stop_Timer_StreamData( major, minor, IdToStream , val )   \
           if ( (VALIDATEACCESS))  {                     \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( sizeof( ULONG ) )    \
                 WRITE_DWORDFROM2WORD(IdToStream, val)   \
           }                                             \
              Call_RAS16SysTrace(major,minor,(ULONG)IdToStream,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);


      #define Stop_Timer_2Word( major, minor, word1 , word2 )  \
           if ( (VALIDATEACCESS))  {                     \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( sizeof( ULONG ) )    \
                 WRITE_DWORDFROM2WORD( word1 , word2 )   \
           }                                             \
              Call_RAS16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);


      #define Stop_Timer_3Word( major, minor, word1 , word2, word3 )   \
           if ( (VALIDATEACCESS))  {                     \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( (2 * sizeof(ULONG)) )\
                 WRITE_DWORDFROM2WORD( word1 , word2 )   \
                 WRITE_DWORDFROM2WORD( word3, 0 )        \
           }                                             \
              Call_RAS16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)NULL,(ULONG)NULL);


      #define Stop_Timer_4Word( major, minor, word1 , word2, word3, word4 )   \
           if ( (VALIDATEACCESS))  {                     \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( (2 * sizeof(ULONG)) )\
                 WRITE_DWORDFROM2WORD( word1 , word2 )   \
                 WRITE_DWORDFROM2WORD( word3, word4 )    \
           }                                             \
              Call_RAS16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)word4,(ULONG)NULL);


      #define Stop_Timer_5Word( major, minor, word1, word2, word3, word4, word5 )   \
           if ( (VALIDATEACCESS))  {                     \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( (2 * sizeof(ULONG)) )\
                 WRITE_DWORDFROM2WORD( word1 , word2 )   \
                 WRITE_DWORDFROM2WORD( word3, 0 )        \
           }                                             \
              Call_RAS16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)word4,(ULONG)word5);


      #define Stop_Timer_DWord( major, minor, val )      \
           if ( (VALIDATEACCESS))  {                 \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( sizeof(ULONG) )      \
                 WRITE_DWORD_VALUE(val)                  \
           }                                             \
              Call_RAS16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);


      #define Stop_Timer_Word( major, minor, val )       \
           if ( (VALIDATEACCESS))  {                 \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES(MMEMajorMinor)       \
                 WRITE_DATA_LENGTH(sizeof(USHORT))       \
                 WRITE_WORD_VALUE(val)                   \
           }                                             \
              Call_RAS16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);


      #define Stop_Timer_Byte( major, minor, val )       \
           if ( (VALIDATEACCESS))  {                 \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_BYTE_VALUE(val)                   \
           }                                             \
              Call_RAS16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);


      #define Stop_Timer_String( major, minor, val )     \
           if ( (VALIDATEACCESS))  {                 \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_ASCIIZ_STRING(val)                \
           }                                             \
              Call_RAS16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
  #else
      // #ifdef INCL_32
      #define Stop_Timer_StreamData( major, minor, IdToStream , val )   \
           if ( (VALIDATEACCESS))  {                     \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( sizeof( ULONG ) )    \
                 WRITE_DWORDFROM2WORD(IdToStream, val)   \
           }                                             \
              Call_Dos16SysTrace(major,minor,(ULONG)IdToStream,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);


      #define Stop_Timer_2Word( major, minor, word1 , word2 )  \
           if ( (VALIDATEACCESS))  {                     \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( sizeof( ULONG ) )    \
                 WRITE_DWORDFROM2WORD( word1 , word2 )   \
           }                                             \
              Call_Dos16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);


      #define Stop_Timer_3Word( major, minor, word1 , word2, word3 )   \
           if ( (VALIDATEACCESS))  {                     \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( (2 * sizeof(ULONG)) )\
                 WRITE_DWORDFROM2WORD( word1 , word2 )   \
                 WRITE_DWORDFROM2WORD( word3, 0 )        \
           }                                             \
              Call_Dos16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)NULL,(ULONG)NULL);


      #define Stop_Timer_4Word( major, minor, word1 , word2, word3, word4 )   \
           if ( (VALIDATEACCESS))  {                     \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( (2 * sizeof(ULONG)) )\
                 WRITE_DWORDFROM2WORD( word1 , word2 )   \
                 WRITE_DWORDFROM2WORD( word3, word4 )    \
           }                                             \
              Call_Dos16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)word4,(ULONG)NULL);


      #define Stop_Timer_5Word( major, minor, word1, word2, word3, word4, word5 )   \
           if ( (VALIDATEACCESS))  {                     \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( (2 * sizeof(ULONG)) )\
                 WRITE_DWORDFROM2WORD( word1 , word2 )   \
                 WRITE_DWORDFROM2WORD( word3, 0 )        \
           }                                             \
              Call_Dos16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)word4,(ULONG)word5);


      #define Stop_Timer_DWord( major, minor, val )      \
           if ( (VALIDATEACCESS))  {                 \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_DATA_LENGTH( sizeof(ULONG) )      \
                 WRITE_DWORD_VALUE(val)                  \
           }                                             \
              Call_Dos16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);


      #define Stop_Timer_Word( major, minor, val )       \
           if ( (VALIDATEACCESS))  {                 \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES(MMEMajorMinor)       \
                 WRITE_DATA_LENGTH(sizeof(USHORT))       \
                 WRITE_WORD_VALUE(val)                   \
           }                                             \
              Call_Dos16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);


      #define Stop_Timer_Byte( major, minor, val )       \
           if ( (VALIDATEACCESS))  {                 \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_BYTE_VALUE(val)                   \
           }                                             \
              Call_Dos16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);


      #define Stop_Timer_String( major, minor, val )     \
           if ( (VALIDATEACCESS))  {                 \
                 SET_TIMER_HOOK_NAME( major , minor )    \
                 WRITE_MAJMNR_CODES (MMEMajorMinor)      \
                 WRITE_ASCIIZ_STRING(val)                \
           }                                             \
              Call_Dos16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
  #endif

  //
  //     End of HIGHLEVELHOOK STUFF stuff
  //




#else



      //
      //  These are dummy macros, for when MMIOPH isn't defined.
      //  This way the macros can stay put, yet cause no damage
      //  or code to be generated.
      //
      //


      #define InitPTrace()

      #define Write_Dek_Word( major, minor, val )
      #define Write_Dek_DWord( major, minor, val )
      #define Write_Dek_Byte( major, minor, val )
      #define Write_Dek_String( major, minor, str )

      #ifdef INCL_16
         #define Start_Timer_StreamData( major, minor, IdToStream , val )                 \
          Call_RAS16SysTrace(major,minor,(ULONG)IdToStream,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
         #define Start_Timer_2Word( major, minor, word1, word2 )                          \
          Call_RAS16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
         #define Start_Timer_3Word( major, minor, word1, word2, word3 )                   \
          Call_RAS16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)NULL,(ULONG)NULL);
         #define Start_Timer_4Word( major, minor, word1, word2, word3, word4)             \
          Call_RAS16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)word4,(ULONG)NULL);
         #define Start_Timer_5Word( major, minor, word1, word2, word3, word4, word5 )     \
          Call_RAS16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)word4,(ULONG)word5);
         #define Start_Timer_DWord( major, minor, val )                                   \
          Call_RAS16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
         #define Start_Timer_Word( major, minor, val )                                    \
          Call_RAS16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
         #define Start_Timer_Byte( major, minor, val )                                    \
          Call_RAS16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
         #define Start_Timer_String( major, minor, val )                                  \
          Call_RAS16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);

         #define Stop_Timer_StreamData( major, minor, IdToStream , val )                  \
          Call_RAS16SysTrace(major,minor,(ULONG)IdToStream,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
         #define Stop_Timer_5Word( major, minor, word1, word2, word3, word4, word5 )      \
          Call_RAS16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)word4,(ULONG)word5);
         #define Stop_Timer_4Word( major, minor, word1, word2, word3, word4 )             \
          Call_RAS16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)word4,(ULONG)NULL);
         #define Stop_Timer_3Word( major, minor, word1, word2, word3 )                    \
          Call_RAS16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)NULL,(ULONG)NULL);
         #define Stop_Timer_2Word( major, minor, word1, word2 )                           \
          Call_RAS16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
         #define Stop_Timer_DWord( major, minor, val )                                    \
          Call_RAS16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
         #define Stop_Timer_Word( major, minor, val )                                     \
          Call_RAS16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
         #define Stop_Timer_Byte( major, minor, val )                                     \
          Call_RAS16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
         #define Stop_Timer_String( major, minor, val )                                   \
          Call_RAS16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
      #else
         // #ifdef INCL_32
         #define Start_Timer_StreamData( major, minor, IdToStream , val )                 \
          Call_Dos16SysTrace(major,minor,(ULONG)IdToStream,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
         #define Start_Timer_2Word( major, minor, word1, word2 )                          \
          Call_Dos16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
         #define Start_Timer_3Word( major, minor, word1, word2, word3 )                   \
          Call_Dos16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)NULL,(ULONG)NULL);
         #define Start_Timer_4Word( major, minor, word1, word2, word3, word4 )            \
          Call_Dos16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)word4,(ULONG)NULL);
         #define Start_Timer_5Word( major, minor, word1, word2, word3, word4, word5 )     \
          Call_Dos16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)word4,(ULONG)word5);
         #define Start_Timer_DWord( major, minor, val )                                   \
          Call_Dos16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
         #define Start_Timer_Word( major, minor, val )                                    \
          Call_Dos16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
         #define Start_Timer_Byte( major, minor, val )                                    \
          Call_Dos16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
         #define Start_Timer_String( major, minor, val )                                  \
          Call_Dos16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);

         #define Stop_Timer_StreamData( major, minor, IdToStream , val )                  \
          Call_Dos16SysTrace(major,minor,(ULONG)IdToStream,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
         #define Stop_Timer_5Word( major, minor, word1, word2, word3, word4, word5 )      \
          Call_Dos16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)word4,(ULONG)word5);
         #define Stop_Timer_4Word( major, minor, word1, word2, word3, word4 )             \
          Call_Dos16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)word4,(ULONG)NULL);
         #define Stop_Timer_3Word( major, minor, word1, word2, word3 )                    \
          Call_Dos16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)word3,(ULONG)NULL,(ULONG)NULL);
         #define Stop_Timer_2Word( major, minor, word1, word2 )                           \
          Call_Dos16SysTrace(major,minor,(ULONG)word1,(ULONG)word2,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
         #define Stop_Timer_DWord( major, minor, val )                                    \
          Call_Dos16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
         #define Stop_Timer_Word( major, minor, val )                                     \
          Call_Dos16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
         #define Stop_Timer_Byte( major, minor, val )                                     \
          Call_Dos16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
         #define Stop_Timer_String( major, minor, val )                                   \
          Call_Dos16SysTrace(major,minor,(ULONG)val,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL,(ULONG)NULL);
      #endif


      //
      // If not (PTRACE && ( INCL_32 OR INCL_16 )) at all
      //

#endif


