/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************/
/*                                                                          */
/* Module Name: MMSYSTEM.H                                                  */
/*                                                                          */
/* This is the multimedia include file that has the typedefs, defines and   */
/* function prototyes for Media Control Interface of MMPM/2 (tm)            */
/*                                                                          */
/*                                                                          */
/****************************************************************************/
#define MCI_TRUE                        1
#define MCI_FALSE                       0

/*********************************************************************/
/*                                                                   */
/*             MCI command message identifiers                       */
/*                                                                   */
/*********************************************************************/
#define MCI_OPEN                        1
#define MCI_CLOSE                       2
#define MCI_ESCAPE                      3
#define MCI_PLAY                        4
#define MCI_SEEK                        5
#define MCI_STOP                        6
#define MCI_PAUSE                       7
#define MCI_INFO                        8
#define MCI_GETDEVCAPS                  9
#define MCI_STATUS                      10
#define MCI_SPIN                        11
#define MCI_SET                         12
#define MCI_STEP                        13
#define MCI_RECORD                      14
#define MCI_SYSINFO                     15
#define MCI_SAVE                        16
#define MCI_CUE                         17
#define MCI_UPDATE                      18
#define MCI_SET_CUEPOINT                19
#define MCI_SET_POSITION_ADVISE         20
#define MCI_SET_SYNC_OFFSET             21
#define MCI_LOAD                        22
#define MCI_ACQUIREDEVICE               23
#define MCI_RELEASEDEVICE               24
#define MCI_MASTERAUDIO                 25
#define MCI_GETTOC                      26
#define MCI_DEVICESETTINGS              27
#define MCI_CONNECTOR                   28
#define MCI_RESUME                      29
#define MCI_CONNECTORINFO               31
#define MCI_DEFAULT_CONNECTION          32
#define MCI_CONNECTION                  33
#define MCI_GROUP                       34

   /*************************************************/
   /* MCI command message identifiers reserved for  */
   /*  Digital Video and Video Overlay              */
   /*************************************************/

#define MCI_CAPTURE                     40
#define MCI_FREEZE                      41
#define MCI_GETIMAGEBUFFER              42
#define MCI_GETIMAGEPALETTE             43
#define MCI_PUT                         44
#define MCI_REALIZE                     45
#define MCI_REWIND                      46
#define MCI_RESTORE                     47
#define MCI_SETIMAGEBUFFER              48
#define MCI_SETIMAGEPALETTE             49
#define MCI_UNFREEZE                    50
#define MCI_WHERE                       51
#define MCI_WINDOW                      52

#define MCI_DELETE                      53
#define MCI_CUT                         54
#define MCI_PASTE                       55
#define MCI_COPY                        56
#define MCI_REDO                        57
#define MCI_UNDO                        58
#define MCI_MIXNOTIFY                   59
#define MCI_SETTUNER                    60
#define MCI_MAX_COMMAND                 60

#define RECT                            DWORD
#define HDCT                            DWORD
/*********************************************************************/
/* this and all subsequent message ID's are reserved for the user    */
/*********************************************************************/
#define MCI_USER_MESSAGES               2000

/*********************************************************************/
/* Special Device ID for "all"                                       */
/*********************************************************************/
#define MCI_ALL_DEVICE_ID               0xFFFF

/*********************************************************************/
/* MCI implementation limits                                         */
/*********************************************************************/
#define MAX_DEVICE_NAME                 20
#define MAX_ALIAS_NAME                  20
#define MAX_PRODINFO                    40
#define MAX_EXTENSION_NAME              4
#define MAX_DEV_PARAMS                  128
#define MAX_VERSION_NUMBER              6
#define MAX_PDD_NAME                    9
#define MAX_DLL_NAME                    260
#define MAX_CLASSES                     10
#define MAX_CONNECTORS                  10
#define MAX_EXTENSIONS                  25
#define MAX_TYPEBUFFER                  256

#ifdef INCL_32
/*********************************************************************/
/* MCI Device Type Constants                                         */
/*********************************************************************/
#define MCI_DEVTYPE_VIDEOTAPE           1
#define MCI_DEVTYPE_VIDEODISC           2
#define MCI_DEVTYPE_CD_AUDIO            3
#define MCI_DEVTYPE_DAT                 4
#define MCI_DEVTYPE_AUDIO_TAPE          5
#define MCI_DEVTYPE_OTHER               6
#define MCI_DEVTYPE_WAVEFORM_AUDIO      7
#define MCI_DEVTYPE_SEQUENCER           8
#define MCI_DEVTYPE_AUDIO_AMPMIX        9
#define MCI_DEVTYPE_OVERLAY             10
#define MCI_DEVTYPE_ANIMATION           11
#define MCI_DEVTYPE_DIGITAL_VIDEO       12
#define MCI_DEVTYPE_SPEAKER             13
#define MCI_DEVTYPE_HEADPHONE           14
#define MCI_DEVTYPE_MICROPHONE          15
#define MCI_DEVTYPE_MONITOR             16
#define MCI_DEVTYPE_CDXA                17

/*********************************************************************/
/* MCI Device Type Names                                             */
/*********************************************************************/
#define MCI_DEVTYPE_VIDEOTAPE_NAME          "Videotape"
#define MCI_DEVTYPE_VIDEODISC_NAME          "Videodisc"
#define MCI_DEVTYPE_CD_AUDIO_NAME           "CDaudio"
#define MCI_DEVTYPE_DAT_NAME                "DAT"
#define MCI_DEVTYPE_AUDIO_TAPE_NAME         "Audiotape"
#define MCI_DEVTYPE_OTHER_NAME              "Other"
#define MCI_DEVTYPE_WAVEFORM_AUDIO_NAME     "Waveaudio"
#define MCI_DEVTYPE_SEQUENCER_NAME          "Sequencer"
#define MCI_DEVTYPE_AUDIO_AMPMIX_NAME       "Ampmix"
#define MCI_DEVTYPE_OVERLAY_NAME            "Overlay"
#define MCI_DEVTYPE_ANIMATION_NAME          "Animation"
#define MCI_DEVTYPE_DIGITAL_VIDEO_NAME      "Digitalvideo"
#define MCI_DEVTYPE_SPEAKER_NAME            "Speaker"
#define MCI_DEVTYPE_HEADPHONE_NAME          "Headphone"
#define MCI_DEVTYPE_MICROPHONE_NAME         "Microphone"
#define MCI_DEVTYPE_MONITOR_NAME            "Monitor"
#define MCI_DEVTYPE_CDXA_NAME               "CDXA"

#define MCI_MAX_SYSTEM_DEVICE_NAMES         17

#endif                       /* INCL_32 */

/*********************************************************************/
/* Getdevcaps, set, and status item base values                      */
/*********************************************************************/

#define MCI_AMP_ITEM_BASE                   0x00001000L
#define MCI_CD_ITEM_BASE                    0x00002000L
#define MCI_CDXA_ITEM_BASE                  0x00003000L
#define MCI_VD_ITEM_BASE                    0x00004000L
#define MCI_SEQ_ITEM_BASE                   0x00005000L
#define MCI_WAVE_ITEM_BASE                  0x00006000L
#define MCI_VID_ITEM_BASE                   0x00007000L
#define MCI_DGV_ITEM_BASE                   0x00008000L
#define MCI_OVLY_ITEM_BASE                  0x00009000L

/*********************************************************************/
/* Flags for mciDriverNotify                                         */
/*********************************************************************/
#define MCI_NOTIFY_SUCCESSFUL               0x0000
#define MCI_NOTIFY_SUPERSEDED               0x0001
#define MCI_NOTIFY_ABORTED                  0x0002
#define MCI_NOTIFY_ERROR                    0x0003

/*********************************************************************/
/* mciDriverNotify  Message Types                                    */
/*********************************************************************/
#define MM_MCINOTIFY                        0x0500
#define MM_MCIPASSDEVICE                    0x0501
#define MM_MCIPOSITIONCHANGE                0x0502
#define MM_MCICUEPOINT                      0x0503
#define MM_MCIPLAYLISTMESSAGE               0x0504
#define MM_MCIEVENT                         0x0505
#define MM_MCISYNCH                         0x0506

#define MCI_LOSING_USE                      0x00000001L
#define MCI_GAINING_USE                     0x00000002L

/*********************************************************************/
/* Common message flags                                              */
/*     0x000000XX are reserved for common flags                      */
/*********************************************************************/
#define MCI_NOTIFY                          0x00000001L
#define MCI_WAIT                            0x00000002L
#define MCI_FROM                            0x00000004L
#define MCI_TO                              0x00000008L
#define MCI_MILLISECONDS                    0x00000010L
#define MCI_TRACK                           0x00000020L
#define MCI_OVER                            0x00000040L
#define MCI_TEST                            0x00000080L
#define MCI_TO_BUFFER                       0x00000100L
#define MCI_FROM_BUFFER                     0x00000200L
#define MCI_CONVERT_FORMAT                  0x00000400L


/*********************************************************************/
/* Time formats                                                      */
/*********************************************************************/
#define MCI_FORMAT_MILLISECONDS             0x00000001L
#define MCI_FORMAT_MMTIME                   0x00000002L
#define MCI_FORMAT_MSF                      0x00000005L
#define MCI_FORMAT_TMSF                     0x00000006L
#define MCI_FORMAT_CHAPTERS                 0x00000007L
#define MCI_FORMAT_FRAMES                   0x00000008L
#define MCI_FORMAT_HMS                      0x00000009L
#define MCI_FORMAT_TRACKS                   0x0000000AL
#define MCI_FORMAT_BYTES                    0x0000000BL
#define MCI_FORMAT_SAMPLES                  0x0000000CL
#define MCI_FORMAT_HMSF                     0x0000000DL
#define MCI_FORMAT_SET_SMPTE_24             0x0000000EL
#define MCI_FORMAT_SET_SMPTE_25             0x0000000FL
#define MCI_FORMAT_SET_SMPTE_30             0x00000010L
#define MCI_FORMAT_SET_SMPTE_30DROP         0x00000011L
#define MCI_FORMAT_SET_SONGPTR              0x00000012L
#define MCI_FORMAT_USEC                     0x00000013L

/*********************************************************************/
/* Speed formats                                                     */
/*********************************************************************/
#define MCI_FORMAT_PERCENTAGE               0x00000003L
#define MCI_FORMAT_FPS                      0x00000004L


/*********************************************************************/
/*                                                                   */
/*  Time format conversions macros                                   */
/*                                                                   */
/*********************************************************************/
#define MSECTOMM(value)      (((value) > (0xFFFFFFFF /3)) ? 0L : \
                              ((value) * 3))

#define MSECFROMMM(value)    (((value)+1) / 3)

#define REDBOOKTOMM(value)   ((((value) & 0x000000FF) * 60 * 3000) + \
                              (((value) & 0x0000FF00) / 0x100 * 3000) + \
                              (((value) & 0x00FF0000) / 0x10000 * 3000/75))

#define FPS24TOMM(value) ((((value) & 0x000000FF) * 60 * 60 * 3000) + \
                          (((value) & 0x0000FF00) / 0x100 * 60 * 3000) + \
                          (((value) & 0x00FF0000) / 0x10000 * 3000) + \
                          (((value) & 0xFF000000) / 0x1000000 * 3000/24))

#define FPS25TOMM(value) ((((value) & 0x000000FF) * 60 * 60 * 3000) + \
                          (((value) & 0x0000FF00) / 0x100 * 60 * 3000) + \
                          (((value) & 0x00FF0000) / 0x10000 * 3000) + \
                          (((value) & 0xFF000000) / 0x1000000 * 3000/25))

#define FPS30TOMM(value) ((((value) & 0x000000FF) * 60 * 60 * 3000) + \
                          (((value) & 0x0000FF00) / 0x100 * 60 * 3000) + \
                          (((value) & 0x00FF0000) / 0x10000 * 3000) + \
                          (((value) & 0xFF000000) / 0x1000000 * 3000/30))

#define HMSTOMM(value)   ((((value) & 0x000000FF) * 60 * 60 * 3000) + \
                          (((value) & 0x0000FF00) / 0x100 * 60 * 3000) + \
                          (((value) & 0x00FF0000) / 0x10000 * 3000))


  /* The +20 is used for rounding purposes.  It is derived by:           */
  /*   1/2 * ((300 MMTIME/SEC / (75 FRAMES/SEC)) = 20 MMTIME/HALF-FRAME  */
#define REDBOOKFROMMM(value) ((((value)+20) >= 0x100*60*3000) ? 0L : \
                              ((((value)+20) / (60*3000)) + \
                               (((value)+20) % (60*3000) / 3000 << 8) + \
                               (((value)+20) / (3000/75) % 75 << 16)))

#define FPS24FROMMM(value) ((((value)+63) >= 0x100*60*60*3000) ? 0L : \
                        (((((((value)+63) % 3000)/(3000/24)) << 24) & 0xFF000000) | \
                         ((((((value)+63) / 3000) % 60) << 16) & 0x00FF0000)      | \
                        (((((((value)+63) / 3000) / 60) % 60) << 8) & 0x0000FF00) | \
                         ((((((value)+63) / 3000) / 60) / 60)  & 0x000000FF)))

#define FPS25FROMMM(value) ((((value)+60) >= 0x100*60*60*3000) ? 0L : \
                        (((((((value)+60) % 3000)/(3000/25)) << 24) & 0xFF000000) | \
                         ((((((value)+60) / 3000) % 60) << 16) & 0x00FF0000)      | \
                        (((((((value)+60) / 3000) / 60) % 60) << 8) & 0x0000FF00) | \
                         ((((((value)+60) / 3000) / 60) / 60)  & 0x000000FF)))

#define FPS30FROMMM(value) ((((value)+50) >= 0x100*60*60*3000) ? 0L : \
                        (((((((value)+50) % 3000)/(3000/30)) << 24) & 0xFF000000) | \
                         ((((((value)+50) / 3000) % 60) << 16) & 0x00FF0000)      | \
                        (((((((value)+50) / 3000) / 60) % 60) << 8) & 0x0000FF00) | \
                         ((((((value)+50) / 3000) / 60) / 60)  & 0x000000FF)))

#define HMSFROMMM(value) ((((value)+50) >= 0x100*60*60*3000) ? 0L : \
                        (((((((value)+50) / 3000) % 60) << 16) & 0x00FF0000)      | \
                        (((((((value)+50) / 3000) / 60) % 60) << 8) & 0x0000FF00) | \
                         ((((((value)+50) / 3000) / 60) / 60)  & 0x000000FF)))

#define TMSF_TRACK(time)     (*(BYTE *)(&(time)))
#define TMSF_MINUTE(time)    (*((BYTE *)(&(time))+1))
#define TMSF_SECOND(time)    (*((BYTE *)(&(time))+2))
#define TMSF_FRAME(time)     (*((BYTE *)(&(time))+3))
#define MSF_MINUTE(time)     (*(BYTE *)(&(time)))
#define MSF_SECOND(time)     (*((BYTE *)(&(time))+1))
#define MSF_FRAME(time)      (*((BYTE *)(&(time))+2))

/*********************************************************************/
/*                                                                   */
/*  BYTE ACCESS WITH A DWORD MACROS                                  */
/*                                                                   */
/*********************************************************************/
#define DWORD_LWLB(dw)    (*(BYTE *)((DWORD *)(&dw)))     /* Low  Word Low Byte  */
#define DWORD_LWHB(dw)    (*((BYTE *)((DWORD *)(&dw))+1)) /* Low  Word High Byte */
#define DWORD_HWLB(dw)    (*((BYTE *)((DWORD *)(&dw))+2)) /* High Word Low Byte  */
#define DWORD_HWHB(dw)    (*((BYTE *)((DWORD *)(&dw))+3)) /* High Word High Byte */
#define DWORD_LOWD(dw)    (*(WORD *)((DWORD *)(&dw)))     /* Low  Word           */
#define DWORD_HIWD(dw)    (*((WORD *)((DWORD *)(&dw))+1)) /* High Word           */

#ifdef INCL_32

#pragma pack(1)

/*********************************************************************/
/* parameters for default command messages with empty parameter lists*/
/*********************************************************************/
typedef struct _MCI_GENERIC_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message */
} MCI_GENERIC_PARMS;
typedef MCI_GENERIC_PARMS   *LPMCI_GENERIC_PARMS;


/*********************************************************************/
/* flags for the MCI_ACQUIREDEVICE message                           */
/*     0x00000X00 are reserved for MCI_ACQUIREDEVICE flags           */
/*********************************************************************/
#define MCI_EXCLUSIVE                       0x00000100L
#define MCI_EXCLUSIVE_INSTANCE              0x00000200L
#define MCI_ACQUIRE_QUEUE                   0x00000400L


/*********************************************************************/
/* flags for the MCI_CAPTURE message                                 */
/*     0x0000XX00 are reserved for MCI_CAPTURE flags                 */
/*     MCI_CONVERT is used by MCI_GETIMAGEBUFFER, MCI_SETIMAGEBUFFER */
/*                            MCI_CAPTURE, and MCI_RESTORE           */
/*********************************************************************/
#define MCI_CAPTURE_RECT                    0x00000100L
#define MCI_CONVERT                         0x00001000L

/*********************************************************************/
/* parameter structure for the MCI_CAPTURE message                   */
/*********************************************************************/
typedef struct _MCI_CAPTURE_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message */
    RECTL   rect;            /* Rectangle array specifying the area to  */
                             /* be captured                             */
} MCI_CAPTURE_PARMS;
typedef MCI_CAPTURE_PARMS   *LPMCI_CAPTURE_PARMS;


/*********************************************************************/
/* flags for MCI_CONNECTOR and MCI_CONNECTION messages               */
/*********************************************************************/
#define MCI_ENABLE_CONNECTOR                0x00000100L
#define MCI_DISABLE_CONNECTOR               0x00000200L
#define MCI_QUERY_CONNECTOR_STATUS          0x00000400L
#define MCI_CONNECTOR_TYPE                  0x00000800L
#define MCI_CONNECTOR_INDEX                 0x00001000L
#define MCI_TO_CONNECTOR_INDEX              0x00002000L
#define MCI_TO_CONNECTOR_TYPE               0x00004000L
#define MCI_QUERY_CONNECTION                0x00008000L
#define MCI_MAKE_CONNECTION                 0x00010000L
#define MCI_BREAK_CONNECTION                0x00020000L
#define MCI_ENUMERATE_CONNECTORS            0x00040000L
#define MCI_QUERY_CONNECTOR_TYPE            0x00080000L
#define MCI_QUERY_VALID_CONNECTION          0x00100000L
#define MCI_CONNECTOR_ALIAS                 0x00200000L


/*********************************************************************/
/* Connector types                                                   */
/*********************************************************************/
#define MCI_MIDI_STREAM_CONNECTOR           0x00000001L
#define MCI_CD_STREAM_CONNECTOR             0x00000002L
#define MCI_WAVE_STREAM_CONNECTOR           0x00000003L
#define MCI_AMP_STREAM_CONNECTOR            0x00000004L
#define MCI_XA_STREAM_CONNECTOR             0x00000005L
#define MCI_HEADPHONES_CONNECTOR            0x00000006L
#define MCI_SPEAKERS_CONNECTOR              0x00000007L
#define MCI_MICROPHONE_CONNECTOR            0x00000008L
#define MCI_LINE_IN_CONNECTOR               0x00000009L
#define MCI_LINE_OUT_CONNECTOR              0x0000000aL
#define MCI_VIDEO_IN_CONNECTOR              0x0000000bL
#define MCI_VIDEO_OUT_CONNECTOR             0x0000000cL
#define MCI_PHONE_SET_CONNECTOR             0x0000000dL
#define MCI_PHONE_LINE_CONNECTOR            0x0000000eL
#define MCI_AUDIO_IN_CONNECTOR              0x0000000fL
#define MCI_AUDIO_OUT_CONNECTOR             0x00000010L
#define MCI_UNIVERSAL_CONNECTOR             0x00000011L
#define MCI_INTERNAL_AUDIO_CONNECTOR        0x00000012L
#define MCI_MIDI_IN_CONNECTOR               0x00000013L
#define MCI_MIDI_OUT_CONNECTOR              0x00000014L
#define MCI_NULL_CONNECTOR                  0x00000015L

/*********************************************************************/
/* parameter structure for the MCI_CONNECTION message                */
/*********************************************************************/
typedef struct _MCI_CONNECTION_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message */
    DWORD   dwConnectorType; /* Connector type                          */
    DWORD   dwConnectorIndex;/* Connector index                         */
    LPSTR   lpstrAlias;      /* Connection device alias                 */
    WORD    wToDeviceID;     /* Connected to device ID                  */
    WORD    wReserved0;      /* Reserved field                          */
    DWORD   dwReserved1;     /* Reserved field                          */
    DWORD   dwReserved2;     /* Reserved field                          */
} MCI_CONNECTION_PARMS;
typedef MCI_CONNECTION_PARMS   *LPMCI_CONNECTION_PARMS;

/*********************************************************************/
/* parameter structure for the MCI_CONNECTOR message                 */
/*********************************************************************/
typedef struct _MCI_CONNECTOR_PARMS {
    DWORD  dwCallback;       /* PM window handle for MCI notify message    */
    DWORD  dwReturn;         /* Return information                         */
    DWORD  dwConnectorType;  /* If specified, dwConnectorIndex is relative */
                             /* to the specified connector type            */
    DWORD  dwConnectorIndex; /* Connector number                           */
} MCI_CONNECTOR_PARMS;
typedef MCI_CONNECTOR_PARMS   *LPMCI_CONNECTOR_PARMS;

/*********************************************************************/
/* parameter structure for the MCI_CONNECTORINFO message             */
/*********************************************************************/
typedef struct _MCI_CONNECTORINFO_PARMS {
    DWORD  dwCallback;       /* PM window handle for MCI notify message    */
    DWORD  dwReturn;         /* Return information                         */
    DWORD  dwDeviceTypeID;   /* MCI device type                            */
    DWORD  dwConnectorType;  /* If specified, dwConnectorIndex is relative */
                             /* to the specified connector type            */
    DWORD  dwConnectorIndex; /* Connector number                           */
    DWORD  dwToConnectorType;   /* Connector type to test if               */
                                /* MCI_QUERY_VALID_CONNECTION is specified */
} MCI_CONNECTORINFO_PARMS;
typedef MCI_CONNECTORINFO_PARMS   *LPMCI_CONNECTORINFO_PARMS;

/*********************************************************************/
/* flags for the MCI_CUE message                                     */
/*     0x00000x00 are reserved for MCI_CUE flags                     */
/*********************************************************************/
#define MCI_CUE_INPUT                       0x00000100L
#define MCI_CUE_OUTPUT                      0x00000200L

    /*************************************************/
    /* Additional flags for Wave Audio for MCI_CUE   */
    /*************************************************/
#define MCI_WAVE_INPUT                      0x00001000L
#define MCI_WAVE_OUTPUT                     0x00002000L


/*********************************************************************/
/* parameter structure for the MCI_DEFAULT_CONNECTION message        */
/*********************************************************************/
typedef struct _MCI_DEFAULT_CONNECTION_PARMS {
    DWORD dwCallback;        /* PM window handle for MCI notify message    */
    PSZ   pszDevice;         /* Device name                                */
    DWORD dwConnectorType;   /* If specified, dwConnectorIndex is relative */
                             /* to the specified connector type            */
    DWORD dwConnectorIndex;  /* Connector number                           */
    PSZ   pszToDevice;       /* Return device name to which the connection */
                             /* exists                                     */
    DWORD dwToConnectorType; /* Connector type                             */
    DWORD dwToConnectorIndex;   /* Connector number                        */
} MCI_DEFAULT_CONNECTION_PARMS;
typedef MCI_DEFAULT_CONNECTION_PARMS   *LPMCI_DEFAULT_CONNECTION_PARMS;

/*********************************************************************/
/* parameter structure for the MCI_DEVICESETTINGS message            */
/*********************************************************************/
typedef struct _MCI_DEVICESETTINGS_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message    */
    HWND    hwndNotebook;    /* Hwhd to notebook window                    */
    USHORT  usDeviceType;    /* Device type                                */
    PSZ     pszDeviceName;   /* Device name                                */
} MCI_DEVICESETTINGS_PARMS;
typedef MCI_DEVICESETTINGS_PARMS   *LPMCI_DEVICESETTINGS_PARMS;

/**********************************************************************/
/* parameter structure for the MCI_CUT / COPY / DELETE / UNDO / etc...*/
/**********************************************************************/
typedef struct _MCI_EDIT_PARMS {
    ULONG   ulCallback;      /* PM window handle for MCI notify message     */
    ULONG   ulStructLen;     /* Length of the Structure                     */
    ULONG   ulFrom;          /* Beginning Point of Range                    */
    ULONG   ulTo;            /* ending point of range                       */
    PVOID   pBuff;           /* user buffer                                 */
    ULONG   ulBufLen;        /* length of user buffer                       */
    PVOID   pHeader;         /* header which describes the buffer           */
} MCI_EDIT_PARMS;
typedef MCI_EDIT_PARMS   *PMCI_EDIT_PARMS;

/*********************************************************************/
/* flags and parameter structure for the MCI_ESCAPE message          */
/*     0x00000X00 are reserved for MCI_ESCAPE flags                  */
/*********************************************************************/
#define MCI_ESCAPE_STRING                   0x00000100L

typedef struct _MCI_ESCAPE_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message    */
    LPSTR   lpstrCommand;    /* Command to send to the device              */
} MCI_ESCAPE_PARMS;
typedef MCI_ESCAPE_PARMS   *LPMCI_ESCAPE_PARMS;

/*********************************************************************/
/* flags for the MCI_FREEZE message                                  */
/*     0x0000XX00 are reserved for MCI_FREEZE flags                  */
/*********************************************************************/
#define MCI_OVLY_FREEZE_RECT                0x00000100L
#define MCI_OVLY_FREEZE_RECT_OUTSIDE        0x00000200L

/*********************************************************************/
/* flags for the MCI_GETDEVCAPS message                              */
/*     0x00XXXX00 are reserved for MCI_GETDEVCAPS flags              */
/*********************************************************************/
#define MCI_GETDEVCAPS_MESSAGE              0x00000100L
#define MCI_GETDEVCAPS_ITEM                 0x00000200L
#define MCI_GETDEVCAPS_EXTENDED             0x00000400L

   /*************************************************/
   /* General MCI_GETDEVCAPS item values            */
   /*************************************************/
#define MCI_GETDEVCAPS_CAN_EJECT            0x00000001L
#define MCI_GETDEVCAPS_CAN_LOCKEJECT        0x00000002L
#define MCI_GETDEVCAPS_CAN_PLAY             0x00000003L
#define MCI_GETDEVCAPS_CAN_PROCESS_INTERNAL 0x00000004L
#define MCI_GETDEVCAPS_CAN_RECORD           0x00000005L
#define MCI_GETDEVCAPS_CAN_RECORD_INSERT    0x00000006L
#define MCI_GETDEVCAPS_CAN_SAVE             0x00000007L
#define MCI_GETDEVCAPS_CAN_SETVOLUME        0x00000008L
#define MCI_GETDEVCAPS_CAN_STREAM           0x00000009L
#define MCI_GETDEVCAPS_DEVICE_TYPE          0x0000000AL
#define MCI_GETDEVCAPS_HAS_AUDIO            0x0000000BL
#define MCI_GETDEVCAPS_HAS_VIDEO            0x0000000CL
#define MCI_GETDEVCAPS_PREROLL_TIME         0x0000000DL
#define MCI_GETDEVCAPS_PREROLL_TYPE         0x0000000EL
#define MCI_GETDEVCAPS_USES_FILES           0x0000000FL
#define MCI_GETDEVCAPS_HAS_IMAGE            0x00000010L
#define MCI_GETDEVCAPS_WAVE_FORMAT          0x00000011L

    /***********************************************/
    /* return ID's for videodisc MCI_GETDEVCAPS    */
    /***********************************************/
#define MCI_VD_MEDIA_CLV                    0x00000001L
#define MCI_VD_MEDIA_CAV                    0x00000002L
#define MCI_VD_MEDIA_OTHER                  0x00000003L

    /*************************************************/
    /* MCI_GETDEVCAPS item values for video devices  */
    /*************************************************/
#define MCI_VID_GETDEVCAPS_CAN_STRETCH       MCI_VID_ITEM_BASE
#define MCI_VID_GETDEVCAPS_CAN_DISTORT       (MCI_VID_ITEM_BASE+1)
#define MCI_VID_GETDEVCAPS_VIDEO_X_EXTENT    (MCI_VID_ITEM_BASE+2)
#define MCI_VID_GETDEVCAPS_VIDEO_Y_EXTENT    (MCI_VID_ITEM_BASE+3)
#define MCI_VID_GETDEVCAPS_IMAGE_X_EXTENT    (MCI_VID_ITEM_BASE+4)
#define MCI_VID_GETDEVCAPS_IMAGE_Y_EXTENT    (MCI_VID_ITEM_BASE+5)
#define MCI_VID_GETDEVCAPS_MAX_WINDOWS       (MCI_VID_ITEM_BASE+6)
#define MCI_VID_GETDEVCAPS_CAN_FREEZE        (MCI_VID_ITEM_BASE+7)
#define MCI_VID_GETDEVCAPS_OVERLAY_GRAPHICS  (MCI_VID_ITEM_BASE+8)

#define MCI_VID_GETDEVCAPS_CAN_REVERSE       (MCI_VID_ITEM_BASE+9)
#define MCI_VID_GETDEVCAPS_FAST_RATE         (MCI_VID_ITEM_BASE+10)
#define MCI_VID_GETDEVCAPS_SLOW_RATE         (MCI_VID_ITEM_BASE+11)
#define MCI_VID_GETDEVCAPS_NORMAL_RATE       (MCI_VID_ITEM_BASE+12)
#define MCI_VID_GETDEVCAPS_MINIMUM_RATE      (MCI_VID_ITEM_BASE+13)
#define MCI_VID_GETDEVCAPS_MAXIMUM_RATE      (MCI_VID_ITEM_BASE+14)

    /*************************************************/
    /* MCI_GETDEVCAPS flag values for Videodisc      */
    /*************************************************/
#define MCI_VD_GETDEVCAPS_CLV               0x00000400L
#define MCI_VD_GETDEVCAPS_CAV               0x00000800L

    /*************************************************/
    /* MCI_GETDEVCAPS item values for Videodisc      */
    /*************************************************/

#define MCI_VD_GETDEVCAPS_CAN_REVERSE       MCI_VID_GETDEVCAPS_CAN_REVERSE
#define MCI_VD_GETDEVCAPS_FAST_RATE         MCI_VID_GETDEVCAPS_FAST_RATE
#define MCI_VD_GETDEVCAPS_SLOW_RATE         MCI_VID_GETDEVCAPS_SLOW_RATE
#define MCI_VD_GETDEVCAPS_NORMAL_RATE       MCI_VID_GETDEVCAPS_NORMAL_RATE
#define MCI_VD_GETDEVCAPS_MINIMUM_RATE      MCI_VID_GETDEVCAPS_MINIMUM_RATE
#define MCI_VD_GETDEVCAPS_MAXIMUM_RATE      MCI_VID_GETDEVCAPS_MAXIMUM_RATE

    /************************************************/
    /* MCI_GETDEVCAPS item values for Digital Video */
    /************************************************/
#define MCI_DGV_GETDEVCAPS_CAN_REVERSE      MCI_VID_GETDEVCAPS_CAN_REVERSE
#define MCI_DGV_GETDEVCAPS_CAN_STRETCH      MCI_VID_GETDEVCAPS_CAN_STRETCH
#define MCI_DGV_GETDEVCAPS_CAN_DISTORT      MCI_VID_GETDEVCAPS_CAN_DISTORT
#define MCI_DGV_GETDEVCAPS_FAST_RATE        MCI_VID_GETDEVCAPS_FAST_RATE
#define MCI_DGV_GETDEVCAPS_SLOW_RATE        MCI_VID_GETDEVCAPS_SLOW_RATE
#define MCI_DGV_GETDEVCAPS_NORMAL_RATE      MCI_VID_GETDEVCAPS_NORMAL_RATE
#define MCI_DGV_GETDEVCAPS_MINIMUM_RATE     MCI_VID_GETDEVCAPS_MINIMUM_RATE
#define MCI_DGV_GETDEVCAPS_MAXIMUM_RATE     MCI_VID_GETDEVCAPS_MAXIMUM_RATE
#define MCI_DGV_GETDEVCAPS_VIDEO_X_EXTENT   MCI_VID_GETDEVCAPS_VIDEO_X_EXTENT
#define MCI_DGV_GETDEVCAPS_VIDEO_Y_EXTENT   MCI_VID_GETDEVCAPS_VIDEO_Y_EXTENT
#define MCI_DGV_GETDEVCAPS_IMAGE_X_EXTENT   MCI_VID_GETDEVCAPS_IMAGE_X_EXTENT
#define MCI_DGV_GETDEVCAPS_IMAGE_Y_EXTENT   MCI_VID_GETDEVCAPS_IMAGE_Y_EXTENT
#define MCI_DGV_GETDEVCAPS_MAX_WINDOWS      MCI_VID_GETDEVCAPS_MAX_WINDOWS
#define MCI_DGV_GETDEVCAPS_OVERLAY_GRAPHICS MCI_VID_GETDEVCAPS_OVERLAY_GRAPHICS
#define MCI_DGV_GETDEVCAPS_HAS_TUNER        (MCI_DGV_ITEM_BASE)
#define MCI_DGV_GETDEVCAPS_HAS_TELETEX      (MCI_DGV_ITEM_BASE+1)
#define MCI_DGV_GETDEVCAPS_HAS_AFC          (MCI_DGV_ITEM_BASE+2)

   /*************************************************/
   /* MCI_GETDEVCAPS item values for Video Overlay  */
   /*************************************************/
#define MCI_OVLY_GETDEVCAPS_CAN_STRETCH     MCI_VID_GETDEVCAPS_CAN_STRETCH
#define MCI_OVLY_GETDEVCAPS_CAN_DISTORT     MCI_VID_GETDEVCAPS_CAN_DISTORT
#define MCI_OVLY_GETDEVCAPS_VIDEO_X_EXTENT  MCI_VID_GETDEVCAPS_VIDEO_X_EXTENT
#define MCI_OVLY_GETDEVCAPS_VIDEO_Y_EXTENT  MCI_VID_GETDEVCAPS_VIDEO_Y_EXTENT
#define MCI_OVLY_GETDEVCAPS_IMAGE_X_EXTENT  MCI_VID_GETDEVCAPS_IMAGE_X_EXTENT
#define MCI_OVLY_GETDEVCAPS_IMAGE_Y_EXTENT  MCI_VID_GETDEVCAPS_IMAGE_Y_EXTENT
#define MCI_OVLY_GETDEVCAPS_MAX_WINDOWS     MCI_VID_GETDEVCAPS_MAX_WINDOWS
#define MCI_OVLY_GETDEVCAPS_CAN_FREEZE      MCI_VID_GETDEVCAPS_CAN_FREEZE
#define MCI_OVLY_GETDEVCAPS_OVERLAY_GRAPHICS MCI_VID_GETDEVCAPS_OVERLAY_GRAPHICS


#define MCI_PREROLL_NOTIFIED                0x00000001L
#define MCI_PREROLL_DETERMINISTIC           0x00000002L
#define MCI_PREROLL_NONE                    0x00000003L

/*********************************************************************/
/* parameter structure for the MCI_GETDEVCAPS message                */
/*********************************************************************/
typedef struct _MCI_GETDEVCAPS_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message */
    DWORD   dwReturn;        /* Return field                            */
    DWORD   dwItem;          /* Item field for GETDEVCAPS item to query */
    WORD    wMessage;        /* Field to hold MCI message to query      */
    WORD    wReserved0;      /* Reserved field                          */
} MCI_GETDEVCAPS_PARMS;
typedef MCI_GETDEVCAPS_PARMS   * LPMCI_GETDEVCAPS_PARMS;

/*********************************************************************/
/* parameter structure for the MCI_WAVE_GETDEVCAPS                   */
/*********************************************************************/
typedef struct _MCI_WAVE_GETDEVCAPS_PARMS {
    ULONG   ulCallback;       /* PM window handle for MCI notify message */
    ULONG   ulReturn;         /* Return field                            */
    ULONG   ulItem;           /* Item field for GETDEVCAPS item to query */
    USHORT  usMessage;        /* Field to hold MCI message to query      */
    USHORT  usReserved0;      /* Reserved field                          */
    ULONG   ulLength;         /* Length of structure in ULONGS           */
    ULONG   ulBitsPerSample;  /* Number of Bits per Sample               */
    ULONG   ulFormatTag;      /* Format Tag                              */
    ULONG   ulSamplesPerSec;  /* Sampling Rate                           */
    ULONG   ulChannels;       /* Number of channels                      */
    ULONG   ulFormatMode;     /* Either MCI_RECORD or MCI_PLAY           */
} MCI_WAVE_GETDEVCAPS_PARMS;
typedef MCI_WAVE_GETDEVCAPS_PARMS   * PMCI_WAVE_GETDEVCAPS_PARMS;

/*********************************************************************/
/* potential values for the ulValue field of MCI_AMP_GETDEVCAPS  */
/*********************************************************************/
#define  MCI_AMP_CAN_SET_MONITOR           MCI_AMP_SET_MONITOR
#define  MCI_AMP_CAN_SET_BALANCE           MCI_AMP_SET_BALANCE
#define  MCI_AMP_CAN_SET_ALC               MCI_AMP_SET_ALC
#define  MCI_AMP_CAN_SET_MONITOR           MCI_AMP_SET_MONITOR
#define  MCI_AMP_CAN_SET_CROSSOVER         MCI_AMP_SET_CROSSOVER
#define  MCI_AMP_CAN_SET_LOUDNESS          MCI_AMP_SET_LOUDNESS
#define  MCI_AMP_CAN_SET_MUTE              MCI_AMP_SET_MUTE
#define  MCI_AMP_CAN_SET_REVERB            MCI_AMP_SET_REVERB
#define  MCI_AMP_CAN_SET_STEREOENHANCE     MCI_AMP_SET_STEREOENHANCE
#define  MCI_AMP_CAN_SET_CUSTOM1           MCI_AMP_SET_CUSTOM1
#define  MCI_AMP_CAN_SET_CUSTOM2           MCI_AMP_SET_CUSTOM2
#define  MCI_AMP_CAN_SET_CUSTOM3           MCI_AMP_SET_CUSTOM3
#define  MCI_AMP_CAN_SET_LRVOLUME          MCI_AMP_SET_LRVOLUME
#define  MCI_AMP_CAN_SET_BASS              MCI_AMP_SET_BASS
#define  MCI_AMP_CAN_SET_MID               MCI_AMP_SET_MID
#define  MCI_AMP_CAN_SET_TREBLE            MCI_AMP_SET_TREBLE
#define  MCI_AMP_CAN_SET_PITCH             MCI_AMP_SET_PITCH
#define  MCI_AMP_CAN_SET_GAIN              MCI_AMP_SET_GAIN
#define  MCI_AMP_CAN_SET_CHORUS            MCI_AMP_SET_CHORUS
#define  MCI_AMP_CAN_SET_VOLUME            MCI_AMP_SET_VOLUME

/*********************************************************************/
/* potential values for the ulExtended field of MCI_AMP_GETDEVCAPS_PARMS */
/*********************************************************************/
#define MCI_MIXER_LINE    0x00000001L


/*********************************************************************/
/* parameter structure for the MCI_AMP_GETDEVCAPS                    */
/*********************************************************************/
typedef struct _MCI_AMP_GETDEVCAPS_PARMS {
    ULONG   hwndCallback;     /* PM window handle for MCI notify message */
    ULONG   ulReturn;         /* Return field                            */
    ULONG   ulItem;           /* Item field for GETDEVCAPS item to query */
    USHORT  usMessage;        /* Field to hold MCI message to query      */
    USHORT  usReserved0;      /* Reserved field                          */
    ULONG   ulLength;         /* Length of structure in ULONGS           */
    ULONG   ulValue;          /* Value to determine caps                 */
    ULONG   ulAttribute;      /* Flags to modified the extended parms    */
    ULONG   ulExtended;       /* Extended flags field                    */
} MCI_AMP_GETDEVCAPS_PARMS;
typedef MCI_AMP_GETDEVCAPS_PARMS   * PMCI_AMP_GETDEVCAPS_PARMS;


/*********************************************************************/
/* values for the ulFlags field of MCI_MIXEVENT_PARMS                */
/*********************************************************************/
#define MCI_MIX_ATTRIBUTE       0x00000001L
#define MCI_MIX_CONNECTOR       0x00000002L

/*********************************************************************/
/* values for the lParam field for mix_notify                        */
/*********************************************************************/

#define MCI_MIXNOTIFY_ON        0x00000004L
#define MCI_MIXNOTIFY_OFF       0x00000008L

/*********************************************************************/
/* value to indicate type of MM_MCIEVENT                             */
/*********************************************************************/

#define MCI_MIXEVENT            0x00000001L

/*********************************************************************/
/* parameter structure for the MCI_MIXEVENT_PARMS                    */
/*********************************************************************/
typedef struct _MCI_MIXEVENT_PARMS
   {
   ULONG  ulLength;        /* Length of struct                         */
   HWND   hwndMixer;       /* window to inform of mixer changes        */
   ULONG  ulFlags;         /* Either MCI_MIX_ATTRIBUTE                 */
                           /*       or MCI_MIX_CONNECTOR               */
   USHORT usDeviceID;      /* device id to notify of the change        */
   ULONG  ulDeviceType;    /* Device Type which generated the change   */
   ULONG  ulDeviceOrdinal; /* Ordinal of device Type                   */
   ULONG  ulAttribute;     /* Attribute that changed(volume, bass etc.)*/
   ULONG  ulValue;         /* new value of the attribute which changed */
   ULONG  ulConnectorType; /* Connector Type                           */
   ULONG  ulConnectorIndex;/* Connector Index                          */
   ULONG  ulConnStatus;    /* Is connector enabled/disabled.           */

   } MCI_MIXEVENT_PARMS;

typedef MCI_MIXEVENT_PARMS *PMCI_MIXEVENT_PARMS;


/*********************************************************************/
/* flag values for the MCI_GETIMAGEBUFFER and MCI_SETIMAGEBUFFER msg */
/*     0x0000XX00 are reserved for MCI_GETIMAGEBUFFER and            */
/*       MCI_SETIMAGEBUFFER Flags                                    */
/*     MCI_CONVERT is defined by MCI_CAPTURE message as 0x00001000L  */
/*********************************************************************/
#define MCI_USE_HW_BUFFER                   0x00000400L
#define MCI_GET_HW_BUFFER_PTR               0x00000800L

   /***************************************************/
   /* parm structure for MCI_GETIMAGEBUFFER and       */
   /*                    MCI_SETIMAGEBUFFER messages  */
   /***************************************************/
typedef  struct _MCI_IMAGE_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message */
    DWORD   dwPelFormat;     /* Format of the image data returned       */
    WORD    wBitCount;       /* Number of bitsimage data returned       */
    WORD    wReserved0;      /* Reserved field                          */
    DWORD   dwImageCompression; /*                                      */
    RECTL   rect;            /* Image area to get/set                   */
    PVOID   pPelBuffer;      /* Pel data buffer                         */
    DWORD   dwPelBufferHeight; /* Number of rows in buffer              */
    DWORD   dwPelBufferWidth;  /* Pels per row in buffer                */
    DWORD   dwBufLen;        /* Pel data buffer length in bytes         */

} MCI_IMAGE_PARMS;
typedef MCI_IMAGE_PARMS   *LPMCI_IMAGE_PARMS;

/*********************************************************************/
/* flags for the MCI_GETIMAGEPALETTE message                         */
/*     0x0000XX00 are reserved for MCI_GETIMAGEPALETTE flags         */
/*********************************************************************/
#define MCI_FIND_BEST_REGISTERED            0x00000100L
#define MCI_QUERY_REGISTERED_MAP            0x00000200L
#define MCI_QUERY_REGISTERED_MAP_SIZE       0x00000400L


   /***************************************************/
   /* parameter structure for MCI_GETIMAGEPALETTE and */
   /*    MCI_SETIMAGEPALETTE messages                 */
   /***************************************************/
typedef  struct _MCI_PALETTE_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message   */
    WORD    wRegisteredMap;  /* Id of the palette from the registed color */
                             /* map                                       */
    WORD    wReserved0;      /* Reserved field                            */
    DWORD   dwPalEntries;    /* size of the palette returned              */
    PVOID   pPalette;        /* pointer to the palette                    */
} MCI_PALETTE_PARMS;
typedef MCI_PALETTE_PARMS   *LPMCI_PALETTE_PARMS;


/*********************************************************************/
/* Parameter structure for the MCI_GETTOC message                    */
/*********************************************************************/
typedef struct _MCI_TOC_REC {
    BYTE      TrackNum;      /* Returned Track Number                          */
    DWORD     dwStartAddr;   /* Starting address of the track in MMTIME format */
    DWORD     dwEndAddr;     /* Ending address of the track in MMTIME format   */
    BYTE      Control;       /* Track Control information                      */
    WORD      wCountry;      /* Country                                        */
    DWORD     dwOwner;       /* Owner                                          */
    DWORD     dwSerialNum;   /* Serial Number                                  */
} MCI_TOC_REC;
typedef MCI_TOC_REC   *LPTOCREC;

typedef struct _MCI_TOC_PARMS {
    DWORD     dwCallback;    /* PM window handle for MCI notify message    */
    LPTOCREC  lpBuf;         /* Pointer to array MCI_TOC_REC structures to */
                             /* be filled in by the mci device             */
    DWORD     dwBufSize;     /* Size of the array                          */
} MCI_TOC_PARMS;
typedef MCI_TOC_PARMS   * LPMCI_TOC_PARMS;

/*********************************************************************/
/* parameters for the MCI_GROUP message                              */
/*     0x00XXXX00 are reserved for MCI_GROUP flags                   */
/*********************************************************************/
#define MCI_SYNCHRONIZE                     0x00000100L
#define MCI_NOPIECEMEAL                     0x00000200L
#define MCI_GROUP_MAKE                      0x00000400L
#define MCI_GROUP_DELETE                    0x00000800L
#define MCI_GROUP_ALIAS                     0x00001000L
#define MCI_GROUP_MASTER                    0x00002000L

typedef struct _MCI_GROUP_PARMS {
    HWND    hwndCallback;    /* PM window handle for MCI notify message.    */
    USHORT  usGroupID;       /* GroupID                                     */
    USHORT  usReserved0;     /* RESERVED                                    */
    ULONG   ulStructLength;  /* Length of Structure in ULONGS.              */
    USHORT  usMasterID;      /* ID of Master device in Synchrounous groups. */
    USHORT  usReserved1;     /* RESERVED                                    */
    PSZ     pszGroupAlias;   /* Pointer to Alias Name.                      */
    ULONG   ulNumDevices;    /* Number of Devices in group.                 */
    PULONG  paulDeviceID;    /* Array of Device ids in the group.           */
} MCI_GROUP_PARMS;
typedef MCI_GROUP_PARMS *PMCI_GROUP_PARMS;


/*********************************************************************/
/* flags for the MCI_INFO message                                    */
/*     0x00000X00 are reserved for MCI_INFO flags                    */
/*********************************************************************/
#define MCI_INFO_PRODUCT                    0x00000100L
#define MCI_INFO_FILE                       0x00000200L

    /************************************************/
    /* CD Audio                MCI_INFO             */
    /************************************************/
#define MCI_CD_INFO_ID                      0x00010000L
#define MCI_CD_INFO_UPC                     0x00020000L

    /************************************************/
    /* Videodisc               MCI_INFO             */
    /************************************************/
#define MCI_VD_INFO_LABEL                   0x00001000L

    /************************************************/
    /* Digital Video           MCI_INFO             */
    /************************************************/
#define MCI_DGV_INFO_VIDEO_FILE             0x00001000L
#define MCI_DGV_INFO_IMAGE_FILE             0x00002000L
#define MCI_DGV_INFO_REGION                 0x00004000L
#define MCI_DGV_INFO_REGION_TEXT            0x00008000L
#define MCI_DGV_INFO_TEXT                   0x00010000L

    /************************************************/
    /* Video Overlay           MCI_INFO             */
    /************************************************/
#define MCI_OVLY_INFO_TEXT                  0x00010000L


typedef struct _MCI_INFO_PARMS {
    DWORD     dwCallback;    /* PM window handle for MCI notify message */
    LPSTR     lpstrReturn;   /* Pointer to return buffer                */
    DWORD     dwRetSize;     /* Return buffer size                      */
} MCI_INFO_PARMS;
typedef MCI_INFO_PARMS   *LPMCI_INFO_PARMS;

/*********************************************************************/
/* parameters and flags for the MCI_LOAD message                     */
/*     0x00000X00 are reserved for MCI_LOAD flags                    */
/*********************************************************************/
typedef struct _MCI_LOAD_PARMS {
    DWORD  dwCallback;       /* PM window handle for MCI notify message */
    LPSTR  lpstrElementName; /* File name to loads                      */
} MCI_LOAD_PARMS;
typedef MCI_LOAD_PARMS   *LPMCI_LOAD_PARMS;

/*********************************************************************/
/* parameters and flags for the MCI_MASTERAUDIO                      */
/*     0x000XXX00 are reserved for MCI_MASTERAUDIO  flags            */
/*********************************************************************/
#define MCI_ON                              0x00000100L
#define MCI_OFF                             0x00000200L
#define MCI_HEADPHONES                      0x00000400L
#define MCI_SPEAKERS                        0x00000800L
#define MCI_MASTERVOL                       0x00001000L
#define MCI_SAVESETTING                     0x00002000L
#define MCI_QUERYSAVEDSETTING               0x00004000L
#define MCI_QUERYCURRENTSETTING             0x00008000L


typedef struct _MCI_MASTERAUDIO_PARMS {
    DWORD   dwDummyCallback; /* PM window handle for MCI notify message */
    DWORD   dwReturn;        /* Return field for query information      */
    DWORD   dwMasterVolume;  /* Master volume field                     */
} MCI_MASTERAUDIO_PARMS;
typedef MCI_MASTERAUDIO_PARMS   *LPMCI_MASTERAUDIO_PARMS;

/*********************************************************************/
/* parameters and flags for the MCI_OPEN message                     */
/*     0x0000XX00 are reserved for MCI_OPEN flags                    */
/*********************************************************************/
#define MCI_OPEN_ELEMENT                    0x00000100L
#define MCI_OPEN_ALIAS                      0x00000200L
#define MCI_OPEN_ELEMENT_ID                 0x00000400L
#define MCI_OPEN_PLAYLIST                   0x00000800L
#define MCI_OPEN_TYPE_ID                    0x00001000L
#define MCI_OPEN_SHAREABLE                  0x00002000L
#define MCI_OPEN_MMIO                       0x00004000L
#define MCI_READONLY                        0x00008000L

    /***************************************************/
    /* parameters and flags for the MCI_OPEN message   */
    /* Digital Video, Video Overlay specific           */
    /***************************************************/
#define MCI_VID_OPEN_PARENT                 0x01000000L
#define MCI_DGV_OPEN_PARENT                 MCI_VID_OPEN_PARENT
#define MCI_OVLY_OPEN_PARENT                MCI_VID_OPEN_PARENT

typedef struct _MCI_OPEN_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message */
    WORD    wDeviceID;       /* Device ID returned to user              */
    WORD    wReserved0;      /* Reserved                                */
    LPSTR   lpstrDeviceType; /* Device name from SYSTEM.INI             */
    LPSTR   lpstrElementName;/* Typically a file name or NULL           */
    LPSTR   lpstrAlias;      /* Optional device alias                   */
} MCI_OPEN_PARMS;
typedef MCI_OPEN_PARMS   *LPMCI_OPEN_PARMS;

    /**********************************************************/
    /* parameters for the AMP MCI_OPEN message                */
    /**********************************************************/
typedef struct _MCI_AMP_OPEN_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message */
    WORD    wDeviceID;       /* Device ID returned to user              */
    WORD    wReserved0;      /* Reserved field                          */
    LPSTR   lpstrDeviceType; /* Device name from SYSTEM.INI             */
    LPSTR   lpstrElementName;/* Typically a file name or NULL           */
    LPSTR   lpstrAlias;      /* Optional device alias                   */
    ULONG   ulDevDataPtr;    /* Pointer to device data                  */
} MCI_AMP_OPEN_PARMS;
typedef MCI_AMP_OPEN_PARMS   *LPMCI_AMP_OPEN_PARMS;

    /**********************************************************/
    /* parameters for MCI_OPEN message for video devices      */
    /**********************************************************/

typedef  struct _MCI_VID_OPEN_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message */
    WORD    wDeviceID;       /* Device ID returned to user              */
    WORD    wReserved0;      /* Reserved field                          */
    LPSTR   lpstrDeviceType; /* Device name from SYSTEM.INI             */
    LPSTR   lpstrElementName;/* Typically a file name or NULL           */
    LPSTR   lpstrAlias;      /* Optional device alias                   */
    HWND    hwndParent;      /* Parent window handle                    */
} MCI_VID_OPEN_PARMS;

typedef MCI_VID_OPEN_PARMS   MCI_DGV_OPEN_PARMS;
typedef MCI_DGV_OPEN_PARMS   *LPMCI_DGV_OPEN_PARMS;

typedef MCI_VID_OPEN_PARMS    MCI_OVLY_OPEN_PARMS;
typedef MCI_OVLY_OPEN_PARMS   *LPMCI_OVLY_OPEN_PARMS;

    /***************************************************/
    /* MCI_PLAY flag values for videodisc              */
    /***************************************************/
#define MCI_VD_PLAY_REVERSE                 0x00001000L
#define MCI_VD_PLAY_FAST                    0x00002000L
#define MCI_VD_PLAY_SPEED                   0x00004000L
#define MCI_VD_PLAY_SCAN                    0x00008000L
#define MCI_VD_PLAY_SLOW                    0x00010000L

    /***************************************************/
    /* MCI_PLAY flag values for digital video          */
    /***************************************************/
#define MCI_DGV_PLAY_REVERSE                0x00001000L
#define MCI_DGV_PLAY_FAST                   0x00002000L
#define MCI_DGV_PLAY_SPEED                  0x00004000L
#define MCI_DGV_PLAY_SCAN                   0x00008000L
#define MCI_DGV_PLAY_SLOW                   0x00010000L
#define MCI_DGV_PLAY_REPEAT                 0x00020000L

typedef struct _MCI_PLAY_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message */
    DWORD   dwFrom;          /* Play from this position                 */
    DWORD   dwTo;            /* Play to this position                   */
} MCI_PLAY_PARMS;
typedef MCI_PLAY_PARMS   *LPMCI_PLAY_PARMS;

typedef struct _MCI_VD_PLAY_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message */
    DWORD   dwFrom;          /* Play from this position                 */
    DWORD   dwTo;            /* Play to this position                   */
    DWORD   dwFactor;        /* Play at this speed factor               */
} MCI_VD_PLAY_PARMS;
typedef MCI_VD_PLAY_PARMS   *LPMCI_VD_PLAY_PARMS;

typedef  struct _MCI_DGV_PLAY_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message */
    DWORD   dwFrom;          /* Play from this position                 */
    DWORD   dwTo;            /* Play to this position                   */
    DWORD   dwSpeed;         /* Specifies the play rate in frames per second */
} MCI_DGV_PLAY_PARMS;
typedef MCI_DGV_PLAY_PARMS   *LPMCI_DGV_PLAY_PARMS;

/*********************************************************************/
/* parameters for the MCI_PUT  message                               */
/*     0x00000X00 are reserved for MCI_PUT  flags                    */
/*********************************************************************/
#define MCI_VID_PUT_RECT                    0x00000100L
#define MCI_VID_PUT_DESTINATION             0x00000200L
#define MCI_VID_PUT_SOURCE                  0x00000400L
#define MCI_VID_PUT_WINDOW_MOVE             0x00000800L
#define MCI_VID_PUT_WINDOW_SIZE             0x00001000L

#define MCI_DGV_PUT_RECT                    MCI_VID_PUT_RECT
#define MCI_DGV_PUT_DESTINATION             MCI_VID_PUT_DESTINATION
#define MCI_DGV_PUT_SOURCE                  MCI_VID_PUT_SOURCE
#define MCI_DGV_PUT_WINDOW_MOVE             MCI_VID_PUT_WINDOW_MOVE
#define MCI_DGV_PUT_WINDOW_SIZE             MCI_VID_PUT_WINDOW_SIZE
#define MCI_DGV_MONITOR                     0x00010000L
#define MCI_DGV_RECORD                      0x00020000L

#define MCI_OVLY_PUT_RECT                   MCI_VID_PUT_RECT
#define MCI_OVLY_PUT_DESTINATION            MCI_VID_PUT_DESTINATION
#define MCI_OVLY_PUT_SOURCE                 MCI_VID_PUT_SOURCE
#define MCI_OVLY_PUT_WINDOW_MOVE            MCI_VID_PUT_WINDOW_MOVE
#define MCI_OVLY_PUT_WINDOW_SIZE            MCI_VID_PUT_WINDOW_SIZE

    /***************************************************/
    /* Rectangle parameters for MCI_PUT, MCI_WHERE,    */
    /* MCI_FREEZE, and MCI_UNFREEZE                    */
    /***************************************************/

typedef  struct _MCI_VID_RECT_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message */
    RECTL   rc;              /* rectangle array specifying the offset   */
                             /* and size of a rectangle                 */
} MCI_VID_RECT_PARMS;

typedef MCI_VID_RECT_PARMS   MCI_DGV_RECT_PARMS;
typedef MCI_DGV_RECT_PARMS   *LPMCI_DGV_RECT_PARMS;

typedef MCI_VID_RECT_PARMS   MCI_OVLY_RECT_PARMS;
typedef MCI_OVLY_RECT_PARMS  *LPMCI_OVLY_RECT_PARMS;

/*********************************************************************/
/* parameters for the MCI_RECORD message                             */
/*     0x00000X00 are reserved for MCI_RECORD flags                  */
/*********************************************************************/
#define MCI_RECORD_INSERT                   0x00000100L
#define MCI_RECORD_OVERWRITE                0x00000200L

#define MCI_DGV_RECORD_RECT                 0x00000400L

typedef struct _MCI_RECORD_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message */
    DWORD   dwFrom;          /* Record from position                    */
    DWORD   dwTo;            /* Record to position                      */
} MCI_RECORD_PARMS;
typedef MCI_RECORD_PARMS   *LPMCI_RECORD_PARMS;

/*********************************************************************/
/* parameters for the MCI_RELEASEDEVICE message                      */
/*     0xXXXXXX00 are reserved for MCI_RELEASEDEVICE message         */
/*********************************************************************/
#define MCI_RETURN_RESOURCE                 0x00000100L

/*********************************************************************/
/* parameters for the MCI_RESTORE message                            */
/*     0x0000XX00 are reserved for MCI_RESTORE flags                 */
/*     MCI_CONVERT is defined by MCI_CAPTURE message as 0x00001000L  */
/*********************************************************************/
#define MCI_RESTORE_SRC_RECT                0x00000100L
#define MCI_RESTORE_DEST_RECT               0x00000200L

typedef struct _MCI_RESTORE_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message     */
    RECTL   SrcRect;         /* Rectangle array specifying the source       */
                             /* area to be restored                                 */
    RECTL   DestRect;        /* Rectangle array specifying the destination  */
                             /* area to be restored                         */
} MCI_RESTORE_PARMS;
typedef MCI_RESTORE_PARMS   *LPMCI_RESTORE_PARMS;

/*********************************************************************/
/* parameters for the MCI_SAVE  message                              */
/*     0x00000X00 are reserved for MCI_SAVE  flags                   */
/*********************************************************************/
#define MCI_SAVE_FILE                       0x00000100L

    /*************************************************/
    /* Digital Video               MCI_SAVE          */
    /*************************************************/

#define MCI_DGV_SAVE_VIDEO_FILE             0x00001000L
#define MCI_DGV_SAVE_IMAGE_FILE             0x00002000L

typedef struct _MCI_SAVE_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message     */
    DWORD   lpFileName;      /* Filename to save data to                    */
} MCI_SAVE_PARMS;
typedef MCI_SAVE_PARMS   *LPMCI_SAVE_PARMS;

/*********************************************************************/
/* parameters for the MCI_SEEK message                               */
/*     0x00000X00 are reserved for MCI_SEEK flags                    */
/*********************************************************************/
#define MCI_TO_START                        0x00000100L
#define MCI_TO_END                          0x00000200L

    /*************************************************/
    /* Digital Video               MCI_SEEK          */
    /*************************************************/

#define MCI_DGV_SEEK_TO_NEAREST_IFRAME      0x00100000L

    /*************************************************/
    /* Videodisc                   MCI_SEEK          */
    /*************************************************/
#define MCI_VD_SEEK_REVERSE                 0x00001000L

typedef struct _MCI_SEEK_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message     */
    DWORD   dwTo;            /* Seek to this position                       */
} MCI_SEEK_PARMS;
typedef MCI_SEEK_PARMS   *LPMCI_SEEK_PARMS;

/*********************************************************************/
/* Flags for the MCI_SET message                                     */
/*     0x00XXXX00 are reserved for MCI_SET  flags                    */
/*********************************************************************/
#define MCI_SET_ITEM                        0x00000100L
#define MCI_SET_ON                          0x00000200L
#define MCI_SET_OFF                         0x00000400L
#define MCI_SET_VIDEO                       0x00000800L
#define MCI_SET_AUDIO                       0x00001000L
#define MCI_SET_DOOR_OPEN                   0x00002000L
#define MCI_SET_DOOR_CLOSED                 0x00004000L
#define MCI_SET_SPEED_FORMAT                0x00008000L
#define MCI_SET_TIME_FORMAT                 0x00010000L
#define MCI_SET_DOOR_LOCK                   0x00020000L
#define MCI_SET_DOOR_UNLOCK                 0x00040000L
#define MCI_SET_VOLUME                      0x00080000L
#define MCI_SET_ITEM_FOURCC                 0x00100000L
#define MCI_SET_REVERSE                     0x00200000L

/*******************************************************/
/* Values for the dwAudio field                        */
/*******************************************************/
#define MCI_SET_AUDIO_ALL                   0x00000000L
#define MCI_SET_AUDIO_LEFT                  0x00000001L
#define MCI_SET_AUDIO_RIGHT                 0x00000002L

/*******************************************************/
/* MCI_SET flags for amp/mixer                         */
/*******************************************************/
#define MCI_AMP_SET_BALANCE                 0x00100000L
#define MCI_AMP_SET_PITCH                   0x00200000L
#define MCI_AMP_SET_TREBLE                  0x00400000L
#define MCI_AMP_SET_BASS                    0x00800000L
#define MCI_AMP_SET_GAIN                    0x01000000L

#define MCI_AMP_SET_ALC                     0x00000004L
#define MCI_AMP_SET_CROSSOVER               0x00000010L
#define MCI_AMP_SET_LOUDNESS                0x00000020L
#define MCI_AMP_SET_MUTE                    0x00000040L
#define MCI_AMP_SET_REVERB                  0x00000080L
#define MCI_AMP_SET_STEREOENHANCE           0x00000100L
#define MCI_AMP_SET_CUSTOM1                 0x00000200L
#define MCI_AMP_SET_CUSTOM2                 0x00000400L
#define MCI_AMP_SET_CUSTOM3                 0x00000800L
#define MCI_AMP_SET_LRVOLUME                0x00001000L
#define MCI_AMP_SET_MID                     0x00020000L
#define MCI_AMP_SET_CHORUS                  0x00004000L
#define MCI_AMP_SET_VOLUME                  MCI_SET_VOLUME

/*******************************************************/
/* General MCI_SET item values                         */
/*******************************************************/
#define MCI_SET_MONITOR                     0x00000001L
#define MCI_SET_MONITOR_AUDIO               0x00000002L
#define MCI_SET_MONITOR_VIDEO               0x00000003L
#define MCI_SET_RECORD                      0x00000004L

/*******************************************************/
/* MCI_SET item values for amp/mixer                   */
/*******************************************************/
#define MCI_AMP_SET_MONITOR                 MCI_SET_MONITOR_AUDIO
#define MCI_AMP_SET_AUDIO                   0x00000008





/*******************************************************/
/* MCI_SET flags for CDXA                              */
/*******************************************************/
#define MCI_CDXA_SET_CHANNEL                0x01000000L
#define MCI_CDXA_AUDIO_DEVICE               0x10000000L
#define MCI_CDXA_AUDIO_BUFFER               0x02000000L
#define MCI_CDXA_VIDEO_BUFFER               0x04000000L
#define MCI_CDXA_DATA_BUFFER                0x08000000L

/*******************************************************/
/* MCI_SET flags for videodisc                         */
/*******************************************************/
#define MCI_VD_SET_ON                       MCI_SET_ON
#define MCI_VD_SET_OFF                      MCI_SET_OFF
#define MCI_VD_SET_VIDEO                    MCI_SET_VIDEO
#define MCI_VD_SET_CHANNEL                  0x00100000L
#define MCI_VD_SET_DISPLAY                  0x00200000L

/*******************************************************/
/* Generic MCI_SET item values for video devices       */
/*******************************************************/
#define MCI_VID_SET_VIDEO_COMPRESSION           MCI_VID_ITEM_BASE
#define MCI_VID_SET_IMAGE_COMPRESSION           (MCI_VID_ITEM_BASE+1)
#define MCI_VID_SET_IMAGE_BITSPERPEL            (MCI_VID_ITEM_BASE+2)
#define MCI_VID_SET_IMAGE_PELFORMAT             (MCI_VID_ITEM_BASE+3)
#define MCI_VID_SET_BRIGHTNESS                  (MCI_VID_ITEM_BASE+4)
#define MCI_VID_SET_CONTRAST                    (MCI_VID_ITEM_BASE+5)
#define MCI_VID_SET_HUE                         (MCI_VID_ITEM_BASE+6)
#define MCI_VID_SET_SATURATION                  (MCI_VID_ITEM_BASE+7)
#define MCI_VID_SET_SHARPNESS                   (MCI_VID_ITEM_BASE+8)
#define MCI_VID_SET_GREYSCALE                   (MCI_VID_ITEM_BASE+9)
#define MCI_VID_SET_IMAGE_QUALITY               (MCI_VID_ITEM_BASE+10)
#define MCI_VID_SET_VIDEO_QUALITY               (MCI_VID_ITEM_BASE+11)
#define MCI_VID_SET_IMAGE_COMPRESSION_METHOD    (MCI_VID_ITEM_BASE+12)
#define MCI_VID_SET_MINIMUM_VIDEO_REFRESH_RATE  (MCI_VID_ITEM_BASE+13)
#define MCI_VID_SET_IMAGE_FILE_FORMAT           (MCI_VID_ITEM_BASE+14)
#define MCI_VID_SET_REF_INTERVAL                (MCI_VID_ITEM_BASE+15)
#define MCI_VID_SET_MAXDATARATE                 (MCI_VID_ITEM_BASE+16)
#define MCI_VID_SET_VIDEO_FILE_FORMAT           (MCI_VID_ITEM_BASE+17)

/*******************************************************/
/* MCI_SET item values for video overlay               */
/*******************************************************/
#define MCI_OVLY_SET_IMAGE_COMPRESSION          MCI_VID_SET_IMAGE_COMPRESSION
#define MCI_OVLY_SET_IMAGE_BITSPERPEL           MCI_VID_SET_IMAGE_BITSPERPEL
#define MCI_OVLY_SET_IMAGE_PELFORMAT            MCI_VID_SET_IMAGE_PELFORMAT
#define MCI_OVLY_SET_BRIGHTNESS                 MCI_VID_SET_BRIGHTNESS
#define MCI_OVLY_SET_CONTRAST                   MCI_VID_SET_CONTRAST
#define MCI_OVLY_SET_HUE                        MCI_VID_SET_HUE
#define MCI_OVLY_SET_SATURATION                 MCI_VID_SET_SATURATION
#define MCI_OVLY_SET_SHARPNESS                  MCI_VID_SET_SHARPNESS
#define MCI_OVLY_SET_GREYSCALE                  MCI_VID_SET_GREYSCALE
#define MCI_OVLY_SET_IMAGE_QUALITY              MCI_VID_SET_IMAGE_QUALITY
#define MCI_OVLY_SET_IMAGE_COMPRESSION_METHOD   MCI_VID_SET_IMAGE_COMPRESSION_METHOD
#define MCI_OVLY_SET_MINIMUM_VIDEO_REFRESH_RATE MCI_VID_SET_MINIMUM_VIDEO_REFRESH_RATE
#define MCI_OVLY_SET_IMAGE_FILE_FORMAT          MCI_VID_SET_IMAGE_FILE_FORMAT

/*******************************************************/
/* MCI_SET item values for digital video               */
/*******************************************************/
#define MCI_DGV_SET_VIDEO_COMPRESSION           MCI_VID_SET_VIDEO_COMPRESSION
#define MCI_DGV_SET_IMAGE_COMPRESSION           MCI_VID_SET_IMAGE_COMPRESSION
#define MCI_DGV_SET_IMAGE_BITSPERPEL            MCI_VID_SET_IMAGE_BITSPERPEL
#define MCI_DGV_SET_IMAGE_PELFORMAT             MCI_VID_SET_IMAGE_PELFORMAT
#define MCI_DGV_SET_BRIGHTNESS                  MCI_VID_SET_BRIGHTNESS
#define MCI_DGV_SET_CONTRAST                    MCI_VID_SET_CONTRAST
#define MCI_DGV_SET_HUE                         MCI_VID_SET_HUE
#define MCI_DGV_SET_SATURATION                  MCI_VID_SET_SATURATION
#define MCI_DGV_SET_SHARPNESS                   MCI_VID_SET_SHARPNESS
#define MCI_DGV_SET_GREYSCALE                   MCI_VID_SET_GREYSCALE
#define MCI_DGV_SET_IMAGE_QUALITY               MCI_VID_SET_IMAGE_QUALITY
#define MCI_DGV_SET_VIDEO_QUALITY               MCI_VID_SET_VIDEO_QUALITY
#define MCI_DGV_SET_IMAGE_COMPRESSION_METHOD    MCI_VID_SET_IMAGE_COMPRESSION_METHOD
#define MCI_DGV_SET_MONITOR                     MCI_SET_MONITOR
#define MCI_DGV_SET_MINIMUM_VIDEO_REFRESH_RATE  MCI_VID_SET_MINIMUM_VIDEO_REFRESH_RATE
#define MCI_DGV_SET_IMAGE_FILE_FORMAT           MCI_VID_SET_IMAGE_FILE_FORMAT
#define MCI_DGV_SET_REF_INTERVAL                MCI_VID_SET_REF_INTERVAL
#define MCI_DGV_SET_MAXDATARATE                 MCI_VID_SET_MAXDATARATE
#define MCI_DGV_SET_VIDEO_FILE_FORMAT           MCI_VID_SET_VIDEO_FILE_FORMAT

#define MCI_DGV_SET_AUDIO_COMPRESSION           MCI_DGV_ITEM_BASE
#define MCI_DGV_SET_AUDIO_QUALITY               (MCI_DGV_ITEM_BASE+1)
#define MCI_DGV_SET_CHANNELS                    (MCI_DGV_ITEM_BASE+2)
#define MCI_DGV_SET_BITSPERSAMPLE               (MCI_DGV_ITEM_BASE+3)
#define MCI_DGV_SET_SAMPLESPERSEC               (MCI_DGV_ITEM_BASE+4)
#define MCI_DGV_SET_FORMATTAG                   (MCI_DGV_ITEM_BASE+5)
#define MCI_DGV_SET_BLOCKALIGN                  (MCI_DGV_ITEM_BASE+6)
#define MCI_DGV_SET_AVGBYTESPERSEC              (MCI_DGV_ITEM_BASE+7)

#define MCI_DGV_SET_VIDEO_COMPRESSION_SUBTYPE   (MCI_DGV_ITEM_BASE+8)
#define MCI_DGV_SET_VIDEO_RECORD_RATE           (MCI_DGV_ITEM_BASE+9)
#define MCI_DGV_SET_VIDEO_RECORD_FRAME_DURATION (MCI_DGV_ITEM_BASE+10)
#define MCI_DGV_SET_RECORD_AUDIO                (MCI_DGV_ITEM_BASE+11)
#define MCI_DGV_SET_TRANSPARENT_COLOR           (MCI_DGV_ITEM_BASE+12)
#define MCI_DGV_SET_GRAPHIC_TRANSPARENT_COLOR   (MCI_DGV_ITEM_BASE+12)
#define MCI_DGV_SET_AUDIOSYNC                   (MCI_DGV_ITEM_BASE+13)
#define MCI_DGV_SET_VIDEO_TRANSPARENT_COLOR     (MCI_DGV_ITEM_BASE+14)

/*******************************************************/
/* Video file format                                   */
/*******************************************************/
#define MCI_VID_FILE_FORMAT_AVI       0x20495641L

/*******************************************************/
/* Audio/video/image compression types                 */
/*******************************************************/
#define MCI_AUD_COMP_ADPCM4          0x00000001L
#define MCI_AUD_COMP_PCM8            0x00000002L

#define MCI_VID_COMP_RTV_2_0         0x00000101L
#define MCI_VID_COMP_RTV_2_1         0x00000102L
#define MCI_VID_COMP_ULTI            0x49544C55L
#define MCI_VID_COMP_RT21            0x31325452L
#define MCI_VID_COMP_NONE            0x20424944L   /* This is 'DIB ' now.    */

#define MCI_IMG_COMP_NONE            0x00000201L
#define MCI_IMG_COMP_PIC9_1_0        0x00000202L
#define MCI_IMG_COMP_PIC16_1_0       0x00000203L
#define MCI_IMG_COMP_JPEG9           0x00000204L
#define MCI_IMG_COMP_JPEG9_1_0       MCI_IMG_COMP_JPEG9
#define MCI_IMG_COMP_BMP_RLE4        0x00000205L
#define MCI_IMG_COMP_BMP_RLE8        0x00000206L
#define MCI_IMG_COMP_JPEGN           0x00000207L

/*******************************************************/
/* PEL Formats (video/image)                           */
/*******************************************************/
#define MCI_VID_PALETTE              0x00000001L
#define MCI_VID_RGB                  0x00000002L
#define MCI_VID_YUV                  0x00000003L

#define MCI_IMG_PALETTE              MCI_VID_PALETTE
#define MCI_IMG_RGB                  MCI_VID_RGB
#define MCI_IMG_YUV                  MCI_VID_YUV


/*******************************************************/
/* Audio/video/image quality levels                    */
/*******************************************************/
#define MCI_AUD_QUALITY_HIGH         0x00000001L
#define MCI_AUD_QUALITY_MED          0x00000002L
#define MCI_AUD_QUALITY_LOW          0x00000003L

#define MCI_VID_QUALITY_HIGH         0x00000101L
#define MCI_VID_QUALITY_MED          0x00000102L
#define MCI_VID_QUALITY_LOW          0x00000103L
#define MCI_VID_QUALITY_BEST         MCI_VID_QUALITY_HIGH
#define MCI_VID_QUALITY_CDROM        MCI_VID_QUALITY_MED
#define MCI_VID_QUALITY_COMPACT      MCI_VID_QUALITY_LOW
#define MCI_VID_QUALITY_BETTER       MCI_VID_QUALITY_MED
#define MCI_VID_QUALITY_GOOD         MCI_VID_QUALITY_LOW

#define MCI_IMG_QUALITY_HIGH         0x00000201L
#define MCI_IMG_QUALITY_MED          0x00000202L
#define MCI_IMG_QUALITY_LOW          0x00000203L

/*******************************************************/
/* MCI_SET flags for wave audio                        */
/*******************************************************/
#define MCI_WAVE_SET_SAMPLESPERSEC          0x01000000L
#define MCI_WAVE_SET_AVGBYTESPERSEC         0x02000000L
#define MCI_WAVE_SET_BLOCKALIGN             0x04000000L
#define MCI_WAVE_SET_FORMATTAG              0x08000000L
#define MCI_WAVE_SET_CHANNELS               0x10000000L
#define MCI_WAVE_SET_BITSPERSAMPLE          0x80000000L

/*******************************************************/
/* Wave format tag defines                             */
/*******************************************************/
#define MCI_WAVE_FORMAT_PCM                 DATATYPE_WAVEFORM
#define MCI_WAVE_FORMAT_ADPCM               0x0002L
#define MCI_WAVE_FORMAT_IBM_CVSD            0x0005L
#define MCI_WAVE_FORMAT_ALAW                DATATYPE_RIFF_ALAW
#define MCI_WAVE_FORMAT_MULAW               DATATYPE_RIFF_MULAW
#define MCI_WAVE_FORMAT_OKI_ADPCM           0x0010L
#define MCI_WAVE_FORMAT_DVI_ADPCM           0x0011L
#define MCI_WAVE_FORMAT_DIGISTD             0x0015L
#define MCI_WAVE_FORMAT_DIGIFIX             0x0016L
#define MCI_WAVE_FORMAT_AVC_ADPCM           DATATYPE_ADPCM_AVC
#define MCI_WAVE_FORMAT_IBM_ADPCM           DATATYPE_ADPCM_AVC
#define MCI_WAVE_FORMAT_IBM_MULAW           DATATYPE_MULAW
#define MCI_WAVE_FORMAT_IBM_ALAW            DATATYPE_ALAW
#define MCI_WAVE_FORMAT_CT_ADPCM            DATATYPE_CT_ADPCM
#define MCI_WAVE_FORMAT_MPEG1               DATATYPE_MPEG1AUDIO

/*******************************************************/
/* MCI_SET flags for sequencer                         */
/*******************************************************/
#define MCI_SEQ_SET_TEMPO                   0x00100000L
#define MCI_SEQ_SET_PORT                    0x00200000L
#define MCI_SEQ_ENABLE_PORT_MAPPER          0x00400000L
#define MCI_SEQ_DISABLE_PORT_MAPPER         0x00800000L
#define MCI_SEQ_SET_OFFSET                  0x01000000L
#define MCI_SEQ_SET_MASTER                  0x02000000L
#define MCI_SEQ_SET_SLAVE                   0x04000000L

   /**********************************************/
   /* SEQ time formats                           */
   /**********************************************/
   #define MCI_SEQ_SET_SMPTE_24             0x00000100L
   #define MCI_SEQ_SET_SMPTE_25             0x00000200L
   #define MCI_SEQ_SET_SMPTE_30             0x00000300L
   #define MCI_SEQ_SET_SMPTE_30DROP         0x00000400L
   #define MCI_SEQ_SET_SONGPTR              0x00000500L

   /**********************************************/
   /* SEQ synchronization types                  */
   /**********************************************/
   #define MCI_SEQ_MIDI                     0x00000001L
   #define MCI_SEQ_SMPTE                    0x00000002L
   #define MCI_SEQ_FILE                     0x00000003L
   #define MCI_SEQ_NONE                     0x00000004L

   /**********************************************/
   /* SEQ PORT TYPES                             */
   /**********************************************/
   #define MCI_SET_NONE                     0x10000000L
   #define MIDI_MAPPER                      0x20000000L
   #define MCI_MIDI_MAPPER                  MIDI_MAPPER

typedef struct _MCI_SET_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message        */
    DWORD   dwTimeFormat;    /* Time format to be used by the device           */
    DWORD   dwSpeedFormat;   /* Speed format used by this device               */
    DWORD   dwAudio;         /* Channel number for this operation              */
                             /* (MCI_SET_AUDIO_LEFT, MCI_SET_AUDIO_RIGHT,      */
                             /*  MCI_SET_AUDIO_ALL)                            */
    DWORD   dwLevel;         /* Volume, treble or bass level as % of max.      */
    DWORD   dwOver;          /* Delay time for vectored change in milliseconds */
    DWORD   dwItem;          /* Item field for set item flags                  */
    DWORD   dwValue;         /* Value associated with item flag                */
} MCI_SET_PARMS;
typedef MCI_SET_PARMS       *LPMCI_SET_PARMS;

typedef MCI_SET_PARMS       MCI_AMP_SET_PARMS;
typedef MCI_AMP_SET_PARMS   *LPMCI_AMP_SET_PARMS;

typedef MCI_SET_PARMS       MCI_DGV_SET_PARMS;
typedef MCI_DGV_SET_PARMS   *LPMCI_DGV_SET_PARMS;

typedef MCI_SET_PARMS       MCI_OVLY_SET_PARMS;
typedef MCI_OVLY_SET_PARMS  *LPMCI_OVLY_SET_PARMS;

typedef struct _MCI_CDXA_SET_PARMS {
    DWORD   dwCallback;
    DWORD   dwTimeFormat;    /* Time format to be used by the device           */
    DWORD   dwSpeedFormat;   /* Speed format used by this device               */
    DWORD   dwAudio;         /* Channel number for this operation              */
                             /* (MCI_SET_AUDIO_LEFT, MCI_SET_AUDIO_RIGHT,      */
                             /*  MCI_SET_AUDIO_ALL)                            */
    DWORD   dwLevel;         /* Volume, treble or bass level as % of max.      */
    DWORD   dwOver;          /* Delay time for vectored change in milliseconds */
    DWORD   dwItem;          /* Item field for set item flags                  */
    DWORD   dwValue;         /* Value associated with item flag                */
    DWORD   dwChannel;       /* Channel number                                 */
    PVOID   pPlayList;       /* Pointer to play list                           */
    DWORD   dwPlayListSize;  /* Play list size                                 */
} MCI_CDXA_SET_PARMS;
typedef MCI_CDXA_SET_PARMS   *LPMCI_CDXA_SET_PARMS;

typedef struct _MCI_VD_SET_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message        */
    DWORD   dwTimeFormat;    /* Time format to be used by the device           */
    DWORD   dwSpeedFormat;   /* Speed format used by this device               */
    DWORD   dwAudio;         /* Channel number for this operation              */
                             /* (MCI_SET_AUDIO_LEFT, MCI_SET_AUDIO_RIGHT,      */
                             /*  MCI_SET_AUDIO_ALL)                            */
    DWORD   dwLevel;         /* Volume, treble or bass level as % of max.      */
    DWORD   dwOver;          /* Delay time for vectored change in milliseconds */
    DWORD   dwItem;          /* Item field for set item flags                  */
    DWORD   dwValue;         /* Value associated with item flag                */
    DWORD   dwChannel;       /* Videodisc channel                              */
} MCI_VD_SET_PARMS;
typedef MCI_VD_SET_PARMS   *LPMCI_VD_SET_PARMS;

typedef struct _MCI_WAVE_SET_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message        */
    DWORD   dwTimeFormat;    /* Time format to be used by the device           */
    DWORD   dwSpeedFormat;   /* Speed format used by this device               */
    DWORD   dwAudio;         /* Channel number for this operation              */
                             /* (MCI_SET_AUDIO_LEFT, MCI_SET_AUDIO_RIGHT,      */
                             /*  MCI_SET_AUDIO_ALL)                            */
    DWORD   dwLevel;         /* Volume, trebble or bass level as % of max.     */
    DWORD   dwOver;          /* Delay time for vectored change in milliseconds */
    DWORD   dwItem;          /* Item field for set item flags                  */
    DWORD   dwValue;         /* Value associated with item flag                */
    WORD    wInput;          /* Channel for input                              */
    WORD    wReserved0;      /* Reserved field                                 */
    WORD    wOutput;         /* Channel for output                             */
    WORD    wReserved1;      /* Reserved field                                 */
    WORD    wFormatTag;      /* Format tag                                     */
    WORD    wReserved2;      /* Reserved field                                 */
    WORD    nChannels;       /* mono(1) or stereo(2)                           */
    WORD    wReserved3;      /* Reserved field                                 */
    DWORD   nSamplesPerSec;  /* Samples per seconds                            */
    DWORD   nAvgBytesPerSec; /* Bytes per seconds                              */
    WORD    nBlockAlign;     /* Block alignment of data                        */
    WORD    wReserved4;      /* Reserved field                                 */
    WORD    wBitsPerSample;  /* Bits per seconds                               */
    WORD    wReserved5;      /* Reserved field                                 */
} MCI_WAVE_SET_PARMS;
typedef MCI_WAVE_SET_PARMS   *LPMCI_WAVE_SET_PARMS;

typedef struct _MCI_SEQ_SET_PARMS {
    DWORD   dwCallback;
    DWORD   dwTimeFormat;    /* Time format to be used by the device           */
    DWORD   dwSpeedFormat;   /* Speed format used by this device               */
    DWORD   dwAudio;         /* Channel number for this operation              */
                             /* (MCI_SET_AUDIO_LEFT, MCI_SET_AUDIO_RIGHT,      */
                             /*  MCI_SET_AUDIO_ALL)                            */
    DWORD   dwLevel;         /* Volume, trebble or bass level as % of max.     */
    DWORD   dwOver;          /* Delay time for vectored change in milliseconds */
    DWORD   dwItem;          /* Item field for set item flags                  */
    DWORD   dwValue;         /* Value associated with item flag                */
    DWORD   dwTempo;         /* Specified the tempo                            */
    DWORD   dwPort;          /* Output port                                    */
    DWORD   dwSlave;         /* Unused field                                   */
    DWORD   dwMaster;        /* Unused field                                   */
    DWORD   dwOffset;        /* Specified the data offset                      */
} MCI_SEQ_SET_PARMS;
typedef MCI_SEQ_SET_PARMS   *LPMCI_SEQ_SET_PARMS;


/*********************************************************************/
/* parameters for the MCI_SET_CUEPOINT message                       */
/*     0x00000x00 are reserved for MCI_SET_CUEPOINT flags            */
/*********************************************************************/
#define MCI_SET_CUEPOINT_ON                 0x00000100L
#define MCI_SET_CUEPOINT_OFF                0x00000200L

typedef struct _MCI_CUEPOINT_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message        */
    DWORD   dwCuepoint;      /* Specifies the cuepoint location                */
    WORD    wUserParm;       /* User parmameter returned on cuepoint           */
                             /* notify message                                 */
    WORD    wReserved0;      /* Reserved field                                 */
} MCI_CUEPOINT_PARMS;
typedef MCI_CUEPOINT_PARMS   *LPMCI_CUEPOINT_PARMS;

/*********************************************************************/
/* parameters for the MCI_SETIMAGEPALETTE message                    */
/*     0x000XXX00 are reserved for MCI_SETIMAGEPALETTE flags         */
/*********************************************************************/
#define MCI_SET_REGISTERED                  0x00000100L

/*********************************************************************/
/* flags and parameter structure for the MCI_SET_POSITION_ADVISE msg */
/*     0x00000X00 are reserved for MCI_SET_POSITION_ADVISE flags     */
/*********************************************************************/
#define MCI_SET_POSITION_ADVISE_ON          0x00000100L
#define MCI_SET_POSITION_ADVISE_OFF         0x00000200L

typedef struct _MCI_POSITION_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message        */
    DWORD   dwUnits;         /* Specifies position change notifiication        */
                             /* granularity                                    */
    WORD    wUserParm;       /* User parameter returned on position change     */
                             /* notification message.                          */
    WORD    Reserved0;       /* Reserved field                                 */
    DWORD   Reserved1;       /* Reserved field                                 */
    } MCI_POSITION_PARMS;
typedef MCI_POSITION_PARMS   *LPMCI_POSITION_PARMS;

/*********************************************************************/
/* parameter structure for the MCI_SET_SYNC_OFFSET message           */
/*********************************************************************/
typedef struct _MCI_SYNC_OFFSET_PARMS{
    DWORD   dwCallback;      /* PM window handle for MCI notify message        */
    DWORD   dwOffset;        /* Specifies the device media position offset     */
                             /* in the currently specified device units.       */
} MCI_SYNC_OFFSET_PARMS;
typedef MCI_SYNC_OFFSET_PARMS   *LPMCI_SYNC_OFFSET_PARMS;

/*********************************************************************/
/* flags for the MCI_SPIN message                                    */
/*     0x00000X00 are reserved for MCI_SPIN flags                    */
/*********************************************************************/
#define MCI_SPIN_UP                         0x00000100L
#define MCI_SPIN_DOWN                       0x00000200L

/*********************************************************************/
/* MCI_STATUS message flags                                          */
/*     0x000XXX00 are reserved for MCI_STATUS flags                  */
/*     MCI_VOLUME and MCI_VOLUME_DELAY are 0x00000100 and 0x00000200 */
/*********************************************************************/
#define MCI_STATUS_ITEM                     0x00000100L
#define MCI_STATUS_START                    0x00000200L
#define MCI_STATUS_CONNECTOR                0x00000400L

/*************************************************/
/* General MCI_STATUS item values                */
/*************************************************/
#define MCI_STATUS_CURRENT_TRACK            0x00000001L
#define MCI_STATUS_LENGTH                   0x00000002L
#define MCI_STATUS_MODE                     0x00000003L
#define MCI_STATUS_NUMBER_OF_TRACKS         0x00000004L
#define MCI_STATUS_POSITION                 0x00000005L
#define MCI_STATUS_POSITION_IN_TRACK        0x00000006L
#define MCI_STATUS_MEDIA_PRESENT            0x00000007L
#define MCI_STATUS_VOLUME                   0x00000008L
#define MCI_STATUS_READY                    0x00000009L
#define MCI_STATUS_TIME_FORMAT              0x0000000AL
#define MCI_STATUS_SPEED_FORMAT             0x0000000BL
#define MCI_STATUS_MONITOR                  0x0000000CL
#define MCI_STATUS_AUDIO                    0x0000000DL
#define MCI_STATUS_VIDEO                    0x0000000EL
#define MCI_STATUS_CLIPBOARD                0x0000000FL
#define MCI_STATUS_CAN_PASTE                0x00000010L
#define MCI_STATUS_CAN_REDO                 0x00000020L
#define MCI_STATUS_CAN_UNDO                 0x00000030L

   /*************************************************/
   /* dwValue field values for MCI_STATUS_AUDIO     */
   /*************************************************/
#define MCI_STATUS_AUDIO_ALL                   0x00000000L
#define MCI_STATUS_AUDIO_LEFT                  0x00000001L
#define MCI_STATUS_AUDIO_RIGHT                 0x00000002L

/*************************************************/
/* MCI_STATUS item values for amp/mixer          */
/*************************************************/
#define MCI_AMP_STATUS_PITCH                MCI_AMP_ITEM_BASE
#define MCI_AMP_STATUS_TREBLE               (MCI_AMP_ITEM_BASE+1)
#define MCI_AMP_STATUS_BASS                 (MCI_AMP_ITEM_BASE+2)
#define MCI_AMP_STATUS_BALANCE              (MCI_AMP_ITEM_BASE+3)
#define MCI_AMP_STATUS_GAIN                 (MCI_AMP_ITEM_BASE+4)
#define MCI_AMP_STATUS_MONITOR              (MCI_AMP_ITEM_BASE+5)

#define MCI_AMP_STATUS_MID                  (MCI_AMP_ITEM_BASE+6)
#define MCI_AMP_STATUS_VOLUME               MCI_STATUS_VOLUME
#define MCI_AMP_STATUS_LOUDNESS             (MCI_AMP_ITEM_BASE+7)
#define MCI_AMP_STATUS_CROSSOVER            (MCI_AMP_ITEM_BASE+8)
#define MCI_AMP_STATUS_REVERB               (MCI_AMP_ITEM_BASE+9)
#define MCI_AMP_STATUS_ALC                  (MCI_AMP_ITEM_BASE+10)
#define MCI_AMP_STATUS_CHORUS               (MCI_AMP_ITEM_BASE+11)
#define MCI_AMP_STATUS_CUSTOM1              (MCI_AMP_ITEM_BASE+12)
#define MCI_AMP_STATUS_CUSTOM2              (MCI_AMP_ITEM_BASE+13)
#define MCI_AMP_STATUS_CUSTOM3              (MCI_AMP_ITEM_BASE+14)

/*************************************************/
/* MCI_STATUS item values for cd audio           */
/*************************************************/
#define MCI_CD_STATUS_TRACK_TYPE            MCI_CD_ITEM_BASE
#define MCI_CD_STATUS_TRACK_COPYPERMITTED   (MCI_CD_ITEM_BASE+1)
#define MCI_CD_STATUS_TRACK_CHANNELS        (MCI_CD_ITEM_BASE+2)
#define MCI_CD_STATUS_TRACK_PREEMPHASIS     (MCI_CD_ITEM_BASE+3)

    /************************************************/
    /* return values for CD MCI_STATUS message with */
    /*   MCI_CD_STATUS_TRACK_TYPE set               */
    /************************************************/
#define MCI_CD_TRACK_AUDIO                  0x00000001L
#define MCI_CD_TRACK_DATA                   0x00000002L
#define MCI_CD_TRACK_OTHER                  0x00000003L

/*************************************************/
/* MCI_STATUS item values for CDXA               */
/*************************************************/
#define MCI_CDXA_STATUS_CHANNEL             MCI_CDXA_ITEM_BASE

    /************************************************/
    /*returned from call for MCI_CDXA_STATUS_CHANNEL*/
    /************************************************/
#define MCI_CDXA_NONE                       0x00000000L


/*************************************************/
/* MCI_STATUS item values for sequencer          */
/*************************************************/
#define MCI_SEQ_STATUS_TEMPO                MCI_SEQ_ITEM_BASE
#define MCI_SEQ_STATUS_OFFSET               (MCI_SEQ_ITEM_BASE+1)
#define MCI_SEQ_STATUS_DIVTYPE              (MCI_SEQ_ITEM_BASE+2)
#define MCI_SEQ_STATUS_MASTER               (MCI_SEQ_ITEM_BASE+3)
#define MCI_SEQ_STATUS_PORT                 (MCI_SEQ_ITEM_BASE+4)
#define MCI_SEQ_STATUS_SLAVE                (MCI_SEQ_ITEM_BASE+5)

   /**********************************************/
   /* Return value for current division type     */
   /**********************************************/
#define MCI_SEQ_DIV_PPQN                    0x00000001L
#define MCI_SEQ_DIV_SMPTE_24                0x00000002L
#define MCI_SEQ_DIV_SMPTE_25                0x00000003L
#define MCI_SEQ_DIV_SMPTE_30DROP            0x00000004L
#define MCI_SEQ_DIV_SMPTE_30                0x00000005L

   /*************************************************/
   /* MCI_STATUS items for videodisc                */
   /*************************************************/
#define MCI_VD_STATUS_SPEED                 MCI_VD_ITEM_BASE
#define MCI_VD_STATUS_FORWARD               (MCI_VD_ITEM_BASE+1)
#define MCI_VD_MEDIA_TYPE                   (MCI_VD_ITEM_BASE+2)
#define MCI_VD_STATUS_SIDE                  (MCI_VD_ITEM_BASE+3)
#define MCI_VD_STATUS_DISC_SIZE             (MCI_VD_ITEM_BASE+4)

    /***********************************************/
    /* return values for videodisc status command  */
    /***********************************************/
#define MCI_VD_SPEED_NORMAL                 0x00000000L
#define MCI_VD_SPEED_FAST                   0x00000001L
#define MCI_VD_SPEED_SLOW                   0x00000002L

/*************************************************/
/* MCI_STATUS items for wave audio               */
/*************************************************/
#define MCI_WAVE_STATUS_LEVEL               MCI_WAVE_ITEM_BASE
#define MCI_WAVE_STATUS_SAMPLESPERSEC       (MCI_WAVE_ITEM_BASE+1)
#define MCI_WAVE_STATUS_AVGBYTESPERSEC      (MCI_WAVE_ITEM_BASE+2)
#define MCI_WAVE_STATUS_BLOCKALIGN          (MCI_WAVE_ITEM_BASE+3)
#define MCI_WAVE_STATUS_FORMATTAG           (MCI_WAVE_ITEM_BASE+4)
#define MCI_WAVE_STATUS_CHANNELS            (MCI_WAVE_ITEM_BASE+5)
#define MCI_WAVE_STATUS_BITSPERSAMPLE       (MCI_WAVE_ITEM_BASE+6)

/*************************************************/
/* Common video MCI_STATUS items                 */
/*************************************************/
#define MCI_VID_STATUS_HWND                 MCI_VID_ITEM_BASE
#define MCI_VID_STATUS_AUDIO_COMPRESSION    (MCI_VID_ITEM_BASE+1)
#define MCI_VID_STATUS_VIDEO_COMPRESSION    (MCI_VID_ITEM_BASE+2)
#define MCI_VID_STATUS_IMAGE_COMPRESSION    (MCI_VID_ITEM_BASE+3)
#define MCI_VID_STATUS_AUDIO_QUALITY        (MCI_VID_ITEM_BASE+4)
#define MCI_VID_STATUS_VIDEO_QUALITY        (MCI_VID_ITEM_BASE+5)
#define MCI_VID_STATUS_IMAGE_QUALITY        (MCI_VID_ITEM_BASE+6)
#define MCI_VID_STATUS_IMAGE_BITSPERPEL     (MCI_VID_ITEM_BASE+7)
#define MCI_VID_STATUS_IMAGE_PELFORMAT      (MCI_VID_ITEM_BASE+8)
#define MCI_VID_STATUS_FORWARD              (MCI_VID_ITEM_BASE+9)
#define MCI_VID_STATUS_NORMAL_RATE          (MCI_VID_ITEM_BASE+10)
#define MCI_VID_STATUS_VIDEO_X_EXTENT       (MCI_VID_ITEM_BASE+11)
#define MCI_VID_STATUS_VIDEO_Y_EXTENT       (MCI_VID_ITEM_BASE+12)
#define MCI_VID_STATUS_IMAGE_X_EXTENT       (MCI_VID_ITEM_BASE+13)
#define MCI_VID_STATUS_IMAGE_Y_EXTENT       (MCI_VID_ITEM_BASE+14)
#define MCI_VID_STATUS_BRIGHTNESS           (MCI_VID_ITEM_BASE+15)
#define MCI_VID_STATUS_CONTRAST             (MCI_VID_ITEM_BASE+16)
#define MCI_VID_STATUS_HUE                  (MCI_VID_ITEM_BASE+17)
#define MCI_VID_STATUS_SATURATION           (MCI_VID_ITEM_BASE+18)
#define MCI_VID_STATUS_GREYSCALE            (MCI_VID_ITEM_BASE+19)
#define MCI_VID_STATUS_SHARPNESS            (MCI_VID_ITEM_BASE+20)
#define MCI_VID_STATUS_SPEED                (MCI_VID_ITEM_BASE+21)
#define MCI_VID_STATUS_IMAGE_FILE_FORMAT    (MCI_VID_ITEM_BASE+22)
#define MCI_VID_STATUS_TRANSPARENT_TYPE     (MCI_VID_ITEM_BASE+23)
#define MCI_VID_STATUS_REF_INTERVAL         (MCI_VID_ITEM_BASE+24)
#define MCI_VID_STATUS_MAXDATARATE          (MCI_VID_ITEM_BASE+25)
#define MCI_VID_STATUS_VIDEO_FILE_FORMAT    (MCI_VID_ITEM_BASE+26)

   /*************************************************/
   /* Status Transparent Type returns               */
   /* MCI_VID_PALETTE                               */
   /* MCI_VID_RGB                                   */
   /* MCI_VID_YUV                                   */
   /*************************************************/
#define MCI_VID_STATUS_TRANSPARENT_COLOR    (MCI_VID_ITEM_BASE+24)

/*************************************************/
/* MCI_STATUS items for digital video            */
/*************************************************/
#define MCI_DGV_STATUS_HWND                 MCI_VID_STATUS_HWND
#define MCI_DGV_STATUS_AUDIO_COMPRESSION    MCI_VID_STATUS_AUDIO_COMPRESSION
#define MCI_DGV_STATUS_VIDEO_COMPRESSION    MCI_VID_STATUS_VIDEO_COMPRESSION
#define MCI_DGV_STATUS_IMAGE_COMPRESSION    MCI_VID_STATUS_IMAGE_COMPRESSION
#define MCI_DGV_STATUS_AUDIO_QUALITY        MCI_VID_STATUS_AUDIO_QUALITY
#define MCI_DGV_STATUS_VIDEO_QUALITY        MCI_VID_STATUS_VIDEO_QUALITY
#define MCI_DGV_STATUS_IMAGE_QUALITY        MCI_VID_STATUS_IMAGE_QUALITY
#define MCI_DGV_STATUS_IMAGE_BITSPERPEL     MCI_VID_STATUS_IMAGE_BITSPERPEL
#define MCI_DGV_STATUS_IMAGE_PELFORMAT      MCI_VID_STATUS_IMAGE_PELFORMAT
#define MCI_DGV_STATUS_FORWARD              MCI_VID_STATUS_FORWARD
#define MCI_DGV_STATUS_NORMAL_RATE          MCI_VID_STATUS_NORMAL_RATE
#define MCI_DGV_STATUS_VIDEO_X_EXTENT       MCI_VID_STATUS_VIDEO_X_EXTENT
#define MCI_DGV_STATUS_VIDEO_Y_EXTENT       MCI_VID_STATUS_VIDEO_Y_EXTENT
#define MCI_DGV_STATUS_IMAGE_X_EXTENT       MCI_VID_STATUS_IMAGE_X_EXTENT
#define MCI_DGV_STATUS_IMAGE_Y_EXTENT       MCI_VID_STATUS_IMAGE_Y_EXTENT
#define MCI_DGV_STATUS_BRIGHTNESS           MCI_VID_STATUS_BRIGHTNESS
#define MCI_DGV_STATUS_CONTRAST             MCI_VID_STATUS_CONTRAST
#define MCI_DGV_STATUS_HUE                  MCI_VID_STATUS_HUE
#define MCI_DGV_STATUS_SATURATION           MCI_VID_STATUS_SATURATION
#define MCI_DGV_STATUS_SPEED                MCI_VID_STATUS_SPEED
#define MCI_DGV_STATUS_SHARPNESS            MCI_VID_STATUS_SHARPNESS
#define MCI_DGV_STATUS_REF_INTERVAL         MCI_VID_STATUS_REF_INTERVAL
#define MCI_DGV_STATUS_MAXDATARATE          MCI_VID_STATUS_MAXDATARATE
#define MCI_DGV_STATUS_VIDEO_FILE_FORMAT    MCI_VID_STATUS_VIDEO_FILE_FORMAT

#define MCI_DGV_STATUS_CHANNELS             (MCI_DGV_ITEM_BASE+13)
#define MCI_DGV_STATUS_BITSPERSAMPLE        (MCI_DGV_ITEM_BASE+14)
#define MCI_DGV_STATUS_SAMPLESPERSEC        (MCI_DGV_ITEM_BASE+15)
#define MCI_DGV_STATUS_FORMATTAG            (MCI_DGV_ITEM_BASE+16)
#define MCI_DGV_STATUS_BLOCKALIGN           (MCI_DGV_ITEM_BASE+17)
#define MCI_DGV_STATUS_AVGBYTESPERSEC       (MCI_DGV_ITEM_BASE+18)
#define MCI_DGV_STATUS_VIDEO_COMPRESSION_SUBTYPE   (MCI_DGV_ITEM_BASE+19)
#define MCI_DGV_STATUS_VIDEO_RECORD_RATE           (MCI_DGV_ITEM_BASE+20)
#define MCI_DGV_STATUS_VIDEO_RECORD_FRAME_DURATION (MCI_DGV_ITEM_BASE+21)
#define MCI_DGV_STATUS_RECORD_AUDIO         (MCI_DGV_ITEM_BASE+22)
#define MCI_DGV_STATUS_TRANSPARENT_COLOR    (MCI_DGV_ITEM_BASE+23)
#define MCI_DGV_STATUS_GRAPHIC_TRANSPARENT_COLOR (MCI_DGV_ITEM_BASE+23)  /* MUST BE SAME AS TRANSPARENT COLOR */
#define MCI_DGV_STATUS_HWND_MONITOR         (MCI_DGV_ITEM_BASE+24)
#define MCI_DGV_STATUS_DROPPED_FRAME_PCT    (MCI_DGV_ITEM_BASE+25)
#define MCI_DGV_STATUS_AUDIOSYNC            (MCI_DGV_ITEM_BASE+26)
#define MCI_DGV_STATUS_AUDIOSYNC_DIRECTION  (MCI_DGV_ITEM_BASE+27)
#define MCI_DGV_STATUS_VIDEO_TRANSPARENT_COLOR (MCI_DGV_ITEM_BASE+28)  /* MUST BE SAME AS TRANSPARENT COLOR */
#define MCI_DGV_STATUS_TUNER_TV_CHANNEL     (MCI_DGV_ITEM_BASE+29)
#define MCI_DGV_STATUS_TUNER_LOW_TV_CHANNEL (MCI_DGV_ITEM_BASE+30)
#define MCI_DGV_STATUS_TUNER_HIGH_TV_CHANNEL (MCI_DGV_ITEM_BASE+31)
#define MCI_DGV_STATUS_TUNER_REGION          (MCI_DGV_ITEM_BASE+32)
#define MCI_DGV_STATUS_TUNER_FINETUNE        (MCI_DGV_ITEM_BASE+33)
#define MCI_DGV_STATUS_TUNER_FREQUENCY       (MCI_DGV_ITEM_BASE+34)
#define MCI_DGV_STATUS_TUNER_AUDIO_CHANNEL   (MCI_DGV_ITEM_BASE+35)
#define MCI_DGV_STATUS_TUNER_AFC             (MCI_DGV_ITEM_BASE+36)
#define MCI_DGV_STATUS_VALID_SIGNAL          (MCI_DGV_ITEM_BASE+37)

/*************************************************/
/* MCI_STATUS item values for video overlay      */
/*************************************************/
#define MCI_OVLY_STATUS_HWND                 MCI_VID_STATUS_HWND
#define MCI_OVLY_STATUS_IMAGE_COMPRESSION    MCI_VID_STATUS_IMAGE_COMPRESSION
#define MCI_OVLY_STATUS_IMAGE_BITSPERPEL     MCI_VID_STATUS_IMAGE_BITSPERPEL
#define MCI_OVLY_STATUS_IMAGE_PELFORMAT      MCI_VID_STATUS_IMAGE_PELFORMAT
#define MCI_OVLY_STATUS_IMAGE_X_EXTENT       MCI_VID_STATUS_IMAGE_X_EXTENT
#define MCI_OVLY_STATUS_IMAGE_Y_EXTENT       MCI_VID_STATUS_IMAGE_Y_EXTENT
#define MCI_OVLY_STATUS_BRIGHTNESS           MCI_VID_STATUS_BRIGHTNESS
#define MCI_OVLY_STATUS_CONTRAST             MCI_VID_STATUS_CONTRAST
#define MCI_OVLY_STATUS_HUE                  MCI_VID_STATUS_HUE
#define MCI_OVLY_STATUS_SATURATION           MCI_VID_STATUS_SATURATION
#define MCI_OVLY_STATUS_GREYSCALE            MCI_VID_STATUS_GREYSCALE
#define MCI_OVLY_STATUS_IMAGE_QUALITY        MCI_VID_STATUS_IMAGE_QUALITY
#define MCI_OVLY_STATUS_SHARPNESS            MCI_VID_STATUS_SHARPNESS
#define MCI_OVLY_STATUS_IMAGE_FILE_FORMAT    MCI_VID_STATUS_IMAGE_FILE_FORMAT
#define MCI_OVLY_STATUS_TRANSPARENT_TYPE     MCI_VID_STATUS_TRANSPARENT_TYPE
#define MCI_OVLY_STATUS_TRANSPARENT_COLOR    MCI_VID_STATUS_TRANSPARENT_COLOR

   /*************************************************/
   /* Status Mode return values                     */
   /*************************************************/
#define MCI_MODE_NOT_READY                  0x00000001L
#define MCI_MODE_PAUSE                      0x00000002L
#define MCI_MODE_PLAY                       0x00000003L
#define MCI_MODE_STOP                       0x00000004L
#define MCI_MODE_RECORD                     0x00000005L
#define MCI_MODE_SEEK                       0x00000006L

   /*************************************************/
   /* Status Direction return values                */
   /*************************************************/
#define MCI_FORWARD                         0x00000000L
#define MCI_REVERSE                         0x00000001L

typedef struct _MCI_STATUS_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message */
    DWORD   dwReturn;        /* Return field                            */
    DWORD   dwItem;          /* Item field for STATUS item to query     */
    DWORD   dwValue;         /* Status value field (this used to be)    */
                             /*  dwTrack but was changed in Rel 1.1     */
                             /*  to extend the status structure.        */
                             /*  See the programming reference on when  */
                             /*  dwValue is used and how...             */
} MCI_STATUS_PARMS;
typedef MCI_STATUS_PARMS   *LPMCI_STATUS_PARMS;


typedef struct _MCI_CDXA_STATUS_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message */
    DWORD   dwReturn;        /* Return field                            */
    DWORD   dwItem;          /* Item field for STATUS item to query     */
    DWORD   dwValue;         /* Status value field (this used to be)    */
                             /*  dwTrack but was changed in Rel 1.1     */
                             /*  to extend the status structure.        */
                             /*  See the programming reference on when  */
                             /*  dwValue is used and how...             */
    DWORD   dwChannel;       /* Channel                                 */
} MCI_CDXA_STATUS_PARMS;
typedef MCI_CDXA_STATUS_PARMS   *LPMCI_CDXA_STATUS_PARMS;

/*********************************************************************/
/* flags and parameter structure for the MCI_STEP message            */
/*     0x00000X00 are reserved for MCI_STEP flags                    */
/*********************************************************************/
#define MCI_STEP_FRAMES                     0x00000100L
#define MCI_STEP_REVERSE                    0x00000200L

typedef struct _MCI_STEP_PARMS {
    DWORD   dwCallback;      /* PM window handle for MCI notify message */
    DWORD   dwStep;          /* amount to step in current time format   */
} MCI_STEP_PARMS;
typedef MCI_STEP_PARMS   *LPMCI_STEP_PARMS;

/*********************************************************************/
/* flags for the MCI_SYSINFO message                                 */
/*     0xXXXXXX00 are reserved for MCI_SYSINFO flags                 */
/*********************************************************************/
#define MCI_SYSINFO_QUANTITY                0x00000100L
#define MCI_SYSINFO_OPEN                    0x00000200L
#define MCI_SYSINFO_NAME                    0x00000400L
#define MCI_SYSINFO_INSTALLNAME             0x00000800L
#define MCI_SYSINFO_ITEM                    0x00001000L
#define MCI_SYSINFO_INI_LOCK                0x00002000L

    /********************************************************/
    /* Extended SYSINFO functions                           */
    /********************************************************/
    #define MCI_SYSINFO_INSTALL_DRIVER      0x00000001L
    #define MCI_SYSINFO_QUERY_DRIVER        0x00000002L
    #define MCI_SYSINFO_DELETE_DRIVER       0x00000004L
    #define MCI_SYSINFO_SET_PARAMS          0x00000008L
    #define MCI_SYSINFO_QUERY_PARAMS        0x00000010L
    #define MCI_SYSINFO_SET_CONNECTORS      0x00000020L
    #define MCI_SYSINFO_QUERY_CONNECTORS    0x00000040L
    #define MCI_SYSINFO_SET_EXTENSIONS      0x00000080L
    #define MCI_SYSINFO_QUERY_EXTENSIONS    0x00000100L
    #define MCI_SYSINFO_SET_ALIAS           0x00000200L
    #define MCI_SYSINFO_QUERY_NAMES         0x00000400L
    #define MCI_SYSINFO_SET_DEFAULT         0x00000800L
    #define MCI_SYSINFO_QUERY_DEFAULT       0x00001000L
    #define MCI_SYSINFO_SET_TYPES           0x00002000L
    #define MCI_SYSINFO_QUERY_TYPES         0x00004000L

    /********************************************************/
    /* Device Flags                                         */
    /********************************************************/
    #define MCI_SYSINFO_DEV_CONTROLLABLE    0x00000001L
    #define MCI_SYSINFO_DEV_NONCONTROLLABLE 0x00000002L
    #define MCI_SYSINFO_DEVICESETTINGS      0x00000004L

/*********************************************************************/
/* parameter structures for the MCI_SYSINFO message                  */
/*********************************************************************/
typedef struct _MCI_SYSINFO_PARMS {
    DWORD   dwDummyCallback; /* NOTIFY not allowed for SYSINFO          */
    LPSTR   lpstrReturn;     /* Pointer to return buffer                */
    DWORD   dwRetSize;       /* Return buffer size                      */
    DWORD   dwNumber;        /* Ordinal Number                          */
    WORD    wDeviceType;     /* MCI device type number                  */
    WORD    wReserved0;      /* Reserved field                          */
    DWORD   dwItem;          /* Used to indicate the MCI_SYSINFO        */
                             /* extended function to perform            */
    PVOID   pSysInfoParm;
} MCI_SYSINFO_PARMS;
typedef MCI_SYSINFO_PARMS   *LPMCI_SYSINFO_PARMS;

typedef struct _MCI_SYSINFO_LOGDEVICE {
    CHAR    szInstallName[MAX_DEVICE_NAME];       /* Device install name            */
    USHORT  usDeviceType;                         /* Device type number             */
    ULONG   ulDeviceFlag;                         /* Flag indicating whether device */
                                                  /*  device is controllable or not */
    CHAR    szVersionNumber[MAX_VERSION_NUMBER];  /* INI file version number        */
    CHAR    szProductInfo[MAX_PRODINFO];          /* Textual product description    */
    CHAR    szMCDDriver[MAX_DEVICE_NAME];         /* MCI Driver dll name            */
    CHAR    szVSDDriver[MAX_DEVICE_NAME];         /* VSD dll name                   */
    CHAR    szPDDName[MAX_PDD_NAME];              /* Device PDD name                */
    CHAR    szMCDTable[MAX_DEVICE_NAME];          /* Device type command table      */
    CHAR    szVSDTable[MAX_DEVICE_NAME];          /* Device specific command table  */
    USHORT  usShareType;                          /* Device sharing mode            */
    CHAR    szResourceName[MAX_DEVICE_NAME];      /* Resource name                  */
    USHORT  usResourceUnits;                      /* Total resource units available */
                                                  /*  for this device               */
    USHORT  usResourceClasses;                    /* Number of resource classes for */
                                                  /*  this device                   */
    USHORT  ausClassArray[MAX_CLASSES];           /* Maximum number of resource     */
                                                  /*  units for each class          */
    USHORT  ausValidClassArray[MAX_CLASSES][MAX_CLASSES]; /* Valid class combinations */
} MCI_SYSINFO_LOGDEVICE;
typedef MCI_SYSINFO_LOGDEVICE  *LPMCI_SYSINFO_LOGDEVICE;


typedef struct _MCI_SYSINFO_DEVPARAMS {
    CHAR    szInstallName[MAX_DEVICE_NAME];       /* Device install name            */
    CHAR    szDevParams[MAX_DEV_PARAMS];          /* Device specific parameters     */
} MCI_SYSINFO_DEVPARAMS;
typedef MCI_SYSINFO_DEVPARAMS *LPMCI_SYSINFO_DEVPARAMS;

typedef struct _CONNECT {
    WORD   wConnectType;                          /* Connector type                 */
    CHAR   szToInstallName[MAX_DEVICE_NAME];      /* Install name this connector    */
                                                  /*  is connected to               */
    WORD   wToConnectIndex;                       /* Connector index this connector */
                                                  /*  is connected to               */
} CONNECT;
typedef CONNECT *PCONNECT;


typedef struct _MCI_SYSINFO_CONPARAMS {
    CHAR    szInstallName[MAX_DEVICE_NAME];       /* Device install name            */
    USHORT  usNumConnectors;                      /* Number of device connectors    */
    CONNECT ConnectorList[MAX_CONNECTORS];        /* Connector list array           */
} MCI_SYSINFO_CONPARAMS;
typedef MCI_SYSINFO_CONPARAMS *LPMCI_SYSINFO_CONPARAMS;

typedef struct _MCI_SYSINFO_EXTENSION {
    CHAR    szInstallName[MAX_DEVICE_NAME];       /* Device install name            */
    USHORT  usNumExtensions;                      /* Number of extensions           */
    CHAR    szExtension[MAX_EXTENSIONS][MAX_EXTENSION_NAME];
                                                  /* Extension name array           */
} MCI_SYSINFO_EXTENSION;
typedef MCI_SYSINFO_EXTENSION *LPMCI_SYSINFO_EXTENSION;

typedef struct _MCI_SYSINFO_ALIAS {
    CHAR    szInstallName[MAX_DEVICE_NAME];       /* Device install name  */
    CHAR    szAliasName[MAX_ALIAS_NAME];          /* Alias name           */
} MCI_SYSINFO_ALIAS;
typedef MCI_SYSINFO_ALIAS *LPMCI_SYSINFO_ALIAS;

typedef struct _MCI_SYSINFO_DEFAULTDEVICE {
    CHAR    szInstallName[MAX_DEVICE_NAME];       /* Device install name  */
    USHORT  usDeviceType;                         /* Device type number   */
} MCI_SYSINFO_DEFAULTDEVICE;
typedef MCI_SYSINFO_DEFAULTDEVICE *LPMCI_SYSINFO_DEFAULTDEVICE;

typedef struct _MCI_SYSINFO_QUERY_NAME {
    CHAR    szInstallName[MAX_DEVICE_NAME];       /* Device install name  */
    CHAR    szLogicalName[MAX_DEVICE_NAME];       /* Logical device name  */
    CHAR    szAliasName[MAX_ALIAS_NAME];          /* Alias name           */
    USHORT  usDeviceType;                         /* Device type number   */
    USHORT  usDeviceOrd;                          /* Device type ordinal  */
} MCI_SYSINFO_QUERY_NAME;
typedef MCI_SYSINFO_QUERY_NAME *LPMCI_SYSINFO_QUERY_NAME;

typedef struct _MCI_SYSINFO_TYPES {
    CHAR    szInstallName[MAX_DEVICE_NAME];       /* Device install name  */
    CHAR    szTypes[MAX_TYPEBUFFER+1];            /* EA types             */
} MCI_SYSINFO_TYPES;
typedef MCI_SYSINFO_TYPES *LPMCI_SYSINFO_TYPES;


/*********************************************************************/
/* flags for the MCI_UNFREEZE message                                */
/*     0x00000X00 are reserved for MCI_UNFREEZE flags                */
/*********************************************************************/
#define MCI_OVLY_UNFREEZE_RECT              0x00000100L
#define MCI_OVLY_UNFREEZE_RECT_OUTSIDE      0x00000200L

/*********************************************************************/
/* flags for the MCI_WHERE message                                   */
/*     0x0000XX00 are reserved for MCI_WHERE flags                   */
/*********************************************************************/
#define MCI_VID_WHERE_DESTINATION           0x00000100L
#define MCI_VID_WHERE_SOURCE                0x00000200L
#define MCI_VID_WHERE_WINDOW                0x00000400L

#define MCI_DGV_WHERE_DESTINATION           MCI_VID_WHERE_DESTINATION
#define MCI_DGV_WHERE_SOURCE                MCI_VID_WHERE_SOURCE
#define MCI_DGV_WHERE_WINDOW                MCI_VID_WHERE_WINDOW
#define MCI_DGV_WHERE_ADJUSTED              0x00000800L

#define MCI_OVLY_WHERE_DESTINATION          MCI_VID_WHERE_DESTINATION
#define MCI_OVLY_WHERE_SOURCE               MCI_VID_WHERE_SOURCE
#define MCI_OVLY_WHERE_WINDOW               MCI_VID_WHERE_WINDOW

/*********************************************************************/
/* flags and parameter structure for the MCI_WINDOW message          */
/*     0x0000XX00   are reserved for MCI_WINDOW flags                */
/*********************************************************************/
#define MCI_VID_WINDOW_HWND                 0x00000100L
#define MCI_VID_WINDOW_STATE                0x00000200L
#define MCI_VID_WINDOW_TEXT                 0x00000400L
#define MCI_VID_WINDOW_DEFAULT              0x00000800L

#define MCI_DGV_WINDOW_HWND                 MCI_VID_WINDOW_HWND
#define MCI_DGV_WINDOW_STATE                MCI_VID_WINDOW_STATE
#define MCI_DGV_WINDOW_TEXT                 MCI_VID_WINDOW_TEXT
#define MCI_DGV_WINDOW_DEFAULT              MCI_VID_WINDOW_DEFAULT

#define MCI_OVLY_WINDOW_HWND                MCI_VID_WINDOW_HWND
#define MCI_OVLY_WINDOW_STATE               MCI_VID_WINDOW_STATE
#define MCI_OVLY_WINDOW_TEXT                MCI_VID_WINDOW_TEXT
#define MCI_OVLY_WINDOW_DEFAULT             MCI_VID_WINDOW_DEFAULT

typedef  struct _MCI_VID_WINDOW_PARMS{
    DWORD   dwCallback;      /* PM window handle for MCI notify message */
    HWND    hwndDest;        /* Handle to the client window used for    */
                             /* the destination of the video image      */
    WORD    wCmdShow;        /* Specifies how the window is displayed   */
    WORD    wReserved1;      /* Reserved                                */
    LPSTR   lpstrText;       /* The text to use as the window caption   */
    LPSTR   lpstrAlias;      /* The window alias for the display window */
} MCI_VID_WINDOW_PARMS;

typedef MCI_VID_WINDOW_PARMS   MCI_DGV_WINDOW_PARMS;
typedef MCI_DGV_WINDOW_PARMS   *LPMCI_DGV_WINDOW_PARMS;

typedef MCI_VID_WINDOW_PARMS   MCI_OVLY_WINDOW_PARMS;
typedef MCI_OVLY_WINDOW_PARMS  *LPMCI_OVLY_WINDOW_PARMS;


/*********************************************************************/
/* flags and parameter structure for the MCI_TUNER  message     PML  */
/*********************************************************************/
#define MCI_DGV_AUDIO_CHANNEL               0x00010000L
#define MCI_DGV_TV_CHANNEL                  0x00020000L
#define MCI_DGV_FREQUENCY                   0x00040000L
#define MCI_DGV_FINETUNE_PLUS               0x00080000L
#define MCI_DGV_FINETUNE_MINUS              0x00100000L
#define MCI_DGV_REGION                      0x00200000L
#define MCI_DGV_AFC_ON                      0x00400000L
#define MCI_DGV_AFC_OFF                     0x00800000L
#define MCI_DGV_POLARIZATION                0x00800000L
#define MCI_DGV_QUERY                       0x01000000L

typedef struct _MCI_DGV_TUNER_PARMS {
    ULONG  ulCallback;       /* PM window handle for MCI notify message    */
    ULONG  ulFrequency;      /* Tuner Frequency                            */
    ULONG  ulAudioChannel;   /* Audio Channel                              */
    ULONG  usTVChannel;      /* TV Channel                                 */
    LONG   lFineTune;        /* Fine tuning adjustments.                   */
    LPSTR  lpstrRegion;      /* TV Channel Region                          */
    ULONG  ulReserved1;      /* Reserved 1                                 */
    ULONG  ulReserved2;      /* Reserved 2                                 */
} MCI_DGV_TUNER_PARMS;
typedef MCI_DGV_TUNER_PARMS   *LPMCI_DGV_TUNER_PARMS;

#pragma pack()
/*********************************************************************/
/*                                                                   */
/*  MCI system value defines                                         */
/*                                                                   */
/*********************************************************************/
#define MSV_CLOSEDCAPTION                   0x0
#define MSV_MASTERVOLUME                    0x1
#define MSV_HEADPHONES                      0x2
#define MSV_SPEAKERS                        0x3
#define MSV_WORKPATH                        0x4
#define MSV_SYSQOSVALUE                     0x5
#define MSV_SYSQOSERRORFLAG                 0x6

#define MSV_MAX                             0x7

#endif                       /* INCL_32 */

/*********************************************************************/
/* Playlist defines                                                  */
/*********************************************************************/
#define DATA_OPERATION                      0
#define BRANCH_OPERATION                    1
#define LOOP_OPERATION                      2
#define CALL_OPERATION                      3
#define RETURN_OPERATION                    4
#define EXIT_OPERATION                      5
#define NOP_OPERATION                       6
#define MESSAGE_OPERATION                   7
#define CUEPOINT_OPERATION                  8

/*********************************************************************/
/*                                                                   */
/*  MCI Function prototypes                                          */
/*                                                                   */
/*********************************************************************/

#ifdef INCL_32

DWORD APIENTRY mciSendCommand   (WORD   wDeviceID,
                                 WORD   wMessage,
                                 DWORD  dwParam1,
                                 DWORD  dwParam2,
                                 WORD   wUserParm);

DWORD APIENTRY  mciSendString   (LPSTR lpstrCommandBuf,
                                 LPSTR lpstrReturnString,
                                 WORD  wReturnLength,
                                 HWND  hCallBack,
                                 WORD  wUserParm );

DWORD APIENTRY mciGetErrorString(DWORD   dwError,
                                 LPSTR   lpstrBuffer,
                                 WORD    wLength);


DWORD APIENTRY mciMakeGroup     (PW      pwDeviceGroupID,
                                 WORD    wDeviceCount,
                                 PAW     pawDeviceList,
                                 DWORD   dwFlags,
                                 DWORD   dwMMTime);


DWORD APIENTRY mciDeleteGroup   (WORD   wGroupID);



BOOL APIENTRY mciSetSysValue (USHORT iSysValue, PVOID pValue);

BOOL  APIENTRY mciQuerySysValue (USHORT iSysValue, PVOID pValue);

DWORD  APIENTRY mciGetDeviceID  (LPSTR  lpstrName);

#else                        /* INCL_32 */

#define mciSendString mci16SendString
#define mciGetErrorString mci16GetErrorString
#define mciGetDeviceID mci16GetDeviceID

ULONG APIENTRY  mciSendString   (LPSTR   lpstrCommandBuf,
                                 LPSTR   lpstrReturnString,
                                 WORD    wReturnLength,
                                 HWND    hCallBack,
                                 WORD    wUserParm );

ULONG APIENTRY mciGetErrorString    (DWORD  dwError,
                                     LPSTR  lpstrBuffer,
                                     WORD   wLength);

ULONG APIENTRY mciGetDeviceID  (LPSTR  lpstrName);


#endif                       /* INCL_32 */
