;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;-----------------------------Module-Header-----------------------------;
; Module Name: RESMAP.INC
;
; Created: 15-Oct-1991
; Author:  Soh Ohta     [jl09057 @ ymtvm3, IBM Japan]
;
;                       Refer to Copyright Inscruction Form No.G120-2083
;
; Exported Functions:   none
;
; Public Functions:     none
;
; Public Data:          none
;
; General Description:
;
;-----------------------------------------------------------------------;

UNDEFINED_VALUE equ     0
INVALID_ADDRESS equ     0

;
; Font id.
;

FONT_FD_VIRTUAL_FONT    equ     0       ; FD virtual font
FONT_CP_MBCS_BASEFONT   equ     1       ; CP MBCS font call (via FNTCALLS)
FONT_PM_SBCS_RESOURCE   equ     2       ; PM SBCS font resource
FONT_PM_SBCS_OTHERDLL   equ     3       ; PM SBCS font resource
FONT_PM_DBCS_USERFONT   equ     4       ; PM DBCS font file (via USERFDD)
FONT_PM_DBCS_FONTFILE   equ     5       ; PM DBCS font file
FONT_WIN_DBCS_FONTFILE  equ     6       ;         DBCS WIFE font file

;
; Resource type.
;

RT_RESMAP       equ     1001            ; FD resource mapping table
RT_CPINFO       equ     1002            ; FD default codepage info
RT_FDDESC       equ     1003            ; FD description
RT_VFONT        equ     1004            ; FD virtual fonts
RT_PFONT        equ     7               ; FD physical fonts (same as .FON)

;
; Resource id.
;

RI_RESMAP       equ     1

;
; Driver codepage information.
;

VECTOR          struc
ve_lo           db      ?
ve_hi           db      ?
VECTOR          ends

CPINFO          struc
ci_usCodePage   dw      ?               ; codepage id
ci_usFirstChar  dw      ?               ; DBCS first char
ci_usLastChar   dw      ?               ; DBCS last char
ci_usDefaultChar dw     ?               ; DBCS default char
ci_usBreakChar  dw      ?               ; DBCS break char
ci_usBlobChar   dw      ?               ; DBCS blob char
ci_c1stRange    dw      ?               ; DBCS leading byte ranges
ci_av1stRange   db      (size VECTOR)*5 dup (?)
ci_c2ndRange    dw      ?               ; DBCS trailing byte ranges
ci_av2ndRange   db      (size VECTOR)*5 dup (?)
CPINFO          ends

;
; Font bits definition.
;

BITSDEF         struc
bd_npBits       dw      ?               ; pointer to bitmap bits
bd_cbScan       db      ?               ; bitmap width in bytes
bd_nScans       db      ?               ; bitmap height in scancount
bd_x            db      ?               ; x offset to image mapping rect
bd_y            db      ?               ; y offset to image mapping rect
bd_cx           db      ?               ; x extent of image mapping rect
bd_cy           db      ?               ; y extent of image mapping rect
BITSDEF         ends

;
; Virtual / physical font resource descriptor.
;

RESMAP          struc
rm_npFont       dw      ?               ; resource mapping chain
rm_npPrivate    dw      ?               ; pointer to font private info
rm_fontId       dw      ?               ; font source id
rm_refCount     dw      ?               ; reference count
rm_bd           db      (size BITSDEF) dup (?)  ; bitmap definition
rm_resId        dw      ?               ; metrics resource id
rm_fsTypeFlags  dw      ?               ; font type flags
rm_xMaxCharInc  dw      ?               ; max char increment
rm_xAveCharWidth dw     ?               ; average char width
rm_yMaxBaselineExt dw   ?               ; max baseline extent
RESMAP          ends

;
; Virtual font resource descriptor header.
;

RESMAPHEADER    struc
rh_cbSize       dw      ?               ; size of RESMAP resource segment
rh_cFonts       dw      ?               ; number of virtual fonts
;rh_aFonts                              ; array  of virtual fonts
RESMAPHEADER    ends

;
; Definitions for base fonts.
;

FNTBLOCK        struc
fb_cbFix        dw      ?               ; size of FNTBLOCK structure
fb_codepage     dw      ?               ; 0 (default)
fb_reserved1    dw      ?               ; 0
fb_reserved2    dw      ?               ; 0
fb_fontId       dw      ?               ; font id (BF_ID_*)
fb_width        dw      ?               ; font width
fb_height       dw      ?               ; font height
FNTBLOCK        ends

BASEFONTINFO    struc
bf_option       dw      ?               ; option flags (BF_OPTION_*)
bf_fb           db      (size FNTBLOCK) dup (?)
BASEFONTINFO    ends

BF_ID_STANDARD_DBCS     equ     0000h   ; base DBCS fonts
BF_ID_STANDARD_SBCS     equ     0001h   ; base SBCS fonts
BF_OPTION_NORMAL        equ     0000h   ; requesting normal box
BF_OPTION_PACKED        equ     0002h   ; requesting normal box (packed)
BF_OPTION_FULLBOX       equ     0004h   ; requesting full box

;
; Definitions for resource fonts.
;

RESOURCEINFO    struc
rf_resType      dw      ?               ; resource type
rf_resId        dw      ?               ; resource id
rf_lpFoca       dd      ?               ; long pointer to FOCAFONT
rf_szModule     db      ?               ; module name
RESOURCEINFO    ends

;
; Definition for fontfile fonts.
;

FONTFILEINFO    struc
ff_npEncode     dw      ?               ; pointer to encode table
ff_npCache      dw      ?               ; pointer to disk cache
ff_cbCache      dw      ?               ; disk cache size
ff_cbValid      dw      ?               ; valid data size
ff_ulOffset     dd      ?               ; current file pointer location
ff_szFile       db      ?               ; fontfile name
FONTFILEINFO    ends

;
; Definition for user fontfile fonts.
;

USERFONTINFO    struc
uf_szFile       db      ?               ; user fontfile name
USERFONTINFO    ends

UFONTMAP        struc
um_lpBits       dd      ?               ; image buffer address
um_width        dw      ?               ; width
um_height       dw      ?               ; height
UFONTMAP        ends

;
; Definitions for         DBCS WIFE font decompression.
;

MAXHEIGHT       equ     48
MAXROW          equ     16
MAXTBL          equ     16*16*16
MSTONE          equ     16

MASKTBL         struc
mt_mask         dw      ?
mt_len          db      ?
mt_data         db      ?
MASKTBL         ends

ENCODE          struc
ec_cbSize       dw      ?
ec_cx           db      ?
ec_cy           db      ?
ec_nChar        dw      ?
ec_nMask        dw      ?
ec_npMstone     dw      ?
ec_npLenTbl     dw      ?
ec_Dcmp         db      (MAXTBL/2) dup (?)
ec_Huff         db      ?
ENCODE          ends

