/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************/
/*  Module Name: RESMAP.H                                                     */
/*                                                                            */
/*  Created: 15-Oct-1991                                                      */
/*  Author:  Soh Ohta     [jl09057 @ ymtvm3, IBM Japan]                       */
/*                                                                            */
/*                        Refer to Copyright Inscruction Form No.G120-2083    */
/*                                                                            */
/*  Exported Functions:   none                                                */
/*                                                                            */
/*  Public Functions:     none                                                */
/*                                                                            */
/*  Public Data:          none                                                */
/*                                                                            */
/*  General Description:                                                      */
/*                                                                            */
/******************************************************************************/

#define UNDEFINED_VALUE 0
#define INVALID_ADDRESS 0

//
// Font id.
//

#define FONT_FD_VIRTUAL_FONT    0       // FD virtual font
#define FONT_CP_MBCS_BASEFONT   1       // CP MBCS font call (via FNTCALLS)
#define FONT_PM_SBCS_RESOURCE   2       // PM SBCS font resource
#define FONT_PM_SBCS_OTHERDLL   3       // PM SBCS font resource
#define FONT_PM_DBCS_USERFONT   4       // PM DBCS font file (via USERFDD)
#define FONT_PM_DBCS_FONTFILE   5       // PM DBCS font file
#define FONT_WIN_DBCS_FONTFILE  6       //         DBCS WIFE font file

//
// Resource type.
//

#define RT_RESMAP       1001            // FD resource mapping table
#define RT_CPINFO       1002            // FD default codepage info
#define RT_FDDESC       1003            // FD description
#define RT_VFONT        1004            // FD virtual fonts
#define RT_PFONT        7               // FD physical fonts (same as .FON)

//
// Resource id.
//

#define RI_RESMAP       1

//
// Driver codepage information.
//

typedef struct _VE {    /* ve */
    BYTE            lo;
    BYTE            hi;
} VECTOR, NEAR *NPVECTOR;

typedef struct _CI {    /* ci */
    USHORT          usCodePage;         // codepage id
    USHORT          usFirstChar;        // DBCS first char
    USHORT          usLastChar;         // DBCS last char
    USHORT          usDefaultChar;      // DBCS default char
    USHORT          usBreakChar;        // DBCS break char
    USHORT          usBlobChar;         // DBCS blob char
    USHORT          c1stRange;          // DBCS leading byte ranges
    VECTOR          av1stRange[5];      //
    USHORT          c2ndRange;          // DBCS trailing byte ranges
    VECTOR          av2ndRange[5];      //
} CPINFO, NEAR *NPCPINFO;

//
// Font bits definition.
//

typedef struct _BD {    /* bd */
    NPBYTE          npBits;             // pointer to bitmap bits
    BYTE            cbScan;             // bitmap width in bytes
    BYTE            nScans;             // bitmap height in scancount
    BYTE            x;                  // x offset to image mapping rect
    BYTE            y;                  // y offset to image mapping rect
    BYTE            cx;                 // x extent of image mapping rect
    BYTE            cy;                 // y extent of image mapping rect
} BITSDEF, NEAR *NPBITSDEF;

//
// Virtual / physical font resource descriptor.
//

typedef struct _RM {    /* rm */
    struct _RM NEAR *npFont;            // resource mapping chain
    NPBYTE          npPrivate;          // pointer to font private info
    USHORT          fontId;             // font source id
    USHORT          refCount;           // reference count
    BITSDEF         bitsDef;            // bitmap definition
    USHORT          resId;              // metrics resource id
    USHORT          fsTypeFlags;        // font type flags
    USHORT          xMaxCharInc;        // max char increment
    USHORT          xAveCharWidth;      // average char width
    USHORT          yMaxBaselineExt;    // max baseline extent
} RESMAP, NEAR *NPRESMAP;

//
// Virtual font resource descriptor header.
//

typedef struct _RH {    /* rh */
    USHORT          cbSize;             // size of RESMAP resource segment
    USHORT          cFonts;             // number of virtual fonts
    RESMAP          aFonts[1];          // array  of virtual fonts
} RESMAPHEADER, NEAR *NPRESMAPHEADER;

//
// Definitions for base fonts.
//

typedef struct _FB {    /* fb */
    USHORT          cbFix;              // size of FNTBLOCK structure
    USHORT          codepage;           // 0 (default)
    USHORT          reserved1;          // 0
    USHORT          reserved2;          // 0
    USHORT          fontId;             // font id (BF_ID_*)
    USHORT          width;              // font width
    USHORT          height;             // font height
} FNTBLOCK, FAR *PFNTBLOCK;

typedef struct _BF {    /* bf */
    USHORT          option;             // option flags (BF_OPTION_*)
    FNTBLOCK        fntBlock;           // FntGetImage () parameter
} BASEFONTINFO, NEAR *NPBASEFONTINFO;

#define BF_ID_STANDARD_DBCS     0x0000  // base DBCS fonts
#define BF_ID_STANDARD_SBCS     0x0001  // base SBCS fonts
#define BF_OPTION_NORMAL        0x0000  // requesting normal box
#define BF_OPTION_PACKED        0x0002  // requesting normal box (packed)
#define BF_OPTION_FULLBOX       0x0004  // requesting full box

//
// Definitions for resource fonts.
//

typedef struct _RF {    /* rf */
    USHORT          resType;            // resource type
    USHORT          resId;              // resource id
    PFOCAFONT       lpFoca;             // long pointer to FOCAFONT
    CHAR            szModule[1];        // module name
} RESOURCEINFO, NEAR *NPRESOURCEINFO;

//
// Definition for fontfile fonts.
//

typedef struct _FF {    /* ff */
    NPBYTE          npEncode;           // pointer to encode table
    NPBYTE          npCache;            // pointer to disk cache
    USHORT          cbCache;            // disk cache size
    USHORT          cbValid;            // valid data size
    ULONG           ulOffset;           // current file pointer location
    CHAR            szFile[1];          // fontfile name
} FONTFILEINFO, NEAR *NPFONTFILEINFO;

//
// Definition for user fontfile fonts.
//

typedef struct _UF {    /* uf */
    CHAR            szFile[1];          // user fontfile name
} USERFONTINFO, NEAR *NPUSERFONTINFO;

typedef struct _UM {    /* um */
    PBYTE           lpBits;             // image buffer address
    USHORT          height;             // width
    USHORT          width;              // height
} UFONTMAP, NEAR *NPUFONTMAP, FAR *PUFONTMAP;

//
// Definitions for         DBCS WIFE font decompression.
//

typedef ULONG NEAR *NPULONG;
typedef UCHAR NEAR *NPSZ;

#define MAXHEIGHT   48
#define MAXROW      16
#define MAXTBL      16*16*16
#define MSTONE      16

typedef struct _MASKTBL {   /* mt */
    USHORT      mask;
    BYTE        len;
    BYTE        data;
} MASKTBL;

typedef struct _ENCODE {    /* ec */
    USHORT      cbSize;
    BYTE        cx;
    BYTE        cy;
    USHORT      nChar;
    USHORT      nMask;
    NPULONG     npMstone;
    NPBYTE      npLenTbl;
    BYTE        Dcmp[MAXTBL/2];
    MASKTBL     Huff[1];
} ENCODE,NEAR *NPENCODE;

//
// Physical to Virtual Mapping Macros.
//

#define GetMappedWidth(w,v,p) \
        (((w)*(v)->xAveCharWidth)/(p)->xAveCharWidth)

#define GetMappedCbScan(w,v,p) \
        ((GetMappedWidth(w,v,p)-1)/8+1)

#define GetMappedCbBuf(w,v,p) \
        (GetMappedCbScan(w,v,p)*(v)->bitsDef.nScans)

