;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;-----------------------------Module-Header-----------------------------;
; Module Name: PC3270.INC
;
;   Font driver font metrics definition.
;
; Created: 30-Jan-1992
; Author:  Soh Ohta     [jl09057 @ ymtvm3, IBM Japan]
;
;                       Refer to Copyright Inscruction Form No.G120-2083
;
; Exported Functions:   none
;
; Public Functions:     none
;
; Public Data:          none
;
; General Description:
;
;-----------------------------------------------------------------------;

;-----------------------------------------------------------------------;
;   Character Design Descriptions
;
;                                               
;   Ŀ             Ŀ
;   ....................             DBCS_Leading....................
;   ....................SBCS_Leading       ******Ĵ
;   ******..........                  .**......**..**...*.
;   .**....**...........                       .***.***************
;   .**....**...........                       ..*......**..**.....
;   .***..***...........                       *.....*..**..**..*..
;   .***..***...........  SBCS_UpperExt        **..*.*************.
;   .***..***...........                       .**.*.**...**...**..
;   .***.****.********ĳ                  .**.*.**...**...**..
;   .***.*.**..**.....*.                      ...**.**...**...**..
;   .*.***.**..**.....*.         DBCS_MaxExt  ...*..************..
;   .*.***.**...**...**.                      ..**..**...**.......
;   .*.***.**...**...*..                      ..**.......**....*..
;   .*..*..**....**.**..   SBCS_LowerExt      ..*..**************.
;   .*..*..**....**.*...                      ***........**.......
;   .*..*..**.....***...                      .*.........**.....*.
;   .*.....**......*....                      .**.****************
;   .*.....**..*..**....                      ..**.....***.**.....
;   ************ĴSBCS_Baseline     ..**....**....***...
;   ..........*****.....                        ..**..***......*****
;   ..........-***-----------DBCS_Baseline*******Ĵ
;   ....................                         ....................
;                            
;
;-----------------------------------------------------------------------;

;-----------------------------------------------------------------------;
;   MINCHO System fonts
;-----------------------------------------------------------------------;

ifdef EZ08SYS                           ; MINCHO System  8pt ( 6x12)
    EH08SYS         equ     1
    DBCS            equ     1
endif;EZ08SYS
ifdef EH08SYS
    FIXED           equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO System', 19 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  80
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     10
    SBCS_LowerExt   equ     7
    SBCS_Leading    equ     2
    SBCS_Width      equ     6
    DBCS_Baseline   equ     1
    DBCS_MaxExt     equ     12
    DBCS_Leading    equ     1
endif;EH08SYS

ifdef EZ10SYS                           ; MINCHO System 10pt ( 7x16)
    EH10SYS         equ     1
    DBCS            equ     1
endif;EZ10SYS
ifdef EH10SYS
    FIXED           equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO System', 19 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  100
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     12
    SBCS_LowerExt   equ     8
    SBCS_Leading    equ     2
    SBCS_Width      equ     7
    DBCS_Baseline   equ     1
    DBCS_MaxExt     equ     14
    DBCS_Leading    equ     1
endif;EH10SYS

ifdef EZ12SYS                           ; MINCHO System 12pt ( 8x18)
    EH12SYS         equ     1
    DBCS            equ     1
endif;EZ12SYS
ifdef EH12SYS
    FIXED           equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO System', 19 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  120
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     14
    SBCS_LowerExt   equ     9
    SBCS_Leading    equ     2
    SBCS_Width      equ     8
    DBCS_Baseline   equ     1
    DBCS_MaxExt     equ     16
    DBCS_Leading    equ     1
endif;EH12SYS

ifdef EZ14SYS                           ; MINCHO System 14pt ( 9x20)
    EH14SYS         equ     1
    DBCS            equ     1
endif;EZ14SYS
ifdef EH14SYS
    FIXED           equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO System', 19 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  140
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     16
    SBCS_LowerExt   equ     10
    SBCS_Leading    equ     2
    SBCS_Width      equ     9
    DBCS_Baseline   equ     1
    DBCS_MaxExt     equ     18
    DBCS_Leading    equ     1
endif;EH14SYS

ifdef EZ15SYS                           ; MINCHO System 15pt (11x24)
    EH15SYS         equ     1
    DBCS            equ     1
endif;EZ15SYS
ifdef EH15SYS
    FIXED           equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO System', 19 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  150
    SBCS_Baseline   equ     4
    SBCS_UpperExt   equ     17
    SBCS_LowerExt   equ     11
    SBCS_Leading    equ     3
    SBCS_Width      equ     11
    DBCS_Baseline   equ     2
    DBCS_MaxExt     equ     20
    DBCS_Leading    equ     2
endif;EH15SYS

ifdef EZ18SYS                           ; MINCHO System 18pt (13x28)
    EH18SYS         equ     1
    DBCS            equ     1
endif;EZ18SYS
ifdef EH18SYS
    FIXED           equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO System', 19 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  180
    SBCS_Baseline   equ     4
    SBCS_UpperExt   equ     20
    SBCS_LowerExt   equ     13
    SBCS_Leading    equ     4
    SBCS_Width      equ     13
    DBCS_Baseline   equ     2
    DBCS_MaxExt     equ     24
    DBCS_Leading    equ     2
endif;EH18SYS

;-----------------------------------------------------------------------;
;   MINCHO fonts
;-----------------------------------------------------------------------;

ifdef EZ08MIN                           ; MINCHO  8pt ( 6x12)
    EH08MIN         equ     1
    DBCS            equ     1
endif;EZ08MIN
ifdef EH08MIN
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO', 26 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  80
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     10
    SBCS_LowerExt   equ     7
    SBCS_Leading    equ     1
    SBCS_Width      equ     6
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     12
    DBCS_Leading    equ     0
endif;EH08MIN

ifdef EZ10MIN                           ; MINCHO 10pt ( 7x14)
    EH10MIN         equ     1
    DBCS            equ     1
endif;EZ10MIN
ifdef EH10MIN
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO', 26 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  100
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     12
    SBCS_LowerExt   equ     8
    SBCS_Leading    equ     1
    SBCS_Width      equ     7
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     14
    DBCS_Leading    equ     0
endif;EH10MIN

ifdef EZ12MIN                           ; MINCHO 12pt ( 8x16)
    EH12MIN         equ     1
    DBCS            equ     1
endif;EZ12MIN
ifdef EH12MIN
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO', 26 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  120
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     14
    SBCS_LowerExt   equ     9
    SBCS_Leading    equ     1
    SBCS_Width      equ     8
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     16
    DBCS_Leading    equ     0
endif;EH12MIN

ifdef EZ14MIN                           ; MINCHO 14pt ( 9x18)
    EH14MIN         equ     1
    DBCS            equ     1
endif;EZ14MIN
ifdef EH14MIN
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO', 26 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  140
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     16
    SBCS_LowerExt   equ     10
    SBCS_Leading    equ     1
    SBCS_Width      equ     9
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     18
    DBCS_Leading    equ     0
endif;EH14MIN

ifdef EZ15MIN                           ; MINCHO 15pt (10x20)
    EH15MIN         equ     1
    DBCS            equ     1
endif;EZ15MIN
ifdef EH15MIN
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO', 26 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  150
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     17
    SBCS_LowerExt   equ     11
    SBCS_Leading    equ     1
    SBCS_Width      equ     10
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     20
    DBCS_Leading    equ     0
endif;EH15MIN

ifdef EZ18MIN                           ; MINCHO 18pt (12x24)
    EH18MIN         equ     1
    DBCS            equ     1
endif;EZ18MIN
ifdef EH18MIN
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO', 26 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  180
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     20
    SBCS_LowerExt   equ     13
    SBCS_Leading    equ     2
    SBCS_Width      equ     12
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     24
    DBCS_Leading    equ     0
endif;EH18MIN

;-----------------------------------------------------------------------;
;   MINCHO Terminal fonts
;-----------------------------------------------------------------------;

ifdef EZ08TRM                           ; MINCHO Terminal  8pt ( 8x12)
    EH08TRM         equ     1
    DBCS            equ     1
endif;EZ08TRM
ifdef EH08TRM
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO Terminal', 17 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  80
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     10
    SBCS_LowerExt   equ     7
    SBCS_Leading    equ     1
    SBCS_Width      equ     8
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     12
    DBCS_Leading    equ     0
endif;EH08TRM

ifdef EZ10TRM                           ; MINCHO Terminal 10pt ( 8x14)
    EH10TRM         equ     1
    DBCS            equ     1
endif;EZ10TRM
ifdef EH10TRM
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO Terminal', 17 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  100
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     12
    SBCS_LowerExt   equ     8
    SBCS_Leading    equ     1
    SBCS_Width      equ     8
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     14
    DBCS_Leading    equ     0
endif;EH10TRM


    .errnz  ((SBCS_Baseline+SBCS_UpperExt+SBCS_Leading)\
             - (DBCS_Baseline+DBCS_MaxExt+DBCS_Leading))


;-----------------------------------------------------------------------;
;   MINCHO Family Fonts Key Metrics Definition
;-----------------------------------------------------------------------;

usCodePage          equ     65400       ; Non-Registered Codepage fonts
xDeviceRes          equ     96          ; VGA resolution
yDeviceRes          equ     96          ; VGA resolution

ifndef DBCS                                             ; SBCS metrics
usFirstChar         equ     0
usLastChar          equ     0FFh
usDefaultChar       equ     0
usBreakChar         equ     0
fsTypeFlags         =       FM_TYPE_LICENSED
else ;DBCS                                              ; DBCS metrics
usFirstChar         equ     0
usLastChar          equ     0
usDefaultChar       equ     0
usBreakChar         equ     0
fsTypeFlags         =       FM_TYPE_LICENSED+FM_TYPE_DBCS
endif;DBCS

ifndef NODESCENDER
;-----------------------------------------------------------------------;
;   MINCHO System / MINCHO Proportional Font Height Definitions
;
;   Ŀ
;   ........................................
;   ....................**.......**..**.....
;   *************Ĵ
;   .**....**............***.***************  
;   .**....**.............*......**..**.....  
;   .***..***...........*.....*..**..**..*..  ...yLowerCaseAscent
;   .***..***...........**..*.*************.  
;   .***..***............**.*.**...**...**..  
;   .***.****.****..****.**.*.**...**...**..ĳ
;   .***.*.**..**.....*....**.**...**...**..   
;   .*.***.**..**.....*....*..************..   
;   .*.***.**...**...**...**..**...**.......   
;   .*.***.**...**...*....**.......**....*..   
;   .*..*..**....**.**....*..**************.   
;   .*..*..**....**.*...***........**.......    yXHeight
;   .*..*..**.....***....*.........**.....*.   
;   .*.....**......*.....**.****************   
;   .*.....**..*..**......**.....***.**.....   
;   *******************Ĵ (baseline)
;   ..........*****.......**..***......*****  ...yMaxDescender
;   **********͵ĳ yUnderscorePosition
;   ........................................  
;   
;
;-----------------------------------------------------------------------;

yExternalLeading    equ     0
yMaxBaselineExt     equ     SBCS_Baseline+SBCS_UpperExt+SBCS_Leading
yXHeight            equ     SBCS_LowerExt
yLowerCaseAscent    equ     SBCS_UpperExt
yMaxDescender       equ     SBCS_Baseline
yUnderscorePosition equ     DBCS_Baseline

else ;NODESCENDER
;-----------------------------------------------------------------------;
;   MINCHO / MINCHO Terminal Font Height Definitions
;
;   ******Ŀ
;   ***....***...........**......**..**...*.  
;   .**....**............***.***************  
;   .**....**.............*......**..**.....  
;   .***..***...........*.....*..**..**..*..  ...yLowerCaseAscent
;   .***..***...........**..*.*************.  
;   .***..***............**.*.**...**...**..  
;   .***.****.****..****.**.*.**...**...**..ĳ
;   .***.*.**..**.....*....**.**...**...**..   
;   .*.***.**..**.....*....*..************..   
;   .*.***.**...**...**...**..**...**.......   
;   .*.***.**...**...*....**.......**....*..   
;   .*..*..**....**.**....*..**************.   
;   .*..*..**....**.*...***........**.......    yXHeight
;   .*..*..**.....***....*.........**.....*.   
;   .*.....**......*.....**.****************   
;   .*.....**..*..**......**.....***.**.....   
;   ****..*******.*.......**....**....***...   
;   ..........*****.......**..***......*****    (baseline)
;   **********; yUnderscorePosition
;                                                    yMaxDescender
;
;-----------------------------------------------------------------------;

yExternalLeading    equ     0
yMaxBaselineExt     equ     SBCS_Baseline+SBCS_UpperExt+SBCS_Leading
yXHeight            equ     SBCS_Baseline+SBCS_LowerExt
yLowerCaseAscent    equ     SBCS_Baseline+SBCS_UpperExt
yMaxDescender       equ     DBCS_Baseline
yUnderscorePosition equ     DBCS_Baseline

endif;NODESCENDER

;-----------------------------------------------------------------------;
;   MINCHO Family Fonts Widths Definition
;-----------------------------------------------------------------------;

ifndef FIXED

  ifndef DBCS
    xAveCharWidth   equ     SBCS_Width
    xMaxCharInc     equ     SBCS_MaxInc
  else ;DBCS
    xAveCharWidth   equ     SBCS_Width*2
    xMaxCharInc     equ     SBCS_Width*2
  endif;DBCS

else ;FIXED

  ifndef DBCS
    xAveCharWidth   equ     SBCS_Width
    xMaxCharInc     equ     SBCS_Width
  else ;DBCS
    xAveCharWidth   equ     SBCS_Width*2
    xMaxCharInc     equ     SBCS_Width*2
  endif;DBCS

endif;FIXED

