;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;-----------------------------Module-Header-----------------------------;
; Module Name: MINCHO.INC
;
;   Font driver font metrics definition.
;
; Created: 30-Jan-1992
; Author:  Soh Ohta     [jl09057 @ ymtvm3, IBM Japan]
;
;                       Refer to Copyright Inscruction Form No.G120-2083
;
; Exported Functions:   none
;
; Public Functions:     none
;
; Public Data:          none
;
; General Description:
;
;-----------------------------------------------------------------------;

;-----------------------------------------------------------------------;
;   Character Design Descriptions
;
;                                               
;   Ŀ             Ŀ
;   ....................             DBCS_Leading....................
;   ....................SBCS_Leading       ******Ĵ
;   ******..........                  .**......**..**...*.
;   .**....**...........                       .***.***************
;   .**....**...........                       ..*......**..**.....
;   .***..***...........                       *.....*..**..**..*..
;   .***..***...........  SBCS_UpperExt        **..*.*************.
;   .***..***...........                       .**.*.**...**...**..
;   .***.****.********ĳ                  .**.*.**...**...**..
;   .***.*.**..**.....*.                      ...**.**...**...**..
;   .*.***.**..**.....*.         DBCS_MaxExt  ...*..************..
;   .*.***.**...**...**.                      ..**..**...**.......
;   .*.***.**...**...*..                      ..**.......**....*..
;   .*..*..**....**.**..   SBCS_LowerExt      ..*..**************.
;   .*..*..**....**.*...                      ***........**.......
;   .*..*..**.....***...                      .*.........**.....*.
;   .*.....**......*....                      .**.****************
;   .*.....**..*..**....                      ..**.....***.**.....
;   ************ĴSBCS_Baseline     ..**....**....***...
;   ..........*****.....                        ..**..***......*****
;   ..........-***-----------DBCS_Baseline*******Ĵ
;   ....................                         ....................
;                            
;
;-----------------------------------------------------------------------;

;-----------------------------------------------------------------------;
;   MINCHO Proportional fonts
;-----------------------------------------------------------------------;

ifdef MZ12PRO                           ; MINCHO Proportional 12pt ( 8x18)
    MH12PRO         equ     1
    DBCS            equ     1
    FIXED           equ     1
endif;MZ12PRO
ifdef MH12PRO
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO Proportional', 13 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  120
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     14
    SBCS_LowerExt   equ     9
    SBCS_Leading    equ     2
    SBCS_Width      equ     8
    SBCS_MaxInc     equ     17
    DBCS_Baseline   equ     1
    DBCS_MaxExt     equ     16
    DBCS_Leading    equ     1
endif;MH12PRO

ifdef MZ15PRO                           ; MINCHO Proportional 15pt (11x24)
    MH15PRO         equ     1
    DBCS            equ     1
    FIXED           equ     1
endif;MZ15PRO
ifdef MH15PRO
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO Proportional', 13 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  150
    SBCS_Baseline   equ     4
    SBCS_UpperExt   equ     17
    SBCS_LowerExt   equ     11
    SBCS_Leading    equ     3
    SBCS_Width      equ     11
    SBCS_MaxInc     equ     20
    DBCS_Baseline   equ     2
    DBCS_MaxExt     equ     20
    DBCS_Leading    equ     2
endif;MH15PRO

ifdef MZ18PRO                           ; MINCHO Proportional 18pt (12x26)
    MH18PRO         equ     1
    DBCS            equ     1
    FIXED           equ     1
endif;MZ18PRO
ifdef MH18PRO
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO Proportional', 13 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  180
    SBCS_Baseline   equ     3
    SBCS_UpperExt   equ     20
    SBCS_LowerExt   equ     13
    SBCS_Leading    equ     3
    SBCS_Width      equ     12
    SBCS_MaxInc     equ     23
    DBCS_Baseline   equ     1
    DBCS_MaxExt     equ     24
    DBCS_Leading    equ     1
endif;MH18PRO

;-----------------------------------------------------------------------;
;   MINCHO System fonts
;-----------------------------------------------------------------------;

ifdef MZ08SYS                           ; MINCHO System  8pt ( 6x12)
    MH08SYS         equ     1
    DBCS            equ     1
endif;MZ08SYS
ifdef MH08SYS
    FIXED           equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO System', 19 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  80
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     10
    SBCS_LowerExt   equ     7
    SBCS_Leading    equ     2
    SBCS_Width      equ     6
    DBCS_Baseline   equ     1
    DBCS_MaxExt     equ     12
    DBCS_Leading    equ     1
endif;MH08SYS

ifdef MZ10SYS                           ; MINCHO System 10pt ( 7x16)
    MH10SYS         equ     1
    DBCS            equ     1
endif;MZ10SYS
ifdef MH10SYS
    FIXED           equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO System', 19 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  100
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     12
    SBCS_LowerExt   equ     8
    SBCS_Leading    equ     2
    SBCS_Width      equ     7
    DBCS_Baseline   equ     1
    DBCS_MaxExt     equ     14
    DBCS_Leading    equ     1
endif;MH10SYS

ifdef MZ12SYS                           ; MINCHO System 12pt ( 8x18)
    MH12SYS         equ     1
    DBCS            equ     1
endif;MZ12SYS
ifdef MH12SYS
    FIXED           equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO System', 19 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  120
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     14
    SBCS_LowerExt   equ     9
    SBCS_Leading    equ     2
    SBCS_Width      equ     8
    DBCS_Baseline   equ     1
    DBCS_MaxExt     equ     16
    DBCS_Leading    equ     1
endif;MH12SYS

ifdef MZ14SYS                           ; MINCHO System 14pt ( 9x20)
    MH14SYS         equ     1
    DBCS            equ     1
endif;MZ14SYS
ifdef MH14SYS
    FIXED           equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO System', 19 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  140
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     16
    SBCS_LowerExt   equ     10
    SBCS_Leading    equ     2
    SBCS_Width      equ     9
    DBCS_Baseline   equ     1
    DBCS_MaxExt     equ     18
    DBCS_Leading    equ     1
endif;MH14SYS

ifdef MZ15SYS                           ; MINCHO System 15pt (11x24)
    MH15SYS         equ     1
    DBCS            equ     1
endif;MZ15SYS
ifdef MH15SYS
    FIXED           equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO System', 19 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  150
    SBCS_Baseline   equ     4
    SBCS_UpperExt   equ     17
    SBCS_LowerExt   equ     11
    SBCS_Leading    equ     3
    SBCS_Width      equ     11
    DBCS_Baseline   equ     2
    DBCS_MaxExt     equ     20
    DBCS_Leading    equ     2
endif;MH15SYS

ifdef MZ18SYS                           ; MINCHO System 18pt (13x28)
    MH18SYS         equ     1
    DBCS            equ     1
endif;MZ18SYS
ifdef MH18SYS
    FIXED           equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO System', 19 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  180
    SBCS_Baseline   equ     4
    SBCS_UpperExt   equ     20
    SBCS_LowerExt   equ     13
    SBCS_Leading    equ     4
    SBCS_Width      equ     13
    DBCS_Baseline   equ     2
    DBCS_MaxExt     equ     24
    DBCS_Leading    equ     2
endif;MH18SYS

ifdef MZ21SYS                           ; MINCHO System 21pt (15x32)
    MH21SYS         equ     1
    DBCS            equ     1
endif;MZ21SYS
ifdef MH21SYS
    FIXED           equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO System', 19 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  210
    SBCS_Baseline   equ     4
    SBCS_UpperExt   equ     24
    SBCS_LowerExt   equ     15
    SBCS_Leading    equ     4
    SBCS_Width      equ     15
    DBCS_Baseline   equ     2
    DBCS_MaxExt     equ     28
    DBCS_Leading    equ     2
endif;MH21SYS

ifdef MZ23SYS                           ; MINCHO System 23pt (16x34)
    MH23SYS         equ     1
    DBCS            equ     1
endif;MZ23SYS
ifdef MH23SYS
    FIXED           equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO System', 19 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  230
    SBCS_Baseline   equ     4
    SBCS_UpperExt   equ     26
    SBCS_LowerExt   equ     17
    SBCS_Leading    equ     4
    SBCS_Width      equ     16
    DBCS_Baseline   equ     2
    DBCS_MaxExt     equ     30
    DBCS_Leading    equ     2
endif;MH23SYS

ifdef MZ24SYS                           ; MINCHO System 24pt (17x36)
    MH24SYS         equ     1
    DBCS            equ     1
endif;MZ24SYS
ifdef MH24SYS
    FIXED           equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO System', 19 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  240
    SBCS_Baseline   equ     4
    SBCS_UpperExt   equ     28
    SBCS_LowerExt   equ     18
    SBCS_Leading    equ     4
    SBCS_Width      equ     17
    DBCS_Baseline   equ     2
    DBCS_MaxExt     equ     32
    DBCS_Leading    equ     2
endif;MH24SYS

ifdef MZ27SYS                           ; MINCHO System 27pt (19x40)
    MH27SYS         equ     1
    DBCS            equ     1
endif;MZ27SYS
ifdef MH27SYS
    FIXED           equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO System', 19 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  270
    SBCS_Baseline   equ     5
    SBCS_UpperExt   equ     30
    SBCS_LowerExt   equ     19
    SBCS_Leading    equ     5
    SBCS_Width      equ     19
    DBCS_Baseline   equ     2
    DBCS_MaxExt     equ     36
    DBCS_Leading    equ     2
endif;MH27SYS

ifdef MZ30SYS                           ; MINCHO System 30pt (23x48)
    MH30SYS         equ     1
    DBCS            equ     1
endif;MZ30SYS
ifdef MH30SYS
    FIXED           equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO System', 19 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  300
    SBCS_Baseline   equ     7
    SBCS_UpperExt   equ     34
    SBCS_LowerExt   equ     21
    SBCS_Leading    equ     7
    SBCS_Width      equ     23
    DBCS_Baseline   equ     4
    DBCS_MaxExt     equ     40
    DBCS_Leading    equ     4
endif;MH30SYS

;-----------------------------------------------------------------------;
;   MINCHO fonts
;-----------------------------------------------------------------------;

ifdef MZ08MIN                           ; MINCHO  8pt ( 6x12)
    MH08MIN         equ     1
    DBCS            equ     1
endif;MZ08MIN
ifdef MH08MIN
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO', 26 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  80
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     10
    SBCS_LowerExt   equ     7
    SBCS_Leading    equ     1
    SBCS_Width      equ     6
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     12
    DBCS_Leading    equ     0
endif;MH08MIN

ifdef MZ10MIN                           ; MINCHO 10pt ( 7x14)
    MH10MIN         equ     1
    DBCS            equ     1
endif;MZ10MIN
ifdef MH10MIN
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO', 26 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  100
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     12
    SBCS_LowerExt   equ     8
    SBCS_Leading    equ     1
    SBCS_Width      equ     7
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     14
    DBCS_Leading    equ     0
endif;MH10MIN

ifdef MZ12MIN                           ; MINCHO 12pt ( 8x16)
    MH12MIN         equ     1
    DBCS            equ     1
endif;MZ12MIN
ifdef MH12MIN
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO', 26 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  120
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     14
    SBCS_LowerExt   equ     9
    SBCS_Leading    equ     1
    SBCS_Width      equ     8
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     16
    DBCS_Leading    equ     0
endif;MH12MIN

ifdef MZ14MIN                           ; MINCHO 14pt ( 9x18)
    MH14MIN         equ     1
    DBCS            equ     1
endif;MZ14MIN
ifdef MH14MIN
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO', 26 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  140
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     16
    SBCS_LowerExt   equ     10
    SBCS_Leading    equ     1
    SBCS_Width      equ     9
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     18
    DBCS_Leading    equ     0
endif;MH14MIN

ifdef MZ15MIN                           ; MINCHO 15pt (10x20)
    MH15MIN         equ     1
    DBCS            equ     1
endif;MZ15MIN
ifdef MH15MIN
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO', 26 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  150
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     17
    SBCS_LowerExt   equ     11
    SBCS_Leading    equ     1
    SBCS_Width      equ     10
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     20
    DBCS_Leading    equ     0
endif;MH15MIN

ifdef MZ18MIN                           ; MINCHO 18pt (12x24)
    MH18MIN         equ     1
    DBCS            equ     1
endif;MZ18MIN
ifdef MH18MIN
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO', 26 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  180
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     20
    SBCS_LowerExt   equ     13
    SBCS_Leading    equ     2
    SBCS_Width      equ     12
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     24
    DBCS_Leading    equ     0
endif;MH18MIN

ifdef MZ21MIN                           ; MINCHO 21pt (14x28)
    MH21MIN         equ     1
    DBCS            equ     1
endif;MZ21MIN
ifdef MH21MIN
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO', 26 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  210
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     24
    SBCS_LowerExt   equ     15
    SBCS_Leading    equ     2
    SBCS_Width      equ     14
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     28
    DBCS_Leading    equ     0
endif;MH21MIN

ifdef MZ23MIN                           ; MINCHO 23pt (15x30)
    MH23MIN         equ     1
    DBCS            equ     1
endif;MZ23MIN
ifdef MH23MIN
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO', 26 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  230
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     26
    SBCS_LowerExt   equ     17
    SBCS_Leading    equ     2
    SBCS_Width      equ     15
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     30
    DBCS_Leading    equ     0
endif;MH23MIN

ifdef MZ24MIN                           ; MINCHO 24pt (16x32)
    MH24MIN         equ     1
    DBCS            equ     1
endif;MZ24MIN
ifdef MH24MIN
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO', 26 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  240
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     28
    SBCS_LowerExt   equ     18
    SBCS_Leading    equ     2
    SBCS_Width      equ     16
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     32
    DBCS_Leading    equ     0
endif;MH24MIN

ifdef MZ27MIN                           ; MINCHO 27pt (18x36)
    MH27MIN         equ     1
    DBCS            equ     1
endif;MZ27MIN
ifdef MH27MIN
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO', 26 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  270
    SBCS_Baseline   equ     3
    SBCS_UpperExt   equ     30
    SBCS_LowerExt   equ     19
    SBCS_Leading    equ     3
    SBCS_Width      equ     18
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     36
    DBCS_Leading    equ     0
endif;MH27MIN

ifdef MZ30MIN                           ; MINCHO 30pt (20x40)
    MH30MIN         equ     1
    DBCS            equ     1
endif;MZ30MIN
ifdef MH30MIN
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO', 26 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  300
    SBCS_Baseline   equ     3
    SBCS_UpperExt   equ     34
    SBCS_LowerExt   equ     21
    SBCS_Leading    equ     3
    SBCS_Width      equ     20
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     40
    DBCS_Leading    equ     0
endif;MH30MIN

ifdef MZ36MIN                           ; MINCHO 36pt (24x48)
    MH36MIN         equ     1
    DBCS            equ     1
endif;MZ36MIN
ifdef MH36MIN
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO', 26 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  360
    SBCS_Baseline   equ     4
    SBCS_UpperExt   equ     40
    SBCS_LowerExt   equ     26
    SBCS_Leading    equ     4
    SBCS_Width      equ     24
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     48
    DBCS_Leading    equ     0
endif;MH36MIN

;-----------------------------------------------------------------------;
;   MINCHO Terminal fonts
;-----------------------------------------------------------------------;

ifdef MZ08TRM                           ; MINCHO Terminal  8pt ( 8x12)
    MH08TRM         equ     1
    DBCS            equ     1
endif;MZ08TRM
ifdef MH08TRM
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO Terminal', 17 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  80
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     10
    SBCS_LowerExt   equ     7
    SBCS_Leading    equ     1
    SBCS_Width      equ     8
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     12
    DBCS_Leading    equ     0
endif;MH08TRM

ifdef MZ10TRM                           ; MINCHO Terminal 10pt ( 8x14)
    MH10TRM         equ     1
    DBCS            equ     1
endif;MZ10TRM
ifdef MH10TRM
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO Terminal', 17 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  100
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     12
    SBCS_LowerExt   equ     8
    SBCS_Leading    equ     1
    SBCS_Width      equ     8
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     14
    DBCS_Leading    equ     0
endif;MH10TRM

;-----------------------------------------------------------------------;
;   MINCHO DRAFT fonts
;-----------------------------------------------------------------------;

ifdef MZ08DRF                           ; MINCHO DRAFT  8pt ( 6x12)
    MH08DRF         equ     1
    DBCS            equ     1
endif;MZ08DRF
ifdef MH08DRF
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO DRAFT', 20 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  80
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     10
    SBCS_LowerExt   equ     7
    SBCS_Leading    equ     1
    SBCS_Width      equ     6
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     12
    DBCS_Leading    equ     0
endif;MH08DRF

ifdef MZ10DRF                           ; MINCHO DRAFT 10pt ( 7x14)
    MH10DRF         equ     1
    DBCS            equ     1
endif;MZ10DRF
ifdef MH10DRF
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO DRAFT', 20 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  100
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     12
    SBCS_LowerExt   equ     8
    SBCS_Leading    equ     1
    SBCS_Width      equ     7
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     14
    DBCS_Leading    equ     0
endif;MH10DRF

ifdef MZ12DRF                           ; MINCHO DRAFT 12pt ( 8x16)
    MH12DRF         equ     1
    DBCS            equ     1
endif;MZ12DRF
ifdef MH12DRF
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO DRAFT', 20 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  120
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     14
    SBCS_LowerExt   equ     9
    SBCS_Leading    equ     1
    SBCS_Width      equ     8
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     16
    DBCS_Leading    equ     0
endif;MH12DRF

ifdef MZ14DRF                           ; MINCHO DRAFT 14pt ( 9x18)
    MH14DRF         equ     1
    DBCS            equ     1
endif;MZ14DRF
ifdef MH14DRF
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO DRAFT', 20 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  140
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     16
    SBCS_LowerExt   equ     10
    SBCS_Leading    equ     1
    SBCS_Width      equ     9
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     18
    DBCS_Leading    equ     0
endif;MH14DRF

ifdef MZ15DRF                           ; MINCHO DRAFT 15pt (10x20)
    MH15DRF         equ     1
    DBCS            equ     1
endif;MZ15DRF
ifdef MH15DRF
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO DRAFT', 20 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  150
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     17
    SBCS_LowerExt   equ     11
    SBCS_Leading    equ     1
    SBCS_Width      equ     10
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     20
    DBCS_Leading    equ     0
endif;MH15DRF

ifdef MZ17DRF                           ; MINCHO DRAFT 17pt (11x22)
    MH17DRF         equ     1
    DBCS            equ     1
endif;MZ17DRF
ifdef MH17DRF
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO DRAFT', 20 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  170
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     19
    SBCS_LowerExt   equ     12
    SBCS_Leading    equ     1
    SBCS_Width      equ     11
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     22
    DBCS_Leading    equ     0
endif;MH17DRF

ifdef MZ24DRF                           ; MINCHO DRAFT 24pt (16x32)
    MH24DRF         equ     1
    DBCS            equ     1
endif;MZ24DRF
ifdef MH24DRF
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO DRAFT', 20 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  240
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     28
    SBCS_LowerExt   equ     18
    SBCS_Leading    equ     2
    SBCS_Width      equ     16
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     32
    DBCS_Leading    equ     0
endif;MH24DRF

ifdef MZ27DRF                           ; MINCHO DRAFT 27pt (18x36)
    MH27DRF         equ     1
    DBCS            equ     1
endif;MZ27DRF
ifdef MH27DRF
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO DRAFT', 20 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  270
    SBCS_Baseline   equ     3
    SBCS_UpperExt   equ     30
    SBCS_LowerExt   equ     19
    SBCS_Leading    equ     3
    SBCS_Width      equ     18
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     36
    DBCS_Leading    equ     0
endif;MH27DRF

ifdef MZ36DRF                           ; MINCHO DRAFT 36pt (24x48)
    MH36DRF         equ     1
    DBCS            equ     1
endif;MZ36DRF
ifdef MH36DRF
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'MINCHO', 26 dup (0)>
    szFacename      equ     <'MINCHO DRAFT', 20 dup (0)>
    sFamilyClass    equ     CLASS_MINCHO
    usNominalPointSize equ  360
    SBCS_Baseline   equ     4
    SBCS_UpperExt   equ     40
    SBCS_LowerExt   equ     26
    SBCS_Leading    equ     4
    SBCS_Width      equ     24
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     48
    DBCS_Leading    equ     0
endif;MH36DRF


    .errnz  ((SBCS_Baseline+SBCS_UpperExt+SBCS_Leading)\
             - (DBCS_Baseline+DBCS_MaxExt+DBCS_Leading))


;-----------------------------------------------------------------------;
;   MINCHO Family Fonts Key Metrics Definition
;-----------------------------------------------------------------------;

usCodePage          equ     850         ; UGL fonts
xDeviceRes          equ     96          ; VGA resolution
yDeviceRes          equ     96          ; VGA resolution

ifndef DBCS                                             ; SBCS metrics
usFirstChar         equ     0
usLastChar          equ     340h
usDefaultChar       equ     20h
usBreakChar         equ     20h
fsTypeFlags         =       FM_TYPE_LICENSED
else ;DBCS                                              ; DBCS metrics
usFirstChar         equ     0
usLastChar          equ     0
usDefaultChar       equ     0
usBreakChar         equ     0
fsTypeFlags         =       FM_TYPE_LICENSED+FM_TYPE_DBCS
endif;DBCS

ifndef NODESCENDER
;-----------------------------------------------------------------------;
;   MINCHO System / MINCHO Proportional Font Height Definitions
;
;   Ŀ
;   ........................................
;   ....................**.......**..**.....
;   *************Ĵ
;   .**....**............***.***************  
;   .**....**.............*......**..**.....  
;   .***..***...........*.....*..**..**..*..  ...yLowerCaseAscent
;   .***..***...........**..*.*************.  
;   .***..***............**.*.**...**...**..  
;   .***.****.****..****.**.*.**...**...**..ĳ
;   .***.*.**..**.....*....**.**...**...**..   
;   .*.***.**..**.....*....*..************..   
;   .*.***.**...**...**...**..**...**.......   
;   .*.***.**...**...*....**.......**....*..   
;   .*..*..**....**.**....*..**************.   
;   .*..*..**....**.*...***........**.......    yXHeight
;   .*..*..**.....***....*.........**.....*.   
;   .*.....**......*.....**.****************   
;   .*.....**..*..**......**.....***.**.....   
;   *******************Ĵ (baseline)
;   ..........*****.......**..***......*****  ...yMaxDescender
;   **********͵ĳ yUnderscorePosition
;   ........................................  
;   
;
;-----------------------------------------------------------------------;

yExternalLeading    equ     0
yMaxBaselineExt     equ     SBCS_Baseline+SBCS_UpperExt+SBCS_Leading
yXHeight            equ     SBCS_LowerExt
yLowerCaseAscent    equ     SBCS_UpperExt
yMaxDescender       equ     SBCS_Baseline
yUnderscorePosition equ     DBCS_Baseline

else ;NODESCENDER
;-----------------------------------------------------------------------;
;   MINCHO / MINCHO Terminal Font Height Definitions
;
;   ******Ŀ
;   ***....***...........**......**..**...*.  
;   .**....**............***.***************  
;   .**....**.............*......**..**.....  
;   .***..***...........*.....*..**..**..*..  ...yLowerCaseAscent
;   .***..***...........**..*.*************.  
;   .***..***............**.*.**...**...**..  
;   .***.****.****..****.**.*.**...**...**..ĳ
;   .***.*.**..**.....*....**.**...**...**..   
;   .*.***.**..**.....*....*..************..   
;   .*.***.**...**...**...**..**...**.......   
;   .*.***.**...**...*....**.......**....*..   
;   .*..*..**....**.**....*..**************.   
;   .*..*..**....**.*...***........**.......    yXHeight
;   .*..*..**.....***....*.........**.....*.   
;   .*.....**......*.....**.****************   
;   .*.....**..*..**......**.....***.**.....   
;   ****..*******.*.......**....**....***...   
;   ..........*****.......**..***......*****    (baseline)
;   **********; yUnderscorePosition
;                                                    yMaxDescender
;
;-----------------------------------------------------------------------;

yExternalLeading    equ     0
yMaxBaselineExt     equ     SBCS_Baseline+SBCS_UpperExt+SBCS_Leading
yXHeight            equ     SBCS_Baseline+SBCS_LowerExt
yLowerCaseAscent    equ     SBCS_Baseline+SBCS_UpperExt
yMaxDescender       equ     DBCS_Baseline
yUnderscorePosition equ     DBCS_Baseline

endif;NODESCENDER

;-----------------------------------------------------------------------;
;   MINCHO Family Fonts Widths Definition
;-----------------------------------------------------------------------;

ifndef FIXED

  ifndef DBCS
    xAveCharWidth   equ     SBCS_Width
    xMaxCharInc     equ     SBCS_MaxInc
  else ;DBCS
    xAveCharWidth   equ     SBCS_Width*2
    xMaxCharInc     equ     SBCS_Width*2
  endif;DBCS

else ;FIXED

  ifndef DBCS
    xAveCharWidth   equ     SBCS_Width
    xMaxCharInc     equ     SBCS_Width
  else ;DBCS
    xAveCharWidth   equ     SBCS_Width*2
    xMaxCharInc     equ     SBCS_Width*2
  endif;DBCS

endif;FIXED

