;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;-----------------------------Module-Header-----------------------------;
; Module Name: METRICS.INC
;
; Created: 15-Oct-1991
; Author:  Soh Ohta     [jl09057 @ ymtvm3, IBM Japan]
;
;                       Refer to Copyright Inscruction Form No.G120-2083
;
; Exported Functions:   none
;
; Public Functions:     none
;
; Public Data:          none
;
; General Description:
;
;-----------------------------------------------------------------------;

FAD_REVISED     equ     1       ; new family class id for MINCHO/GOTHIC

;-----------------------------------------------------------------------;
; Font Family Classes / Family Sub Classes.
;
;   See Also:   Font Architecture Document  (FAD-0003-512-02)
;               Font Registeration Standard (C-H 3-3220-060)
;-----------------------------------------------------------------------;

FFC_NOCLASS                         equ     0000h   ; No Class
NOC_NOCLASS                         equ     0000h
NOC_MISCELLANEOUS                   equ     0F00h

FFC_OLDSTYLE_SERIFS                 equ     0001h   ; Oldstyle Serifs
OLD_IBM_ROUNDED_LEGIBILITY          equ     0100h
OLD_GARALDE                         equ     0200h
OLD_VENETIAN                        equ     0300h
OLD_MODIFIED_VENETIAN               equ     0400h
OLD_DUTCH_MODERN                    equ     0500h
OLD_DUTCH_TRADITIONAL               equ     0600h
OLD_CONTEMPORARY                    equ     0700h
OLD_CALLIGRAPHIC                    equ     0800h

FFC_TRANSITIONAL_SERIFS             equ     0002h   ; Transitional Serifs
TRA_DIRECT_LINE                     equ     0100h
TRA_SCRIPT                          equ     0200h

FFC_MODERN_SERIFS                   equ     0003h   ; Modern Serifs
MOD_ITALIAN                         equ     0100h
MOD_SCRIPT                          equ     0200h
ifdef FAD_REVISED
MOD_MINCHO                          equ     0300h
endif;FAD_REVISED

FFC_CLARENDON_SERIFS                equ     0004h   ; Clarendon Serifs
CLA_CLARENDON                       equ     0100h
CLA_MODERN                          equ     0200h
CLA_TRADITIONAL                     equ     0300h
CLA_NEWSPAPER                       equ     0400h
CLA_STUB_SERIF                      equ     0500h
CLA_MONOTONE                        equ     0600h
CLA_TYPEWRITER                      equ     0700h

FFC_SLAB_SERIFS                     equ     0005h   ; Slab Serifs
SLA_MONOTONE                        equ     0100h
SLA_HUMANIST                        equ     0200h
SLA_GEOMETRIC                       equ     0300h
SLA_SWISS                           equ     0400h
SLA_TYPEWRITER                      equ     0500h

FFC_FREEFORM_SERIFS                 equ     0007h   ; Freeform Serifs
FRE_MODERN                          equ     0100h

FFC_SANS_SERIFS                     equ     0008h   ; Sans Serifs
SAN_IBM_NEO_GROTESQUE_GOTHIC        equ     0100h
SAN_HUMANIST                        equ     0200h
SAN_LOW_X_ROUND_GEOMETRIC           equ     0300h
SAN_HIGH_X_ROUND_GEOMETRIC          equ     0400h
SAN_NEO_GROTESQUE_GOTHIC            equ     0500h
SAN_MODIFIED_NEO_GROTESQUE_GOTHIC   equ     0600h
SAN_TYPEWRITER_GOTHIC               equ     0900h
SAN_MATRIX                          equ     0A00h

FFC_ORNAMENTALS                     equ     0009h   ; Ornamentals
ORN_ENGRAVER                        equ     0100h
ORN_BLACK_LETTER                    equ     0200h
ORN_DECORATIVE                      equ     0300h
ORN_THREE_DIMENSIONAL               equ     0400h

FFC_SCRIPTS                         equ     000Ah   ; Scripts
SCR_UNCIAL                          equ     0100h
SCR_BRUSH_JOINED                    equ     0200h
SCR_FORMAL_JOINED                   equ     0300h
SCR_MONOTONE_JOINED                 equ     0400h
SCR_CALLIGRAPHIC                    equ     0500h
SCR_BRUSH_UNJOINED                  equ     0600h
SCR_FORMAL_UNJOINED                 equ     0700h
SCR_MONOTONE_UNJOINED               equ     0800h

FFC_SYMBOLIC                        equ     000Ch   ; Symbolic
SYM_MIXED_SERIF                     equ     0300h
SYM_OLDSTYLE_SERIF                  equ     0600h
SYM_NEO_GROTESQUE_SANS_SERIF        equ     0700h

ifndef FAD_REVISED
FFC_CHINESE_ORIGIN                  equ     000Dh   ; Chinese Origin
CHI_MINCHO                          equ     0100h
CHI_GOTHIC                          equ     0200h
CHI_SONG                            equ     0400h
CHI_MING                            equ     0500h

FFC_OTHER_ASIAN                     equ     000Eh   ; Other Asian
ASI_MODERATE_CONTRAST               equ     0100h
ASI_LIGHT_CONTRAST                  equ     0200h
ASI_TYPEWRITER                      equ     0700h
endif;!FAD_REVISED

; Mincho/Gothic Family Classes.

ifndef FAD_REVISED
CLASS_MINCHO        equ     FFC_CHINESE_ORIGIN+CHI_MINCHO
CLASS_GOTHIC        equ     FFC_CHINESE_ORIGIN+CHI_GOTHIC
else ;FAD_REVISED
CLASS_MINCHO        equ     FFC_MODERN_SERIFS+MOD_MINCHO
CLASS_GOTHIC        equ     FFC_SANS_SERIFS+SAN_LOW_X_ROUND_GEOMETRIC
endif;FAD_REVISED

;--------------------------------Macro----------------------------------;
; ComputeMetrics
;
; Compute other metrics values for Mincho/Gothic family fonts.
; The computation will be done based on:
;   - DBCS  (should be defined if DBCS metrics are computed)
;   - FIXED (should be defined if the font is fixed spacing)
;   - xAveCharWidth       (as cell width)
;   - yMaxBaselineExt     (as cell height)
;   - yMaxDescender       (as baseline position)
;   - yUnderscorePosition (as the number of bottom blank scanlines)
;   - usNominalPointSize  (point size * 10)
;
; The following metrics values are not computed by this macro.
;   - xMaxCharInc
;   - yXHeight
;   - yExternalLeading
;
; Note that the glyph index range definitions for DBCS metrics are
; not done by this macro. These values shall be filled at font driver
; initialization time.
;-----------------------------------------------------------------------;

ComputeMetrics      macro

ifndef NODESCENDER                                      ; reviced charbox
yEmHeight           equ     (usNominalPointSize*yDeviceRes/72)/10
xEmInc              equ     (usNominalPointSize*xDeviceRes/72)/10
else ;NODESCENDER                                       ; OS/2 V1 charbox
yEmHeight           equ     yMaxBaselineExt
xEmInc              equ     xAveCharWidth
                   .errndef FIXED                       ; mono spacing
endif;NODESCENDER                                       ; OS/2 V1 charbox

usMinimumPointSize  equ     usNominalPointSize
usMaximumPointSize  equ     usNominalPointSize
yInternalLeading    equ     yMaxBaselineExt-yEmHeight

yMaxAscender        equ     yMaxBaselineExt-yMaxDescender
yLowerCaseDescent   equ     yMaxDescender-yUnderscorePosition

ySubscriptXSize     equ     (xAveCharWidth+1)*2/3
ySubscriptYSize     equ     yLowerCaseAscent*2/3
ySubscriptXOffset   equ     0
ySubscriptYOffset   equ     yUnderscorePosition
ySuperscriptXSize   equ     (xAveCharWidth+1)*2/3
ySuperscriptYSize   equ     yLowerCaseAscent*2/3
ySuperscriptXOffset equ     0
ySuperscriptYOffset equ     yMaxBaselineExt-ySuperscriptYSize

yUnderscoreSize     equ     1
yStrikeoutSize      equ     1
yStrikeoutPosition  equ     yLowerCaseAscent/2

ifndef FIXED                                            ; proportional spacing
fsFontdef           equ     FONTDEFFONT2
fsChardef           equ     FONTDEFCHAR2
xCellWidth          equ     0
yCellHeight         equ     yMaxBaselineExt
xCellIncrement      equ     0
pCellBaseOffset     equ     yMaxAscender
else ;FIXED                                             ; fixed spacing
fsFontdef           equ     FONTDEFFONT1
fsChardef           equ     FONTDEFCHAR1
xCellWidth          equ     xAveCharWidth
yCellHeight         equ     yMaxBaselineExt
xCellIncrement      equ     xAveCharWidth
pCellBaseOffset     equ     yMaxAscender
fsTypeFlags         =       fsTypeFlags+FM_TYPE_FIXED
endif;FIXED

                    endm
