;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;-----------------------------Module-Header-----------------------------;
; Module Name: METRICS.ASM
;
;   Font driver font metrics definition.
;
; Created: 15-Oct-1991
; Author:  Soh Ohta     [jl09057 @ ymtvm3, IBM Japan]
;
;                       Refer to Copyright Inscruction Form No.G120-2083
;
; Exported Functions:   none
;
; Public Functions:     none
;
; Public Data:          none
;
; General Description:
;
;-----------------------------------------------------------------------;

        title   FOCAFONT resource definition
        %out    FOCAFONT resource definition
        page    ,132


        INCL_PM equ 1
        include os2.inc
        include metrics.inc

ifdef MINCHO
        include mincho.inc
endif;MINCHO
ifdef GOTHIC
        include gothic.inc
endif;GOTHIC
ifdef PC3270
        include pc3270.inc
endif;PC3270


;-----------------------------------------------------------------------;
; FOCAFONT definition
;-----------------------------------------------------------------------;

FDFONTSEG segment public
assume cs:FDFONTSEG

        ComputeMetrics                  ; compute metrics

;-----------------------------------------------------------------------;
; Font Signature
;-----------------------------------------------------------------------;
fd_fsSignature:

        dd      FONT_SIGNATURE                          ; fs_ulIdentity
        dd      size FONTSIGNATURE                      ; fs_ulSize
        db      'OS/2 FONT', 3 dup (0)                  ; fs_achSignature[12]

        .errnz  (($-fd_fsSignature)-(size FONTSIGNATURE))

;-----------------------------------------------------------------------;
; Foca Metrics
;-----------------------------------------------------------------------;
fd_fmMetrics:

        dd      FONT_METRICS                            ; foca_ulIdentity
        dd      size FOCAMETRICS                        ; foca_ulSize
        db      szFamilyname                            ; foca_szFamilyname[32]
        db      szFacename                              ; foca_szFacename[32]
        dw      0                                       ; foca_usRegistryId
        dw      usCodePage                              ; foca_usCodePage
        dw      yEmHeight                               ; foca_yEmHeight
        dw      yXHeight                                ; foca_yXHeight
        dw      yMaxAscender                            ; foca_yMaxAscender
        dw      yMaxDescender                           ; foca_yMaxDescender
        dw      yLowerCaseAscent                        ; foca_yLowerCaseAscent
        dw      yLowerCaseDescent                       ; foca_yLowerCaseDescent
        dw      yInternalLeading                        ; foca_yInternalLeading
        dw      yExternalLeading                        ; foca_yExternalLeading
        dw      xAveCharWidth                           ; foca_xAveCharWidth
        dw      xMaxCharInc                             ; foca_xMaxCharInc
        dw      xEmInc                                  ; foca_xEmInc
        dw      yMaxBaselineExt                         ; foca_yMaxBaselineExt
        dw      0                                       ; foca_sCharSlope
        dw      0                                       ; foca_sInlineDir
        dw      0                                       ; foca_sCharRot
        dw      5                                       ; foca_usWeightClass
        dw      5                                       ; foca_usWidthClass
        dw      xDeviceRes                              ; foca_xDeviceRes
        dw      yDeviceRes                              ; foca_yDeviceRes
        dw      usFirstChar                             ; foca_usFirstChar
        dw      usLastChar                              ; foca_usLastChar
        dw      usDefaultChar                           ; foca_usDefaultChar
        dw      usBreakChar                             ; foca_usBreakChar
        dw      usNominalPointSize                      ; foca_usNominalPointSize
        dw      usMinimumPointSize                      ; foca_usMinimumPointSize
        dw      usMaximumPointSize                      ; foca_usMaximumPointSize
        dw      fsTypeFlags                             ; foca_fsTypeFlags
        dw      0                                       ; foca_fsDefn
        dw      0                                       ; foca_fsSelectionFlags
        dw      0                                       ; foca_fsCapabilities
        dw      ySubscriptXSize                         ; foca_ySubscriptXSize
        dw      ySubscriptYSize                         ; foca_ySubscriptYSize
        dw      ySubscriptXOffset                       ; foca_ySubscriptXOffset
        dw      ySubscriptYOffset                       ; foca_ySubscriptYOffset
        dw      ySuperscriptXSize                       ; foca_ySuperscriptXSize
        dw      ySuperscriptYSize                       ; foca_ySuperscriptYSize
        dw      ySuperscriptXOffset                     ; foca_ySuperscriptXOffset
        dw      ySuperscriptYOffset                     ; foca_ySuperscriptYOffset
        dw      yUnderscoreSize                         ; foca_yUnderscoreSize
        dw      yUnderscorePosition                     ; foca_yUnderscorePosition
        dw      yStrikeoutSize                          ; foca_yStrikeoutSize
        dw      yStrikeoutPosition                      ; foca_yStrikeoutPosition
        dw      0                                       ; foca_usKerningPairs
        dw      sFamilyClass                            ; foca_sFamilyClass
        dd      0                                       ; foca_pszDeviceNameOffset

        .errnz  (($-fd_fmMetrics)-(size FOCAMETRICS))

;-----------------------------------------------------------------------;
; Font Definition Header
;-----------------------------------------------------------------------;
fd_fdDefinitions:

        dd      FONT_DEFINITION                         ; fdh_ulIdentity
        dd      size FONTDEFINITIONHEADER               ; fdh_ulSize
        dw      fsFontdef                               ; fdh_fsFontdef
        dw      fsChardef                               ; fdh_fsChardef
        dw      6                                       ; fdh_usCellSize
        dw      xCellWidth                              ; fdh_xCellWidth
        dw      yCellHeight                             ; fdh_yCellHeight
        dw      xCellIncrement                          ; fdh_xCellIncrement
        dw      0                                       ; fdh_xCellA
        dw      0                                       ; fdh_xCellB
        dw      0                                       ; fdh_xCellC
        dw      pCellBaseOffset                         ; fdh_pCellBaseOffset

        .errnz  (($-fd_fdDefinitions)-(size FONTDEFINITIONHEADER))

FDFONTSEG ends
end
