;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;-----------------------------Module-Header-----------------------------;
; Module Name: M36FONT.ASM
;
;   Font resource definition for optional font drivers.
;   This segment will be loaded as a resource into the FD's default
;   shared data segment.
;
; Created: 15-Oct-1991
; Author:  Soh Ohta     [jl09057 @ ymtvm3, IBM Japan]
;
;                       Refer to Copyright Inscruction Form No.G120-2083
;
; Exported Functions:   none
;
; Public Functions:     none
;
; Public Data:          none
;
; General Description:
;
;-----------------------------------------------------------------------;

        title   RESMAP resource definition for MINCHO 36 fd
        %out    RESMAP resource definition for MINCHO 36 fd
        page    ,132


        include os2.inc
        include resmap.inc
        include metrics.inc
        include resource.inc


RESMAPSEG segment public
assume cs:RESMAPSEG
resmap_start:

;-----------------------------------------------------------------------;
; Font resource descriptor header
;-----------------------------------------------------------------------;
resmap_header:

        dw      resmap_end-resmap_header                ; rh_cbSize
        dw      (presmap-vresmap)/(size RESMAP)         ; rh_cFonts
        .errnz  (resmap_header-resmap_start)

;-----------------------------------------------------------------------;
; Virtual font resource descriptors
;-----------------------------------------------------------------------;
vresmap:.errnz  (($-resmap_header) ne (size RESMAPHEADER))

; -------------------
; MINCHO System 19x40
; -------------------
vh19x40:dw      ph19x40                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((19-1)/8)+1                            ; bd_cbScan
        db      40                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      19                                      ; bd_cx
        db      40                                      ; bd_cy
        dw      VRESID_MINSYS_19x40                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      19                                      ; rm_xMaxCharInc
        dw      19                                      ; rm_xAveCharWidth
        dw      40                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh19x40) ne (size RESMAP))

vz38x40:dw      wpz36x36                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((38-1)/8)+1                            ; bd_cbScan
        db      40                                      ; bd_nScans
        db      1                                       ; bd_x
        db      2                                       ; bd_y
        db      36                                      ; bd_cx
        db      36                                      ; bd_cy
        dw      VRESID_MINSYS_38x40                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      38                                      ; rm_xMaxCharInc
        dw      38                                      ; rm_xAveCharWidth
        dw      40                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz38x40) ne (size RESMAP))

; -------------------
; MINCHO System 23x48
; -------------------
vh23x48:dw      ph23x48                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((23-1)/8)+1                            ; bd_cbScan
        db      48                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      23                                      ; bd_cx
        db      48                                      ; bd_cy
        dw      VRESID_MINSYS_23x48                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      23                                      ; rm_xMaxCharInc
        dw      23                                      ; rm_xAveCharWidth
        dw      48                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh23x48) ne (size RESMAP))

vz46x48:dw      wpz36x36                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((46-1)/8)+1                            ; bd_cbScan
        db      48                                      ; bd_nScans
        db      5                                       ; bd_x
        db      6                                       ; bd_y
        db      36                                      ; bd_cx
        db      36                                      ; bd_cy
        dw      VRESID_MINSYS_46x48                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      46                                      ; rm_xMaxCharInc
        dw      46                                      ; rm_xAveCharWidth
        dw      48                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz46x48) ne (size RESMAP))

; ------------
; MINCHO 18x36
; ------------
vh18x36:dw      ph18x36                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((18-1)/8)+1                            ; bd_cbScan
        db      36                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      18                                      ; bd_cx
        db      36                                      ; bd_cy
        dw      VRESID_MINCHO_18x36                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      18                                      ; rm_xMaxCharInc
        dw      18                                      ; rm_xAveCharWidth
        dw      36                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh18x36) ne (size RESMAP))

vz36x36:dw      wpz36x36                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((36-1)/8)+1                            ; bd_cbScan
        db      36                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      36                                      ; bd_cx
        db      36                                      ; bd_cy
        dw      VRESID_MINCHO_36x36                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      36                                      ; rm_xMaxCharInc
        dw      36                                      ; rm_xAveCharWidth
        dw      36                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz36x36) ne (size RESMAP))

; ------------
; MINCHO 20x40
; ------------
vh20x40:dw      ph20x40                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((20-1)/8)+1                            ; bd_cbScan
        db      40                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      20                                      ; bd_cx
        db      40                                      ; bd_cy
        dw      VRESID_MINCHO_20x40                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      20                                      ; rm_xMaxCharInc
        dw      20                                      ; rm_xAveCharWidth
        dw      40                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh20x40) ne (size RESMAP))

vz40x40:dw      wpz36x36                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((40-1)/8)+1                            ; bd_cbScan
        db      40                                      ; bd_nScans
        db      2                                       ; bd_x
        db      2                                       ; bd_y
        db      36                                      ; bd_cx
        db      36                                      ; bd_cy
        dw      VRESID_MINCHO_40x40                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      40                                      ; rm_xMaxCharInc
        dw      40                                      ; rm_xAveCharWidth
        dw      40                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz40x40) ne (size RESMAP))

;-----------------------------------------------------------------------;
; Physical font resource descriptors
;-----------------------------------------------------------------------;
presmap:

; ----------------------
; PM SBCS Resource Fonts
; ----------------------
ph18x36:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf23x48                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((23-1)/8)+1                            ; bd_cbScan
        db      48                                      ; bd_nScans
        db      5                                       ; bd_x
        db      6                                       ; bd_y
        db      18                                      ; bd_cx
        db      36                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      18                                      ; rm_xMaxCharInc
        dw      18                                      ; rm_xAveCharWidth
        dw      36                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph18x36) ne (size RESMAP))

ph19x40:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf23x48                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((23-1)/8)+1                            ; bd_cbScan
        db      48                                      ; bd_nScans
        db      4                                       ; bd_x
        db      4                                       ; bd_y
        db      19                                      ; bd_cx
        db      40                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      19                                      ; rm_xMaxCharInc
        dw      19                                      ; rm_xAveCharWidth
        dw      40                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph19x40) ne (size RESMAP))

ph20x40:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf23x48                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((23-1)/8)+1                            ; bd_cbScan
        db      48                                      ; bd_nScans
        db      3                                       ; bd_x
        db      4                                       ; bd_y
        db      20                                      ; bd_cx
        db      40                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      20                                      ; rm_xMaxCharInc
        dw      20                                      ; rm_xAveCharWidth
        dw      40                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph20x40) ne (size RESMAP))

ph23x48:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf23x48                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((23-1)/8)+1                            ; bd_cbScan
        db      48                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      23                                      ; bd_cx
        db      48                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      23                                      ; rm_xMaxCharInc
        dw      23                                      ; rm_xAveCharWidth
        dw      48                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph23x48) ne (size RESMAP))

; ----------------------
; CP DBCS FNTCALLS Fonts
; ----------------------
bpz24x24:dw     INVALID_ADDRESS                         ; rm_npFont
        dw      bf24x24                                 ; rm_npPrivate
        dw      FONT_CP_MBCS_BASEFONT                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((32-1)/8)+1                            ; bd_cbScan
        db      24                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      24                                      ; bd_cx
        db      24                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      24                                      ; rm_xMaxCharInc
        dw      24                                      ; rm_xAveCharWidth
        dw      24                                      ; rm_yMaxBaselineExt
        .errnz  (($-bpz24x24) ne (size RESMAP))

; -----------------------
;         DBCS Wife Fonts
; -----------------------
wpz36x36:dw     upz36x36                                ; rm_npFont
        dw      wf36x36                                 ; rm_npPrivate
        dw      FONT_WIN_DBCS_FONTFILE                  ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((36-1)/8)+1                            ; bd_cbScan
        db      36                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      36                                      ; bd_cx
        db      36                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      36                                      ; rm_xMaxCharInc
        dw      36                                      ; rm_xAveCharWidth
        dw      36                                      ; rm_yMaxBaselineExt
        .errnz  (($-wpz36x36) ne (size RESMAP))

;-----------------------------------------------------------------------;
; User defined physical font resource descriptors
;-----------------------------------------------------------------------;
uresmap:

upz36x36:dw     bpz24x24                                ; rm_npFont
        dw      uf36x36                                 ; rm_npPrivate
        dw      FONT_PM_DBCS_USERFONT                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((64-1)/8)+1        ; buffer=(64w,36h)  ; bd_cbScan
        db      36                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      36                                      ; bd_cx
        db      36                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      36                                      ; rm_xMaxCharInc
        dw      36                                      ; rm_xAveCharWidth
        dw      36                                      ; rm_yMaxBaselineExt
        .errnz  (($-upz36x36) ne (size RESMAP))

;-----------------------------------------------------------------------;
; Physical font private data.
;-----------------------------------------------------------------------;
private:

rf23x48:dw      RT_PFONT                                ; rf_resType
        dw      PRESID_MINSYS_23x48                     ; rf_resId
        dd      INVALID_ADDRESS                         ; rf_lpFoca
        db      0                                       ; rf_szModule

bf24x24:dw      BF_OPTION_PACKED    ; buffer=(32w,24h)  ; bf_option
        dw      size FNTBLOCK,0,0,0                     ; fb_cbFix,fb_*
        dw      BF_ID_STANDARD_DBCS                     ; fb_fontId
        dw      24,24                                   ; fb_width,fb_height

wf36x36:dw      INVALID_ADDRESS                         ; ff_npEncode
        dw      INVALID_ADDRESS                         ; ff_npCache
        dw      512                                     ; ff_cbCache
        dw      0                                       ; ff_cbValid
        dd      0                                       ; ff_ulOffset
        db      '?:\OS2\SYSDATA\PS55DM36.JFD',0         ; ff_szFile

uf36x36:db      '?:\OS2\SYSDATA\$USERM36.FNT',0         ; uf_szFile

;-----------------------------------------------------------------------;
; End of font resource descriptor
;-----------------------------------------------------------------------;
resmap_end:
RESMAPSEG ends

end
