;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;-----------------------------Module-Header-----------------------------;
; Module Name: M28FONT.ASM
;
;   Font resource definition for optional font drivers.
;   This segment will be loaded as a resource into the FD's default
;   shared data segment.
;
; Created: 15-Oct-1991
; Author:  Soh Ohta     [jl09057 @ ymtvm3, IBM Japan]
;
;                       Refer to Copyright Inscruction Form No.G120-2083
;
; Exported Functions:   none
;
; Public Functions:     none
;
; Public Data:          none
;
; General Description:
;
;-----------------------------------------------------------------------;

        title   RESMAP resource definition for MINCHO 28 fd
        %out    RESMAP resource definition for MINCHO 28 fd
        page    ,132


        include os2.inc
        include resmap.inc
        include metrics.inc
        include resource.inc


RESMAPSEG segment public
assume cs:RESMAPSEG
resmap_start:

;-----------------------------------------------------------------------;
; Font resource descriptor header
;-----------------------------------------------------------------------;
resmap_header:

        dw      resmap_end-resmap_header                ; rh_cbSize
        dw      (presmap-vresmap)/(size RESMAP)         ; rh_cFonts
        .errnz  (resmap_header-resmap_start)

;-----------------------------------------------------------------------;
; Virtual font resource descriptors
;-----------------------------------------------------------------------;
vresmap:.errnz  (($-resmap_header) ne (size RESMAPHEADER))

; -------------------
; MINCHO System 15x32
; -------------------
vh15x32:dw      ph15x32                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((15-1)/8)+1                            ; bd_cbScan
        db      32                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      15                                      ; bd_cx
        db      32                                      ; bd_cy
        dw      VRESID_MINSYS_15x32                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      15                                      ; rm_xMaxCharInc
        dw      15                                      ; rm_xAveCharWidth
        dw      32                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh15x32) ne (size RESMAP))

vz30x32:dw      wpz28x28                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((30-1)/8)+1                            ; bd_cbScan
        db      32                                      ; bd_nScans
        db      1                                       ; bd_x
        db      2                                       ; bd_y
        db      28                                      ; bd_cx
        db      28                                      ; bd_cy
        dw      VRESID_MINSYS_30x32                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      30                                      ; rm_xMaxCharInc
        dw      30                                      ; rm_xAveCharWidth
        dw      32                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz30x32) ne (size RESMAP))

; -------------------
; MINCHO System 16x34
; -------------------
vh16x34:dw      ph16x34                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((16-1)/8)+1                            ; bd_cbScan
        db      34                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      16                                      ; bd_cx
        db      34                                      ; bd_cy
        dw      VRESID_MINSYS_16x34                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      16                                      ; rm_xMaxCharInc
        dw      16                                      ; rm_xAveCharWidth
        dw      34                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh16x34) ne (size RESMAP))

vz32x34:dw      wpz28x28                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((32-1)/8)+1                            ; bd_cbScan
        db      34                                      ; bd_nScans
        db      2                                       ; bd_x
        db      3                                       ; bd_y
        db      28                                      ; bd_cx
        db      28                                      ; bd_cy
        dw      VRESID_MINSYS_32x34                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      32                                      ; rm_xMaxCharInc
        dw      32                                      ; rm_xAveCharWidth
        dw      34                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz32x34) ne (size RESMAP))

; ------------
; MINCHO 14x28
; ------------
vh14x28:dw      ph14x28                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((14-1)/8)+1                            ; bd_cbScan
        db      28                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      14                                      ; bd_cx
        db      28                                      ; bd_cy
        dw      VRESID_MINCHO_14x28                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      14                                      ; rm_xMaxCharInc
        dw      14                                      ; rm_xAveCharWidth
        dw      28                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh14x28) ne (size RESMAP))

vz28x28:dw      wpz28x28                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((28-1)/8)+1                            ; bd_cbScan
        db      28                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      28                                      ; bd_cx
        db      28                                      ; bd_cy
        dw      VRESID_MINCHO_28x28                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      28                                      ; rm_xMaxCharInc
        dw      28                                      ; rm_xAveCharWidth
        dw      28                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz28x28) ne (size RESMAP))

; ------------
; MINCHO 15x30
; ------------
vh15x30:dw      ph15x30                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((15-1)/8)+1                            ; bd_cbScan
        db      30                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      15                                      ; bd_cx
        db      30                                      ; bd_cy
        dw      VRESID_MINCHO_15x30                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      15                                      ; rm_xMaxCharInc
        dw      15                                      ; rm_xAveCharWidth
        dw      30                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh15x30) ne (size RESMAP))

vz30x30:dw      wpz28x28                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((30-1)/8)+1                            ; bd_cbScan
        db      30                                      ; bd_nScans
        db      1                                       ; bd_x
        db      1                                       ; bd_y
        db      28                                      ; bd_cx
        db      28                                      ; bd_cy
        dw      VRESID_MINCHO_30x30                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      30                                      ; rm_xMaxCharInc
        dw      30                                      ; rm_xAveCharWidth
        dw      30                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz30x30) ne (size RESMAP))

;-----------------------------------------------------------------------;
; Physical font resource descriptors
;-----------------------------------------------------------------------;
presmap:

; ----------------------
; PM SBCS Resource Fonts
; ----------------------
ph14x28:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf16x34                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((16-1)/8)+1                            ; bd_cbScan
        db      34                                      ; bd_nScans
        db      2                                       ; bd_x
        db      3                                       ; bd_y
        db      14                                      ; bd_cx
        db      28                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      14                                      ; rm_xMaxCharInc
        dw      14                                      ; rm_xAveCharWidth
        dw      28                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph14x28) ne (size RESMAP))

ph15x30:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf16x34                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((16-1)/8)+1                            ; bd_cbScan
        db      34                                      ; bd_nScans
        db      1                                       ; bd_x
        db      2                                       ; bd_y
        db      15                                      ; bd_cx
        db      30                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      15                                      ; rm_xMaxCharInc
        dw      15                                      ; rm_xAveCharWidth
        dw      30                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph15x30) ne (size RESMAP))

ph15x32:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf16x34                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((16-1)/8)+1                            ; bd_cbScan
        db      34                                      ; bd_nScans
        db      1                                       ; bd_x
        db      1                                       ; bd_y
        db      15                                      ; bd_cx
        db      32                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      15                                      ; rm_xMaxCharInc
        dw      15                                      ; rm_xAveCharWidth
        dw      32                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph15x32) ne (size RESMAP))

ph16x34:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf16x34                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((16-1)/8)+1                            ; bd_cbScan
        db      34                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      16                                      ; bd_cx
        db      34                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      16                                      ; rm_xMaxCharInc
        dw      16                                      ; rm_xAveCharWidth
        dw      34                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph16x34) ne (size RESMAP))

; ----------------------
; CP DBCS FNTCALLS Fonts
; ----------------------
bpz24x24:dw     INVALID_ADDRESS                         ; rm_npFont
        dw      bf24x24                                 ; rm_npPrivate
        dw      FONT_CP_MBCS_BASEFONT                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((32-1)/8)+1                            ; bd_cbScan
        db      24                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      24                                      ; bd_cx
        db      24                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      24                                      ; rm_xMaxCharInc
        dw      24                                      ; rm_xAveCharWidth
        dw      24                                      ; rm_yMaxBaselineExt
        .errnz  (($-bpz24x24) ne (size RESMAP))

; -----------------------
;         DBCS Wife Fonts
; -----------------------
wpz28x28:dw     upz28x28                                ; rm_npFont
        dw      wf28x28                                 ; rm_npPrivate
        dw      FONT_WIN_DBCS_FONTFILE                  ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((28-1)/8)+1                            ; bd_cbScan
        db      28                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      28                                      ; bd_cx
        db      28                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      28                                      ; rm_xMaxCharInc
        dw      28                                      ; rm_xAveCharWidth
        dw      28                                      ; rm_yMaxBaselineExt
        .errnz  (($-wpz28x28) ne (size RESMAP))

;-----------------------------------------------------------------------;
; User defined physical font resource descriptors
;-----------------------------------------------------------------------;
uresmap:

upz28x28:dw     bpz24x24                                ; rm_npFont
        dw      uf28x28                                 ; rm_npPrivate
        dw      FONT_PM_DBCS_USERFONT                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((32-1)/8)+1        ; buffer=(32w,28h)  ; bd_cbScan
        db      28                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      28                                      ; bd_cx
        db      28                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      28                                      ; rm_xMaxCharInc
        dw      28                                      ; rm_xAveCharWidth
        dw      28                                      ; rm_yMaxBaselineExt
        .errnz  (($-upz28x28) ne (size RESMAP))

;-----------------------------------------------------------------------;
; Physical font private data.
;-----------------------------------------------------------------------;
private:

rf16x34:dw      RT_PFONT                                ; rf_resType
        dw      PRESID_MINSYS_16x34                     ; rf_resId
        dd      INVALID_ADDRESS                         ; rf_lpFoca
        db      0                                       ; rf_szModule

bf24x24:dw      BF_OPTION_PACKED    ; buffer=(32w,24h)  ; bf_option
        dw      size FNTBLOCK,0,0,0                     ; fb_cbFix,fb_*
        dw      BF_ID_STANDARD_DBCS                     ; fb_fontId
        dw      24,24                                   ; fb_width,fb_height

wf28x28:dw      INVALID_ADDRESS                         ; ff_npEncode
        dw      INVALID_ADDRESS                         ; ff_npCache
        dw      512                                     ; ff_cbCache
        dw      0                                       ; ff_cbValid
        dd      0                                       ; ff_ulOffset
        db      '?:\OS2\SYSDATA\PS55DM28.JFD',0         ; ff_szFile

uf28x28:db      '?:\OS2\SYSDATA\$USERM28.FNT',0         ; uf_szFile

;-----------------------------------------------------------------------;
; End of font resource descriptor
;-----------------------------------------------------------------------;
resmap_end:
RESMAPSEG ends

end
