;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;-----------------------------Module-Header-----------------------------;
; Module Name: GOTHIC.INC
;
;   Font driver font metrics definition.
;
; Created: 30-Jan-1992
; Author:  Soh Ohta     [jl09057 @ ymtvm3, IBM Japan]
;
;                       Refer to Copyright Inscruction Form No.G120-2083
;
; Exported Functions:   none
;
; Public Functions:     none
;
; Public Data:          none
;
; General Description:
;
;-----------------------------------------------------------------------;

;-----------------------------------------------------------------------;
;   Character Design Descriptions
;
;                                               
;   Ŀ             Ŀ
;   ....................             DBCS_Leading....................
;   ....................SBCS_Leading       ******Ĵ
;   ******..........                  .**......**..**...*.
;   .**....**...........                       .***.***************
;   .**....**...........                       ..*......**..**.....
;   .***..***...........                       *.....*..**..**..*..
;   .***..***...........  SBCS_UpperExt        **..*.*************.
;   .***..***...........                       .**.*.**...**...**..
;   .***.****.********ĳ                  .**.*.**...**...**..
;   .***.*.**..**.....*.                      ...**.**...**...**..
;   .*.***.**..**.....*.         DBCS_MaxExt  ...*..************..
;   .*.***.**...**...**.                      ..**..**...**.......
;   .*.***.**...**...*..                      ..**.......**....*..
;   .*..*..**....**.**..   SBCS_LowerExt      ..*..**************.
;   .*..*..**....**.*...                      ***........**.......
;   .*..*..**.....***...                      .*.........**.....*.
;   .*.....**......*....                      .**.****************
;   .*.....**..*..**....                      ..**.....***.**.....
;   ************ĴSBCS_Baseline     ..**....**....***...
;   ..........*****.....                        ..**..***......*****
;   ..........-***-----------DBCS_Baseline*******Ĵ
;   ....................                         ....................
;                            
;
;-----------------------------------------------------------------------;

;-----------------------------------------------------------------------;
;   GOTHIC Proportional fonts
;-----------------------------------------------------------------------;

ifdef GZ12PRO                           ; GOTHIC Proportional 12pt ( 8x18)
    GH12PRO         equ     1
    DBCS            equ     1
    FIXED           equ     1
endif;GZ12PRO
ifdef GH12PRO
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC Proportional', 13 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  120
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     14
    SBCS_LowerExt   equ     9
    SBCS_Leading    equ     2
    SBCS_Width      equ     8
    SBCS_MaxInc     equ     17
    DBCS_Baseline   equ     1
    DBCS_MaxExt     equ     16
    DBCS_Leading    equ     1
endif;GH12PRO

ifdef GZ15PRO                           ; GOTHIC Proportional 15pt (11x24)
    GH15PRO         equ     1
    DBCS            equ     1
    FIXED           equ     1
endif;GZ15PRO
ifdef GH15PRO
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC Proportional', 13 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  150
    SBCS_Baseline   equ     4
    SBCS_UpperExt   equ     17
    SBCS_LowerExt   equ     11
    SBCS_Leading    equ     3
    SBCS_Width      equ     11
    SBCS_MaxInc     equ     20
    DBCS_Baseline   equ     2
    DBCS_MaxExt     equ     20
    DBCS_Leading    equ     2
endif;GH15PRO

ifdef GZ18PRO                           ; GOTHIC Proportional 18pt (12x26)
    GH18PRO         equ     1
    DBCS            equ     1
    FIXED           equ     1
endif;GZ18PRO
ifdef GH18PRO
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC Proportional', 13 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  180
    SBCS_Baseline   equ     3
    SBCS_UpperExt   equ     20
    SBCS_LowerExt   equ     13
    SBCS_Leading    equ     3
    SBCS_Width      equ     12
    SBCS_MaxInc     equ     23
    DBCS_Baseline   equ     1
    DBCS_MaxExt     equ     24
    DBCS_Leading    equ     1
endif;GH18PRO

;-----------------------------------------------------------------------;
;   GOTHIC System fonts
;-----------------------------------------------------------------------;

ifdef GZ08SYS                           ; GOTHIC System  8pt ( 6x12)
    GH08SYS         equ     1
    DBCS            equ     1
endif;GZ08SYS
ifdef GH08SYS
    FIXED           equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC System', 19 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  80
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     10
    SBCS_LowerExt   equ     7
    SBCS_Leading    equ     2
    SBCS_Width      equ     6
    DBCS_Baseline   equ     1
    DBCS_MaxExt     equ     12
    DBCS_Leading    equ     1
endif;GH08SYS

ifdef GZ10SYS                           ; GOTHIC System 10pt ( 7x16)
    GH10SYS         equ     1
    DBCS            equ     1
endif;GZ10SYS
ifdef GH10SYS
    FIXED           equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC System', 19 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  100
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     12
    SBCS_LowerExt   equ     8
    SBCS_Leading    equ     2
    SBCS_Width      equ     7
    DBCS_Baseline   equ     1
    DBCS_MaxExt     equ     14
    DBCS_Leading    equ     1
endif;GH10SYS

ifdef GZ12SYS                           ; GOTHIC System 12pt ( 8x18)
    GH12SYS         equ     1
    DBCS            equ     1
endif;GZ12SYS
ifdef GH12SYS
    FIXED           equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC System', 19 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  120
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     14
    SBCS_LowerExt   equ     9
    SBCS_Leading    equ     2
    SBCS_Width      equ     8
    DBCS_Baseline   equ     1
    DBCS_MaxExt     equ     16
    DBCS_Leading    equ     1
endif;GH12SYS

ifdef GZ14SYS                           ; GOTHIC System 14pt ( 9x20)
    GH14SYS         equ     1
    DBCS            equ     1
endif;GZ14SYS
ifdef GH14SYS
    FIXED           equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC System', 19 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  140
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     16
    SBCS_LowerExt   equ     10
    SBCS_Leading    equ     2
    SBCS_Width      equ     9
    DBCS_Baseline   equ     1
    DBCS_MaxExt     equ     18
    DBCS_Leading    equ     1
endif;GH14SYS

ifdef GZ15SYS                           ; GOTHIC System 15pt (11x24)
    GH15SYS         equ     1
    DBCS            equ     1
endif;GZ15SYS
ifdef GH15SYS
    FIXED           equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC System', 19 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  150
    SBCS_Baseline   equ     4
    SBCS_UpperExt   equ     17
    SBCS_LowerExt   equ     11
    SBCS_Leading    equ     3
    SBCS_Width      equ     11
    DBCS_Baseline   equ     2
    DBCS_MaxExt     equ     20
    DBCS_Leading    equ     2
endif;GH15SYS

ifdef GZ18SYS                           ; GOTHIC System 18pt (13x28)
    GH18SYS         equ     1
    DBCS            equ     1
endif;GZ18SYS
ifdef GH18SYS
    FIXED           equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC System', 19 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  180
    SBCS_Baseline   equ     4
    SBCS_UpperExt   equ     20
    SBCS_LowerExt   equ     13
    SBCS_Leading    equ     4
    SBCS_Width      equ     13
    DBCS_Baseline   equ     2
    DBCS_MaxExt     equ     24
    DBCS_Leading    equ     2
endif;GH18SYS

ifdef GZ21SYS                           ; GOTHIC System 21pt (15x32)
    GH21SYS         equ     1
    DBCS            equ     1
endif;GZ21SYS
ifdef GH21SYS
    FIXED           equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC System', 19 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  210
    SBCS_Baseline   equ     4
    SBCS_UpperExt   equ     24
    SBCS_LowerExt   equ     15
    SBCS_Leading    equ     4
    SBCS_Width      equ     15
    DBCS_Baseline   equ     2
    DBCS_MaxExt     equ     28
    DBCS_Leading    equ     2
endif;GH21SYS

ifdef GZ23SYS                           ; GOTHIC System 23pt (16x34)
    GH23SYS         equ     1
    DBCS            equ     1
endif;GZ23SYS
ifdef GH23SYS
    FIXED           equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC System', 19 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  230
    SBCS_Baseline   equ     4
    SBCS_UpperExt   equ     26
    SBCS_LowerExt   equ     17
    SBCS_Leading    equ     4
    SBCS_Width      equ     16
    DBCS_Baseline   equ     2
    DBCS_MaxExt     equ     30
    DBCS_Leading    equ     2
endif;GH23SYS

ifdef GZ24SYS                           ; GOTHIC System 24pt (17x36)
    GH24SYS         equ     1
    DBCS            equ     1
endif;GZ24SYS
ifdef GH24SYS
    FIXED           equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC System', 19 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  240
    SBCS_Baseline   equ     4
    SBCS_UpperExt   equ     28
    SBCS_LowerExt   equ     18
    SBCS_Leading    equ     4
    SBCS_Width      equ     17
    DBCS_Baseline   equ     2
    DBCS_MaxExt     equ     32
    DBCS_Leading    equ     2
endif;GH24SYS

ifdef GZ27SYS                           ; GOTHIC System 27pt (19x40)
    GH27SYS         equ     1
    DBCS            equ     1
endif;GZ27SYS
ifdef GH27SYS
    FIXED           equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC System', 19 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  270
    SBCS_Baseline   equ     5
    SBCS_UpperExt   equ     30
    SBCS_LowerExt   equ     19
    SBCS_Leading    equ     5
    SBCS_Width      equ     19
    DBCS_Baseline   equ     2
    DBCS_MaxExt     equ     36
    DBCS_Leading    equ     2
endif;GH27SYS

ifdef GZ30SYS                           ; GOTHIC System 30pt (23x48)
    GH30SYS         equ     1
    DBCS            equ     1
endif;GZ30SYS
ifdef GH30SYS
    FIXED           equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC System', 19 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  300
    SBCS_Baseline   equ     7
    SBCS_UpperExt   equ     34
    SBCS_LowerExt   equ     21
    SBCS_Leading    equ     7
    SBCS_Width      equ     23
    DBCS_Baseline   equ     4
    DBCS_MaxExt     equ     40
    DBCS_Leading    equ     4
endif;GH30SYS

;-----------------------------------------------------------------------;
;   GOTHIC fonts
;-----------------------------------------------------------------------;

ifdef GZ08GOT                           ; GOTHIC  8pt ( 6x12)
    GH08GOT         equ     1
    DBCS            equ     1
endif;GZ08GOT
ifdef GH08GOT
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC', 26 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  80
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     10
    SBCS_LowerExt   equ     7
    SBCS_Leading    equ     1
    SBCS_Width      equ     6
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     12
    DBCS_Leading    equ     0
endif;GH08GOT

ifdef GZ10GOT                           ; GOTHIC 10pt ( 7x14)
    GH10GOT         equ     1
    DBCS            equ     1
endif;GZ10GOT
ifdef GH10GOT
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC', 26 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  100
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     12
    SBCS_LowerExt   equ     8
    SBCS_Leading    equ     1
    SBCS_Width      equ     7
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     14
    DBCS_Leading    equ     0
endif;GH10GOT

ifdef GZ12GOT                           ; GOTHIC 12pt ( 8x16)
    GH12GOT         equ     1
    DBCS            equ     1
endif;GZ12GOT
ifdef GH12GOT
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC', 26 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  120
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     14
    SBCS_LowerExt   equ     9
    SBCS_Leading    equ     1
    SBCS_Width      equ     8
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     16
    DBCS_Leading    equ     0
endif;GH12GOT

ifdef GZ14GOT                           ; GOTHIC 14pt ( 9x18)
    GH14GOT         equ     1
    DBCS            equ     1
endif;GZ14GOT
ifdef GH14GOT
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC', 26 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  140
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     16
    SBCS_LowerExt   equ     10
    SBCS_Leading    equ     1
    SBCS_Width      equ     9
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     18
    DBCS_Leading    equ     0
endif;GH14GOT

ifdef GZ15GOT                           ; GOTHIC 15pt (10x20)
    GH15GOT         equ     1
    DBCS            equ     1
endif;GZ15GOT
ifdef GH15GOT
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC', 26 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  150
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     17
    SBCS_LowerExt   equ     11
    SBCS_Leading    equ     1
    SBCS_Width      equ     10
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     20
    DBCS_Leading    equ     0
endif;GH15GOT

ifdef GZ18GOT                           ; GOTHIC 18pt (12x24)
    GH18GOT         equ     1
    DBCS            equ     1
endif;GZ18GOT
ifdef GH18GOT
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC', 26 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  180
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     20
    SBCS_LowerExt   equ     13
    SBCS_Leading    equ     2
    SBCS_Width      equ     12
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     24
    DBCS_Leading    equ     0
endif;GH18GOT

ifdef GZ21GOT                           ; GOTHIC 21pt (14x28)
    GH21GOT         equ     1
    DBCS            equ     1
endif;GZ21GOT
ifdef GH21GOT
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC', 26 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  210
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     24
    SBCS_LowerExt   equ     15
    SBCS_Leading    equ     2
    SBCS_Width      equ     14
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     28
    DBCS_Leading    equ     0
endif;GH21GOT

ifdef GZ23GOT                           ; GOTHIC 23pt (15x30)
    GH23GOT         equ     1
    DBCS            equ     1
endif;GZ23GOT
ifdef GH23GOT
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC', 26 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  230
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     26
    SBCS_LowerExt   equ     17
    SBCS_Leading    equ     2
    SBCS_Width      equ     15
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     30
    DBCS_Leading    equ     0
endif;GH23GOT

ifdef GZ24GOT                           ; GOTHIC 24pt (16x32)
    GH24GOT         equ     1
    DBCS            equ     1
endif;GZ24GOT
ifdef GH24GOT
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC', 26 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  240
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     28
    SBCS_LowerExt   equ     18
    SBCS_Leading    equ     2
    SBCS_Width      equ     16
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     32
    DBCS_Leading    equ     0
endif;GH24GOT

ifdef GZ27GOT                           ; GOTHIC 27pt (18x36)
    GH27GOT         equ     1
    DBCS            equ     1
endif;GZ27GOT
ifdef GH27GOT
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC', 26 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  270
    SBCS_Baseline   equ     3
    SBCS_UpperExt   equ     30
    SBCS_LowerExt   equ     19
    SBCS_Leading    equ     3
    SBCS_Width      equ     18
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     36
    DBCS_Leading    equ     0
endif;GH27GOT

ifdef GZ30GOT                           ; GOTHIC 30pt (20x40)
    GH30GOT         equ     1
    DBCS            equ     1
endif;GZ30GOT
ifdef GH30GOT
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC', 26 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  300
    SBCS_Baseline   equ     3
    SBCS_UpperExt   equ     34
    SBCS_LowerExt   equ     21
    SBCS_Leading    equ     3
    SBCS_Width      equ     20
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     40
    DBCS_Leading    equ     0
endif;GH30GOT

ifdef GZ36GOT                           ; GOTHIC 36pt (24x48)
    GH36GOT         equ     1
    DBCS            equ     1
endif;GZ36GOT
ifdef GH36GOT
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC', 26 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  360
    SBCS_Baseline   equ     4
    SBCS_UpperExt   equ     40
    SBCS_LowerExt   equ     26
    SBCS_Leading    equ     4
    SBCS_Width      equ     24
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     48
    DBCS_Leading    equ     0
endif;GH36GOT

;-----------------------------------------------------------------------;
;   GOTHIC Terminal fonts
;-----------------------------------------------------------------------;

ifdef GZ08TRM                           ; GOTHIC Terminal  8pt ( 8x12)
    GH08TRM         equ     1
    DBCS            equ     1
endif;GZ08TRM
ifdef GH08TRM
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC Terminal', 17 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  80
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     10
    SBCS_LowerExt   equ     7
    SBCS_Leading    equ     1
    SBCS_Width      equ     8
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     12
    DBCS_Leading    equ     0
endif;GH08TRM

ifdef GZ10TRM                           ; GOTHIC Terminal 10pt ( 8x14)
    GH10TRM         equ     1
    DBCS            equ     1
endif;GZ10TRM
ifdef GH10TRM
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC Terminal', 17 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  100
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     12
    SBCS_LowerExt   equ     8
    SBCS_Leading    equ     1
    SBCS_Width      equ     8
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     14
    DBCS_Leading    equ     0
endif;GH10TRM

;-----------------------------------------------------------------------;
;   GOTHIC DRAFT fonts
;-----------------------------------------------------------------------;

ifdef GZ08DRF                           ; GOTHIC DRAFT  8pt ( 6x12)
    GH08DRF         equ     1
    DBCS            equ     1
endif;GZ08DRF
ifdef GH08DRF
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC DRAFT', 20 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  80
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     10
    SBCS_LowerExt   equ     7
    SBCS_Leading    equ     1
    SBCS_Width      equ     6
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     12
    DBCS_Leading    equ     0
endif;GH08DRF

ifdef GZ10DRF                           ; GOTHIC DRAFT 10pt ( 7x14)
    GH10DRF         equ     1
    DBCS            equ     1
endif;GZ10DRF
ifdef GH10DRF
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC DRAFT', 20 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  100
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     12
    SBCS_LowerExt   equ     8
    SBCS_Leading    equ     1
    SBCS_Width      equ     7
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     14
    DBCS_Leading    equ     0
endif;GH10DRF

ifdef GZ12DRF                           ; GOTHIC DRAFT 12pt ( 8x16)
    GH12DRF         equ     1
    DBCS            equ     1
endif;GZ12DRF
ifdef GH12DRF
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC DRAFT', 20 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  120
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     14
    SBCS_LowerExt   equ     9
    SBCS_Leading    equ     1
    SBCS_Width      equ     8
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     16
    DBCS_Leading    equ     0
endif;GH12DRF

ifdef GZ14DRF                           ; GOTHIC DRAFT 14pt ( 9x18)
    GH14DRF         equ     1
    DBCS            equ     1
endif;GZ14DRF
ifdef GH14DRF
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC DRAFT', 20 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  140
    SBCS_Baseline   equ     1
    SBCS_UpperExt   equ     16
    SBCS_LowerExt   equ     10
    SBCS_Leading    equ     1
    SBCS_Width      equ     9
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     18
    DBCS_Leading    equ     0
endif;GH14DRF

ifdef GZ15DRF                           ; GOTHIC DRAFT 15pt (10x20)
    GH15DRF         equ     1
    DBCS            equ     1
endif;GZ15DRF
ifdef GH15DRF
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC DRAFT', 20 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  150
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     17
    SBCS_LowerExt   equ     11
    SBCS_Leading    equ     1
    SBCS_Width      equ     10
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     20
    DBCS_Leading    equ     0
endif;GH15DRF

ifdef GZ17DRF                           ; GOTHIC DRAFT 17pt (11x22)
    GH17DRF         equ     1
    DBCS            equ     1
endif;GZ17DRF
ifdef GH17DRF
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC DRAFT', 20 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  170
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     19
    SBCS_LowerExt   equ     12
    SBCS_Leading    equ     1
    SBCS_Width      equ     11
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     22
    DBCS_Leading    equ     0
endif;GH17DRF

ifdef GZ24DRF                           ; GOTHIC DRAFT 24pt (16x32)
    GH24DRF         equ     1
    DBCS            equ     1
endif;GZ24DRF
ifdef GH24DRF
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC DRAFT', 20 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  240
    SBCS_Baseline   equ     2
    SBCS_UpperExt   equ     28
    SBCS_LowerExt   equ     18
    SBCS_Leading    equ     2
    SBCS_Width      equ     16
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     32
    DBCS_Leading    equ     0
endif;GH24DRF

ifdef GZ27DRF                           ; GOTHIC DRAFT 27pt (18x36)
    GH27DRF         equ     1
    DBCS            equ     1
endif;GZ27DRF
ifdef GH27DRF
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC DRAFT', 20 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  270
    SBCS_Baseline   equ     3
    SBCS_UpperExt   equ     30
    SBCS_LowerExt   equ     19
    SBCS_Leading    equ     3
    SBCS_Width      equ     18
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     36
    DBCS_Leading    equ     0
endif;GH27DRF

ifdef GZ36DRF                           ; GOTHIC DRAFT 36pt (24x48)
    GH36DRF         equ     1
    DBCS            equ     1
endif;GZ36DRF
ifdef GH36DRF
    FIXED           equ     1
    NODESCENDER     equ     1
    szFamilyname    equ     <'GOTHIC', 26 dup (0)>
    szFacename      equ     <'GOTHIC DRAFT', 20 dup (0)>
    sFamilyClass    equ     CLASS_GOTHIC
    usNominalPointSize equ  360
    SBCS_Baseline   equ     4
    SBCS_UpperExt   equ     40
    SBCS_LowerExt   equ     26
    SBCS_Leading    equ     4
    SBCS_Width      equ     24
    DBCS_Baseline   equ     0
    DBCS_MaxExt     equ     48
    DBCS_Leading    equ     0
endif;GH36DRF


    .errnz  ((SBCS_Baseline+SBCS_UpperExt+SBCS_Leading)\
             - (DBCS_Baseline+DBCS_MaxExt+DBCS_Leading))


;-----------------------------------------------------------------------;
;   GOTHIC Family Fonts Key Metrics Definition
;-----------------------------------------------------------------------;

usCodePage          equ     850         ; UGL fonts
xDeviceRes          equ     96          ; VGA resolution
yDeviceRes          equ     96          ; VGA resolution

ifndef DBCS                                             ; SBCS metrics
usFirstChar         equ     0
usLastChar          equ     340h
usDefaultChar       equ     20h
usBreakChar         equ     20h
fsTypeFlags         =       FM_TYPE_LICENSED
else ;DBCS                                              ; DBCS metrics
usFirstChar         equ     0
usLastChar          equ     0
usDefaultChar       equ     0
usBreakChar         equ     0
fsTypeFlags         =       FM_TYPE_LICENSED+FM_TYPE_DBCS
endif;DBCS

ifndef NODESCENDER
;-----------------------------------------------------------------------;
;   GOTHIC System / GOTHIC Proportional Font Height Definitions
;
;   Ŀ
;   ........................................
;   ....................**.......**..**.....
;   *************Ĵ
;   .**....**............***.***************  
;   .**....**.............*......**..**.....  
;   .***..***...........*.....*..**..**..*..  ...yLowerCaseAscent
;   .***..***...........**..*.*************.  
;   .***..***............**.*.**...**...**..  
;   .***.****.****..****.**.*.**...**...**..ĳ
;   .***.*.**..**.....*....**.**...**...**..   
;   .*.***.**..**.....*....*..************..   
;   .*.***.**...**...**...**..**...**.......   
;   .*.***.**...**...*....**.......**....*..   
;   .*..*..**....**.**....*..**************.   
;   .*..*..**....**.*...***........**.......    yXHeight
;   .*..*..**.....***....*.........**.....*.   
;   .*.....**......*.....**.****************   
;   .*.....**..*..**......**.....***.**.....   
;   *******************Ĵ (baseline)
;   ..........*****.......**..***......*****  ...yMaxDescender
;   **********͵ĳ yUnderscorePosition
;   ........................................  
;   
;
;-----------------------------------------------------------------------;

yExternalLeading    equ     0
yMaxBaselineExt     equ     SBCS_Baseline+SBCS_UpperExt+SBCS_Leading
yXHeight            equ     SBCS_LowerExt
yLowerCaseAscent    equ     SBCS_UpperExt
yMaxDescender       equ     SBCS_Baseline
yUnderscorePosition equ     DBCS_Baseline

else ;NODESCENDER
;-----------------------------------------------------------------------;
;   GOTHIC / GOTHIC Terminal Font Height Definitions
;
;   ******Ŀ
;   ***....***...........**......**..**...*.  
;   .**....**............***.***************  
;   .**....**.............*......**..**.....  
;   .***..***...........*.....*..**..**..*..  ...yLowerCaseAscent
;   .***..***...........**..*.*************.  
;   .***..***............**.*.**...**...**..  
;   .***.****.****..****.**.*.**...**...**..ĳ
;   .***.*.**..**.....*....**.**...**...**..   
;   .*.***.**..**.....*....*..************..   
;   .*.***.**...**...**...**..**...**.......   
;   .*.***.**...**...*....**.......**....*..   
;   .*..*..**....**.**....*..**************.   
;   .*..*..**....**.*...***........**.......    yXHeight
;   .*..*..**.....***....*.........**.....*.   
;   .*.....**......*.....**.****************   
;   .*.....**..*..**......**.....***.**.....   
;   ****..*******.*.......**....**....***...   
;   ..........*****.......**..***......*****    (baseline)
;   **********; yUnderscorePosition
;                                                    yMaxDescender
;
;-----------------------------------------------------------------------;

yExternalLeading    equ     0
yMaxBaselineExt     equ     SBCS_Baseline+SBCS_UpperExt+SBCS_Leading
yXHeight            equ     SBCS_Baseline+SBCS_LowerExt
yLowerCaseAscent    equ     SBCS_Baseline+SBCS_UpperExt
yMaxDescender       equ     DBCS_Baseline
yUnderscorePosition equ     DBCS_Baseline

endif;NODESCENDER

;-----------------------------------------------------------------------;
;   GOTHIC Family Fonts Widths Definition
;-----------------------------------------------------------------------;

ifndef FIXED

  ifndef DBCS
    xAveCharWidth   equ     SBCS_Width
    xMaxCharInc     equ     SBCS_MaxInc
  else ;DBCS
    xAveCharWidth   equ     SBCS_Width*2
    xMaxCharInc     equ     SBCS_Width*2
  endif;DBCS

else ;FIXED

  ifndef DBCS
    xAveCharWidth   equ     SBCS_Width
    xMaxCharInc     equ     SBCS_Width
  else ;DBCS
    xAveCharWidth   equ     SBCS_Width*2
    xMaxCharInc     equ     SBCS_Width*2
  endif;DBCS

endif;FIXED

