;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;-----------------------------Module-Header-----------------------------;
; Module Name: M32FONT.ASM
;
;   Font resource definition for optional font drivers.
;   This segment will be loaded as a resource into the FD's default
;   shared data segment.
;
; Created: 15-Oct-1991
; Author:  Soh Ohta     [jl09057 @ ymtvm3, IBM Japan]
;
;                       Refer to Copyright Inscruction Form No.G120-2083
;
; Exported Functions:   none
;
; Public Functions:     none
;
; Public Data:          none
;
; General Description:
;
;-----------------------------------------------------------------------;

        title   RESMAP resource definition for GOTHIC 32 fd
        %out    RESMAP resource definition for GOTHIC 32 fd
        page    ,132


        include os2.inc
        include resmap.inc
        include metrics.inc
        include resource.inc


RESMAPSEG segment public
assume cs:RESMAPSEG
resmap_start:

;-----------------------------------------------------------------------;
; Font resource descriptor header
;-----------------------------------------------------------------------;
resmap_header:

        dw      resmap_end-resmap_header                ; rh_cbSize
        dw      (presmap-vresmap)/(size RESMAP)         ; rh_cFonts
        .errnz  (resmap_header-resmap_start)

;-----------------------------------------------------------------------;
; Virtual font resource descriptors
;-----------------------------------------------------------------------;
vresmap:.errnz  (($-resmap_header) ne (size RESMAPHEADER))

; -------------------
; GOTHIC System 17x36
; -------------------
vh17x36:dw      ph17x36                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((17-1)/8)+1                            ; bd_cbScan
        db      36                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      17                                      ; bd_cx
        db      36                                      ; bd_cy
        dw      VRESID_GOTSYS_17x36                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      17                                      ; rm_xMaxCharInc
        dw      17                                      ; rm_xAveCharWidth
        dw      36                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh17x36) ne (size RESMAP))

vz34x36:dw      wpz32x32                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((34-1)/8)+1                            ; bd_cbScan
        db      36                                      ; bd_nScans
        db      1                                       ; bd_x
        db      2                                       ; bd_y
        db      32                                      ; bd_cx
        db      32                                      ; bd_cy
        dw      VRESID_GOTSYS_34x36                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      34                                      ; rm_xMaxCharInc
        dw      34                                      ; rm_xAveCharWidth
        dw      36                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz34x36) ne (size RESMAP))

; ------------
; GOTHIC 16x32
; ------------
vh16x32:dw      ph16x32                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((16-1)/8)+1                            ; bd_cbScan
        db      32                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      16                                      ; bd_cx
        db      32                                      ; bd_cy
        dw      VRESID_GOTHIC_16x32                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      16                                      ; rm_xMaxCharInc
        dw      16                                      ; rm_xAveCharWidth
        dw      32                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh16x32) ne (size RESMAP))

vz32x32:dw      wpz32x32                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((32-1)/8)+1                            ; bd_cbScan
        db      32                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      32                                      ; bd_cx
        db      32                                      ; bd_cy
        dw      VRESID_GOTHIC_32x32                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      32                                      ; rm_xMaxCharInc
        dw      32                                      ; rm_xAveCharWidth
        dw      32                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz32x32) ne (size RESMAP))

;-----------------------------------------------------------------------;
; Physical font resource descriptors
;-----------------------------------------------------------------------;
presmap:

; ----------------------
; PM SBCS Resource Fonts
; ----------------------
ph16x32:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf17x36                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((17-1)/8)+1                            ; bd_cbScan
        db      36                                      ; bd_nScans
        db      1                                       ; bd_x
        db      2                                       ; bd_y
        db      16                                      ; bd_cx
        db      32                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      16                                      ; rm_xMaxCharInc
        dw      16                                      ; rm_xAveCharWidth
        dw      32                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph16x32) ne (size RESMAP))

ph17x36:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf17x36                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((17-1)/8)+1                            ; bd_cbScan
        db      36                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      17                                      ; bd_cx
        db      36                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      17                                      ; rm_xMaxCharInc
        dw      17                                      ; rm_xAveCharWidth
        dw      36                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph17x36) ne (size RESMAP))

; ----------------------
; CP DBCS FNTCALLS Fonts
; ----------------------
bpz24x24:dw     INVALID_ADDRESS                         ; rm_npFont
        dw      bf24x24                                 ; rm_npPrivate
        dw      FONT_CP_MBCS_BASEFONT                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((32-1)/8)+1                            ; bd_cbScan
        db      24                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      24                                      ; bd_cx
        db      24                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      24                                      ; rm_xMaxCharInc
        dw      24                                      ; rm_xAveCharWidth
        dw      24                                      ; rm_yMaxBaselineExt
        .errnz  (($-bpz24x24) ne (size RESMAP))

; -----------------------
;         DBCS Wife Fonts
; -----------------------
wpz32x32:dw     upz32x32                                ; rm_npFont
        dw      wf32x32                                 ; rm_npPrivate
        dw      FONT_WIN_DBCS_FONTFILE                  ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((32-1)/8)+1                            ; bd_cbScan
        db      32                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      32                                      ; bd_cx
        db      32                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      32                                      ; rm_xMaxCharInc
        dw      32                                      ; rm_xAveCharWidth
        dw      32                                      ; rm_yMaxBaselineExt
        .errnz  (($-wpz32x32) ne (size RESMAP))

;-----------------------------------------------------------------------;
; User defined physical font resource descriptors
;-----------------------------------------------------------------------;
uresmap:

upz32x32:dw     bpz24x24                                ; rm_npFont
        dw      uf32x32                                 ; rm_npPrivate
        dw      FONT_PM_DBCS_USERFONT                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((32-1)/8)+1        ; buffer=(32w,32h)  ; bd_cbScan
        db      32                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      32                                      ; bd_cx
        db      32                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      32                                      ; rm_xMaxCharInc
        dw      32                                      ; rm_xAveCharWidth
        dw      32                                      ; rm_yMaxBaselineExt
        .errnz  (($-upz32x32) ne (size RESMAP))

;-----------------------------------------------------------------------;
; Physical font private data.
;-----------------------------------------------------------------------;
private:

rf17x36:dw      RT_PFONT                                ; rf_resType
        dw      PRESID_GOTSYS_17x36                     ; rf_resId
        dd      INVALID_ADDRESS                         ; rf_lpFoca
        db      0                                       ; rf_szModule

bf24x24:dw      BF_OPTION_PACKED    ; buffer=(32w,24h)  ; bf_option
        dw      size FNTBLOCK,0,0,0                     ; fb_cbFix,fb_*
        dw      BF_ID_STANDARD_DBCS                     ; fb_fontId
        dw      24,24                                   ; fb_width,fb_height

wf32x32:dw      INVALID_ADDRESS                         ; ff_npEncode
        dw      INVALID_ADDRESS                         ; ff_npCache
        dw      512                                     ; ff_cbCache
        dw      0                                       ; ff_cbValid
        dd      0                                       ; ff_ulOffset
        db      '?:\OS2\SYSDATA\PS55DG32.JFD',0         ; ff_szFile

uf32x32:db      '?:\OS2\SYSDATA\$USERG32.FNT',0         ; uf_szFile

;-----------------------------------------------------------------------;
; End of font resource descriptor
;-----------------------------------------------------------------------;
resmap_end:
RESMAPSEG ends

end
