/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************/
/*  Module Name: FDINIT.C                                                     */
/*                                                                            */
/*      Initialize code for for OS/2 DBCS PM font drivers.                    */
/*                                                                            */
/*  Created: 15-Oct-1991                                                      */
/*  Author:  Soh Ohta     [jl09057 @ ymtvm3, IBM Japan]                       */
/*                                                                            */
/*                        Refer to Copyright Inscruction Form No.G120-2083    */
/*                                                                            */
/*  Exported Functions:   none                                                */
/*                                                                            */
/*  Public Functions:     DynaLinkInit                                        */
/*                        LoadResources                                       */
/*                        FreeResources                                       */
/*                                                                            */
/*  Public Data:          none                                                */
/*                                                                            */
/*  General Description:                                                      */
/*                                                                            */
/******************************************************************************/

#define INCL_PM
#define INCL_DOS
#include <os2.h>
#include "resmap.h"


NPRESMAPHEADER npResmapHeader = 0;      // font resource mapping definition.
NPBYTE  npImageSrc = 0;                 // image mapping work area.
NPBYTE  npImageDst = 0;                 // image mapping work area.
USHORT  cbImage = 0;                    // image mapping work area size.
CPINFO  cpInfo = {0};                   // codepage vector.
UCHAR   chBootDrive = 0;                // boot drive (A,B,C...).

HMODULE hmod = 0;                       // FD's module handle.
SEL     selDs = 0;                      // FD's shared data segment selector.
HHEAP   hHeap = 0;                      // FD's heap handle.
USHORT  cbHeap = 0;                     // FD's heap size.

#define cbMinDed    (sizeof(USHORT))
#define cbMaxDed    (256)
#define cbGrow      (cbMaxDed*16)

USHORT  LoadFont (NPRESMAP,NPRESMAP);
VOID    FreeFont (NPRESMAP);
#define DriveLetter(drive)  ((UCHAR)((drive)+'A'-1))



/******************************************************************************/
/*  DynaLinkInit                                                              */
/*                                                                            */
/*  Initialization for font driver module loading time.                       */
/*  Saves font drivers key variables.                                         */
/*                                                                            */
/*  Parameter:                                                                */
/*      sharedDs  = automatic data segment selector (shared segment)          */
/*      heapSize  = maximum heap size defined in .DEF file                    */
/*      hModule   = module handle of font driver itsself                      */
/*  Return:                                                                   */
/*      success   = 1 (passed to OS/2)                                        */
/******************************************************************************/

USHORT DynaLinkInit (SEL sharedDs, USHORT heapSize, HMODULE hModule)
{
    SEL         selGlobalSeg,selLocalSeg;
    PGINFOSEG   pgis;

    selDs   = sharedDs;
    cbHeap  = heapSize;
    hmod    = hModule;

    DosGetInfoSeg (&selGlobalSeg,&selLocalSeg);
    pgis = MAKEPGINFOSEG (selGlobalSeg);
    chBootDrive = DriveLetter (pgis-> bootdrive);

    return 1;
}

/******************************************************************************/
/*  LoadResources                                                             */
/*                                                                            */
/*  Load all of font driver resources into the heap memory created within     */
/*  the dll's automatic data segment.                                         */
/*  The font driver will load the following resources:                        */
/*                                                                            */
/*     codepage vector (CPINFO structure)                                    */
/*     font resource mapping definition (RESMAP,RESMAPHEADER)                */
/*     image mapping work area                                               */
/*     physical font resources (by LoadAllFonts())                           */
/*                                                                            */
/*  Parameter:                                                                */
/*      codepage  = codepage to be used (system default codepage)             */
/*  Return:                                                                   */
/*      success   = 0                                                         */
/*      error     = -1                                                        */
/******************************************************************************/

USHORT LoadResources (USHORT codepage)
{
    USHORT          cb;
    PBYTE           lp;
    register USHORT i;
    USHORT          LoadAllFonts (VOID);


    if (hHeap = WinCreateHeap (selDs,cbHeap,cbGrow,cbMinDed,cbMaxDed,0)) {

        if (DosGetResource2 (hmod,RT_CPINFO,codepage,&lp) == 0) {
            cpInfo = *(CPINFO FAR*)lp;
            DosFreeResource (lp);

            if (DosGetResource2 (hmod,RT_RESMAP,RI_RESMAP,&lp) == 0) {
                cb = ((RESMAPHEADER FAR*)lp)->cbSize;
                if ((npResmapHeader = (NPRESMAPHEADER)WinAllocMem (hHeap,cb)) == NULL) {
                    DosFreeResource (lp);
                } else {
                    for (i=0; i<cb; i++)
                        ((NPBYTE)npResmapHeader)[i] = lp[i];
                    DosFreeResource (lp);

                    if (cbImage = LoadAllFonts ()) {
                        if (npImageSrc = WinAllocMem (hHeap,cbImage*2)) {
                            npImageDst = npImageSrc+cbImage;
                            return npResmapHeader->cFonts;
                        }
                    }
                    WinFreeMem (hHeap,(NPBYTE)npResmapHeader,npResmapHeader->cbSize);
                }
            }
        }
        WinDestroyHeap (hHeap);
    }
    return 0;
}

/******************************************************************************/
/*  FreeResources                                                             */
/*                                                                            */
/*  Free all of font driver resources.                                        */
/*                                                                            */
/*  Parameter:                                                                */
/*      nothing                                                               */
/*  Return:                                                                   */
/*      nothing                                                               */
/******************************************************************************/

VOID FreeResources (VOID)
{
    register USHORT ires;

    for (ires=0; ires<npResmapHeader->cFonts; ires++)
        FreeFont (&npResmapHeader->aFonts[ires]);

    WinFreeMem (hHeap,npImageSrc,cbImage*2);
    WinFreeMem (hHeap,(NPBYTE)npResmapHeader,npResmapHeader->cbSize);
    WinDestroyHeap (hHeap);
}

/******************************************************************************/
/*  LoadAllFonts                                                              */
/*                                                                            */
/*  Load all of font resources.                                               */
/*                                                                            */
/*  Parameter:                                                                */
/*      nothing                                                               */
/*  Return:                                                                   */
/*      success   = image buffer size required                                */
/*      error     = 0                                                         */
/******************************************************************************/

USHORT LoadAllFonts (VOID)
{
    register USHORT cb,cbMax;
    register USHORT ires;

    for (cbMax=ires=0; ires<npResmapHeader->cFonts; ires++) {
        if (cb = LoadFont (&npResmapHeader->aFonts[ires],&npResmapHeader->aFonts[ires])) {
            if (cb > cbMax)
                cbMax = cb;
        } else {
            while (ires)
                FreeFont (&npResmapHeader->aFonts[--ires]);
            return 0;
        }
    }
    return cbMax;
}

