/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/******************************************************************************/
/*  Module Name: FDCP.C                                                       */
/*                                                                            */
/*      Physical font resource access support routine for OS/2 DBCS PM        */
/*      font drivers.                                                         */
/*                                                                            */
/*  Created: 15-Oct-1991                                                      */
/*  Author:  Soh Ohta     [jl09057 @ ymtvm3, IBM Japan]                       */
/*                                                                            */
/*                        Refer to Copyright Inscruction Form No.G120-2083    */
/*                                                                            */
/*  Exported Functions:   none                                                */
/*                                                                            */
/*  Public Functions:     LoadCPFont                                          */
/*                        FreeCPFont                                          */
/*                        QueryCPWidth                                        */
/*                        QueryDefCPWidth                                     */
/*                        QueryCPImage                                        */
/*                        QueryDefCPImage                                     */
/*                        BitmapFromBaseFont                                  */
/*                                                                            */
/*  Public Data:          none                                                */
/*                                                                            */
/*  General Description:                                                      */
/*                                                                            */
/******************************************************************************/

#define INCL_PM
#define INCL_DOS
#include <os2.h>
#include <memory.h>
#include "resmap.h"


extern NPBYTE   npImageSrc;             // image mapping work area.
extern NPBYTE   npImageDst;             // image mapping work area.
extern CPINFO   cpInfo;                 // codepage vector.
extern SEL      selDs;                  // FD's shared data segment selector.

VOID                FontFromBitmap (PBYTE,NPBITSDEF);
NPBITSDEF PASCAL    Bitblt (NPBITSDEF,NPBITSDEF);
USHORT FAR PASCAL   FntGetImage (PFNTBLOCK,USHORT,USHORT,PBYTE);



/******************************************************************************/
/*  LoadCPFont                                                                */
/*                                                                            */
/*  Load resoures associated to the specified physical font.                  */
/*                                                                            */
/*  Parameter:                                                                */
/*      npFont    = physical font descriptor (font to be modified)            */
/*  Return:                                                                   */
/*      success   = 0                                                         */
/*      error     = -1                                                        */
/******************************************************************************/

USHORT LoadCPFont (NPRESMAP npFont)
{
    return 0;
}

/******************************************************************************/
/*  FreeCPFont                                                                */
/*                                                                            */
/*  Free resoures associated to the specified physical font.                  */
/*                                                                            */
/*  Parameter:                                                                */
/*      npFont    = physical font descriptor (font to be modified)            */
/*  Return:                                                                   */
/*      nothing                                                               */
/******************************************************************************/

VOID FreeCPFont (NPRESMAP npFont)
{
}

/******************************************************************************/
/*  QueryCPWidth                                                              */
/*                                                                            */
/*  Return specified character cell width.                                    */
/*                                                                            */
/*  Parameter:                                                                */
/*      index     = glyph index                                               */
/*      npVirtual = virtual  font descriptor (FD font being requested)        */
/*      npFont    = physical font descriptor (font to be modified)            */
/*  Return:                                                                   */
/*      success   = character cell width                                      */
/*      error     = 0                                                         */
/******************************************************************************/

USHORT QueryCPWidth (USHORT index, NPRESMAP npVirtual, NPRESMAP npFont)
{
    return npVirtual->xAveCharWidth;
}

/******************************************************************************/
/*  QueryDefCPWidth                                                           */
/*                                                                            */
/*  Return default character cell width.                                      */
/*                                                                            */
/*  Parameter:                                                                */
/*      npVirtual = virtual  font descriptor (FD font being requested)        */
/*      npFont    = physical font descriptor (font to be modified)            */
/*  Return:                                                                   */
/*      success   = character cell width                                      */
/*      error     = 0                                                         */
/******************************************************************************/

USHORT QueryDefCPWidth (NPRESMAP npVirtual, NPRESMAP npFont)
{
    return npVirtual->xAveCharWidth;
}

/******************************************************************************/
/*  QueryCPImage                                                              */
/*                                                                            */
/*  Get specified character image and return its width.                       */
/*                                                                            */
/*  Parameter:                                                                */
/*      index     = glyph index                                               */
/*      npVirtual = virtual  font descriptor (FD font being requested)        */
/*      npFont    = physical font descriptor (font to be modified)            */
/*      lpBuf     = image buffer into which the font is to be built           */
/*      cbBuf     = image buffer size                                         */
/*  Return:                                                                   */
/*      success   = character cell width                                      */
/*      error     = 0                                                         */
/******************************************************************************/

USHORT QueryCPImage (USHORT index, NPRESMAP npVirtual, NPRESMAP npFont, PBYTE lpBuf, USHORT cbBuf)
{
    register NPBASEFONTINFO npBaseInfo;
    VOID BitmapFromBaseFont (NPBITSDEF,NPBYTE,NPBASEFONTINFO);

    if (npVirtual->bitsDef.cbScan*npVirtual->bitsDef.nScans <= cbBuf) {

        // setup image mapping work area.
        npVirtual->bitsDef.npBits = npImageDst;
        npFont->bitsDef.npBits    = npImageSrc;

        // get base font image.
        npBaseInfo = (NPBASEFONTINFO)npFont->npPrivate;

        if ((npBaseInfo->option == BF_OPTION_PACKED) ||
            (npBaseInfo->fntBlock.fontId != BF_ID_STANDARD_DBCS)) {
            // packed DBCS or any SBCS format is already in bitmap format.
            if (FntGetImage (&npBaseInfo->fntBlock,index,npBaseInfo->option,MAKEP(selDs,npImageSrc)) != 0)
                return 0;
        } else {
            // non packed DBCS format. convert to bitmap format.
            if (FntGetImage (&npBaseInfo->fntBlock,index,npBaseInfo->option,MAKEP(selDs,npImageDst)) != 0)
                return 0;
            BitmapFromBaseFont (&npFont->bitsDef,npImageDst,npBaseInfo);
        }

        // do image mapping and convert image to font format.
        FontFromBitmap (lpBuf,Bitblt(&npVirtual->bitsDef,&npFont->bitsDef));
        return npVirtual->xAveCharWidth;
    }
    return 0;
}

/******************************************************************************/
/*  QueryDefCPImage                                                           */
/*                                                                            */
/*  Get default character image and return its width.                         */
/*                                                                            */
/*  Parameter:                                                                */
/*      npVirtual = virtual  font descriptor (FD font being requested)        */
/*      npFont    = physical font descriptor (font to be modified)            */
/*      lpBuf     = image buffer into which the font is to be built           */
/*      cbBuf     = image buffer size                                         */
/*  Return:                                                                   */
/*      success   = character cell width                                      */
/*      error     = 0                                                         */
/******************************************************************************/

USHORT QueryDefCPImage (NPRESMAP npVirtual, NPRESMAP npFont, PBYTE lpBuf, USHORT cbBuf)
{
    if (npVirtual->fsTypeFlags & FM_TYPE_DBCS)
        // get DBCS default character image.
        return QueryCPImage (cpInfo.usDefaultChar,npVirtual,npFont,lpBuf,cbBuf);
    else
        return 0;   // no SBCS font image.
}

/******************************************************************************/
/*  BitmapFromBaseFont                                                        */
/*                                                                            */
/*  Convert non packed base font image to bitmap (=packed) image.             */
/*                                                                            */
/*  Parameter:                                                                */
/*      npBd      = destination bitmap image                                  */
/*      npFont    = source base font image                                    */
/*      npBaseInfo= base font format information                              */
/*  Return:                                                                   */
/*      nothing                                                               */
/******************************************************************************/

VOID BitmapFromBaseFont (NPBITSDEF npBd, NPBYTE npFont, NPBASEFONTINFO npBaseInfo)
{
    NPBYTE  npBitmap;
    USHORT  nScans;

    if ((npBaseInfo->option == BF_OPTION_PACKED) ||
        (npBaseInfo->fntBlock.fontId != BF_ID_STANDARD_DBCS)) {
        // packed DBCS or any SBCS format is already in bitmap format.

        memcpy (npBd->npBits,npFont,(size_t)npBd->cbScan*npBd->nScans);
        return;
    }

    if (npBaseInfo->fntBlock.width == 16) {
        // normal box (16x16) or fullbox (16x19) format.

        npBitmap = npBd->npBits;
        nScans   = npBd->nScans;
        _asm {
            mov     ax,ds
            mov     es,ax               // es = ds
            mov     si,npFont           // si = npFont
            mov     di,npBitmap         // di = npBitmap = npBd->npBits
            mov     cx,nScans           // cx = nScans   = npBd->nScans
            mov     bx,cx               // bx = nScans
        store_one_scan_16:              // do {
            mov     ah,[si][bx]         //   npBitmap[1] = *(npFont+nScans)
            lodsb                       //   npBitmap[0] = *npFont++
            stosw                       //   npBitmap += 2
            loop    store_one_scan_16   // } while (cx--)
        }
        return;
    }

    if (npBaseInfo->option == BF_OPTION_NORMAL) {
        // normal box (24x24) format.

        npBitmap = npBd->npBits;
        nScans   = npBd->nScans;
        _asm {
            mov     si,npFont           // si = npFont
            mov     di,npBitmap         // di = npBitmap = npBd->npBits
            mov     cx,nScans           // cx = nScans   = npBd->nScans
        store_one_scan_24:              // do {
            mov     ax,[si]             //   al:ah = 11111111:2222____
            mov     dx,[si][24*2]       //   dl:dh = 22223333:3333____
            ror     dx,4                //   dl:dh = ____2222:33333333
            or      ah,dl               //   al:ah = 11111111:22222222
            mov     [di],ax             //   npBitmap[0] = al:ah
            mov     [di][2],dh          //   npBitmap[2] = dh
            add     di,4                //   npBitmap += 4
            add     si,2                //   npFont += 2
            loop    store_one_scan_24   // } while (cx--)
        }
        return;

    } else {
        // full box (26x30) format.

        npBitmap = npBd->npBits;
        nScans   = npBd->nScans;
        _asm {
            mov     si,npFont           // si = npFont
            mov     di,npBitmap         // di = npBitmap = npBd->npBits
            mov     cx,nScans           // cx = nScans   = npBd->nScans
        store_one_scan_26:              // do {
            mov     ax,[si]             //   al:ah = 11111111:22222___
            mov     dx,[si][30*2]       //   dl:dh = 22233333:33344___
            mov     bl,dl               //   bl    = 22233333
            shr     bl,5                //   bl    = _____222
            or      ah,bl               //   al:ah = 11111111:22222222
            rol     dx,3                //   dl:dh = 33333333:44______
            mov     [di],ax             //   npBitmap[0] = al:ah
            mov     [di][2],dx          //   npBitmap[2] = dl:dh
            add     di,4                //   npBitmap += 4
            add     si,2                //   npFont += 2
            loop    store_one_scan_26   // } while (cx--)
        }
        return;
    }
}

