;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;-----------------------------Module-Header-----------------------------;
; Module Name: FD1FONT.ASM
;
;   Font resource definition for system font driver #2.
;   This segment will be loaded as a resource into the FD's default
;   shared data segment.
;
; Created: 15-Oct-1991
; Author:  Soh Ohta     [jl09057 @ ymtvm3, IBM Japan]
;
;                       Refer to Copyright Inscruction Form No.G120-2083
;
; Exported Functions:   none
;
; Public Functions:     none
;
; Public Data:          none
;
; General Description:
;
;-----------------------------------------------------------------------;

        title   RESMAP resource definition for system fd#2
        %out    RESMAP resource definition for system fd#2
        page    ,132


        include os2.inc
        include resmap.inc
        include metrics.inc
        include resource.inc


RESMAPSEG segment public
assume cs:RESMAPSEG
resmap_start:

;-----------------------------------------------------------------------;
; Font resource descriptor header
;-----------------------------------------------------------------------;
resmap_header:

        dw      resmap_end-resmap_header                ; rh_cbSize
        dw      (presmap-vresmap)/(size RESMAP)         ; rh_cFonts
        .errnz  (resmap_header-resmap_start)

;-----------------------------------------------------------------------;
; Virtual font resource descriptors
;-----------------------------------------------------------------------;
vresmap:.errnz  (($-resmap_header) ne (size RESMAPHEADER))

; -----------------
; MINCHO DRAFT 6x12
; -----------------
vh06x12:dw      ph12x24                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((6-1)/8)+1                             ; bd_cbScan
        db      12                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      6                                       ; bd_cx
        db      12                                      ; bd_cy
        dw      VRESID_MINDRF_06x12                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      6                                       ; rm_xMaxCharInc
        dw      6                                       ; rm_xAveCharWidth
        dw      12                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh06x12) ne (size RESMAP))

vz12x12:dw      bpz24x24                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((12-1)/8)+1                            ; bd_cbScan
        db      12                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      12                                      ; bd_cx
        db      12                                      ; bd_cy
        dw      VRESID_MINDRF_12x12                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      12                                      ; rm_xMaxCharInc
        dw      12                                      ; rm_xAveCharWidth
        dw      12                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz12x12) ne (size RESMAP))

; -----------------
; MINCHO DRAFT 7x14
; -----------------
vh07x14:dw      ph12x24                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((7-1)/8)+1                             ; bd_cbScan
        db      14                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      7                                       ; bd_cx
        db      14                                      ; bd_cy
        dw      VRESID_MINDRF_07x14                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      7                                       ; rm_xMaxCharInc
        dw      7                                       ; rm_xAveCharWidth
        dw      14                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh07x14) ne (size RESMAP))

vz14x14:dw      bpz24x24                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((14-1)/8)+1                            ; bd_cbScan
        db      14                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      14                                      ; bd_cx
        db      14                                      ; bd_cy
        dw      VRESID_MINDRF_14x14                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      14                                      ; rm_xMaxCharInc
        dw      14                                      ; rm_xAveCharWidth
        dw      14                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz14x14) ne (size RESMAP))

; -----------------
; MINCHO DRAFT 8x16
; -----------------
vh08x16:dw      ph12x24                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((8-1)/8)+1                             ; bd_cbScan
        db      16                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      8                                       ; bd_cx
        db      16                                      ; bd_cy
        dw      VRESID_MINDRF_08x16                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      8                                       ; rm_xMaxCharInc
        dw      8                                       ; rm_xAveCharWidth
        dw      16                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh08x16) ne (size RESMAP))

vz16x16:dw      bpz24x24                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((16-1)/8)+1                            ; bd_cbScan
        db      16                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      16                                      ; bd_cx
        db      16                                      ; bd_cy
        dw      VRESID_MINDRF_16x16                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      16                                      ; rm_xMaxCharInc
        dw      16                                      ; rm_xAveCharWidth
        dw      16                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz16x16) ne (size RESMAP))

; -----------------
; MINCHO DRAFT 9x18
; -----------------
vh09x18:dw      ph12x24                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((9-1)/8)+1                             ; bd_cbScan
        db      18                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      9                                       ; bd_cx
        db      18                                      ; bd_cy
        dw      VRESID_MINDRF_09x18                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      9                                       ; rm_xMaxCharInc
        dw      9                                       ; rm_xAveCharWidth
        dw      18                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh09x18) ne (size RESMAP))

vz18x18:dw      bpz24x24                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((18-1)/8)+1                            ; bd_cbScan
        db      18                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      18                                      ; bd_cx
        db      18                                      ; bd_cy
        dw      VRESID_MINDRF_18x18                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      18                                      ; rm_xMaxCharInc
        dw      18                                      ; rm_xAveCharWidth
        dw      18                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz18x18) ne (size RESMAP))

; ------------------
; MINCHO DRAFT 10x20
; ------------------
vh10x20:dw      ph12x24                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((10-1)/8)+1                            ; bd_cbScan
        db      20                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      10                                      ; bd_cx
        db      20                                      ; bd_cy
        dw      VRESID_MINDRF_10x20                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      10                                      ; rm_xMaxCharInc
        dw      10                                      ; rm_xAveCharWidth
        dw      20                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh10x20) ne (size RESMAP))

vz20x20:dw      bpz24x24                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((20-1)/8)+1                            ; bd_cbScan
        db      20                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      20                                      ; bd_cx
        db      20                                      ; bd_cy
        dw      VRESID_MINDRF_20x20                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      20                                      ; rm_xMaxCharInc
        dw      20                                      ; rm_xAveCharWidth
        dw      20                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz20x20) ne (size RESMAP))

; ------------------
; MINCHO DRAFT 11x22
; ------------------
vh11x22:dw      ph12x24                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((11-1)/8)+1                            ; bd_cbScan
        db      22                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      11                                      ; bd_cx
        db      22                                      ; bd_cy
        dw      VRESID_MINDRF_11x22                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      11                                      ; rm_xMaxCharInc
        dw      11                                      ; rm_xAveCharWidth
        dw      22                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh11x22) ne (size RESMAP))

vz22x22:dw      bpz24x24                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((22-1)/8)+1                            ; bd_cbScan
        db      22                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      22                                      ; bd_cx
        db      22                                      ; bd_cy
        dw      VRESID_MINDRF_22x22                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      22                                      ; rm_xMaxCharInc
        dw      22                                      ; rm_xAveCharWidth
        dw      22                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz22x22) ne (size RESMAP))

; ------------------
; MINCHO DRAFT 16x32
; ------------------
vh16x32:dw      ph12x24                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((16-1)/8)+1                            ; bd_cbScan
        db      32                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      16                                      ; bd_cx
        db      32                                      ; bd_cy
        dw      VRESID_MINDRF_16x32                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      16                                      ; rm_xMaxCharInc
        dw      16                                      ; rm_xAveCharWidth
        dw      32                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh16x32) ne (size RESMAP))

vz32x32:dw      bpz24x24                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((32-1)/8)+1                            ; bd_cbScan
        db      32                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      32                                      ; bd_cx
        db      32                                      ; bd_cy
        dw      VRESID_MINDRF_32x32                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      32                                      ; rm_xMaxCharInc
        dw      32                                      ; rm_xAveCharWidth
        dw      32                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz32x32) ne (size RESMAP))

; ------------------
; MINCHO DRAFT 18x36
; ------------------
vh18x36:dw      ph12x24                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((18-1)/8)+1                            ; bd_cbScan
        db      36                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      18                                      ; bd_cx
        db      36                                      ; bd_cy
        dw      VRESID_MINDRF_18x36                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      18                                      ; rm_xMaxCharInc
        dw      18                                      ; rm_xAveCharWidth
        dw      36                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh18x36) ne (size RESMAP))

vz36x36:dw      bpz24x24                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((36-1)/8)+1                            ; bd_cbScan
        db      36                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      36                                      ; bd_cx
        db      36                                      ; bd_cy
        dw      VRESID_MINDRF_36x36                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      36                                      ; rm_xMaxCharInc
        dw      36                                      ; rm_xAveCharWidth
        dw      36                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz36x36) ne (size RESMAP))

; ------------------
; MINCHO DRAFT 24x48
; ------------------
vh24x48:dw      ph12x24                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((24-1)/8)+1                            ; bd_cbScan
        db      48                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      24                                      ; bd_cx
        db      48                                      ; bd_cy
        dw      VRESID_MINDRF_24x48                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      24                                      ; rm_xMaxCharInc
        dw      24                                      ; rm_xAveCharWidth
        dw      48                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh24x48) ne (size RESMAP))

vz48x48:dw      bpz24x24                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((48-1)/8)+1                            ; bd_cbScan
        db      48                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      48                                      ; bd_cx
        db      48                                      ; bd_cy
        dw      VRESID_MINDRF_48x48                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      48                                      ; rm_xMaxCharInc
        dw      48                                      ; rm_xAveCharWidth
        dw      48                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz48x48) ne (size RESMAP))

;-----------------------------------------------------------------------;
; Physical font resource descriptors
;-----------------------------------------------------------------------;
presmap:

; ----------------------
; PM SBCS Resource Fonts
; ----------------------
ph12x24:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf13x28                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_OTHERDLL                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((13-1)/8)+1                            ; bd_cbScan
        db      28                                      ; bd_nScans
        db      1                                       ; bd_x
        db      2                                       ; bd_y
        db      12                                      ; bd_cx
        db      24                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      12                                      ; rm_xMaxCharInc
        dw      12                                      ; rm_xAveCharWidth
        dw      24                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph12x24) ne (size RESMAP))

; ----------------------
; CP DBCS FNTCALLS Fonts
; ----------------------
bpz24x24:dw     INVALID_ADDRESS                         ; rm_npFont
        dw      bf24x24                                 ; rm_npPrivate
        dw      FONT_CP_MBCS_BASEFONT                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((32-1)/8)+1                            ; bd_cbScan
        db      24                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      24                                      ; bd_cx
        db      24                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      24                                      ; rm_xMaxCharInc
        dw      24                                      ; rm_xAveCharWidth
        dw      24                                      ; rm_yMaxBaselineExt
        .errnz  (($-bpz24x24) ne (size RESMAP))

;-----------------------------------------------------------------------;
; User defined physical font resource descriptors
;-----------------------------------------------------------------------;
uresmap:


;-----------------------------------------------------------------------;
; Physical font private data.
;-----------------------------------------------------------------------;
private:

rf13x28:dw      RT_PFONT                                ; rf_resType
        dw      PRESID_MINSYS_13x28                     ; rf_resId
        dd      INVALID_ADDRESS                         ; rf_lpFoca
        db      '?:\OS2\DLL\PMNLSFD1.FDR',0             ; rf_szModule

bf24x24:dw      BF_OPTION_PACKED    ; buffer=(32w,24h)  ; bf_option
        dw      size FNTBLOCK,0,0,0                     ; fb_cbFix,fb_*
        dw      BF_ID_STANDARD_DBCS                     ; fb_fontId
        dw      24,24                                   ; fb_width,fb_height

;-----------------------------------------------------------------------;
; End of font resource descriptor
;-----------------------------------------------------------------------;
resmap_end:
RESMAPSEG ends

end
