;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;-----------------------------Module-Header-----------------------------;
; Module Name: FD1FONT.ASM
;
;   Font resource definition for system font driver #1.
;   This segment will be loaded as a resource into the FD's default
;   shared data segment.
;
; Created: 15-Oct-1991
; Author:  Soh Ohta     [jl09057 @ ymtvm3, IBM Japan]
;
;                       Refer to Copyright Inscruction Form No.G120-2083
;
; Exported Functions:   none
;
; Public Functions:     none
;
; Public Data:          none
;
; General Description:
;
; CHANGE ACTIVITY:
; FLAG REASON   RLSE DATE   ORIGIN   COMMENTS
; ---- -------- ---- ------ -------- ----------------------------------------
; @NI1 DCR291   R206 930714 N.Iuchi  12 dot WINDOW DBCS font support
;-----------------------------------------------------------------------;

        title   RESMAP resource definition for system fd#1
        %out    RESMAP resource definition for system fd#1
        page    ,132


        include os2.inc
        include resmap.inc
        include metrics.inc
        include resource.inc


RESMAPSEG segment public
assume cs:RESMAPSEG
resmap_start:

;-----------------------------------------------------------------------;
; Font resource descriptor header
;-----------------------------------------------------------------------;
resmap_header:

        dw      resmap_end-resmap_header                ; rh_cbSize
        dw      (presmap-vresmap)/(size RESMAP)         ; rh_cFonts
        .errnz  (resmap_header-resmap_start)

;-----------------------------------------------------------------------;
; Virtual font resource descriptors
;-----------------------------------------------------------------------;
vresmap:.errnz  (($-resmap_header) ne (size RESMAPHEADER))

if      1                                                               ;@KY1
; -----------
; MINCHO 6x12
; -----------
vh06x12:dw      ph06x12                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((6-1)/8)+1                             ; bd_cbScan
        db      12                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      6                                       ; bd_cx
        db      12                                      ; bd_cy
        dw      VRESID_MINCHO_06x12                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      6                                       ; rm_xMaxCharInc
        dw      6                                       ; rm_xAveCharWidth
        dw      12                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh06x12) ne (size RESMAP))

vz12x12:dw      wpz12x12                                ; rm_npFont     ;@NI1
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((12-1)/8)+1                            ; bd_cbScan
        db      12                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      12                                      ; bd_cx
        db      12                                      ; bd_cy
        dw      VRESID_MINCHO_12x12                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      12                                      ; rm_xMaxCharInc
        dw      12                                      ; rm_xAveCharWidth
        dw      12                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz12x12) ne (size RESMAP))

; -----------
; MINCHO 7x14
; -----------
vh07x14:dw      ph07x14                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((7-1)/8)+1                             ; bd_cbScan
        db      14                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      7                                       ; bd_cx
        db      14                                      ; bd_cy
        dw      VRESID_MINCHO_07x14                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      7                                       ; rm_xMaxCharInc
        dw      7                                       ; rm_xAveCharWidth
        dw      14                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh07x14) ne (size RESMAP))

vz14x14:dw      wpz12x12                                ; rm_npFont     ;@NI1
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((14-1)/8)+1                            ; bd_cbScan
        db      14                                      ; bd_nScans
        db      1                                       ; bd_x
        db      1                                       ; bd_y
        db      12                                      ; bd_cx
        db      12                                      ; bd_cy
        dw      VRESID_MINCHO_14x14                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      14                                      ; rm_xMaxCharInc
        dw      14                                      ; rm_xAveCharWidth
        dw      14                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz14x14) ne (size RESMAP))

; -----------
; MINCHO 8x16
; -----------
vh08x16:dw      ph08x16                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((8-1)/8)+1                             ; bd_cbScan
        db      16                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      8                                       ; bd_cx
        db      16                                      ; bd_cy
        dw      VRESID_MINCHO_08x16                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      8                                       ; rm_xMaxCharInc
        dw      8                                       ; rm_xAveCharWidth
        dw      16                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh08x16) ne (size RESMAP))

vz16x16:dw      bpz16x16                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((16-1)/8)+1                            ; bd_cbScan
        db      16                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      16                                      ; bd_cx
        db      16                                      ; bd_cy
        dw      VRESID_MINCHO_16x16                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      16                                      ; rm_xMaxCharInc
        dw      16                                      ; rm_xAveCharWidth
        dw      16                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz16x16) ne (size RESMAP))

; -----------
; MINCHO 9x18
; -----------
vh09x18:dw      ph09x18                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((9-1)/8)+1                             ; bd_cbScan
        db      18                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      9                                       ; bd_cx
        db      18                                      ; bd_cy
        dw      VRESID_MINCHO_09x18                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      9                                       ; rm_xMaxCharInc
        dw      9                                       ; rm_xAveCharWidth
        dw      18                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh09x18) ne (size RESMAP))

vz18x18:dw      bpz16x18                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((18-1)/8)+1                            ; bd_cbScan
        db      18                                      ; bd_nScans
        db      1                                       ; bd_x
        db      0                                       ; bd_y
        db      16                                      ; bd_cx
        db      18                                      ; bd_cy
        dw      VRESID_MINCHO_18x18                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      18                                      ; rm_xMaxCharInc
        dw      18                                      ; rm_xAveCharWidth
        dw      18                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz18x18) ne (size RESMAP))

; ------------
; MINCHO 10x20
; ------------
vh10x20:dw      ph10x20                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((10-1)/8)+1                            ; bd_cbScan
        db      20                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      10                                      ; bd_cx
        db      20                                      ; bd_cy
        dw      VRESID_MINCHO_10x20                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      10                                      ; rm_xMaxCharInc
        dw      10                                      ; rm_xAveCharWidth
        dw      20                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh10x20) ne (size RESMAP))

vz20x20:dw      wpz20x20                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((20-1)/8)+1                            ; bd_cbScan
        db      20                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      20                                      ; bd_cx
        db      20                                      ; bd_cy
        dw      VRESID_MINCHO_20x20                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      20                                      ; rm_xMaxCharInc
        dw      20                                      ; rm_xAveCharWidth
        dw      20                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz20x20) ne (size RESMAP))

; ------------
; MINCHO 12x24
; ------------
vh12x24:dw      ph12x24                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((12-1)/8)+1                            ; bd_cbScan
        db      24                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      12                                      ; bd_cx
        db      24                                      ; bd_cy
        dw      VRESID_MINCHO_12x24                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      12                                      ; rm_xMaxCharInc
        dw      12                                      ; rm_xAveCharWidth
        dw      24                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh12x24) ne (size RESMAP))

vz24x24:dw      bpz24x24                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((24-1)/8)+1                            ; bd_cbScan
        db      24                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      24                                      ; bd_cx
        db      24                                      ; bd_cy
        dw      VRESID_MINCHO_24x24                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      24                                      ; rm_xMaxCharInc
        dw      24                                      ; rm_xAveCharWidth
        dw      24                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz24x24) ne (size RESMAP))
endif                                                                   ;@KY1

; ----------------------
; MINCHO Proportional 18
; ----------------------
vhPro18:dw      phPro18                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((8-1)/8)+1                             ; bd_cbScan
        db      18                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      8                                       ; bd_cx
        db      18                                      ; bd_cy
        dw      VRESID_MINPRO_08x18                     ; rm_resId
        dw      0                                       ; rm_fsTypeFlags
        dw      17                                      ; rm_xMaxCharInc
        dw      8                                       ; rm_xAveCharWidth
        dw      18                                      ; rm_yMaxBaselineExt
        .errnz  (($-vhPro18) ne (size RESMAP))

vzPro18:dw      bpz16x18                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((16-1)/8)+1                            ; bd_cbScan
        db      18                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      16                                      ; bd_cx
        db      18                                      ; bd_cy
        dw      VRESID_MINPRO_16x18                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      16                                      ; rm_xMaxCharInc
        dw      16                                      ; rm_xAveCharWidth
        dw      18                                      ; rm_yMaxBaselineExt
        .errnz  (($-vzPro18) ne (size RESMAP))

; ----------------------
; MINCHO Proportional 24
; ----------------------
vhPro24:dw      phPro24                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((11-1)/8)+1                            ; bd_cbScan
        db      24                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      11                                      ; bd_cx
        db      24                                      ; bd_cy
        dw      VRESID_MINPRO_11x24                     ; rm_resId
        dw      0                                       ; rm_fsTypeFlags
        dw      20                                      ; rm_xMaxCharInc
        dw      11                                      ; rm_xAveCharWidth
        dw      24                                      ; rm_yMaxBaselineExt
        .errnz  (($-vhPro24) ne (size RESMAP))

vzPro24:dw      wpz20x20                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((22-1)/8)+1                            ; bd_cbScan
        db      24                                      ; bd_nScans
        db      1                                       ; bd_x
        db      2                                       ; bd_y
        db      20                                      ; bd_cx
        db      20                                      ; bd_cy
        dw      VRESID_MINPRO_22x24                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      22                                      ; rm_xMaxCharInc
        dw      22                                      ; rm_xAveCharWidth
        dw      24                                      ; rm_yMaxBaselineExt
        .errnz  (($-vzPro24) ne (size RESMAP))

; ----------------------
; MINCHO Proportional 26
; ----------------------
vhPro26:dw      phPro26                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((12-1)/8)+1                            ; bd_cbScan
        db      26                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      12                                      ; bd_cx
        db      26                                      ; bd_cy
        dw      VRESID_MINPRO_12x26                     ; rm_resId
        dw      0                                       ; rm_fsTypeFlags
        dw      23                                      ; rm_xMaxCharInc
        dw      12                                      ; rm_xAveCharWidth
        dw      26                                      ; rm_yMaxBaselineExt
        .errnz  (($-vhPro26) ne (size RESMAP))

vzPro26:dw      bpz24x24                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((24-1)/8)+1                            ; bd_cbScan
        db      26                                      ; bd_nScans
        db      0                                       ; bd_x
        db      1                                       ; bd_y
        db      24                                      ; bd_cx
        db      24                                      ; bd_cy
        dw      VRESID_MINPRO_24x26                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      24                                      ; rm_xMaxCharInc
        dw      24                                      ; rm_xAveCharWidth
        dw      26                                      ; rm_yMaxBaselineExt
        .errnz  (($-vzPro26) ne (size RESMAP))

; ------------------
; MINCHO System 6x14
; ------------------
vh06x14:dw      ph06x14                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((6-1)/8)+1                             ; bd_cbScan
        db      14                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      6                                       ; bd_cx
        db      14                                      ; bd_cy
        dw      VRESID_MINSYS_06x14                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      6                                       ; rm_xMaxCharInc
        dw      6                                       ; rm_xAveCharWidth
        dw      14                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh06x14) ne (size RESMAP))

vz12x14:dw      wpz12x12                                ; rm_npFont     ;@NI1
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((12-1)/8)+1                            ; bd_cbScan
        db      14                                      ; bd_nScans
        db      0                                       ; bd_x
        db      1                                       ; bd_y
        db      12                                      ; bd_cx
        db      12                                      ; bd_cy
        dw      VRESID_MINSYS_12x14                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      12                                      ; rm_xMaxCharInc
        dw      12                                      ; rm_xAveCharWidth
        dw      14                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz12x14) ne (size RESMAP))

; ------------------
; MINCHO System 7x16
; ------------------
vh07x16:dw      ph07x16                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((7-1)/8)+1                             ; bd_cbScan
        db      16                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      7                                       ; bd_cx
        db      16                                      ; bd_cy
        dw      VRESID_MINSYS_07x16                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      7                                       ; rm_xMaxCharInc
        dw      7                                       ; rm_xAveCharWidth
        dw      16                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh07x16) ne (size RESMAP))

vz14x16:dw      wpz12x12                                ; rm_npFont     ;@NI1
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((14-1)/8)+1                            ; bd_cbScan
        db      16                                      ; bd_nScans
        db      1                                       ; bd_x
        db      2                                       ; bd_y
        db      12                                      ; bd_cx
        db      12                                      ; bd_cy
        dw      VRESID_MINSYS_14x16                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      14                                      ; rm_xMaxCharInc
        dw      14                                      ; rm_xAveCharWidth
        dw      16                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz14x16) ne (size RESMAP))

; ------------------
; MINCHO System 8x18
; ------------------
vh08x18:dw      ph08x18                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((8-1)/8)+1                             ; bd_cbScan
        db      18                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      8                                       ; bd_cx
        db      18                                      ; bd_cy
        dw      VRESID_MINSYS_08x18                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      8                                       ; rm_xMaxCharInc
        dw      8                                       ; rm_xAveCharWidth
        dw      18                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh08x18) ne (size RESMAP))

vz16x18:dw      bpz16x18                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((16-1)/8)+1                            ; bd_cbScan
        db      18                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      16                                      ; bd_cx
        db      18                                      ; bd_cy
        dw      VRESID_MINSYS_16x18                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      16                                      ; rm_xMaxCharInc
        dw      16                                      ; rm_xAveCharWidth
        dw      18                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz16x18) ne (size RESMAP))

; ------------------
; MINCHO System 9x20
; ------------------
vh09x20:dw      ph09x20                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((9-1)/8)+1                             ; bd_cbScan
        db      20                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      9                                       ; bd_cx
        db      20                                      ; bd_cy
        dw      VRESID_MINSYS_09x20                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      9                                       ; rm_xMaxCharInc
        dw      9                                       ; rm_xAveCharWidth
        dw      20                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh09x20) ne (size RESMAP))

vz18x20:dw      bpz16x18                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((18-1)/8)+1                            ; bd_cbScan
        db      20                                      ; bd_nScans
        db      1                                       ; bd_x
        db      1                                       ; bd_y
        db      16                                      ; bd_cx
        db      18                                      ; bd_cy
        dw      VRESID_MINSYS_18x20                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      18                                      ; rm_xMaxCharInc
        dw      18                                      ; rm_xAveCharWidth
        dw      20                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz18x20) ne (size RESMAP))

; -------------------
; MINCHO System 11x24
; -------------------
vh11x24:dw      ph11x24                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((11-1)/8)+1                            ; bd_cbScan
        db      24                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      11                                      ; bd_cx
        db      24                                      ; bd_cy
        dw      VRESID_MINSYS_11x24                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      11                                      ; rm_xMaxCharInc
        dw      11                                      ; rm_xAveCharWidth
        dw      24                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh11x24) ne (size RESMAP))

vz22x24:dw      wpz20x20                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((22-1)/8)+1                            ; bd_cbScan
        db      24                                      ; bd_nScans
        db      1                                       ; bd_x
        db      2                                       ; bd_y
        db      20                                      ; bd_cx
        db      20                                      ; bd_cy
        dw      VRESID_MINSYS_22x24                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      22                                      ; rm_xMaxCharInc
        dw      22                                      ; rm_xAveCharWidth
        dw      24                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz22x24) ne (size RESMAP))

; -------------------
; MINCHO System 13x28
; -------------------
vh13x28:dw      ph13x28                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((13-1)/8)+1                            ; bd_cbScan
        db      28                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      13                                      ; bd_cx
        db      28                                      ; bd_cy
        dw      VRESID_MINSYS_13x28                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      13                                      ; rm_xMaxCharInc
        dw      13                                      ; rm_xAveCharWidth
        dw      28                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh13x28) ne (size RESMAP))

vz26x28:dw      bpz26x28                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((26-1)/8)+1                            ; bd_cbScan
        db      28                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      26                                      ; bd_cx
        db      28                                      ; bd_cy
        dw      VRESID_MINSYS_26x28                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      26                                      ; rm_xMaxCharInc
        dw      26                                      ; rm_xAveCharWidth
        dw      28                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz26x28) ne (size RESMAP))

if      0                                                               ;@KY1
; -----------
; MINCHO 6x12
; -----------
vh06x12:dw      ph06x12                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((6-1)/8)+1                             ; bd_cbScan
        db      12                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      6                                       ; bd_cx
        db      12                                      ; bd_cy
        dw      VRESID_MINCHO_06x12                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      6                                       ; rm_xMaxCharInc
        dw      6                                       ; rm_xAveCharWidth
        dw      12                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh06x12) ne (size RESMAP))

vz12x12:dw      wpz12x12                                ; rm_npFont      ;@NI1
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((12-1)/8)+1                            ; bd_cbScan
        db      12                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      12                                      ; bd_cx
        db      12                                      ; bd_cy
        dw      VRESID_MINCHO_12x12                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      12                                      ; rm_xMaxCharInc
        dw      12                                      ; rm_xAveCharWidth
        dw      12                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz12x12) ne (size RESMAP))

; -----------
; MINCHO 7x14
; -----------
vh07x14:dw      ph07x14                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((7-1)/8)+1                             ; bd_cbScan
        db      14                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      7                                       ; bd_cx
        db      14                                      ; bd_cy
        dw      VRESID_MINCHO_07x14                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      7                                       ; rm_xMaxCharInc
        dw      7                                       ; rm_xAveCharWidth
        dw      14                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh07x14) ne (size RESMAP))

vz14x14:dw      wpz12x12                                ; rm_npFont     ;@NI1
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((14-1)/8)+1                            ; bd_cbScan
        db      14                                      ; bd_nScans
        db      1                                       ; bd_x
        db      1                                       ; bd_y
        db      12                                      ; bd_cx
        db      12                                      ; bd_cy
        dw      VRESID_MINCHO_14x14                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      14                                      ; rm_xMaxCharInc
        dw      14                                      ; rm_xAveCharWidth
        dw      14                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz14x14) ne (size RESMAP))

; -----------
; MINCHO 8x16
; -----------
vh08x16:dw      ph08x16                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((8-1)/8)+1                             ; bd_cbScan
        db      16                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      8                                       ; bd_cx
        db      16                                      ; bd_cy
        dw      VRESID_MINCHO_08x16                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      8                                       ; rm_xMaxCharInc
        dw      8                                       ; rm_xAveCharWidth
        dw      16                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh08x16) ne (size RESMAP))

vz16x16:dw      bpz16x16                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((16-1)/8)+1                            ; bd_cbScan
        db      16                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      16                                      ; bd_cx
        db      16                                      ; bd_cy
        dw      VRESID_MINCHO_16x16                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      16                                      ; rm_xMaxCharInc
        dw      16                                      ; rm_xAveCharWidth
        dw      16                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz16x16) ne (size RESMAP))

; -----------
; MINCHO 9x18
; -----------
vh09x18:dw      ph09x18                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((9-1)/8)+1                             ; bd_cbScan
        db      18                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      9                                       ; bd_cx
        db      18                                      ; bd_cy
        dw      VRESID_MINCHO_09x18                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      9                                       ; rm_xMaxCharInc
        dw      9                                       ; rm_xAveCharWidth
        dw      18                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh09x18) ne (size RESMAP))

vz18x18:dw      bpz16x18                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((18-1)/8)+1                            ; bd_cbScan
        db      18                                      ; bd_nScans
        db      1                                       ; bd_x
        db      0                                       ; bd_y
        db      16                                      ; bd_cx
        db      18                                      ; bd_cy
        dw      VRESID_MINCHO_18x18                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      18                                      ; rm_xMaxCharInc
        dw      18                                      ; rm_xAveCharWidth
        dw      18                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz18x18) ne (size RESMAP))

; ------------
; MINCHO 10x20
; ------------
vh10x20:dw      ph10x20                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((10-1)/8)+1                            ; bd_cbScan
        db      20                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      10                                      ; bd_cx
        db      20                                      ; bd_cy
        dw      VRESID_MINCHO_10x20                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      10                                      ; rm_xMaxCharInc
        dw      10                                      ; rm_xAveCharWidth
        dw      20                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh10x20) ne (size RESMAP))

vz20x20:dw      wpz20x20                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((20-1)/8)+1                            ; bd_cbScan
        db      20                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      20                                      ; bd_cx
        db      20                                      ; bd_cy
        dw      VRESID_MINCHO_20x20                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      20                                      ; rm_xMaxCharInc
        dw      20                                      ; rm_xAveCharWidth
        dw      20                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz20x20) ne (size RESMAP))

; ------------
; MINCHO 12x24
; ------------
vh12x24:dw      ph12x24                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((12-1)/8)+1                            ; bd_cbScan
        db      24                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      12                                      ; bd_cx
        db      24                                      ; bd_cy
        dw      VRESID_MINCHO_12x24                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      12                                      ; rm_xMaxCharInc
        dw      12                                      ; rm_xAveCharWidth
        dw      24                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh12x24) ne (size RESMAP))

vz24x24:dw      bpz24x24                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((24-1)/8)+1                            ; bd_cbScan
        db      24                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      24                                      ; bd_cx
        db      24                                      ; bd_cy
        dw      VRESID_MINCHO_24x24                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      24                                      ; rm_xMaxCharInc
        dw      24                                      ; rm_xAveCharWidth
        dw      24                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz24x24) ne (size RESMAP))
endif                                                                   ;@KY1

; --------------------
; MINCHO Terminal 8x12
; --------------------
vh08x12:dw      ph08x16                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((8-1)/8)+1                             ; bd_cbScan
        db      12                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      8                                       ; bd_cx
        db      12                                      ; bd_cy
        dw      VRESID_MINTRM_08x12                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      8                                       ; rm_xMaxCharInc
        dw      8                                       ; rm_xAveCharWidth
        dw      12                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh08x12) ne (size RESMAP))

vz16x12:dw      bpz16x16                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((16-1)/8)+1                            ; bd_cbScan
        db      12                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      16                                      ; bd_cx
        db      12                                      ; bd_cy
        dw      VRESID_MINTRM_16x12                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      16                                      ; rm_xMaxCharInc
        dw      16                                      ; rm_xAveCharWidth
        dw      12                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz16x12) ne (size RESMAP))

; --------------------
; MINCHO Terminal 8x14
; --------------------
vh08x14:dw      ph08x16                                 ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((8-1)/8)+1                             ; bd_cbScan
        db      14                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      8                                       ; bd_cx
        db      14                                      ; bd_cy
        dw      VRESID_MINTRM_08x14                     ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      8                                       ; rm_xMaxCharInc
        dw      8                                       ; rm_xAveCharWidth
        dw      14                                      ; rm_yMaxBaselineExt
        .errnz  (($-vh08x14) ne (size RESMAP))

vz16x14:dw      bpz16x16                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((16-1)/8)+1                            ; bd_cbScan
        db      14                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      16                                      ; bd_cx
        db      14                                      ; bd_cy
        dw      VRESID_MINTRM_16x14                     ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      16                                      ; rm_xMaxCharInc
        dw      16                                      ; rm_xAveCharWidth
        dw      14                                      ; rm_yMaxBaselineExt
        .errnz  (($-vz16x14) ne (size RESMAP))

;-----------------------------------------------------------------------;
; Physical font resource descriptors
;-----------------------------------------------------------------------;
presmap:

; ----------------------
; PM SBCS Resource Fonts
; ----------------------
phPro18:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rfPro18                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((8-1)/8)+1                             ; bd_cbScan
        db      18                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      8                                       ; bd_cx
        db      18                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      0                                       ; rm_fsTypeFlags
        dw      17                                      ; rm_xMaxCharInc
        dw      8                                       ; rm_xAveCharWidth
        dw      18                                      ; rm_yMaxBaselineExt
        .errnz  (($-phPro18) ne (size RESMAP))

phPro24:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rfPro24                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((11-1)/8)+1                            ; bd_cbScan
        db      24                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      11                                      ; bd_cx
        db      24                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      0                                       ; rm_fsTypeFlags
        dw      20                                      ; rm_xMaxCharInc
        dw      11                                      ; rm_xAveCharWidth
        dw      24                                      ; rm_yMaxBaselineExt
        .errnz  (($-phPro24) ne (size RESMAP))

phPro26:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rfPro26                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((12-1)/8)+1                            ; bd_cbScan
        db      26                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      12                                      ; bd_cx
        db      26                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      0                                       ; rm_fsTypeFlags
        dw      23                                      ; rm_xMaxCharInc
        dw      12                                      ; rm_xAveCharWidth
        dw      26                                      ; rm_yMaxBaselineExt
        .errnz  (($-phPro26) ne (size RESMAP))

ph06x12:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf07x16                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((7-1)/8)+1                             ; bd_cbScan
        db      16                                      ; bd_nScans
        db      1                                       ; bd_x
        db      2                                       ; bd_y
        db      6                                       ; bd_cx
        db      12                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      6                                       ; rm_xMaxCharInc
        dw      6                                       ; rm_xAveCharWidth
        dw      12                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph06x12) ne (size RESMAP))

ph06x14:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf07x16                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((7-1)/8)+1                             ; bd_cbScan
        db      16                                      ; bd_nScans
        db      1                                       ; bd_x
        db      1                                       ; bd_y
        db      6                                       ; bd_cx
        db      14                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      6                                       ; rm_xMaxCharInc
        dw      6                                       ; rm_xAveCharWidth
        dw      14                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph06x14) ne (size RESMAP))

ph07x14:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf07x16                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((7-1)/8)+1                             ; bd_cbScan
        db      16                                      ; bd_nScans
        db      0                                       ; bd_x
        db      1                                       ; bd_y
        db      7                                       ; bd_cx
        db      14                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      7                                       ; rm_xMaxCharInc
        dw      7                                       ; rm_xAveCharWidth
        dw      14                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph07x14) ne (size RESMAP))

ph07x16:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf07x16                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((7-1)/8)+1                             ; bd_cbScan
        db      16                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      7                                       ; bd_cx
        db      16                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      7                                       ; rm_xMaxCharInc
        dw      7                                       ; rm_xAveCharWidth
        dw      16                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph07x16) ne (size RESMAP))

ph08x16:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf09x20                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((9-1)/8)+1                             ; bd_cbScan
        db      20                                      ; bd_nScans
        db      1                                       ; bd_x
        db      2                                       ; bd_y
        db      8                                       ; bd_cx
        db      16                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      8                                       ; rm_xMaxCharInc
        dw      8                                       ; rm_xAveCharWidth
        dw      16                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph08x16) ne (size RESMAP))

ph08x18:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf09x20                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((9-1)/8)+1                             ; bd_cbScan
        db      20                                      ; bd_nScans
        db      1                                       ; bd_x
        db      1                                       ; bd_y
        db      8                                       ; bd_cx
        db      18                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      8                                       ; rm_xMaxCharInc
        dw      8                                       ; rm_xAveCharWidth
        dw      18                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph08x18) ne (size RESMAP))

ph09x18:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf09x20                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((9-1)/8)+1                             ; bd_cbScan
        db      20                                      ; bd_nScans
        db      0                                       ; bd_x
        db      1                                       ; bd_y
        db      9                                       ; bd_cx
        db      18                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      9                                       ; rm_xMaxCharInc
        dw      9                                       ; rm_xAveCharWidth
        dw      18                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph09x18) ne (size RESMAP))

ph09x20:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf09x20                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((9-1)/8)+1                             ; bd_cbScan
        db      20                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      9                                       ; bd_cx
        db      20                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      9                                       ; rm_xMaxCharInc
        dw      9                                       ; rm_xAveCharWidth
        dw      20                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph09x20) ne (size RESMAP))

ph10x20:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf11x24                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((11-1)/8)+1                            ; bd_cbScan
        db      24                                      ; bd_nScans
        db      1                                       ; bd_x
        db      2                                       ; bd_y
        db      10                                      ; bd_cx
        db      20                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      10                                      ; rm_xMaxCharInc
        dw      10                                      ; rm_xAveCharWidth
        dw      20                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph10x20) ne (size RESMAP))

ph11x24:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf11x24                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((11-1)/8)+1                            ; bd_cbScan
        db      24                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      11                                      ; bd_cx
        db      24                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      11                                      ; rm_xMaxCharInc
        dw      11                                      ; rm_xAveCharWidth
        dw      24                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph11x24) ne (size RESMAP))

ph12x24:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf13x28                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((13-1)/8)+1                            ; bd_cbScan
        db      28                                      ; bd_nScans
        db      1                                       ; bd_x
        db      2                                       ; bd_y
        db      12                                      ; bd_cx
        db      24                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      12                                      ; rm_xMaxCharInc
        dw      12                                      ; rm_xAveCharWidth
        dw      24                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph12x24) ne (size RESMAP))

ph13x28:dw      INVALID_ADDRESS                         ; rm_npFont
        dw      rf13x28                                 ; rm_npPrivate
        dw      FONT_PM_SBCS_RESOURCE                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((13-1)/8)+1                            ; bd_cbScan
        db      28                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      13                                      ; bd_cx
        db      28                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED                           ; rm_fsTypeFlags
        dw      13                                      ; rm_xMaxCharInc
        dw      13                                      ; rm_xAveCharWidth
        dw      28                                      ; rm_yMaxBaselineExt
        .errnz  (($-ph13x28) ne (size RESMAP))

; ----------------------
; CP DBCS FNTCALLS Fonts
; ----------------------
bpz16x16:dw     INVALID_ADDRESS                         ; rm_npFont
        dw      bf16x16                                 ; rm_npPrivate
        dw      FONT_CP_MBCS_BASEFONT                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((16-1)/8)+1                            ; bd_cbScan
        db      16                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      16                                      ; bd_cx
        db      16                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      16                                      ; rm_xMaxCharInc
        dw      16                                      ; rm_xAveCharWidth
        dw      16                                      ; rm_yMaxBaselineExt
        .errnz  (($-bpz16x16) ne (size RESMAP))

bpz16x18:dw     INVALID_ADDRESS                         ; rm_npFont
        dw      bf16x19                                 ; rm_npPrivate
        dw      FONT_CP_MBCS_BASEFONT                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((16-1)/8)+1                            ; bd_cbScan
        db      19                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      16                                      ; bd_cx
        db      18                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      16                                      ; rm_xMaxCharInc
        dw      16                                      ; rm_xAveCharWidth
        dw      18                                      ; rm_yMaxBaselineExt
        .errnz  (($-bpz16x18) ne (size RESMAP))

bpz24x24:dw     INVALID_ADDRESS                         ; rm_npFont
        dw      bf24x24                                 ; rm_npPrivate
        dw      FONT_CP_MBCS_BASEFONT                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((32-1)/8)+1                            ; bd_cbScan
        db      24                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      24                                      ; bd_cx
        db      24                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      24                                      ; rm_xMaxCharInc
        dw      24                                      ; rm_xAveCharWidth
        dw      24                                      ; rm_yMaxBaselineExt
        .errnz  (($-bpz24x24) ne (size RESMAP))

bpz26x28:dw     INVALID_ADDRESS                         ; rm_npFont
        dw      bf26x30                                 ; rm_npPrivate
        dw      FONT_CP_MBCS_BASEFONT                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((32-1)/8)+1                            ; bd_cbScan
        db      30                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      26                                      ; bd_cx
        db      28                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      26                                      ; rm_xMaxCharInc
        dw      26                                      ; rm_xAveCharWidth
        dw      28                                      ; rm_yMaxBaselineExt
        .errnz  (($-bpz26x28) ne (size RESMAP))

; -----------------------
;         DBCS Wife Fonts
; -----------------------

wpz12x12:dw      dz12x12                                 ; rm_npFont      ;@NI1
        dw      wf12x12                                 ; rm_npPrivate
        dw      FONT_WIN_DBCS_FONTFILE                  ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((12-1)/8)+1                            ; bd_cbScan
        db      12                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      12                                      ; bd_cx
        db      12                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      12                                      ; rm_xMaxCharInc
        dw      12                                      ; rm_xAveCharWidth
        dw      12                                      ; rm_yMaxBaselineExt;@NI1
        .errnz  (($-wpz12x12) ne (size RESMAP))

wpz20x20:dw     upz20x20                                ; rm_npFont
        dw      wf20x20                                 ; rm_npPrivate
        dw      FONT_WIN_DBCS_FONTFILE                  ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((20-1)/8)+1                            ; bd_cbScan
        db      20                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      20                                      ; bd_cx
        db      20                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      20                                      ; rm_xMaxCharInc
        dw      20                                      ; rm_xAveCharWidth
        dw      20                                      ; rm_yMaxBaselineExt
        .errnz  (($-wpz20x20) ne (size RESMAP))
;-----------------------------------------------------------------------;
; User defined physical font resource descriptors
;-----------------------------------------------------------------------;
uresmap:

upz20x20:dw     bpz24x24                                ; rm_npFont
        dw      uf20x20                                 ; rm_npPrivate
        dw      FONT_PM_DBCS_USERFONT                   ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((32-1)/8)+1        ; buffer=(32w,20h)  ; bd_cbScan
        db      20                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      20                                      ; bd_cx
        db      20                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      20                                      ; rm_xMaxCharInc
        dw      20                                      ; rm_xAveCharWidth
        dw      20                                      ; rm_yMaxBaselineExt
        .errnz  (($-upz20x20) ne (size RESMAP))

;-----------------------------------------------------------------------;
; if WINDOW font file not found on 12 dot DBCS.                     ;@NI1
;-----------------------------------------------------------------------;
dz12x12:dw      bpz16x16                                ; rm_npFont
        dw      INVALID_ADDRESS                         ; rm_npPrivate
        dw      FONT_FD_VIRTUAL_FONT                    ; rm_fontId
        dw      0                                       ; rm_refCount
        dw      INVALID_ADDRESS                         ; bd_npBits
        db      ((12-1)/8)+1                            ; bd_cbScan
        db      12                                      ; bd_nScans
        db      0                                       ; bd_x
        db      0                                       ; bd_y
        db      12                                      ; bd_cx
        db      12                                      ; bd_cy
        dw      UNDEFINED_VALUE                         ; rm_resId
        dw      FM_TYPE_FIXED+FM_TYPE_DBCS              ; rm_fsTypeFlags
        dw      12                                      ; rm_xMaxCharInc
        dw      12                                      ; rm_xAveCharWidth
        dw      12                                      ; rm_yMaxBaselineExt
        .errnz  (($-dz12x12) ne (size RESMAP))
;-----------------------------------------------------------------------;
; Physical font private data.
;-----------------------------------------------------------------------;
private:

rfPro18:dw      RT_PFONT                                ; rf_resType
        dw      PRESID_MINPRO_08x18                     ; rf_resId
        dd      INVALID_ADDRESS                         ; rf_lpFoca
        db      0                                       ; rf_szModule

rfPro24:dw      RT_PFONT                                ; rf_resType
        dw      PRESID_MINPRO_11x24                     ; rf_resId
        dd      INVALID_ADDRESS                         ; rf_lpFoca
        db      0                                       ; rf_szModule

rfPro26:dw      RT_PFONT                                ; rf_resType
        dw      PRESID_MINPRO_12x26                     ; rf_resId
        dd      INVALID_ADDRESS                         ; rf_lpFoca
        db      0                                       ; rf_szModule

rf07x16:dw      RT_PFONT                                ; rf_resType
        dw      PRESID_MINSYS_07x16                     ; rf_resId
        dd      INVALID_ADDRESS                         ; rf_lpFoca
        db      0                                       ; rf_szModule

rf09x20:dw      RT_PFONT                                ; rf_resType
        dw      PRESID_MINSYS_09x20                     ; rf_resId
        dd      INVALID_ADDRESS                         ; rf_lpFoca
        db      0                                       ; rf_szModule

rf11x24:dw      RT_PFONT                                ; rf_resType
        dw      PRESID_MINSYS_11x24                     ; rf_resId
        dd      INVALID_ADDRESS                         ; rf_lpFoca
        db      0                                       ; rf_szModule

rf13x28:dw      RT_PFONT                                ; rf_resType
        dw      PRESID_MINSYS_13x28                     ; rf_resId
        dd      INVALID_ADDRESS                         ; rf_lpFoca
        db      0                                       ; rf_szModule

bf16x16:dw      BF_OPTION_PACKED    ; buffer=(16w,16h)  ; bf_option
        dw      size FNTBLOCK,0,0,0                     ; fb_cbFix,fb_*
        dw      BF_ID_STANDARD_DBCS                     ; fb_fontId
        dw      16,16                                   ; fb_width,fb_height

bf16x19:dw      BF_OPTION_FULLBOX   ; buffer=(16w,19h)  ; bf_option
        dw      size FNTBLOCK,0,0,0                     ; fb_cbFix,fb_*
        dw      BF_ID_STANDARD_DBCS                     ; fb_fontId
        dw      16,16                                   ; fb_width,fb_height

bf24x24:dw      BF_OPTION_PACKED    ; buffer=(32w,24h)  ; bf_option
        dw      size FNTBLOCK,0,0,0                     ; fb_cbFix,fb_*
        dw      BF_ID_STANDARD_DBCS                     ; fb_fontId
        dw      24,24                                   ; fb_width,fb_height

bf26x30:dw      BF_OPTION_FULLBOX   ; buffer=(32w,30h)  ; bf_option
        dw      size FNTBLOCK,0,0,0                     ; fb_cbFix,fb_*
        dw      BF_ID_STANDARD_DBCS                     ; fb_fontId
        dw      24,24                                   ; fb_width,fb_height

wf12x12:dw      INVALID_ADDRESS                         ; ff_npEncode ;@NI1
        dw      INVALID_ADDRESS                         ; ff_npCache
        dw      512                                     ; ff_cbCache
        dw      0                                       ; ff_cbValid
        dd      0                                       ; ff_ulOffset
        db      '?:\OS2\SYSDATA\PS55DG12.JFD',0         ; ff_szFile   ;@NI1

wf20x20:dw      INVALID_ADDRESS                         ; ff_npEncode
        dw      INVALID_ADDRESS                         ; ff_npCache
        dw      512                                     ; ff_cbCache
        dw      0                                       ; ff_cbValid
        dd      0                                       ; ff_ulOffset
        db      '?:\OS2\SYSDATA\PS55DM20.JFD',0         ; ff_szFile

uf20x20:db      '?:\OS2\SYSDATA\$USERM20.FNT',0         ; uf_szFile

;-----------------------------------------------------------------------;
; End of font resource descriptor
;-----------------------------------------------------------------------;
resmap_end:
RESMAPSEG ends

end
