;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = SEAMLESS.INC
;*
;* DESCRIPTIVE NAME = Seamless         defines
;*
;*
;* VERSION      V2.0
;*
;* DATE         10/4/91
;*
;* DESCRIPTION  Seamless         defines
;*
;* FUNCTIONS
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*****************************************************************************/

;/*
;** This structure is copied from VMD.INC because I could not include VMD.INC
;** because of redefinitions.
;*/

VMSSIZE         struct   ;vmss
        vmss_nb             dd 36  ;size of structure, in bytes (36)
        vmss_lMode          dd ?   ;video mode (eg, 00h-13h, or -1)
        vmss_ulWidth        dd ?   ;width of screen, in pixels
        vmss_ulHeight       dd ?   ;height of screen, in pixels
        vmss_ulCellWidth    dd ?   ;width of screen cells, in pixels
        vmss_ulCellHeight   dd ?   ;height of screen cells, in pixels
        vmss_ulPtrWidth     dd ?   ;width of pointer drawing size, in pixels
        vmss_ulPtrHeight    dd ?   ;height of pointer drawing size, in pixels
        vmss_ulPtrUnitWidth dd ?   ;width of pointer drawing unit, in pixels
VMSSIZE         ends

SEAMLESS_TIMEOUT        equ 10000 ;Timeout value for the semaphore when we
                                  ;are running seamless

VWIN_INIT               equ 0c0h ; Send the semDriver address to VWIN
VWIN_SIGHEARTBEAT       equ 0c1h ; Send VWIN notification that we timed out
VWIN_SIGVDMDIRTY        equ 0c2h ; Start/stop VDM drawing
VWIN_SETSIZE            equ 0c4h ; Set the mode size info for VMOUSE
VDM_SUSPEND_DRAW        equ 4001h ;to stop drawing
VDM_RESUME_DRAW         equ 4002h ;to continue drawing
SEAMLESS_ACTIVE         equ 00000001b   ;Bit set if seamless is setup

SM_RING0                EQU     0
SM_RING1                EQU     1
SM_RING2                EQU     2
SM_RING3                EQU     3

SM_DATA_ADDRESS         EQU     0
SM_CODE_ADDRESS         EQU     00000100B

SM_ADDRESS_16BIT        EQU     0
SM_ADDRESS_32BIT        EQU     00001000B

SM_MAPPING              EQU     0
SM_PASSTHRU             EQU     00010000B

SM_MATCH_LINEAR         EQU     00100000B

_SM_PMDISP_ADDRESSES    struc   ;spa
flOptions       dd      ?       ; BIT1, BIT0 = xx ring level if BIT3=1
                                ; BIT2=0 for DATA,    BIT2=1 for CODE
                                ; BIT3=0 for 16:16,   BIT3=1 for 0:32
                                ; BIT4=0 for mapping, BIT4=1 for passthru
                                ;             (only one passthru allowed)
                                ; BIT5 - BIT31 reserved (must be 0)
ulLength        dd      ?       ; Length of the data in bytes
pStart          dd      ?       ; 
_SM_PMDISP_ADDRESSES    ends

_SM_WINDRV      struct
;       .err            ; 256color without palette manager not supported.
    signature             db  "VG01" ; string to synchronize interface to VDM
    exclude               dd  ?      ; pointer to cursor far_exclude() function
    unexclude             dd  ?      ; pointer to cursor far_unexclude() function
    init_hw_regs_addr     dd  ?      ; pointer to init_hw_regs() function
    hwsemOff              dw  ?      ; offset of hardware semaphore structure
    wHeartbeatOff         dw  ?      ; offset of VDM heartbeat
    PtrDataSeg            dw  ?      ; segment of PtrData segment
    fbControllerOwnedOff  dw  ?      ; offset of fControllerOwned byte flag
    fbControllerNotifyOff dw  ?      ; offset of fControllerNotify byte flag
    fbShadowFlagsOff      dw  ?      ; offset of fbShadowFlags byte flag
    fbControllerMineOff   dw  ?      ; offset of fVDMControllerMine
    fbShadowedGrafModeOff dw  ?      ; offset of shadowed_graf_mode
    wBankReg              dw  ?      ; this chips bank select register
    bfPaletteIsFixed      db  ?      ; boolean indicating PM Driver is fixed palette
    ulLastPalUpdate       dd  ?      ; time stamp of last palette update
    pHWPalette            dd  ?      ; 16:16 ptr to copy of PM driver HWPalette
ifdef  IBMJ        ;IBMJ
    pmdd_screen_busy      dd  ?      ; 16:16 ptr of screen_busy.
ifdef  JTUNE        ;IBMJ
    pmdd_swFlags          dd  ?      ; 16:16 ptr of SW flags.
    pmdd_2ndsel           dw  ?      ; 2nd selector (shadowed B0000H -)
endif ;JTUNE        ;IBMJ
endif ;IBMJ        ;IBMJ

_SM_WINDRV      ends


BLACK   =       0
RED     =       1
GREEN   =       2
YELLOW  =       3
BLUE    =       4
MAGENTA =       5
CYAN    =       6
WHITE   =       7

;/*
;**-----------------------------Macro-------------------------------------------;
;** color_puts
;**
;** If FIREWALLS is nonzero, outputs a string to the debugging output screen
;** using the two colors specified.
;**
;** Entry:
;**       Foreground = foreground color
;**       Background = background color
;**       String   = string to output
;**
;** Example:
;**       puts    BLUE,BLACK,<*** StretchBlt: creating shadow bitmap>
;**
;** Registers Preserved:
;**       all
;**
;** Registers Destroyed:
;**       none
;**
;*/

color_puts    macro   foreground,background,string
        local   message

ifdef FIREWALLS
        Debug32Output PROTO SYSCALL, pszMsg:DWORD

_DATA SEGMENT
        message db      27,"[3",foreground+48,";4",background+48,";1m","&string",27,"[0m",13,10,0
_DATA ENDS

        push    eax
        push    ebx
        push    ecx
        push    edx
        INVOKE  Debug32Output,ADDR message
        pop     edx
        pop     ecx
        pop     ebx
        pop     eax
endif   ;FIREWALLS
        endm

