;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = PROTOS.INC
;*
;* DESCRIPTIVE NAME = Function prototypes
;*
;*
;* VERSION      V2.0
;*
;* DATE         09/22/91
;*
;* DESCRIPTION   Function prototypes
;*
;* FUNCTIONS
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   10/22/91                     Written by Scott Lawson
;*   11/26/92                     John Batty. Added DCAF changes.
;*   11/17/93  Changeteam  75466  Added debug data routine.
;*
;*****************************************************************************/

IFNDEF PROTOS_DEFD      ; Don't include if already included

PROTOS_DEFD EQU 1       ; Indicate it has been included

WASWORD TYPEDEF DWORD

;/*
;**   External Protos
;*/


move_pointers PROTO SYSCALL,
                pBitsAndXor:DWORD,
                pBitsColor :DWORD,
                fwFlags    :DWORD


WinVisRegionNotify              PROTO SYSCALL,
        ignore:DWORD

@enum_dispatch                   TYPEDEF PROTO SYSCALL,
        pfn:DWORD,
        flags:DWORD

@deselect_lct                    TYPEDEF PROTO ; COLORTBL.ASM

@device_specific_init             TYPEDEF  PROTO SYSCALL

@device_specific_post_init      TYPEDEF  PROTO SYSCALL

far_alloc_far_mem               PROTO SYSCALL

far_calc_rgb_distance           PROTO SYSCALL

far_check_bitmap_info           PROTO SYSCALL

far_clip_line                   PROTO SYSCALL

far_convert_space_screen        PROTO SYSCALL,
        ppt            :DWORD,
        cpt            :WASWORD

far_correlate_for_point_si      PROTO SYSCALL

far_deselect_bitmap             PROTO SYSCALL

far_do_corr                     PROTO SYSCALL,
        hd             :DWORD,
        prclToCor      :DWORD,
        hdd            :DWORD

@far_exclude                    TYPEDEF  PROTO SYSCALL

far_free_far_mem                PROTO SYSCALL

far_global_alloc                PROTO SYSCALL

far_global_free                 PROTO SYSCALL

far_ipc_to_index                PROTO SYSCALL

far_MakeColorsValid             PROTO SYSCALL

far_private_alloc               PROTO SYSCALL

far_private_free                PROTO SYSCALL

far_PropagateSysClrChange       PROTO SYSCALL

@far_unexclude                  TYPEDEF  PROTO SYSCALL

far_physical_enable             PROTO SYSCALL,
        l              :LONG,
        Pointer        :PVOID

Get32PmddCodeSelector             PROTO SYSCALL,
        pselCompileData:PTR WORD

ifdef PGSSP
Get32ScreenSelector               PROTO SYSCALL,
        gssspScreen    :PGSSP
endif

GetHeap                         PROTO SYSCALL

PolyMarker                      PROTO SYSCALL,
        hd             :DWORD,
        lpPolyX        :DWORD,
        Poly           :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

@PolyShortLine                     TYPEDEF PROTO SYSCALL,
        hdc:DWORD, psl:DWORD,
        hddc:DWORD, FunN:DWORD

Vis32RegionCallBack               PROTO SYSCALL,
        myhdc          :DWORD

;/*
;** Local Protos
;*/

AccumBoundsInDevCoords          PROTO SYSCALL

AccumulateBounds                PROTO SYSCALL,
        hdc            :DWORD,
        lpRect         :DWORD,
        hddc           :DWORD,
        FunN           :DWORD


alloc_bm                        PROTO SYSCALL

alloc_ddc                       PROTO SYSCALL


alloc_uncomp_buffer             PROTO SYSCALL

AllocMem                        PROTO SYSCALL


@bmc_int_to_ext TYPEDEF PROTO SYSCALL,
                pbmp:DWORD,           ; Bitmap
                lpInitInfo:DWORD,     ; -> Pointer to info block
                lpBits:DWORD,         ; -> buffer of source bits
                cScans:DWORD,         ; Number of scans to copy
                lFirstScan:DWORD,     ; First scan to copy
                pClrTbl:DWORD         ; Used by some drivers, but not EGA


@bmc_ext_to_int TYPEDEF PROTO SYSCALL,
                pbmp:DWORD,                   ; Bitmap
                lpInitInfo:DWORD,             ; -> Pointer to info block
                lpBits:DWORD,                 ; -> buffer of source bits
                cScans:DWORD,                 ; Number of scans to copy
                ulFirstScan:DWORD,            ; First scan to copy
                pdc:DWORD

Bitblt                          PROTO SYSCALL,
        hd             :DWORD,
        hdcSr          :DWORD,
        Coun           :DWORD,
        lpBitBltPar    :DWORD,
        Mi             :DWORD,
        Styl           :DWORD,
        lpAttr         :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

build_string                    PROTO SYSCALL,
        lp_DDC        :DWORD,
        lp_DestDev    :DWORD,
        x             :DWORD,
        y             :DWORD,
        lp_clip_rect  :DWORD,
        lp_string     :DWORD,
        count         :DWORD,
        npAttrs       :DWORD,
        lp_dx         :DWORD,
        lp_opaque_rect:DWORD,
        eto_options   :DWORD

calc_rgb_distance               PROTO SYSCALL

CharGenericPos                  PROTO SYSCALL,
        hdc             :DWORD,
        lpXY            :DWORD,
        lpRect          :DWORD,
        Options         :DWORD,
        N               :DWORD,
        lpCh            :DWORD,
        lpDx            :DWORD,
        lpAttrs         :DWORD,
        hddc            :DWORD,
        FunN            :DWORD

CharMarkerPos                   PROTO SYSCALL,
        hdc            :DWORD,
        lpXY           :DWORD,
        lpRect         :DWORD,
        ulOptions      :DWORD,
        N              :DWORD,
        lpCc           :DWORD,
        lpDx           :DWORD,
        lpAttrs        :DWORD,
        hddc           :DWORD,
        FunN           :DWORD

IFDEF DINCL_VIOPS

@CharRect                        TYPEDEF PROTO SYSCALL,
        hdc            :HDC,
        lpPS           :DWORD,           ; pVioPresentationSpace,
        lpRectDesc     :DWORD,
        hddc           :DWORD,
        FunN           :DWORD
ELSE
@CharRect                        TYPEDEF PROTO SYSCALL,
        hdc            :HDC,
        lpPS           :PVOID,
        lpRectDesc     :DWORD,
        hddc           :DWORD,
        FunN           :DWORD

ENDIF ; DINCL_VIOPS

@CharStr                         TYPEDEF PROTO SYSCALL,
        hdc            :DWORD,
        lpPS           :DWORD,
        lpStrDesc      :DWORD,
        hddc           :DWORD,
        FunN           :DWORD

CharString                      PROTO SYSCALL,
        hd             :DWORD,
                       :DWORD,
        lpChar         :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

CharStringPos                   PROTO SYSCALL,
        hdc            :DWORD,
        lpXY           :DWORD,
        lpRect         :DWORD,
        ulOptions      :DWORD,
        N              :DWORD,
        lpCc           :DWORD,
        lpDx           :DWORD,
        lpAttrs        :DWORD,
        hddc           :DWORD,
        FunN           :DWORD

check_bitmap_info               PROTO SYSCALL

check_sem                       PROTO SYSCALL

clip_line                       PROTO SYSCALL

ColorConvert                    PROTO SYSCALL

compute_bounds                  PROTO SYSCALL

ComputeShortlineBounds          PROTO SYSCALL,
        ps             :DWORD

ComputeSubSpace                 PROTO SYSCALL

ComputeSymmetry                 PROTO SYSCALL

convert_device_screen           PROTO SYSCALL,
        ppt            :DWORD,
        cpt            :WASWORD

convert_page_device             PROTO SYSCALL,
        ppt            :DWORD,
        cpt            :WASWORD

convert_rectl                   PROTO SYSCALL

convert_space_screen        PROTO SYSCALL,
        ppt            :DWORD,
        cpt            :WASWORD

convert_screen_screen           PROTO SYSCALL,
        ppt            :DWORD,
        cpt            :WASWORD

convert_screen_world            PROTO SYSCALL,
        lpPoint        :DWORD,
        wCoun          :WASWORD

convert_space_screen            PROTO SYSCALL,
        ppt            :DWORD,
        cpt            :WASWORD

convert_space_space             PROTO SYSCALL,
        ppt            :DWORD,
        cpt            :WASWORD

convert_world_screen            PROTO SYSCALL,
        ppt            :DWORD,
        cpt            :WASWORD

ConvertList32                   PROTO SYSCALL,
        lpSrcList      :DWORD,
        lpDstList      :DWORD,
        ddc            :WASWORD,
        Count          :WASWORD

@copy_bits_to_pattern           TYPEDEF  PROTO SYSCALL

correlate_for_point_si          PROTO SYSCALL

correlate_for_rect_si           PROTO SYSCALL

cProc                           PROTO SYSCALL

@CreateLogColorTable             TYPEDEF PROTO SYSCALL,
        hdc             :HDC,
        flOptions       :ULONG,
        lFormat         :LONG,
        lStart          :LONG,
        cCount          :LONG,
        pData           :PLONG,
        pInstance       :PVOID,
        lFunction       :ULONG

ifdef PDDC
@ResetLogColorTable TYPEDEF PROTO SYSCALL,
                pddc:PDDC
else
@ResetLogColorTable TYPEDEF PROTO SYSCALL,
                pddc:PVOID
endif

ddc_validate                    PROTO SYSCALL,
        pddc:DWORD,
        flFlags:DWORD

DDL_initialization              PROTO SYSCALL

Death                           PROTO SYSCALL,
        hd             :DWORD,
        hdd            :DWORD,
        Fun            :DWORD


deselect_bitmap                 PROTO SYSCALL

DeviceCreateBitmap              PROTO SYSCALL,
        hd             :DWORD,
        lpInfoHd       :DWORD,
        Usag           :DWORD,
        lpBit          :DWORD,
        lpInitInf      :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

DeviceDeleteBitmap              PROTO SYSCALL,
        hd             :DWORD,
        dhBitma        :DWORD,
        lpReturn       :DWORD,
        Usag           :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

DeviceGetAttributes             PROTO SYSCALL,
        hdc            :DWORD,
        BType          :DWORD,
        TheMask        :DWORD,
        lpAttrs        :DWORD,
        hddc           :DWORD,
        FunN           :DWORD

DeviceInvalidateVisRegion       PROTO SYSCALL,
        hd             :DWORD,
        Coun           :DWORD,
        lprghd         :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

DeviceQueryFontAttributes       PROTO SYSCALL,
        hd             :DWORD,
        iMetric        :DWORD,
        lpMetric       :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

DeviceQueryFonts                PROTO SYSCALL,
        hd             :DWORD,
        ulOption       :DWORD,
        lpFilte        :DWORD,
        lpMetric       :DWORD,
        iMetric        :DWORD,
        lpiFont        :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

DeviceSelectBitmap              PROTO SYSCALL,
        hd             :DWORD,
        Handl          :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

DeviceSetAttributes             PROTO SYSCALL,
        hdc            :DWORD,
        BType          :DWORD,
        DefsMask       :DWORD,
        AttrsMask      :DWORD,
        lpAttrs        :DWORD,
        hddc           :DWORD,
        FunN           :DWORD

@DeviceSetAVIOFont2              TYPEDEF PROTO SYSCALL,
        hdc            :DWORD,
        pFattr         :DWORD,
        FontDef        :DWORD,
        inxLCID        :DWORD,
        hDDC           :DWORD,
        inxFn          :DWORD

@DeviceSetCursor                 TYPEDEF PROTO SYSCALL,
        hdc            :HDC,
        pptHotspot     :PPOINTL,
        hbm            :ULONG,
        pInstance      :PVOID,
        lFunction      :ULONG

DeviceSetDCOrigin               PROTO SYSCALL,
        hd             :DWORD,
        lpX            :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

DeviceSetGlobalAttribute        PROTO SYSCALL,
        hdc            :DWORD,
        AttributeType  :DWORD,
        Attribute      :DWORD,
        Options        :DWORD,
        hddc           :DWORD,
        FunN           :DWORD

disable_ddc                     PROTO SYSCALL,
        subfunctio     :DWORD,
        hdd            :DWORD,
        u32_param      :DWORD

DisjointLines                   PROTO SYSCALL,
        hdc            :HDC,
        pptl           :PPOINTL,
        CPoints        :LONG,
        pInstance      :PVOID,
        lFunction      :ULONG

DisplayInit                     PROTO SYSCALL

dither_brush                    PROTO SYSCALL

DllLoadProc                     PROTO SYSCALL,
        hNULL          :DWORD,
        pdll           :DWORD

do_bitblt                       PROTO SYSCALL

do_corr                         PROTO SYSCALL,
        hd             :DWORD,
        prclToCor      :DWORD,
        hdd            :DWORD

do_drawbits                     PROTO SYSCALL

do_exttextout                   PROTO SYSCALL

ifndef IBMJ        ;IBMJ
@do_polylines                    TYPEDEF PROTO SYSCALL,
        fsPolyFlags    :DWORD,
        cLines         :DWORD,
        npaptl         :DWORD,
        usFunN         :WORD,
        fComFlags      :WORD
else  ;IBMJ        ;IBMJ
@do_polylines                    TYPEDEF PROTO SYSCALL,
        pBound         :DWORD,
        fsPolyFlags    :DWORD,
        cLines         :DWORD,
        npaptl         :DWORD,
        usFunN         :WORD,
        fComFlags      :WORD
endif ;IBMJ        ;IBMJ

do_sl_corr                      PROTO SYSCALL

do_stretchblt                   PROTO SYSCALL

double_enter_driver             PROTO SYSCALL

draw_pointer                    PROTO SYSCALL,
        ptlX           :DWORD,
        ptlY           :DWORD

DrawBits                        PROTO SYSCALL,
        hd             :DWORD,
        pBit           :DWORD,
        pbm            :DWORD,
        lCoun          :DWORD,
        aptlPoint      :DWORD,
        lRop           :DWORD,
        flOptions      :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

DrawBorder                      PROTO SYSCALL,
        hd             :DWORD,
        lpr            :DWORD,
        cxBorde        :DWORD,
        cyBorde        :DWORD,
        clrBorde       :DWORD,
        clrInterio     :DWORD,
        flCm           :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

IFDEF DINCL_VIOPS

DrawImageRect                   PROTO SYSCALL,
        hdc            :HDC,
        lpPS           :DWORD,           ; pVioPresentationSpace,
        lpRectDesc     :DWORD,
        hddc           :DWORD,
        FunN           :DWORD
else
DrawImageRect                   PROTO SYSCALL,
        hdc            :HDC,
        lpPS           :PVOID,
        lpRectDesc     :DWORD,
        hddc           :DWORD,
        FunN           :DWORD

ENDIF ; DINCL_VIOPS

DrawLinesCorrelate              PROTO SYSCALL,
        cCurve         :WASWORD

DrawLinesInPath                 PROTO SYSCALL,
        hd             :DWORD,
        lpp            :DWORD,
        lpcvFirs       :DWORD,
        icvCoun        :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

dsa_char                        PROTO SYSCALL

dsa_line                        PROTO SYSCALL

dsa_marker                      PROTO SYSCALL

dsa_pattern                     PROTO SYSCALL

Enable                          PROTO SYSCALL,
        subfunctio     :DWORD,
        u32_param      :DWORD,
        u32_param      :DWORD

enable_ddc                      PROTO SYSCALL,
        subfunctio     :DWORD,
        pFun5Par       :DWORD,
        u32_param      :DWORD

enter_driver                    PROTO SYSCALL

enter_driver_sem                PROTO SYSCALL

enter_driver_sem_only           PROTO SYSCALL

enumerate_clip_rects            PROTO SYSCALL,
        npdd           :WASWORD,
        prclCli        :DWORD,
        pf             :WASWORD

ErasePS                         PROTO SYSCALL,
        hd             :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

Escape                          PROTO SYSCALL,
        hdc            :HDC,
        lEscape        :LONG,
        cInCount       :LONG,
        pInData        :PBYTE,
        pcOutCount     :PLONG,
        pOutData       :PLONG,
        pInstance      :PVOID,
        lFunction      :ULONG

Exclude                         PROTO SYSCALL

@ExtTextOut                      TYPEDEF PROTO SYSCALL,
        lp_DDC         :DWORD,
        lp_device      :DWORD,
        x              :DWORD,
        y              :DWORD,
        lp_clip_rect   :DWORD,
        lp_string      :DWORD,
        count          :DWORD,
        npAttrs        :DWORD,
        lp_dx          :DWORD,
        lp_opaque_rect :DWORD,
        eto_options    :DWORD

exit_list_proc                  PROTO SYSCALL,
        ulTermCode     :DWORD


fill_log_dev_blk                PROTO SYSCALL,
        subfunctio     :DWORD,
        pFun1Par       :DWORD,
        pFun1Re        :DWORD

fill_pattern_empty_bits         PROTO SYSCALL

fill_phys_dev_blk               PROTO SYSCALL,
        subfunctio     :DWORD,
        u32_param      :DWORD,
        u32_param      :DWORD

fixed_pitch_strblt              PROTO SYSCALL,
        lp_DDC        :DWORD,
        lp_DestDev    :DWORD,
        x             :DWORD,
        y             :DWORD,
        lp_clip_rect  :DWORD,
        lp_string     :DWORD,
        count         :DWORD,
        npAttrs       :DWORD,
        lp_dx         :DWORD,
        lp_opaque_rect:DWORD,
        eto_options   :DWORD

Force_Valid_CP                  PROTO SYSCALL,
        pcpi           :DWORD,
        pmapc          :DWORD

Format_CP_Map                   PROTO SYSCALL,
        npmapc         :WASWORD,
        pchar_xlate_tb :DWORD

free_bm                         PROTO SYSCALL

free_controller                 PROTO SYSCALL

free_ddc                        PROTO SYSCALL

free_far_mem                    PROTO SYSCALL

FreeMem                         PROTO SYSCALL


get_clip_rects                  PROTO SYSCALL

Get_CP_Map                      PROTO SYSCALL,
        idc :WASWORD

get_rip_flag                    PROTO SYSCALL

GetBitmapBits                   PROTO SYSCALL,
        hd             :DWORD,
        hBitma         :DWORD,
        ScanStar       :DWORD,
        ScanCoun       :DWORD,
        lpAddres       :DWORD,
        lpInf          :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

GetBoundsData                   PROTO SYSCALL,
        hd             :DWORD,
        fdTyp          :DWORD,
        lpBoundsDat    :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

get_clip_rects                  PROTO SYSCALL

GetCodePage                     PROTO SYSCALL,
        hd             :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

GetCurrentPosition              PROTO SYSCALL,
        hdc            :HDC,
        pptPosition    :PPOINTL,
        pInstance      :PVOID,
        lFunction      :ULONG

GetDCOrigin                     PROTO SYSCALL,
        hd             :DWORD,
        lpX            :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

GetLineOrigin                   PROTO SYSCALL,
        hd             :DWORD,
        lpX            :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

GetPairKerningTable             PROTO SYSCALL,
        hd             :DWORD,
        Coun           :DWORD,
        lpKernPair     :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

GetPel                          PROTO SYSCALL,
        hd             :DWORD,
        lpPar          :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

GetPickWindow                   PROTO SYSCALL,
        hdc            :HDC,
        pPick          :PRECTL,
        pInstance      :PVOID,
        lFunction      :ULONG

GetStyleRatio                   PROTO SYSCALL,
        hd             :DWORD,
        lpRati         :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

GreQueryCodePageVector          PROTO SYSCALL,
        ulCodePage     :DWORD,
        pInstance      :PVOID,
        lFunction      :DWORD

global_alloc                    PROTO SYSCALL

global_free                     PROTO SYSCALL

haltproc                        PROTO SYSCALL

ImageData                       PROTO SYSCALL,
        hd             :DWORD,
        lpDat          :DWORD,
                       :DWORD,
        Ro             :DWORD,
        hdd            :DWORD,
        Fun            :DWORD


init_heap                       PROTO SYSCALL

@init_hw_regs                   TYPEDEF  PROTO SYSCALL

InitTonysBarNGrill              PROTO SYSCALL

InnerAccumulateBounds           PROTO SYSCALL

@InnerCheckCursor               TYPEDEF  PROTO SYSCALL

intersect_rcl                   PROTO SYSCALL

intersect_with_corr             PROTO SYSCALL,
        pDestination   :PRECTL

@ipc_to_index                   TYPEDEF PROTO SYSCALL

leave_driver                    PROTO SYSCALL

leave_driver_sem_only           PROTO SYSCALL

loadproc                        PROTO SYSCALL,
        hNULL          :DWORD,
        pdll           :DWORD

local_pt_visible                PROTO SYSCALL

LockDevice                      PROTO SYSCALL,
        hd             :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

@MakeBrushValid                  TYPEDEF PROTO SYSCALL,
        pColor         :DWORD

MakeColorCntTable               PROTO SYSCALL

@MakeColorsValid                 TYPEDEF PROTO SYSCALL

MakeDitherBitmap                PROTO SYSCALL,
        nNumberOfColors:WASWORD


mono_dither                     PROTO SYSCALL

MovePointers                   PROTO SYSCALL,
        pBitsAndXor    :DWORD,
        pBitsColor     :DWORD,
        wFlags         :WORD

MoveCursor                      PROTO SYSCALL,
        abs_x          :DWORD,
        abs_y          :DWORD

NotifyClipChange                PROTO SYSCALL,
        hd             :DWORD,
        prc            :DWORD,
        crc            :DWORD,
        Flag           :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

ifndef DINCL_SKIP_DDC
NotifyTransformChange           PROTO SYSCALL,
        hd             :DWORD,
        Flag           :DWORD,
        lpDat          :PULONG,
        pddc           :PDDC,
        Fun            :DWORD

SetDeviceCursor PROTO SYSCALL,
                sHotX     :SDWORD,
                sHotY     :SDWORD,
                pbmPointer:HBITMAP,
                pbmColor  :HBITMAP,
                fwFlags   :DWORD,
                pDDC      :PDDC

endif


@OEMBitblt                       TYPEDEF PROTO SYSCALL,
        pddcDst        :DWORD,
        xDst           :DWORD,
        yDst           :DWORD,
        psdSrc         :DWORD,
        xSrc           :DWORD,
        ySrc           :DWORD,
        cxExt          :DWORD,
        cyExt          :DWORD,
        usMix          :DWORD,
        ipcBkgnd       :DWORD,
        fsBlt          :DWORD


@OEMDrawBits                     TYPEDEF PROTO SYSCALL,
        pddcDst        :DWORD,
        xDst           :DWORD,
        yDst           :DWORD,
        psdSrc         :DWORD,
        xSrc           :DWORD,
        ySrc           :DWORD,
        cxExt          :DWORD,
        cyExt          :DWORD,
        usMix          :DWORD,
        ipcBkgnd       :DWORD,
        fsBlt          :DWORD



@OEMStretchBlt                   TYPEDEF PROTO SYSCALL,
        pddcDst        :DWORD,
        xDst           :DWORD,
        yDst           :DWORD,
        psdSrc         :DWORD,
        spacer         :DWORD,
        lpParm         :DWORD,
        cxExt          :DWORD,
        cyExt          :DWORD

one_time_init                   PROTO SYSCALL

OS2_PM_DRV_ENABLE               PROTO SYSCALL,
        subfunctio     :DWORD,
        u32_param      :DWORD,
        u32_param      :DWORD

output_o_rect                   PROTO SYSCALL,
        lp_DDC        :DWORD,
        lp_DestDev    :DWORD,
        x             :DWORD,
        y             :DWORD,
        lp_clip_rect  :DWORD,
        lp_string     :DWORD,
        count         :DWORD,
        npAttrs       :DWORD,
        lp_dx         :DWORD,
        lp_opaque_rect:DWORD,
        eto_options   :DWORD


perform_rip                     PROTO SYSCALL,
        npErro         :DWORD

@Pixel                           TYPEDEF PROTO SYSCALL,
        lX             :LONG,
        lY             :LONG,
        lPhysColor     :DWORD,
        lMixMode       :LONG

pointer_off            PROTO SYSCALL,
        ptlX           :DWORD,
        ptlY           :DWORD

PolyLine                        PROTO SYSCALL,
        hdc            :HDC,
        papPoint       :PPOINTL,
        CPoints        :LONG,
        pInstance      :PVOID,
        lFunction      :ULONG

PolyLineCorrelate               PROTO SYSCALL,
        paptl          :PPOINTL,
        cLines         :ULONG,
        lFunction      :DWORD

EXTERNDEF  polyline_init                   :NEAR
EXTERNDEF  polyline_background_init        :NEAR
EXTERNDEF  polyline_workhorse_routine      :NEAR

PolyMarker                      PROTO SYSCALL,
        hd             :DWORD,
        lpPolyX        :DWORD,
        Poly           :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

@PolyScanline                    TYPEDEF PROTO SYSCALL,
        hdc            :DWORD,
        pScansData     :DWORD,
        hddc           :DWORD,
        FunN           :DWORD

private_alloc                   PROTO SYSCALL

private_free                    PROTO SYSCALL

@PropagateSysClrChange          TYPEDEF PROTO SYSCALL

QueryCharCorr                   PROTO SYSCALL,
        hd             :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

@QueryColorData                  TYPEDEF PROTO SYSCALL,
        hdc            :HDC,
        cArray         :LONG,
        pArray         :PLONG,
        pInstance      :PVOID,
        lFunction      :ULONG

@QueryColorIndex                 TYPEDEF PROTO SYSCALL,
        hdc            :HDC,
        flOptions      :ULONG,
        rgbColor       :LONG,
        pInstance      :PVOID,
        lFunction      :ULONG

QueryDeviceBitmaps              PROTO SYSCALL,
        hd             :DWORD,
        lpOutDat       :DWORD,
        Coun           :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

QueryDeviceCaps                 PROTO SYSCALL,
        hd             :DWORD,
        Inde           :DWORD,
        lpOutDat       :DWORD,
        Coun           :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

QueryDevResource2               PROTO SYSCALL,
        hd             :DWORD,
        resTyp         :DWORD,
        i              :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

QueryHardcopyCaps               PROTO SYSCALL,
        hd             :DWORD,
        Star           :DWORD,
        Coun           :DWORD,
        lpInf          :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

@QueryLogColorTable              TYPEDEF PROTO SYSCALL,
        hdc            :HDC,
        flOptions      :ULONG,
        lStart         :LONG,
        cArray         :LONG,
        pArray         :PLONG,
        pInstance      :PVOID,
        lFunction      :ULONG

@QueryNearestColor               TYPEDEF PROTO SYSCALL,
        hdc            :HDC,
        flOptions      :ULONG,
        rgbColorIn     :LONG,
        pInstance      :PVOID,
        lFunction      :ULONG

@QueryRealColors                 TYPEDEF PROTO SYSCALL,
        hdc            :HDC,
        flOptions      :ULONG,
        lStart         :LONG,
        cArray         :LONG,
        pArray         :PLONG,
        pInstance      :PVOID,
        lFunction      :ULONG

@QueryRGBColor                   TYPEDEF PROTO SYSCALL,
        hdc            :HDC,
        flOptions      :ULONG,
        iColor         :LONG,
        pInstance      :PVOID,
        lFunction      :ULONG

real_exit_list_proc             PROTO SYSCALL

@RealizeColorTable               TYPEDEF PROTO SYSCALL,
        hdc            :HDC,
        pInstance      :PVOID,
        lFunction      :ULONG

RealizeFont                     PROTO SYSCALL,
        hd             :DWORD,
        Comman         :DWORD,
        LogFon         :DWORD,
        EngFon         :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

recalc_correlate_rect           PROTO SYSCALL

reprogram_hardware  PROTO   SYSCALL

req_controller                  PROTO SYSCALL

ifdef FIREWALLS                                                         ;75466
                                                                        ;75466
debuglogger                     PROTO SYSCALL                           ;75466
                                                                        ;75466
endif                                                                   ;75466

res_hw_regs                     PROTO SYSCALL

reset_ddc_state                 PROTO SYSCALL,
        subfunctio     :DWORD,
        hdd            :DWORD,
        flColorMod     :DWORD

ResetBounds                     PROTO SYSCALL,
        hd             :DWORD,
        fdTyp          :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

restore_ddc_state               PROTO SYSCALL,
        subfunctio     :DWORD,
        hdd            :DWORD,
        cLeve          :DWORD


@RestoreScreenBits               TYPEDEF PROTO SYSCALL,
        hdc             :DWORD,
        hSB             :DWORD,
        lpRect          :DWORD,
        Options         :DWORD,
        hddc            :DWORD,
        FunN            :DWORD

Resurrection                    PROTO SYSCALL,
        hd             :DWORD,
        cbDirt         :DWORD,
        pbDirt         :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

@rgb_to_ipc                     TYPEDEF  PROTO SYSCALL

rgb_to_nearest_index            PROTO SYSCALL,
        RGBWante       :DWORD

ring3_CriticalError             PROTO SYSCALL

ring3_VioGetConfig              PROTO SYSCALL

ring3_VioGetCP                  PROTO SYSCALL

ring3_VioGetMode                PROTO SYSCALL

ring3_physical_enable                    PROTO SYSCALL

RLEDrawBits                     PROTO SYSCALL,
        pDestDDC    :DWORD,
        lDestX      :DWORD,
        lDestY      :DWORD,
        pRLEInfo    :DWORD,
        lLeftClipX  :DWORD,
        lBottomClipY:DWORD,
        lExtentX    :DWORD,
        lExtentY    :DWORD,
        pRLEBits    :DWORD,
        pColorTable :DWORD

rotate_brush                    PROTO SYSCALL

save_bitmap                     PROTO SYSCALL

save_ddc_state                  PROTO SYSCALL,
        subfunctio     :DWORD,
        hdd            :DWORD,
        u32_param      :DWORD

save_hw_regs                    PROTO SYSCALL

@save_lct                       TYPEDEF  PROTO SYSCALL

@SaveScreenBits                  TYPEDEF PROTO SYSCALL,
        hdc             :DWORD,
        lpRect          :DWORD,
        hddc            :DWORD,
        FunN            :DWORD

save_that_???_error             PROTO SYSCALL

save_that_error                 PROTO SYSCALL

save_that_severe_error          PROTO SYSCALL

save_that_unrecoverable_error   PROTO SYSCALL,

save_that_warning               PROTO SYSCALL

IFDEF DINCL_VIOPS

@ScrollRect                      TYPEDEF PROTO SYSCALL,
        hdc            :HDC,
        lpPS           :DWORD,           ; pVioPresentationSpace,
        lpRectDesc     :DWORD,
        hddc           :DWORD,
        FunN           :DWORD

else
@ScrollRect                      TYPEDEF PROTO SYSCALL,
        hdc            :HDC,
        lpPS           :PVOID,
        lpRectDesc     :DWORD,
        hddc           :DWORD,
        FunN           :DWORD

ENDIF ; DINCL_VIOPS

set_basic_attributes            PROTO SYSCALL

SetBitmapBits                   PROTO SYSCALL,
        hd             :DWORD,
        hBitma         :DWORD,
        ScanStar       :DWORD,
        ScanCoun       :DWORD,
        lpAddres       :DWORD,
        lpInf          :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

SetCharFont                     PROTO SYSCALL

SetCodePage                     PROTO SYSCALL,
        hd             :DWORD,
        CodePag        :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

@SetColorCursor                  TYPEDEF PROTO SYSCALL,
        hdc            :HDC,
        pPointerInfo   :DWORD,          ; PPOINTERINFO,
        pInstance      :PVOID,
        lFunction      :ULONG

SetCurrentPosition              PROTO SYSCALL,
        hdc            :HDC,
        pptPosition    :PPOINTL,
        pInstance      :PVOID,
        lFunction      :ULONG

SetLineOrigin                   PROTO SYSCALL,
        hd             :DWORD,
        lpX            :DWORD,
        Styl           :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

SetMarkerFont                   PROTO SYSCALL

SetPatternFont                  PROTO SYSCALL

SetPel                          PROTO SYSCALL,
        hd             :DWORD,
        lpPar          :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

SetPickWindow                   PROTO SYSCALL,
        hdc            :HDC,
        pPick          :PRECTL,
        pInstance      :PVOID,
        lFunction      :ULONG

SetStyleRatio                   PROTO SYSCALL,
        hd             :DWORD,
        lpRati         :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

ShortlineCorrelate              PROTO SYSCALL,
        ps             :DWORD

SortColorCntTable               PROTO SYSCALL

synthesize_color_bits           PROTO SYSCALL

synthesize_mono_bits            PROTO SYSCALL

synthesize_xparent_mask         PROTO SYSCALL

TransformColors                 PROTO SYSCALL

truncate_rectl                  PROTO SYSCALL

UnlockDevice                    PROTO SYSCALL,
        hd             :DWORD,
        hdd            :DWORD,
        Fun            :DWORD

IFDEF DINCL_VIOPS

@UpdateCursor                    TYPEDEF PROTO SYSCALL,
        hdc            :HDC,
        lpPS           :DWORD,                   ; pVioPresentationSpace,
        hddc           :PVOID,
        FunN           :ULONG
else
@UpdateCursor                    TYPEDEF PROTO SYSCALL,
        hdc            :HDC,
        lpPS           :PVOID,
        hddc           :PVOID,
        FunN           :ULONG

ENDIF ; DINCL_VIOPS

validate_rectl                  PROTO SYSCALL

WriteBrush                      PROTO SYSCALL

xform_pattern_origin            PROTO SYSCALL

;/*
;** THUNKS
;*/

ThunkToWinSetErrorInfo          PROTO FAR SYSCALL

Win32QueryProcessCp             PROTO SYSCALL

WinSetErrorInfo32               PROTO SYSCALL,
        idError        :ERRORID,
        fsOptions      :ULONG,
        arg1           :VARARG

Vio32GetConfig                  PROTO SYSCALL,
        usReserved:DWORD,
        pvioin:DWORD,
        hvio:DWORD

Vio32GetCP                      PROTO SYSCALL,
        :DWORD,                 ;USHORT in 16 bit world
        pidCodePage:DWORD,      ;PUSHORT in 16 bit world
        hvio:DWORD              ;WORD in 16 bit world

Vio32SetCurPos                  PROTO SYSCALL,
        :DWORD,                 ;USHORT in 16 bit world
        :DWORD,                 ;USHORT in 16 bit world
        hvio:DWORD              ;WORD in 16 bit world

Vio32SetMode                    PROTO SYSCALL,
        pviomodeinfo:DWORD,
        hvio:DWORD              ;WORD in 16 bit world

Vio32SetState                   PROTO SYSCALL,
        pviopalstate:DWORD,
        hvio:DWORD              ;WORD in 16 bit world

Vio32WrtTTY                     PROTO SYSCALL,
        :PCH,
        :DWORD,                 ;WORD in 16 bit world
        hvio:DWORD              ;WORD in 16 bit world

;/*
;** DCAF protos
;*/
ifdef   DCAF                                                         ;          
ifndef  EXCLUDE_DCAF_PROTOS                                          ;          

OpenScreenChangeArea PROTO SYSCALL,
        hdc    :HDC,
        hddc   :PVOID,
        FunN   :ULONG

GetScreenChangeArea PROTO SYSCALL,
        hdc    :HDC,
        hsca   :PVOID,
        phrgn  :PVOID,
        hddc   :PVOID,
        FunN   :ULONG

CloseScreenChangeArea PROTO SYSCALL,
        hdc    :HDC,
        hsca   :PVOID,
        hddc   :PVOID,
        FunN   :ULONG

GetScreenBits PROTO SYSCALL,
        hdc       :HDC,
        hrgn      :ULONG,
        pDest     :PVOID,
        pulLength :PVOID,
        flCmd     :ULONG,
        hddc      :PVOID,
        FunN      :ULONG

GetScreenBitsStub PROTO SYSCALL,
        hdc       :HDC,
        hrgn      :ULONG,
        pDest     :PVOID,
        pulLength :PVOID,
        flCmd     :ULONG,
        hddc      :PVOID,
        FunN      :ULONG

SetScreenBits PROTO SYSCALL,
        hdc       :HDC,
        pBuffer   :PVOID,
        cBytes    :ULONG,
        hrgn      :ULONG,
        hddc      :PVOID,
        FunN      :ULONG

SetScreenBitsStub PROTO SYSCALL,
        hdc       :HDC,
        pBuffer   :PVOID,
        cBytes    :ULONG,
        hrgn      :ULONG,
        hddc      :PVOID,
        FunN      :ULONG

;/*
;** Internal DCAF functions
;*/

AccumulateScreenBound PROTO SYSCALL,
        prectl         :DWORD

CompressScreenBits PROTO SYSCALL,
                hdc :DWORD,
                hrgnApp :DWORD,
                pDest :DWORD,
                ulBufferLen :DWORD,
                flCmd :DWORD,
                hddc  :DWORD

DecompressScreenBits PROTO SYSCALL,
        hddc    :DWORD,
        hrgn    :DWORD,
        pbuffer :DWORD

Planar4bppRectangle PROTO SYSCALL,
        pbuffer :DWORD,
        pbitmap :DWORD,
        prectl  :DWORD

compress_rect PROTO SYSCALL,
        prclCurrentRect :DWORD,
        pfnCompressRow  :DWORD

compress_row_4pl_4 PROTO SYSCALL

init_devinfo_struc PROTO SYSCALL,
        init_hddc :DWORD

MergeSeamlessSCAWithGlobalSCAs PROTO SYSCALL

ResetScreenBounds PROTO SYSCALL

SetFullScreenBounds PROTO SYSCALL

PackBuffer PROTO SYSCALL,
        pUnpacked       :DWORD,
        pPacked         :DWORD,
        cPels           :DWORD,
        ulPlaneOffset   :DWORD

UnPackBuffer PROTO SYSCALL,
        pUnpacked       :DWORD,
        pPacked         :DWORD,
        cPels           :DWORD,
        ulPlaneOffset   :DWORD

SeamlessExcludeCursor PROTO SYSCALL

endif;  ndef EXCLUDE_DCAF_PROTOS                                     ;          
endif;  DCAF                                                         ;          

;/*
;** STUBS
;*/

@InterpretAttributes   TYPEDEF PROTO SYSCALL,
        hdc        :HDC,
        lpPS       :DWORD,               ; PTR VioPresentationSpace,
        lpRectDesc :DWORD,
        hddc       :DWORD,
        FunN       :DWORD

Bitblt                          PROTO SYSCALL

CharString                      PROTO SYSCALL

CharStringPos                   PROTO SYSCALL

Convert                         PROTO SYSCALL

CursorInit                      PROTO SYSCALL

Death                           PROTO SYSCALL

DeviceCreateBitmap              PROTO SYSCALL

DeviceDeleteBitmap              PROTO SYSCALL

DeviceInvalidateVisRegion       PROTO SYSCALL

DeviceQueryFontAttributes       PROTO SYSCALL

DeviceQueryFonts                PROTO SYSCALL

DeviceSelectBitmap              PROTO SYSCALL

DeviceSetDCOrigin               PROTO SYSCALL

DeviceSetGlobalAttribute        PROTO SYSCALL

DisjointLines                   PROTO SYSCALL

DrawBits                        PROTO SYSCALL

ErasePS                         PROTO SYSCALL

GetBitmapBits                   PROTO SYSCALL

GetClipRects                    PROTO SYSCALL

GetCodePage                     PROTO SYSCALL

GetCurrentPosition              PROTO SYSCALL

GetDCOrigin                     PROTO SYSCALL

GetLineOrigin                   PROTO SYSCALL

GetPairKerningTable             PROTO SYSCALL

GetPel                          PROTO SYSCALL

GetPickWindow                   PROTO SYSCALL

GetStyleRatio                   PROTO SYSCALL

GetVisRects                     PROTO SYSCALL

GetVRAMR0Pointer                PROTO SYSCALL

ImageData                       PROTO SYSCALL

LockDevice                      PROTO SYSCALL

NotifyClipChange                PROTO SYSCALL

NotifyTransformChange           PROTO SYSCALL

@physical_enable                 TYPEDEF PROTO SYSCALL,
        fInitMem       :DWORD,
        cbDirty        :DWORD

@physical_disable               TYPEDEF  PROTO SYSCALL

PolyLine                        PROTO SYSCALL

PolyMarker                      PROTO SYSCALL

PtVisible                       PROTO SYSCALL

IFNDEF DBCS        ;IBMJ
QueryCharPositions              PROTO SYSCALL
ENDIF;DBCS        ;IBMJ

QueryDeviceBitmaps              PROTO SYSCALL

QueryDeviceCaps                 PROTO SYSCALL

QueryDevResource2               PROTO SYSCALL

QueryHardcopyCaps               PROTO SYSCALL

IFNDEF DBCS        ;IBMJ
QueryTextBox                    PROTO SYSCALL
ENDIF;DBCS        ;IBMJ

RealizeFont                     PROTO SYSCALL

RectVisible                     PROTO SYSCALL

Resurrection                    PROTO SYSCALL

SelectClipRegion                PROTO SYSCALL

SetBitmapBits                   PROTO SYSCALL

SetCodePage                     PROTO SYSCALL

SetCurrentPosition              PROTO SYSCALL

SetLineOrigin                   PROTO SYSCALL

SetPel                          PROTO SYSCALL

SetPickWindow                   PROTO SYSCALL

@SetScreenBusy                   TYPEDEF PROTO SYSCALL,
        ulState:BYTE

SetStyleRatio                   PROTO SYSCALL

UnlockDevice                    PROTO SYSCALL

@UnrealizeColorTable             TYPEDEF PROTO SYSCALL,
        hdc            :HDC,
        pInstance      :PVOID,
        lFunction      :ULONG

;/*
;** System Calls
;** These functions are system calls for which no prototypes could be found in
;** any include files.
;*/

SSAllocMem                      PROTO SYSCALL,
        BaseAddress    :PVOID,
        ObjectSize     :ULONG,
        Flags          :ULONG

SSFreeMem                       PROTO SYSCALL,
        psel           :PVOID

ENDIF ; PROTOS_DEFD


;/*
;** PFN Prototypes
;*/

PROTODefPolyMarker       TYPEDEF PROTO   SYSCALL,
        hdc            :DWORD,
        paptPoint      :PPOINTL,
        cPoints        :DWORD,
        pInstance      :DWORD,
        lFunction      :DWORD

PFNDefPolyMarker TYPEDEF PTR PROTODefPolyMarker

PROTODefPtVisible         TYPEDEF PROTO   SYSCALL,
        hdc            :DWORD,
        pptPoint       :PPOINTL,
        pInstance      :DWORD,
        lFunction      :DWORD

PFNDefPtVisible TYPEDEF PTR PROTODefPtVisible

PROTODefConvert           TYPEDEF PROTO   SYSCALL,
        hdc            :HDC,
        lSrc           :LONG,
        lDst           :LONG,
        paptPoints     :PPOINTL,
        cPoints        :LONG,
        pInstance      :PVOID,
        lFunction      :ULONG

PFNDefConvert TYPEDEF PTR PROTODefConvert

ifdef DCAF                                                           ;          
ifndef  EXCLUDE_DCAF_PROTOS                                          ;          
PROTODefGetRegionBox TYPEDEF PROTO SYSCALL,
        hdc              :DWORD,
        hrgn             :DWORD,
        prclBound        :DWORD,
        hddc             :DWORD,
        NGreGetRegionBox :DWORD

PFNDefGetRegionBox TYPEDEF PTR PROTODefGetRegionBox

PROTODefSetRectRegion  TYPEDEF PROTO SYSCALL,
        hdc              :DWORD,
        hrgn             :DWORD,
        parcl            :DWORD,
        cRects           :DWORD,
        hddc             :DWORD,
        NGreSetRectRegion:DWORD

PFNDefSetRectRegion TYPEDEF PTR PROTODefSetRectRegion

PROTODefGetRegionRects TYPEDEF PROTO SYSCALL,
        hdc                :DWORD,
        hrgn               :DWORD,
        prclBound          :DWORD,
        prgnrc             :DWORD,
        prcl               :DWORD,
        hddc               :DWORD,
        NGreGetRegionRects :DWORD

PFNDefGetRegionRects TYPEDEF PTR PROTODefGetRegionRects

PROTODefCombineRectRegion TYPEDEF PROTO SYSCALL,
        hdc                   :DWORD,
        hrgnDst               :DWORD,
        prclBound             :DWORD,
        hrgnSrc               :DWORD,
        ulMode                :DWORD,
        hddc                  :DWORD,
        NGreCombineRectRegion :DWORD

PFNDefCombineRectRegion TYPEDEF PTR PROTODefCombineRectRegion

PROTOProcessRectangle TYPEDEF PROTO SYSCALL,
        pbuffer :DWORD,
        pbitmap :DWORD,
        prectl  :DWORD

PFNProcessRectangle TYPEDEF PTR PROTOProcessRectangle

PROTOUnPackBuffer TYPEDEF PROTO SYSCALL,
        pUnpacked       :DWORD,
        pPacked         :DWORD,
        cPels           :DWORD,
        ulPlaneOffset   :DWORD

PFNUnPackBuffer TYPEDEF PTR PROTOUnPackBuffer                                          ;          

PROTOGetScreenBits TYPEDEF PROTO SYSCALL,
        hdc       :HDC,
        hrgn      :ULONG,
        pDest     :PVOID,
        pulLength :PVOID,
        flCmd     :ULONG,
        hddc      :PVOID,
        FunN      :ULONG

PFNGetScreenBits TYPEDEF PTR PROTOGetScreenBits

PROTOSetScreenBits TYPEDEF PROTO SYSCALL,
        hdc       :HDC,
        pBuffer   :PVOID,
        cBytes    :ULONG,
        hrgn      :ULONG,
        hddc      :PVOID,
        FunN      :ULONG

PFNSetScreenBits TYPEDEF PTR PROTOSetScreenBits


endif;  ndef EXCLUDE_DCAF_PROTOS                                     ;          
endif;  DCAF                                                         ;          

IFNDEF DINCL_SKIP_DDC

PROTODefNotifyTransformChange TYPEDEF PROTO SYSCALL,
                hdc:ULONG,
                Flags:ULONG,
                lpData:PULONG,
                pddc:PDDC,
                FunN:ULONG

PFNDefNotifyTransformChange TYPEDEF PTR PROTODefNotifyTransformChange

PROTODefGetClipRects TYPEDEF PROTO SYSCALL,
        hdcTemp        :DWORD,
        prclClip       :DWORD,
        Control        :DWORD,
        arclBuf        :DWORD,
        arclBuf        :DWORD,
        NGreGetClipRects :DWORD

PFNDefGetClipRects TYPEDEF PTR PROTODefGetClipRects

PROTODefRectVisible TYPEDEF PROTO SYSCALL,
        hdcTemp        :DWORD,
        prclRect       :DWORD,
        pInstance      :DWORD,
        lFunc          :DWORD

PFNDefRectVisible TYPEDEF PTR PROTODefRectVisible

PROTODefQueryTextBox TYPEDEF PROTO SYSCALL,
        hdc            :DWORD,
        cChars         :DWORD,
        pchString      :DWORD,
        cptPosition    :DWORD,
        paptPosition   :DWORD,
        pInstance      :DWORD,
        lFunc          :DWORD

PFNDefQueryTextBox TYPEDEF PTR PROTODefQueryTextBox

PROTODefCharStringPos TYPEDEF PROTO SYSCALL,
        hdc             :DWORD,
        pptStart        :DWORD,
        prcRect         :DWORD,
        flOptions       :DWORD,
        cChars          :DWORD,
        pchString       :DWORD,
        padx            :DWORD,
        pAttrs          :DWORD,
        pInstance       :DWORD,
        lFunction       :DWORD

PFNDefCharStringPos TYPEDEF PTR PROTODefCharStringPos

ENDIF ; !DINCL_SKIP_DDC

;/*
;************************* BitBlt PROTOs **********************************
;*/

compute_y                       PROTO SYSCALL
ega_src_copy_side               PROTO SYSCALL,
        cyExt:DWORD

edge_invert                     PROTO SYSCALL
invert                          PROTO SYSCALL
edge_pat_blt                    PROTO SYSCALL
pat_blt                         PROTO SYSCALL
LEFT_edge_mono_to_color_blt          PROTO SYSCALL
RIGHT_edge_mono_to_color_blt          PROTO SYSCALL

mono_to_color_blt               PROTO SYSCALL

PROTOBitBlt TYPEDEF PROTO SYSCALL,
 pddcDst  :DWORD, ;Destination ddc
 xDst     :DWORD, ;Destination x origin
 yDst     :DWORD, ;Destination y origin
 psdSrc   :DWORD, ;Source surface definition
 xSrc     :DWORD, ;Source x origin
 ySrc     :DWORD, ;Source y origin
 cxExt    :DWORD, ;x extent of the BLT
 cyExt    :DWORD, ;y extent of the BLT
 usMix    :DWORD, ;Mix mode
 ipcBkgnd :DWORD, ;Color to mono background match color
 fsBlt    :DWORD

PFNBitBlt TYPEDEF PTR PROTOBitBlt

phase_processing                PROTO PROTOBitBlt
pdevice_processing              PROTO PROTOBitBlt
pattern_preprocessing           PROTO PROTOBitBlt
BitBlt_Dispatch                 PROTO PROTOBitBlt
ega_src_copy_calc_params        PROTO PROTOBitBlt
ega_solid_pat                   PROTO PROTOBitBlt
do_wes_invert                   PROTO PROTOBitBlt
do_wes_patblt                   PROTO PROTOBitBlt
do_wes_mono_trick               PROTO PROTOBitBlt
color_mem_to_screen             PROTO PROTOBitBlt
do_grey_dpx                     PROTO PROTOBitBlt
cms_xfer_zero                   PROTO PROTOBitBlt
calc_parms                      PROTO PROTOBitBlt
cms_xfer_pos                    PROTO PROTOBitBlt
calc_params                     PROTO PROTOBitBlt
ega_src_copy                    PROTO PROTOBitBlt
clean_up_before_exit            PROTO PROTOBitBlt
copy_dev                        PROTO PROTOBitBlt
CBLT                            PROTO PROTOBitBlt
phase_align_generate            PROTO PROTOBitBlt

;/*
;************************* End BitBlt PROTOs ******************************
;*/

RAMSEMREQUEST32 PROTO SYSCALL,
        pSem:DWORD
RAMSEMCLEAR32 PROTO SYSCALL,
        pSem:DWORD
Vga32CallBack PROTO SYSCALL,
        pfnFunction:DWORD


ring3_WinVisRegionNotify PROTO SYSCALL

GreRequestMutexSem PROTO SYSCALL,
        hSem:DWORD

GreReleaseMutexSem PROTO SYSCALL,
        hSem:DWORD

GreQueryMutexSem PROTO SYSCALL,
        hSem:DWORD

CheckVisRegion PROTO SYSCALL

enter_driver2 PROTO SYSCALL

@DeviceSeamlessInit TYPEDEF PROTO SYSCALL,
        pAlias:DWORD

@alloc_brush   TYPEDEF PROTO SYSCALL

@free_brush TYPEDEF PROTO SYSCALL

@copy_brush    TYPEDEF PROTO SYSCALL

@device_enter_driver TYPEDEF PROTO SYSCALL

 CharRect              PROTO @CharRect
 CharStr               PROTO @CharStr
 CreateLogColorTable   PROTO @CreateLogColorTable
 DeviceSeamlessInit    PROTO @DeviceSeamlessInit
 DeviceSetAVIOFont2    PROTO @DeviceSetAVIOFont2
 DeviceSetCursor       PROTO @DeviceSetCursor
 ExtTextOut            PROTO @ExtTextOut
 InnerCheckCursor      PROTO @InnerCheckCursor
 InterpretAttributes   PROTO @InterpretAttributes
 MakeBrushValid        PROTO @MakeBrushValid
 MakeColorsValid       PROTO @MakeColorsValid
 OEMBitblt             PROTO @OEMBitblt
 OEMDrawBits           PROTO @OEMDrawBits
 OEMStretchBlt         PROTO @OEMStretchBlt
 Pixel                 PROTO @Pixel
 PolyScanline          PROTO @PolyScanline
 PolyShortLine         PROTO @PolyShortLine
 PropagateSysClrChange PROTO @PropagateSysClrChange
 QueryColorData        PROTO @QueryColorData
 QueryColorIndex       PROTO @QueryColorIndex
 QueryLogColorTable    PROTO @QueryLogColorTable
 QueryNearestColor     PROTO @QueryNearestColor
 QueryRGBColor         PROTO @QueryRGBColor
 QueryRealColors       PROTO @QueryRealColors
 RealizeColorTable     PROTO @RealizeColorTable
 ResetLogColorTable    PROTO @ResetLogColorTable
 RestoreScreenBits     PROTO @RestoreScreenBits
 SaveScreenBits        PROTO @SaveScreenBits
 ScrollRect            PROTO @ScrollRect
 SetColorCursor        PROTO @SetColorCursor
 SetScreenBusy         PROTO @SetScreenBusy
 UnrealizeColorTable   PROTO @UnrealizeColorTable
 UpdateCursor          PROTO @UpdateCursor
 alloc_brush           PROTO @alloc_brush
 bmc_ext_to_int        PROTO @bmc_ext_to_int
 bmc_int_to_ext        PROTO @bmc_int_to_ext
 copy_bits_to_pattern  PROTO @copy_bits_to_pattern
 copy_brush            PROTO @copy_brush
 deselect_lct          PROTO @deselect_lct
 device_enter_driver   PROTO @device_enter_driver
 device_specific_init  PROTO @device_specific_init
 device_specific_post_init     PROTO @device_specific_post_init
 do_polylines          PROTO @do_polylines
 enum_dispatch         PROTO @enum_dispatch
 far_exclude           PROTO @far_exclude
 far_unexclude         PROTO @far_unexclude
 free_brush            PROTO @free_brush
 init_hw_regs          PROTO @init_hw_regs
 ipc_to_index          PROTO @ipc_to_index
 physical_disable      PROTO @physical_disable
 physical_enable       PROTO @physical_enable
 rgb_to_ipc            PROTO @rgb_to_ipc
 save_lct              PROTO @save_lct

IFDEF DBCS  ; DBCS codepage / DBCS device font support   ;IBMJ

; ---------------- DBCSATTR.ASM ----------------

RealizeFont PROTO SYSCALL,
  hdc :DWORD,
  Command :DWORD,
  LogFont :DWORD,
  EngFont :DWORD,
  hddc :DWORD,
  FunN :DWORD

DeviceQueryFonts PROTO SYSCALL,
  hdc  :DWORD,
  Options  :DWORD,
  lpFilter :DWORD,
  lpMetrics :DWORD,
  iMetrics :DWORD,
  lpiFonts :DWORD,
  hddc  :DWORD,
  FunN  :DWORD

DeviceQueryFontAttributes PROTO SYSCALL,
  hdc  :DWORD,
  iMetrics :DWORD,
  lpMetrics :DWORD,
  hddc  :DWORD,
  FunN  :DWORD

ConvertFattrs PROTO SYSCALL

ConvertFontMetrics PROTO SYSCALL

move_text_metrics PROTO SYSCALL

xform_metrics PROTO SYSCALL,
  hddclo :DWORD

; ---------------- DBCSCP.ASM ----------------

DbcsQueryCodePageVectors PROTO SYSCALL

DbcsCreateCodePageVectors PROTO SYSCALL

DbcsInitCodePageVectors PROTO SYSCALL

; ---------------- DBCSFONT.ASM ----------------

DbcsLoadFontManager PROTO SYSCALL

DbcsQueryFontCount PROTO SYSCALL

DbcsGetFontList PROTO SYSCALL

DbcsRealizeFont PROTO SYSCALL

DbcsUnRealizeFont PROTO SYSCALL

DbcsQueryMatchNum PROTO SYSCALL

DbcsFixFontMetrics PROTO SYSCALL

DbcsQueryFontProfile PROTO SYSCALL

DbcsMapCharGlyph PROTO SYSCALL

DbcsValidateFontSeg PROTO SYSCALL

DbcsLoadFontDriver PROTO SYSCALL

DbcsValidateVioChar PROTO SYSCALL,
  lpIndices :DWORD, ; array  of glyph indices
  cIndices :DWORD, ; number of glyph indices
  selFont  :DWORD ; fontseg selector

; ---------------- DBCSINIT.ASM ----------------

DbcsGetRuntimeOptions PROTO SYSCALL

DbcsModifySystemFonts PROTO SYSCALL

DbcsValidateSystemFonts PROTO SYSCALL

szcomp PROTO SYSCALL

; ---------------- OEMINIT.ASM ----------------

OEM_DbcsGetRuntimeOptions PROTO SYSCALL

OEM_DbcsTweakProfileString PROTO SYSCALL

CheckEnvironmentSwitch PROTO SYSCALL

; ---------------- WINQUERY.ASM ----------------

QueryCharPositions PROTO SYSCALL,
  hdc  :DWORD,
  lpStartXY :DWORD,
  Options  :DWORD,
  N  :DWORD,
  lpCh  :DWORD,
  lpDx  :DWORD,
  lpXY  :DWORD,
  hddc  :DWORD,
  FunN  :DWORD

QueryTextBox PROTO SYSCALL,
  hdc  :DWORD,
  N  :DWORD,
  lpCh  :DWORD,
  Count  :DWORD,
  lpTextBox :DWORD,
  hddc  :DWORD,
  FunN  :DWORD

QueryWidthTable PROTO SYSCALL,
  hdc  :DWORD,
  firstChar :DWORD,
  N  :DWORD,
  lpWidths :DWORD,
  hddc  :DWORD,
  FunN  :DWORD

get_some_widths PROTO SYSCALL,
  gcpvector :DWORD

get_some_dbcs_widths PROTO SYSCALL

; ---------------- MATH.ASM ----------------

get_vector_length PROTO SYSCALL

ulNormalize PROTO SYSCALL

uqNormalize PROTO SYSCALL

square_root PROTO SYSCALL

big_fix_square_root PROTO SYSCALL

; ---------------- DBCSTHNK.ASM ----------------

R2LoadFontMgr32 PROTO SYSCALL

; ---------------- CELLSCAN.ASM ----------------

DbcsScanCells PROTO SYSCALL

; ---------------- Font Maneger Functions ----------------

PROTOfmdisp32_Fm32QueryFonts TYPEDEF PROTO SYSCALL,
 flOptions :DWORD,
 pfmFont  :DWORD,
 hfm  :DWORD,
 startFont :DWORD,
 reqFont  :DWORD

ALPFMfmdisp32_Fm32QueryFonts TYPEDEF PTR PROTOfmdisp32_Fm32QueryFonts

PROTOfmdisp32_Fm32OpenFont TYPEDEF PROTO SYSCALL,
 pfat  :DWORD,
 pfmFont  :DWORD

ALPFMfmdisp32_Fm32OpenFont TYPEDEF PTR PROTOfmdisp32_Fm32OpenFont

PROTOfmdisp32_Fm32CloseFont TYPEDEF PROTO   SYSCALL,
 hfm  :DWORD

ALPFMfmdisp32_Fm32CloseFont TYPEDEF PTR PROTOfmdisp32_Fm32CloseFont

PROTOfmdisp32_Fm32QueryCharAttr TYPEDEF PROTO SYSCALL,
 hfm  :DWORD,
 index  :DWORD,
 pfmData  :DWORD

ALPFMfmdisp32_Fm32QueryCharAttr TYPEDEF PTR PROTOfmdisp32_Fm32QueryCharAttr

PROTOfmdisp32_Fm32CharStr TYPEDEF PROTO   SYSCALL,
 hfm  :DWORD,
 flOptions :DWORD,
 pIndex  :DWORD,
 count  :DWORD

ALPFMfmdisp32_Fm32CharStr TYPEDEF PTR PROTOfmdisp32_Fm32CharStr

PROTOfmdisp32_Fm32CharStr2 TYPEDEF PROTO   SYSCALL,
 hfm  :DWORD,
 flOptions :DWORD,
 pIndex  :DWORD,
 count  :DWORD

ALPFMfmdisp32_Fm32CharStr2 TYPEDEF PTR PROTOfmdisp32_Fm32CharStr2

PROTOfmdisp32_Fm32MapCharGlyph TYPEDEF PROTO SYSCALL,
 hfm  :DWORD,
 codepage :DWORD,
 pStr  :DWORD,
 pIndex  :DWORD,
 strlen  :DWORD

ALPFMfmdisp32_Fm32MapCharGlyph TYPEDEF PTR PROTOfmdisp32_Fm32MapCharGlyph

PROTOfmdisp32_Fm32MapCharGlyph2 TYPEDEF PROTO SYSCALL,
 hfm  :DWORD,
 codepage :DWORD,
 pStr  :DWORD,
 pIndex  :DWORD,
 strlen  :DWORD

ALPFMfmdisp32_Fm32MapCharGlyph2 TYPEDEF PTR PROTOfmdisp32_Fm32MapCharGlyph2

PROTOfmdisp32_Fm32LoadFontDriver TYPEDEF PROTO  SYSCALL,
 flOptions :DWORD,
 szFontDriver :DWORD

ALPFMfmdisp32_Fm32LoadFontDriver TYPEDEF PTR PROTOfmdisp32_Fm32LoadFontDriver

PROTOfmdisp32_Fm32UnLoadFontDriver TYPEDEF PROTO   SYSCALL,
 flOptions :DWORD,
 szFontDriver :DWORD

ALPFMfmdisp32_Fm32UnLoadFontDriver TYPEDEF PTR PROTOfmdisp32_Fm32UnLoadFontDriver

; ---------------- SYSTEM CALLS ----------------

;DosQueryProcAddr PROTO SYSCALL,
;  hmod  :DWORD,
;  ulOrdinal :DWORD,
;  pszFunctionName :DWORD,
;  ppfnProcAddress :DWORD

DosQueryDBCSEnv PROTO SYSCALL,
  cbBuf  :DWORD,
  pctryc  :DWORD,
  pchBuf  :DWORD

DosScanEnv PROTO SYSCALL,
  pszVarName :DWORD,
  ppszResult :DWORD

PrfQueryProfileString PROTO SYSCALL,
  hini  :DWORD,
  pszAppName :DWORD,
  pszKeyName :DWORD,
  pszError :DWORD,
  pszBuf  :DWORD,
  cchBuf  :DWORD

PrfWriteProfileString PROTO SYSCALL,
  hini  :DWORD,
  pszAppName :DWORD,
  pszKeyName :DWORD,
  pszString :DWORD
ENDIF;DBCS        ;IBMJ

