;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;-----------------------------Module-Header-----------------------------;
; Module Name:  OPTIONS.INC
;
;   This is part of the device dependent sources.
;   This module controls device specific compiled / runtime options,
;   and included in driver.inc
;
; Created: 01-Jun-1990
; Author:  Soh Ohta     [jl09057 @ ymtvm3, IBM Japan]
;
;                       Refer to Copyright Inscruction Form No.G120-2083
;
; Exported Functions:   none
;
; Public Functions:     none
;
; Public Data:          none
;
; General Description:
;
; Restrictions:
;
;-----------------------------------------------------------------------;

OPTIONS_INCLUDED    EQU     1


define? macro   option,switch
    if switch
;       public  option
        option  equ     switch
    endif
endm

OFF             equ     0               ; 
ON              equ     -1              ; not OFF


;-----------------------------------------------------------------------;
; Compile Options
;-----------------------------------------------------------------------;

; Adaptation enabling switches

define?     JFIX,               ON      ; Japan unique problem fix
define?     DBCS,               ON      ; DBCS enabling switch
define?     IBMJ,               ON      ; IBM-Japan unique function
define?     TMP,                ON      ; Temporary code
define?     JTUNE,  ON ; Japan additional TUNE-UP code

;-----------------------------------------------------------------------;
; Runtime Options
;-----------------------------------------------------------------------;

; Display driver logical configuration options (for swFlags).
; The configuration is checked at initialization time.
; The significance of the bits in the flags is described below:

SW_OPTIONS      equ     00ffh           ; sw options field  7f --> ff by pochi
SW_SYSTEM_DBCS  equ     0001h           ; system default codepage is DBCS
SW_DISPLAY_DBCS equ     0002h           ; driver can display DBCS font set
SW_CPU_386 equ 0004h  ; distinguish 386 or higher one
SW_HAVE_ACCEL   equ     0008h           ; display card have accelerater
SW_CT_DISABLE equ 0010h  ; disable cell-drawing tuneup
SW_CT_DIS_REQ equ     0020h           ; disable cell-drawing tuneup request
SW_SEAMLESS equ 0040h  ; enable seamless window
SW_SPRITE       equ     0080h           ; enable h/w cursor (=sprite) by pochi

; Display driver physical configuration options (for hwFlags).
; The configuration is checked at enable time.
; The significance of the bits in the flags is described below:
; Plane configuration.
; Display type returned by VioGetConfig.

; Define the default system font and default Vio fonts.

FACESIZE                    equ     32  ; causes error if different
DBCS_SYSTEM_FONT_HEIGHT     equ     16  ; Gpi DBCS system font size
DBCS_SYSTEM_FONT_WIDTH      equ     8
DBCS_SYSTEM_FONT_FACENAME   equ     <FACESIZE dup (0)>  ; any font ok
DBCS_VIO_FONT_FAMILYNAME    equ     <FACESIZE dup (0)>  ; any font ok

; Define the Vio cell width range.

MIN_VIOCELL_WIDTH   equ     5
MAX_VIOCELL_WIDTH   equ     8
MAX_VIOCELL_HEIGHT  equ    18           ; see MaxSymbolLines in cellblt.inc

; Define the version compatibility values.

ALTCAPS_VERTICAL_FONT_RES   equ     96
ALTCAPS_HORIZONTAL_FONT_RES equ     96

